import React, { CSSProperties, ReactNode } from 'react';
export interface AcmAlertInfo {
    type?: 'success' | 'danger' | 'warning' | 'info' | 'default';
    title: ReactNode;
    message?: ReactNode;
    actions?: ReactNode;
    id?: string;
    group?: string;
}
export interface IAlertContext {
    readonly activeAlerts: AcmAlertInfo[];
    readonly alertInfos: AcmAlertInfo[];
    addAlert: (alertInfo: AcmAlertInfo) => void;
    removeAlert: (alertInfo: AcmAlertInfo) => void;
    removeVisibleAlert: (alertInfo: AcmAlertInfo) => void;
    clearAlerts: (matcher?: (alertInfo: AcmAlertInfo) => boolean) => void;
}
export declare const AcmAlertContext: React.Context<IAlertContext>;
export declare function AcmAlertProvider(props: {
    children: ReactNode;
}): JSX.Element;
export declare function AcmAlert(props: {
    alertInfo?: AcmAlertInfo;
    isInline?: boolean;
    title?: ReactNode;
    subtitle?: ReactNode;
    message?: ReactNode;
    noClose?: boolean;
    variant?: 'success' | 'danger' | 'warning' | 'info' | 'default';
    style?: CSSProperties;
}): JSX.Element;
export declare function AcmAlertGroup(props: {
    isInline?: boolean;
    canClose?: boolean;
    alertMargin?: string;
}): JSX.Element;
