import requiredArgs from "../_lib/requiredArgs/index.js";
import getDay from "../getDay/index.js";
import addDays from "../addDays/index.js";
import toDate from "../toDate/index.js";
var baseMap = [7, 6, 5, 4, 3, 2, 1];
/**
 * @name nextDay
 * @category Weekday Helpers
 * @summary When is the next day of the week?
 *
 * @description
 * When is the next day of the week? 0-6 the day of the week, 0 represents Sunday.
 *
 * @param {Date | number} date - the date to check
 * @param {Day} day - day of the week
 * @returns {Date} - the date is the next day of week
 * @throws {TypeError} - 2 arguments required
 *
 * @example
 * When is the next Monday after Mar, 20, 2020?
 * const result = nextDay(new Date(2020, 2, 20), 1)
 * => Mon Mar 23 2020 00:00:00
 *
 * @example
 * When is the next Tuesday after Mar, 21, 2020?
 * const result = nextDay(new Date(2020, 2, 21), 2)
 * => Tue Mar 24 2020 00:00:00
 **/

export default function nextDay(date, day) {
  requiredArgs(2, arguments);
  var map = genMap(day);
  return addDays(toDate(date), map[getDay(toDate(date))]);
}

function genMap(daysToMove) {
  if (daysToMove === 0) {
    return baseMap;
  } else {
    var mapStart = baseMap.slice(-daysToMove);
    var mapEnd = baseMap.slice(0, baseMap.length - daysToMove);
    return mapStart.concat(mapEnd);
  }
}