"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.install = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const child_process_1 = __importDefault(require("child_process"));
function install(dir = '.husky') {
    if (child_process_1.default.spawnSync('git', ['rev-parse']).status !== 0) {
        console.log('husky - not a Git repository, skipping hooks installation');
        return;
    }
    const absoluteHooksDir = path_1.default.resolve(process.cwd(), dir);
    if (!absoluteHooksDir.startsWith(process.cwd())) {
        throw new Error('.. not allowed');
    }
    if (!fs_1.default.existsSync('.git')) {
        throw new Error(".git can't be found");
    }
    try {
        fs_1.default.mkdirSync(path_1.default.join(dir, '_'), { recursive: true });
        fs_1.default.writeFileSync(path_1.default.join(dir, '.gitignore'), '_', 'utf-8');
        fs_1.default.copyFileSync(path_1.default.join(__dirname, '../../scripts/husky.sh'), path_1.default.join(dir, '_/husky.sh'));
        const { error } = child_process_1.default.spawnSync('git', ['config', 'core.hooksPath', dir]);
        if (error) {
            throw error;
        }
    }
    catch (e) {
        console.log('husky - Git hooks failed to install');
        throw e;
    }
    console.log('husky - Git hooks installed');
}
exports.install = install;
