# strip-comments [![NPM version](https://img.shields.io/npm/v/strip-comments.svg?style=flat)](https://www.npmjs.com/package/strip-comments) [![NPM monthly downloads](https://img.shields.io/npm/dm/strip-comments.svg?style=flat)](https://npmjs.org/package/strip-comments) [![NPM total downloads](https://img.shields.io/npm/dt/strip-comments.svg?style=flat)](https://npmjs.org/package/strip-comments) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/strip-comments.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/strip-comments)

> Strip comments from code. Removes line comments, block comments, the first comment only, or all comments. Optionally leave protected comments unharmed.

Please consider following this project's author, [Jon Schlinkert](https://github.com/jonschlinkert), and consider starring the project to show your :heart: and support.

- [Install](#install)
- [Usage](#usage)
- [API](#api)
- [About](#about)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save strip-comments
```

## Usage

By default all comments are stripped.

```js
const strip = require('strip-comments');
const str = strip('const foo = "bar";// this is a comment\n /* me too *\/');
console.log(str);
// => 'const foo = "bar";\n'
```

For more use-cases see the [tests](./test/test.js)

## API

### [strip](index.js#L34)

Strip all code comments from the given `input`, including protected comments that start with `!`, unless disabled by setting `options.keepProtected` to true.

**Params**

* `input` **{String}**: string from which to strip comments
* `options` **{Object}**: optional options, passed to [extract-comments](https://github.com/jonschlinkert/extract-comments)  
* `returns` **{String}**: modified input

**Options**

- `line` **{Boolean}**: if `false` strip only block comments, default `true`
- `block` **{Boolean}**: if `false` strip only line comments, default `true`
- `keepProtected` **{Boolean}**: Keep ignored comments (e.g. `/*!`, `/**!` and `//!`)
- `preserveNewlines` **{Boolean}**: Preserve newlines after comments are stripped

**Example**

```js
const str = strip('const foo = "bar";// this is a comment\n /* me too */');
console.log(str);
// => 'const foo = "bar";'
```

### [.block](index.js#L54)

Strip only block comments.

**Params**

* `input` **{String}**: string from which to strip comments
* `options` **{Object}**: pass `opts.keepProtected: true` to keep ignored comments (e.g. `/*!`)
* `returns` **{String}**: modified string

**Example**

```js
const strip = require('..');
const str = strip.block('const foo = "bar";// this is a comment\n /* me too */');
console.log(str);
// => 'const foo = "bar";// this is a comment'
```

### [.line](index.js#L73)

Strip only line comments.

**Params**

* `input` **{String}**: string from which to strip comments
* `options` **{Object}**: pass `opts.keepProtected: true` to keep ignored comments (e.g. `//!`)
* `returns` **{String}**: modified string

**Example**

```js
const str = strip.line('const foo = "bar";// this is a comment\n /* me too */');
console.log(str);
// => 'const foo = "bar";\n/* me too */'
```

### [.first](index.js#L93)

Strip the first comment from the given `input`. Or, if `opts.keepProtected` is true, the first non-protected comment will be stripped.

**Params**

* `input` **{String}**
* `options` **{Object}**: pass `opts.keepProtected: true` to keep comments with `!`
* `returns` **{String}**

**Example**

```js
const output = strip.first(input, { keepProtected: true });
console.log(output);
// => '//! first comment\nfoo; '
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Related projects

You might also be interested in these projects:

* [babel-extract-comments](https://www.npmjs.com/package/babel-extract-comments): Uses babel (babylon) to extract JavaScript code comments from a JavaScript string or file. | [homepage](https://github.com/jonschlinkert/babel-extract-comments "Uses babel (babylon) to extract JavaScript code comments from a JavaScript string or file.")
* [code-context](https://www.npmjs.com/package/code-context): Parse a string of javascript to determine the context for functions, variables and comments based… [more](https://github.com/jonschlinkert/code-context) | [homepage](https://github.com/jonschlinkert/code-context "Parse a string of javascript to determine the context for functions, variables and comments based on the code that follows.")
* [extract-comments](https://www.npmjs.com/package/extract-comments): Uses esprima to extract line and block comments from a string of JavaScript. Also optionally… [more](https://github.com/jonschlinkert/extract-comments) | [homepage](https://github.com/jonschlinkert/extract-comments "Uses esprima to extract line and block comments from a string of JavaScript. Also optionally parses code context (the next line of code after a comment).")
* [parse-code-context](https://www.npmjs.com/package/parse-code-context): Parse code context in a single line of javascript, for functions, variable declarations, methods, prototype… [more](https://github.com/jonschlinkert/parse-code-context) | [homepage](https://github.com/jonschlinkert/parse-code-context "Parse code context in a single line of javascript, for functions, variable declarations, methods, prototype properties, prototype methods etc.")
* [parse-comments](https://www.npmjs.com/package/parse-comments): Parse code comments from JavaScript or any language that uses the same format. | [homepage](https://github.com/jonschlinkert/parse-comments "Parse code comments from JavaScript or any language that uses the same format.")

### Contributors

| **Commits** | **Contributor** | 
| --- | --- |
| 59 | [jonschlinkert](https://github.com/jonschlinkert) |
| 4 | [charlike-old](https://github.com/charlike-old) |
| 2 | [mk-pmb](https://github.com/mk-pmb) |
| 1 | [kgryte](https://github.com/kgryte) |
| 1 | [epicoxymoron](https://github.com/epicoxymoron) |

### Author

**Jon Schlinkert**

* [LinkedIn Profile](https://linkedin.com/in/jonschlinkert)
* [GitHub Profile](https://github.com/jonschlinkert)
* [Twitter Profile](https://twitter.com/jonschlinkert)

### License

Copyright © 2018, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on March 24, 2018._