[![Build Status](https://travis-ci.org/DirtyHairy/microevent.svg?branch=master)](https://travis-ci.org/DirtyHairy/microevent)
[![npm version](https://badge.fury.io/js/microevent.ts.svg)](https://badge.fury.io/js/microevent.ts)

# What is it?

This package implements an event system with minimal dispatch overhead. Instead
of recording handlers bound to an event in dynamic data structures, this library
binds the handlers to autogenerated code. This enables the VM to inline the
handler invocation and generate code that is just as fast as invoking the handlers
directly.

In a (completely unscientific) benchmark, this library performs bettern than
NodeJS events in terms of event dispatch calls per second by about two orders
of magnitude.

# How to use it?

## Installation

You can install the library into your project via npm

    npm install microevent.ts

The library is written in Typescript and will work in any environment that
supports ES5. No external typings are required for using this library with
Typescript (version >= 2).

## Importing

ES5 / CommonJS

    var Event = require('microevent.ts').Event;

ES6

    import {Event} from 'microevent.ts';

Typescript

    import {Event, EventInterface} from 'microevent.ts';

The `EventInterface` covers only the client side of an event, that is adding
and removing handlers.

##  API

### Creating

ES5/ES6

    const event = new Event();

Typescript

    const event = new Event<PayloadT>();

Create a new event that will dispatch a payload of type `PayloadT`.

### Dispatching

    event.dispatch(payload);

This will call all handlers in the order they were registered, passing `payload`
as first argument.

**IMPORTANT** `dispatch` is a property that refers to dynamically generated code. 
**DO NOT KEEP ANY REFERENCES** to `dispatch` as adding and removing handlers
will invalidate them.

### Registering handlers

    event.addHandler(handler, context);

`context` is an optional parameter that will be passed to the handler on
each invocation.

### Removing handlers

    event.removeHandler(handler, context);

Both `handler` and `context` must be identical to the values used when registering
the handler in the first place.

### Checking for handlers

    event.isHandlerAttached(handler, context)

This will check whether a handler was attached in a given context.

    event.hasHandlers

`true` if the event has any handlers attached, false otherwise.

# License

Feel free to use this library under the conditions of the MIT license.
