"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableComposable = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const table_grid_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table-grid"));
const react_styles_1 = require("@patternfly/react-styles");
const utils_1 = require("../Table/utils/utils");
const react_core_1 = require("@patternfly/react-core");
const TableTypes_1 = require("../Table/TableTypes");
const TableComposableBase = (_a) => {
    var _b;
    var { children, className, variant, borders = true, isStickyHeader = false, gridBreakPoint = TableTypes_1.TableGridBreakpoint.gridMd, 'aria-label': ariaLabel, role = 'grid', innerRef, ouiaId, ouiaSafe = true } = _a, props = tslib_1.__rest(_a, ["children", "className", "variant", "borders", "isStickyHeader", "gridBreakPoint", 'aria-label', "role", "innerRef", "ouiaId", "ouiaSafe"]);
    const ouiaProps = react_core_1.useOUIAProps('Table', ouiaId, ouiaSafe);
    return (React.createElement("table", Object.assign({ "aria-label": ariaLabel, role: role, className: react_styles_1.css(className, table_1.default.table, (_b = table_grid_1.default.modifiers) === null || _b === void 0 ? void 0 : _b[utils_1.toCamel(gridBreakPoint || '').replace(/-?2xl/, '_2xl')], table_1.default.modifiers[variant], !borders && table_1.default.modifiers.noBorderRows, isStickyHeader && table_1.default.modifiers.stickyHeader), ref: innerRef }, ouiaProps, props), children));
};
exports.TableComposable = React.forwardRef((props, ref) => (React.createElement(TableComposableBase, Object.assign({}, props, { innerRef: ref }))));
exports.TableComposable.displayName = 'TableComposable';
//# sourceMappingURL=TableComposable.js.map