import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryAxis } from 'victory-axis';
import { ChartContainer } from '../ChartContainer';
import { getAxisTheme, getTheme } from '../ChartUtils';
export const ChartAxis = (_a) => {
    var { containerComponent = React.createElement(ChartContainer, null), showGrid = false, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["containerComponent", "showGrid", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return (React.createElement(VictoryAxis, Object.assign({ containerComponent: container, theme: showGrid ? getAxisTheme(themeColor, themeVariant) : theme }, rest)));
};
ChartAxis.displayName = 'ChartAxis';
hoistNonReactStatics(ChartAxis, VictoryAxis);
//# sourceMappingURL=ChartAxis.js.map