import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import defaults from 'lodash/defaults';
import { Helpers, VictoryLabel } from 'victory-core';
import { ChartLabel } from '../ChartLabel';
import { ChartLegendTooltipStyles } from '../ChartTheme';
export const ChartLegendTooltipLabel = (_a) => {
    var { dx = 0, index = 0, legendData, legendLabelComponent = React.createElement(ChartLabel, null), style, text, textAnchor = 'end', x, y } = _a, 
    // destructure last
    rest = __rest(_a, ["dx", "index", "legendData", "legendLabelComponent", "style", "text", "textAnchor", "x", "y"]);
    const getStyle = (styles) => {
        const applyDefaultStyle = (customStyle) => defaults(Object.assign({}, customStyle), {
            fill: ChartLegendTooltipStyles.label.fill
        });
        return Array.isArray(styles) ? styles.map(applyDefaultStyle) : applyDefaultStyle(styles);
    };
    const getLegendLabelComponent = () => {
        const label = legendData && legendData.length ? legendData[index].name : undefined;
        return React.cloneElement(legendLabelComponent, {
            style: getStyle({}),
            text: label,
            textAnchor: 'start',
            x,
            y
        });
    };
    const getValueLabelComponent = () => {
        const _x = x + Helpers.evaluateProp(dx);
        return React.createElement(ChartLabel, Object.assign({ style: getStyle(style), text: text, textAnchor: textAnchor, x: _x, y: y }, rest));
    };
    const legendLabel = getLegendLabelComponent();
    const valueLabel = getValueLabelComponent();
    return (React.createElement(React.Fragment, null,
        legendLabel,
        valueLabel));
};
ChartLegendTooltipLabel.displayName = 'ChartLegendTooltipLabel';
// Note: VictoryLabel.role must be hoisted
hoistNonReactStatics(ChartLegendTooltipLabel, VictoryLabel);
//# sourceMappingURL=ChartLegendTooltipLabel.js.map