import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { Helpers } from 'victory-core';
import { VictoryPie } from 'victory-pie';
import { ChartContainer } from '../ChartContainer';
import { ChartLegend } from '../ChartLegend';
import { ChartCommonStyles } from '../ChartTheme';
import { ChartTooltip } from '../ChartTooltip';
import { getComputedLegend, getPaddingForSide, getTheme } from '../ChartUtils';
export var ChartPieLabelPosition;
(function (ChartPieLabelPosition) {
    ChartPieLabelPosition["centroid"] = "centroid";
    ChartPieLabelPosition["endAngle"] = "endAngle";
    ChartPieLabelPosition["startAngle"] = "startAngle";
})(ChartPieLabelPosition || (ChartPieLabelPosition = {}));
export var ChartPieLegendPosition;
(function (ChartPieLegendPosition) {
    ChartPieLegendPosition["bottom"] = "bottom";
    ChartPieLegendPosition["right"] = "right";
})(ChartPieLegendPosition || (ChartPieLegendPosition = {}));
export var ChartPieSortOrder;
(function (ChartPieSortOrder) {
    ChartPieSortOrder["ascending"] = "ascending";
    ChartPieSortOrder["descending"] = "descending";
})(ChartPieSortOrder || (ChartPieSortOrder = {}));
export const ChartPie = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, constrainToVisibleArea = false, containerComponent = React.createElement(ChartContainer, null), labels, legendAllowWrap = false, legendComponent = React.createElement(ChartLegend, null), legendData, legendPosition = ChartCommonStyles.legend.position, padding, radius, standalone = true, themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant), labelComponent = allowTooltip ? (React.createElement(ChartTooltip, { constrainToVisibleArea: constrainToVisibleArea, theme: theme })) : (undefined), legendOrientation = theme.legend.orientation, height = theme.pie.height, width = theme.pie.width } = _a, rest = __rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "constrainToVisibleArea", "containerComponent", "labels", "legendAllowWrap", "legendComponent", "legendData", "legendPosition", "padding", "radius", "standalone", "themeColor", "themeVariant", "theme", "labelComponent", "legendOrientation", "height", "width"]);
    const defaultPadding = {
        bottom: getPaddingForSide('bottom', padding, theme.pie.padding),
        left: getPaddingForSide('left', padding, theme.pie.padding),
        right: getPaddingForSide('right', padding, theme.pie.padding),
        top: getPaddingForSide('top', padding, theme.pie.padding)
    };
    const chartRadius = radius
        ? radius
        : Helpers.getRadius({
            height,
            width,
            padding: defaultPadding
        });
    const chart = (React.createElement(VictoryPie, Object.assign({ height: height, key: "pf-chart-pie", labels: labels, labelComponent: labelComponent, padding: padding, radius: chartRadius, standalone: false, theme: theme, width: width }, rest)));
    const legend = React.cloneElement(legendComponent, Object.assign({ data: legendData, key: 'pf-chart-pie-legend', orientation: legendOrientation, theme }, legendComponent.props));
    // Returns a computed legend
    const getLegend = () => {
        if (!legend.props.data) {
            return null;
        }
        return getComputedLegend({
            allowWrap: legendAllowWrap,
            chartType: 'pie',
            height,
            legendComponent: legend,
            padding: defaultPadding,
            position: legendPosition,
            theme,
            width
        });
    };
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart, getLegend()]);
    return standalone ? (React.createElement(React.Fragment, null, container)) : (React.createElement(React.Fragment, null,
        chart,
        getLegend()));
};
ChartPie.displayName = 'ChartPie';
// Note: VictoryPie.role must be hoisted
hoistNonReactStatics(ChartPie, VictoryPie);
//# sourceMappingURL=ChartPie.js.map