import * as React from 'react';
import { OUIAProps } from '../../helpers';
export interface MenuProps extends Omit<React.HTMLAttributes<HTMLDivElement>, 'ref' | 'onSelect'>, OUIAProps {
    /** Anything that can be rendered inside of the Menu */
    children?: React.ReactNode;
    /** Additional classes added to the Menu */
    className?: string;
    /** Callback for updating when item selection changes. You can also specify onClick on the MenuItem. */
    onSelect?: (event?: any, itemId?: any) => void;
    /** Single itemId for single select menus, or array of itemIds for multi select. You can also specify isSelected on the MenuItem. */
    selected?: any | any[];
    /** Callback called when an MenuItems's action button is clicked. You can also specify it within a MenuItemAction. */
    onActionClick?: (event?: any, itemId?: any, actionId?: any) => void;
    /** Search input of menu */
    hasSearchInput?: boolean;
    /** A callback for when the input value changes. */
    onSearchInputChange?: (event: React.FormEvent<HTMLInputElement> | React.SyntheticEvent<HTMLButtonElement>, value: string) => void;
    /** Accessibility label */
    'aria-label'?: string;
    /** Indicates if menu contains a flyout menu */
    containsFlyout?: boolean;
    /** itemId of the currently active item. You can also specify isActive on the MenuItem. */
    activeItemId?: any;
    /** Forwarded ref */
    innerRef?: React.Ref<any>;
}
export interface MenuState {
    searchInputValue: string | null;
    ouiaStateId: string;
}
export declare const Menu: React.ForwardRefExoticComponent<MenuProps & React.RefAttributes<HTMLDivElement>>;
//# sourceMappingURL=Menu.d.ts.map