"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuItem = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const menu_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Menu/menu"));
const react_styles_1 = require("@patternfly/react-styles");
const external_link_alt_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/external-link-alt-icon"));
const angle_right_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-right-icon"));
const check_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/check-icon"));
const MenuContext_1 = require("./MenuContext");
const MenuItemAction_1 = require("./MenuItemAction");
const MenuItemBase = (_a) => {
    var { children, className, itemId = null, to, isActive = null, isFavorited = null, flyoutMenu, description = null, onClick = () => { }, component, isDisabled = false, isExternalLink = false, isSelected = null, icon, actions, onShowFlyout, innerRef } = _a, props = tslib_1.__rest(_a, ["children", "className", "itemId", "to", "isActive", "isFavorited", "flyoutMenu", "description", "onClick", "component", "isDisabled", "isExternalLink", "isSelected", "icon", "actions", "onShowFlyout", "innerRef"]);
    const Component = component || to ? 'a' : 'button';
    const [flyoutVisible, setFlyoutVisible] = React.useState(false);
    const showFlyout = (displayFlyout) => {
        setFlyoutVisible(displayFlyout);
        onShowFlyout && displayFlyout && onShowFlyout();
    };
    const onItemSelect = (event, onSelect) => {
        // Trigger callback for Menu onSelect
        onSelect && onSelect(event, itemId);
        // Trigger callback for item onClick
        onClick && onClick(event);
    };
    const renderItem = (onSelect, activeItemId, selected) => {
        const additionalProps = Component === 'a'
            ? {
                href: to,
                'aria-disabled': isDisabled ? true : null,
                tabIndex: isDisabled ? -1 : null
            }
            : {};
        const getAriaCurrent = () => {
            if (isActive !== null) {
                if (isActive) {
                    return 'page';
                }
                else {
                    return null;
                }
            }
            else if (itemId !== null && activeItemId !== null) {
                return itemId === activeItemId;
            }
            return null;
        };
        const getIsSelected = () => {
            if (isSelected !== null) {
                return isSelected;
            }
            else if (selected !== null && itemId !== null) {
                return (Array.isArray(selected) && selected.includes(itemId)) || itemId === selected;
            }
            return false;
        };
        return (React.createElement(React.Fragment, null,
            React.createElement(Component, Object.assign({ onClick: (event) => onItemSelect(event, onSelect), className: react_styles_1.css(menu_1.default.menuItem, getIsSelected() && menu_1.default.modifiers.selected, className), "aria-current": getAriaCurrent() }, (isDisabled && { disabled: true }), additionalProps),
                React.createElement("div", { className: react_styles_1.css(menu_1.default.menuItemMain) },
                    icon && React.createElement("span", { className: react_styles_1.css(menu_1.default.menuItemIcon) }, icon),
                    React.createElement("span", { className: react_styles_1.css(menu_1.default.menuItemText) }, children),
                    isExternalLink && (React.createElement("span", { className: react_styles_1.css(menu_1.default.menuItemExternalIcon) },
                        React.createElement(external_link_alt_icon_1.default, { "aria-hidden": true }))),
                    flyoutMenu && (React.createElement("span", { className: react_styles_1.css(menu_1.default.menuItemToggleIcon) },
                        React.createElement(angle_right_icon_1.default, { "aria-hidden": true }))),
                    getIsSelected() && (React.createElement("span", { className: react_styles_1.css(menu_1.default.menuItemSelectIcon) },
                        React.createElement(check_icon_1.default, { "aria-hidden": true })))),
                description && (React.createElement("div", { className: react_styles_1.css(menu_1.default.menuItemDescription) },
                    React.createElement("span", null, description)))),
            flyoutVisible && flyoutMenu));
    };
    return (React.createElement("li", Object.assign({ className: react_styles_1.css(menu_1.default.menuListItem, isDisabled && menu_1.default.modifiers.disabled, className), onMouseOver: flyoutMenu !== undefined ? () => showFlyout(true) : undefined, onMouseLeave: flyoutMenu !== undefined ? () => showFlyout(false) : undefined, ref: innerRef }, props),
        React.createElement(MenuContext_1.MenuContext.Consumer, null, ({ onSelect, onActionClick, activeItemId, selected }) => (React.createElement(React.Fragment, null,
            renderItem(onSelect, activeItemId, selected),
            React.createElement(MenuContext_1.MenuItemContext.Provider, { value: { itemId, isDisabled } },
                actions,
                isFavorited !== null && (React.createElement(MenuItemAction_1.MenuItemAction, { icon: "favorites", isFavorited: isFavorited, "aria-label": isFavorited ? 'starred' : 'not starred', onClick: event => onActionClick(event, itemId), actionId: "fav" }))))))));
};
exports.MenuItem = React.forwardRef((props, ref) => (React.createElement(MenuItemBase, Object.assign({}, props, { innerRef: ref }))));
exports.MenuItem.displayName = 'MenuItem';
//# sourceMappingURL=MenuItem.js.map