"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmAutoRefreshSelect = exports.savePollInterval = void 0;
var react_1 = __importStar(require("react"));
var react_icons_1 = require("@patternfly/react-icons");
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var DEFAULT_REFRESH_TIME = 60;
var REFRESH_VALUES = [30, 60, 5 * 60, 30 * 60, 0];
var REFRESH_INTERVAL_COOKIE = 'acm-page-refresh-interval';
var useStyles = styles_1.makeStyles({
    container: {
        display: 'flex',
        alignItems: 'center',
        maxWidth: '225px',
    },
    reloadButton: {
        cursor: 'pointer',
        marginRight: '0.6rem',
    },
    buttonTitle: {
        maxWidth: '200px',
        '& button': {
            paddingLeft: '0',
            paddingRight: '0',
            '& span': {
                fontSize: 'var(--pf-global--FontSize--sm)',
                color: 'var(--pf-global--primary-color--100)',
            },
            '& span:last-of-type': {
                marginRight: '0',
            },
            '&:hover, &:focus': {
                '& span': {
                    color: 'var(--pf-global--primary-color--200)',
                },
            },
        },
    },
    icon: {
        maxWidth: '25px',
        color: 'var(--pf-global--primary-color--100)',
    },
});
var savePollInterval = function (pollInterval) {
    localStorage.setItem(REFRESH_INTERVAL_COOKIE, "" + pollInterval);
};
exports.savePollInterval = savePollInterval;
var initializeLocalStorage = function (initialValue) {
    var key = REFRESH_INTERVAL_COOKIE;
    return react_1.useState(function () {
        var _a;
        if (initialValue) {
            window.localStorage.setItem(key, "" + initialValue);
            return initialValue;
        }
        else if (window && window.localStorage && window.localStorage.getItem(key)) {
            /* istanbul ignore next */
            var value = (_a = window.localStorage.getItem(key)) !== null && _a !== void 0 ? _a : "" + DEFAULT_REFRESH_TIME * 1000;
            return parseInt(value, 10);
        }
        window.localStorage.setItem(key, "" + DEFAULT_REFRESH_TIME * 1000);
        return DEFAULT_REFRESH_TIME * 1000;
    });
};
function AcmAutoRefreshSelect(props) {
    var _a = react_1.useState(false), isOpen = _a[0], setOpen = _a[1];
    var _b = initializeLocalStorage(props.pollInterval), selected = _b[0], setStoredValue = _b[1];
    var _c = react_1.useState(false), addedListener = _c[0], setAddedListener = _c[1];
    var _d = react_1.useState(false), docHidden = _d[0], setDocHidden = _d[1];
    var onVisibilityChange = function () {
        setDocHidden(window.document.hidden);
    };
    if (!addedListener) {
        document.addEventListener('visibilitychange', onVisibilityChange);
        setAddedListener(true);
    }
    var setValue = function (value) {
        setStoredValue(value);
        window.localStorage.setItem(REFRESH_INTERVAL_COOKIE, "" + value);
    };
    var classes = useStyles();
    var refetch = props.refetch;
    react_1.useEffect(function () {
        refetch();
        exports.savePollInterval(selected);
        if (!docHidden && selected !== 0) {
            var interval_1 = setInterval(function () {
                refetch();
            }, selected);
            return function () {
                document.removeEventListener('visibilitychange', onVisibilityChange);
                setAddedListener(false);
                clearInterval(interval_1);
            };
        }
        return;
    }, [selected, docHidden]);
    var handleKeyPress = function (e) {
        /* istanbul ignore else */
        if (e.key === 'Enter') {
            refetch();
        }
    };
    var autoRefreshChoices = (props.refreshIntervals || REFRESH_VALUES).map(function (pi) {
        var id;
        if (pi >= 60) {
            id = "refresh-" + pi / 60 + "m";
        }
        else if (pi !== 0) {
            id = "refresh-" + pi + "s";
        }
        else {
            id = 'refresh-disable';
        }
        pi *= 1000;
        return { id: id, pi: pi };
    });
    var conversion = function (pi) {
        if (pi >= 60000) {
            return "Refresh every " + pi / 60000 + "m";
        }
        else if (pi !== 0) {
            return "Refresh every " + pi / 1000 + "s";
        }
        else {
            return 'Disable refresh';
        }
    };
    return (react_1.default.createElement("div", { className: classes.container },
        react_1.default.createElement("div", { className: classes.reloadButton, tabIndex: 0, id: 'refresh-icon', "aria-label": 'refresh-icon', role: 'button', onClick: function () { return refetch(); }, onKeyPress: handleKeyPress },
            react_1.default.createElement(react_icons_1.SyncAltIcon, { className: classes.icon })),
        react_1.default.createElement(react_core_1.Dropdown, { className: classes.buttonTitle, "aria-label": 'refetch-intervals', id: "refresh-dropdown", onSelect: function () { return setOpen(!isOpen); }, isOpen: isOpen, isPlain: true, toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "refresh-toggle", "aria-label": "refresh-label", isDisabled: false, onToggle: function () { return setOpen(!isOpen); } }, conversion(selected)), dropdownItems: autoRefreshChoices.map(function (item) { return (react_1.default.createElement(react_core_1.DropdownItem, __assign({ key: item.id }, item, { onClick: function () { return setValue(item.pi); } }), conversion(item.pi))); }) })));
}
exports.AcmAutoRefreshSelect = AcmAutoRefreshSelect;
//# sourceMappingURL=AcmAutoRefreshSelect.js.map