"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmLogWindow = void 0;
var react_1 = __importStar(require("react"));
var styles_1 = require("@material-ui/styles");
require("@patternfly/react-core/dist/styles/base.css");
var AcmSelect_1 = require("../AcmSelect/AcmSelect");
var react_core_1 = require("@patternfly/react-core");
var useStyles = styles_1.makeStyles({
    containerSelect: {
        width: '33%',
    },
    logWindow: {
        color: 'var(--pf-global--palette--black-150)',
        backgroundColor: 'var(--pf-global--palette--black-1000)',
    },
    logWindowHeader: {
        display: 'flex',
        alignItems: 'center',
        backgroundColor: 'var(--pf-global--palette--black-900)',
        marginTop: '1rem',
    },
    logWindowHeaderItem: {
        display: 'flex',
        alignItems: 'center',
        height: '36px',
        backgroundColor: 'var(--pf-global--palette--black-900)',
        padding: '8px 10px 5px 10px',
        borderRight: '1px solid #4f5255',
    },
    logWindowHeaderItemLabel: {
        paddingRight: '.5rem',
    },
    logWindowBody: {
        backgroundColor: 'var(--pf-global--palette--black-1000)',
        fontFamily: 'Menlo,Monaco,Consolas,monospace',
    },
    logWindowScrollPane: {
        overflow: 'auto',
        paddingTop: '10px',
    },
    logWindowContents: {
        height: '500px',
    },
    logWindowLines: {
        paddingLeft: '10px',
        paddingRight: '10px',
        whiteSpace: 'pre',
        width: 0,
    },
});
function AcmLogWindow(props) {
    var cluster = props.cluster, namespace = props.namespace, initialContainer = props.initialContainer, containers = props.containers, onSwitchContainer = props.onSwitchContainer, logs = props.logs;
    var classes = useStyles(props);
    var _a = react_1.useState(initialContainer), selectedContainer = _a[0], setSelectedContainer = _a[1];
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(AcmSelect_1.AcmSelect, { id: 'container-select', label: '', className: classes.containerSelect, value: selectedContainer, onChange: function (value) {
                setSelectedContainer(value);
                onSwitchContainer(value);
            } }, containers.map(function (container) {
            return (react_1.default.createElement(react_core_1.SelectOption, { key: container, value: container }, container));
        })),
        react_1.default.createElement("div", { className: classes.logWindow },
            react_1.default.createElement("div", { className: classes.logWindowHeader },
                react_1.default.createElement("div", { className: classes.logWindowHeaderItem },
                    react_1.default.createElement("p", { className: classes.logWindowHeaderItemLabel }, 'Cluster:'),
                    cluster),
                react_1.default.createElement("div", { className: classes.logWindowHeaderItem },
                    react_1.default.createElement("p", { className: classes.logWindowHeaderItemLabel }, 'Namespace:'),
                    namespace)),
            react_1.default.createElement("div", { className: classes.logWindowBody },
                react_1.default.createElement("div", { className: classes.logWindowScrollPane },
                    react_1.default.createElement("div", { className: classes.logWindowContents },
                        react_1.default.createElement("div", { id: 'log-window-lines-container', className: classes.logWindowLines }, logs)))))));
}
exports.AcmLogWindow = AcmLogWindow;
//# sourceMappingURL=AcmLogWindow.js.map