"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.add = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
function makeHookExecutable(file) {
    fs_1.default.chmodSync(file, 0o0755);
}
function createHookFile(file, cmd) {
    const dir = path_1.default.dirname(file);
    if (!fs_1.default.existsSync(dir)) {
        throw new Error(`can't create hook, ${dir} directory doesn't exist`);
    }
    if (fs_1.default.existsSync(file)) {
        throw new Error(`${file} already exists`);
    }
    const data = ['#!/bin/sh', '. "$(dirname "$0")/_/husky.sh"', '', cmd].join('\n');
    fs_1.default.writeFileSync(file, data, 'utf-8');
    console.log(`created ${dir}${path_1.default.sep}${path_1.default.basename(file)}`);
}
function add(file, cmd) {
    createHookFile(file, cmd);
    makeHookExecutable(file);
}
exports.add = add;
