export interface SubscriptionOptions {
    eventSourceOptions?: {
        withCredentials?: boolean;
        [key: string]: any;
    };
    keepAlive?: {
        eventType?: string;
        intervalMs: number;
    };
    onComplete?: () => void;
    onError?: (error: Error) => void;
    onNext?: (data: string) => void;
    searchParams?: {
        [key: string]: string;
    };
    url: string;
}
export declare class Subscription {
    eventSource: EventSource;
    private options;
    private keepAliveTimer?;
    private keepAliveLastReceivedAt;
    private url;
    constructor(options: SubscriptionOptions);
    private connect;
    get closed(): boolean;
    unsubscribe(): void;
}
