"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartPoint = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const victory_core_1 = require("victory-core");
const path_helpers_1 = require("./path-helpers");
const getPath = (props) => {
    const { x, y } = props;
    const size = victory_core_1.Helpers.evaluateProp(props.size, props);
    if (props.getPath) {
        return props.getPath(x, y, size);
    }
    const pathFunctions = {
        circle: path_helpers_1.PathHelpers.circle,
        square: path_helpers_1.PathHelpers.square,
        diamond: path_helpers_1.PathHelpers.diamond,
        eyeSlash: path_helpers_1.PathHelpers.eyeSlash,
        triangleDown: path_helpers_1.PathHelpers.triangleDown,
        triangleUp: path_helpers_1.PathHelpers.triangleUp,
        plus: path_helpers_1.PathHelpers.plus,
        minus: path_helpers_1.PathHelpers.minus,
        star: path_helpers_1.PathHelpers.star,
        dash: path_helpers_1.PathHelpers.dash,
        threshold: path_helpers_1.PathHelpers.threshold
    };
    const symbol = victory_core_1.Helpers.evaluateProp(props.symbol, props);
    const key = symbol;
    const symbolFunction = typeof pathFunctions[key] === 'function' ? pathFunctions[key] : pathFunctions.square;
    return symbolFunction(x, y, size);
};
exports.ChartPoint = (_a) => {
    var { active, className, clipPath, datum, desc, events, pathComponent = React.createElement(victory_core_1.Path, null), role = 'presentation', shapeRendering = 'auto', tabIndex, transform } = _a, rest = tslib_1.__rest(_a, ["active", "className", "clipPath", "datum", "desc", "events", "pathComponent", "role", "shapeRendering", "tabIndex", "transform"]);
    const props = Object.assign({ active,
        className,
        clipPath,
        datum,
        desc,
        events,
        role,
        shapeRendering,
        tabIndex,
        transform }, rest);
    return React.cloneElement(pathComponent, Object.assign(Object.assign({ className,
        clipPath, d: getPath(props), desc: victory_core_1.Helpers.evaluateProp(desc, props) }, events), { role,
        shapeRendering, style: victory_core_1.Helpers.evaluateStyle(rest.style, props), tabIndex: victory_core_1.Helpers.evaluateProp(tabIndex, props), transform }));
};
exports.ChartPoint.displayName = 'ChartPoint';
//# sourceMappingURL=ChartPoint.js.map