"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isRegExp2 = _interopRequireDefault(require("lodash/isRegExp"));

var _isString2 = _interopRequireDefault(require("lodash/isString"));

var _includes2 = _interopRequireDefault(require("lodash/includes"));

var _isEmpty2 = _interopRequireDefault(require("lodash/isEmpty"));

var _isFunction2 = _interopRequireDefault(require("lodash/isFunction"));

var _throttle2 = _interopRequireDefault(require("lodash/throttle"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _victoryCore = require("victory-core");

var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));

var _index = _interopRequireDefault(require("delaunay-find/lib/index.js"));

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

var VoronoiHelpers = {
  withinBounds: function (props, point) {
    var width = props.width,
        height = props.height,
        polar = props.polar,
        origin = props.origin,
        scale = props.scale;

    var padding = _victoryCore.Helpers.getPadding(props, "voronoiPadding");

    var x = point.x,
        y = point.y;

    if (polar) {
      var distanceSquared = Math.pow(x - origin.x, 2) + Math.pow(y - origin.y, 2);
      var radius = Math.max.apply(Math, _toConsumableArray(scale.y.range()));
      return distanceSquared < Math.pow(radius, 2);
    } else {
      return x >= padding.left && x <= width - padding.right && y >= padding.top && y <= height - padding.bottom;
    }
  },
  getDatasets: function (props) {
    var children = _react.default.Children.toArray(props.children);

    var addMeta = function (data, name, child) {
      var continuous = child && child.type && child.type.continuous;
      var style = child ? child.props && child.props.style : props.style;
      return data.map(function (datum, index) {
        var _Helpers$getPoint = _victoryCore.Helpers.getPoint(datum),
            x = _Helpers$getPoint.x,
            y = _Helpers$getPoint.y,
            y0 = _Helpers$getPoint.y0,
            x0 = _Helpers$getPoint.x0;

        var voronoiX = (+x + +x0) / 2;
        var voronoiY = (+y + +y0) / 2;
        return (0, _assign2.default)({
          _voronoiX: props.voronoiDimension === "y" ? 0 : voronoiX,
          _voronoiY: props.voronoiDimension === "x" ? 0 : voronoiY,
          eventKey: index,
          childName: name,
          continuous: continuous,
          style: style
        }, datum);
      });
    };

    if (props.data) {
      return addMeta(props.data);
    }

    var getData = function (childProps) {
      var data = _victoryCore.Data.getData(childProps);

      return Array.isArray(data) && data.length > 0 ? data : undefined;
    };

    var iteratee = function (child, childName) {
      var childProps = child.props || {};
      var name = childProps.name || childName;
      var blacklist = props.voronoiBlacklist || [];
      var blacklistStr = blacklist.filter(_isString2.default);
      var blacklistRegExp = blacklist.filter(_isRegExp2.default);
      var isRegExpMatch = blacklistRegExp.some(function (regExp) {
        return regExp.test(name);
      });

      if (!_victoryCore.Data.isDataComponent(child) || (0, _includes2.default)(blacklistStr, name) || isRegExpMatch) {
        return null;
      }

      var getChildData = child.type && (0, _isFunction2.default)(child.type.getData) ? child.type.getData : getData;
      var childData = getChildData(child.props);
      return childData ? addMeta(childData, name, child) : null;
    };

    return _victoryCore.Helpers.reduceChildren(children, iteratee, props);
  },
  findPoints: function (datasets, point) {
    return datasets.filter(function (d) {
      return point._voronoiX === d._voronoiX && point._voronoiY === d._voronoiY;
    });
  },
  withinRadius: function (point, mousePosition, radius) {
    if (!point) {
      return false;
    }

    if (!radius) {
      return true;
    }

    var x = mousePosition.x,
        y = mousePosition.y;
    var distanceSquared = Math.pow(x - point[0], 2) + Math.pow(y - point[1], 2);
    return distanceSquared < Math.pow(radius, 2);
  },
  getVoronoiPoints: function (props, mousePosition) {
    var datasets = this.getDatasets(props);
    var scaledData = datasets.map(function (d) {
      var _Helpers$scalePoint = _victoryCore.Helpers.scalePoint(props, d),
          x = _Helpers$scalePoint.x,
          y = _Helpers$scalePoint.y;

      return [x, y];
    });

    var delaunay = _index.default.from(scaledData);

    var index = delaunay.find(mousePosition.x, mousePosition.y);
    var withinRadius = this.withinRadius(scaledData[index], mousePosition, props.radius);
    var points = withinRadius ? this.findPoints(datasets, datasets[index]) : [];
    return {
      points: points,
      index: index
    };
  },
  getActiveMutations: function (props, point) {
    var childName = point.childName,
        continuous = point.continuous;
    var activateData = props.activateData,
        activateLabels = props.activateLabels,
        labels = props.labels;

    if (!activateData && !activateLabels) {
      return [];
    }

    var defaultTarget = activateData ? ["data"] : [];
    var targets = labels && !activateLabels ? defaultTarget : defaultTarget.concat("labels");

    if ((0, _isEmpty2.default)(targets)) {
      return [];
    }

    return targets.map(function (target) {
      var eventKey = continuous === true && target === "data" ? "all" : point.eventKey;
      return {
        childName: childName,
        eventKey: eventKey,
        target: target,
        mutation: function () {
          return {
            active: true
          };
        }
      };
    });
  },
  getInactiveMutations: function (props, point) {
    var childName = point.childName,
        continuous = point.continuous;
    var activateData = props.activateData,
        activateLabels = props.activateLabels,
        labels = props.labels;

    if (!activateData && !activateLabels) {
      return [];
    }

    var defaultTarget = activateData ? ["data"] : [];
    var targets = labels && !activateLabels ? defaultTarget : defaultTarget.concat("labels");

    if ((0, _isEmpty2.default)(targets)) {
      return [];
    }

    return targets.map(function (target) {
      var eventKey = continuous && target === "data" ? "all" : point.eventKey;
      return {
        childName: childName,
        eventKey: eventKey,
        target: target,
        mutation: function () {
          return null;
        }
      };
    });
  },
  // eslint-disable-next-line max-params
  getParentMutation: function (activePoints, mousePosition, parentSVG, vIndex) {
    return [{
      target: "parent",
      eventKey: "parent",
      mutation: function () {
        return {
          activePoints: activePoints,
          mousePosition: mousePosition,
          parentSVG: parentSVG,
          vIndex: vIndex
        };
      }
    }];
  },
  onActivated: function (props, points) {
    if ((0, _isFunction2.default)(props.onActivated)) {
      props.onActivated(points, props);
    }
  },
  onDeactivated: function (props, points) {
    if ((0, _isFunction2.default)(props.onDeactivated)) {
      props.onDeactivated(points, props);
    }
  },
  onMouseLeave: function (evt, targetProps) {
    var _this = this,
        _getParentMutation;

    var activePoints = targetProps.activePoints || [];
    this.onDeactivated(targetProps, activePoints);
    var inactiveMutations = activePoints.length ? activePoints.map(function (point) {
      return _this.getInactiveMutations(targetProps, point);
    }) : [];
    return (_getParentMutation = this.getParentMutation([])).concat.apply(_getParentMutation, _toConsumableArray(inactiveMutations));
  },
  onMouseMove: function (evt, targetProps) {
    var _this2 = this;

    // eslint-disable-line max-statements
    var activePoints = targetProps.activePoints || [];

    var parentSVG = targetProps.parentSVG || _victoryCore.Selection.getParentSVG(evt);

    var mousePosition = _victoryCore.Selection.getSVGEventCoordinates(evt, parentSVG);

    if (!this.withinBounds(targetProps, mousePosition)) {
      var _getParentMutation2;

      this.onDeactivated(targetProps, activePoints);
      var inactiveMutations = activePoints.length ? activePoints.map(function (point) {
        return _this2.getInactiveMutations(targetProps, point);
      }) : [];
      return (_getParentMutation2 = this.getParentMutation([], mousePosition, parentSVG)).concat.apply(_getParentMutation2, _toConsumableArray(inactiveMutations));
    }

    var _getVoronoiPoints = this.getVoronoiPoints(targetProps, mousePosition),
        _getVoronoiPoints$poi = _getVoronoiPoints.points,
        points = _getVoronoiPoints$poi === void 0 ? [] : _getVoronoiPoints$poi,
        index = _getVoronoiPoints.index;

    var parentMutations = this.getParentMutation(points, mousePosition, parentSVG, index);

    if (activePoints.length && (0, _reactFastCompare.default)(points, activePoints)) {
      return parentMutations;
    } else {
      this.onActivated(targetProps, points);
      this.onDeactivated(targetProps, activePoints);
      var activeMutations = points.length ? points.map(function (point) {
        return _this2.getActiveMutations(targetProps, point);
      }) : [];

      var _inactiveMutations = activePoints.length ? activePoints.map(function (point) {
        return _this2.getInactiveMutations(targetProps, point);
      }) : [];

      return parentMutations.concat.apply(parentMutations, _toConsumableArray(_inactiveMutations).concat(_toConsumableArray(activeMutations)));
    }
  }
};
var _default = {
  onMouseLeave: VoronoiHelpers.onMouseLeave.bind(VoronoiHelpers),
  onMouseMove: (0, _throttle2.default)(VoronoiHelpers.onMouseMove.bind(VoronoiHelpers), 32, // eslint-disable-line no-magic-numbers
  {
    leading: true,
    trailing: false
  })
};
exports.default = _default;