import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/TreeView/tree-view';
import { TreeViewList } from './TreeViewList';
import { TreeViewListItem } from './TreeViewListItem';
export const TreeView = (_a) => {
    var { data, isNested = false, hasChecks = false, hasBadges = false, defaultAllExpanded = false, icon, expandedIcon, parentItem, onSelect, onCheck, onSearch, searchProps, activeItems, compareItems = (item, itemToCheck) => item.id === itemToCheck.id } = _a, props = __rest(_a, ["data", "isNested", "hasChecks", "hasBadges", "defaultAllExpanded", "icon", "expandedIcon", "parentItem", "onSelect", "onCheck", "onSearch", "searchProps", "activeItems", "compareItems"]);
    const treeViewList = (React.createElement(TreeViewList, { isNested: isNested, onSearch: onSearch, searchProps: searchProps }, data.map(item => (React.createElement(TreeViewListItem, Object.assign({ key: item.name.toString(), name: item.name, id: item.id, defaultExpanded: item.defaultExpanded !== undefined ? item.defaultExpanded : defaultAllExpanded, onSelect: onSelect, onCheck: onCheck, hasCheck: item.hasCheck !== undefined ? item.hasCheck : hasChecks, checkProps: item.checkProps, hasBadge: item.hasBadge !== undefined ? item.hasBadge : hasBadges, badgeProps: item.badgeProps, activeItems: activeItems, parentItem: parentItem, itemData: item, icon: item.icon !== undefined ? item.icon : icon, expandedIcon: item.expandedIcon !== undefined ? item.expandedIcon : expandedIcon, action: item.action, compareItems: compareItems }, (item.children && {
        children: (React.createElement(TreeView, { data: item.children, isNested: true, parentItem: item, hasChecks: hasChecks, hasBadges: hasBadges, defaultAllExpanded: defaultAllExpanded, onSelect: onSelect, onCheck: onCheck, activeItems: activeItems, icon: icon, expandedIcon: expandedIcon }))
    })))))));
    return (React.createElement(React.Fragment, null, parentItem ? (treeViewList) : (React.createElement("div", Object.assign({ className: css(styles.treeView) }, props), treeViewList))));
};
TreeView.displayName = 'TreeView';
//# sourceMappingURL=TreeView.js.map