import { AnyEntry } from "./entry";
import { OptimisticWrapOptions } from "./index";
import { Unsubscribable } from "./helpers";
export declare type OptimisticDependencyFunction<TKey> = ((key: TKey) => void) & {
    dirty: (key: TKey) => void;
};
export declare type Dep<TKey> = Set<AnyEntry> & {
    subscribe: OptimisticWrapOptions<[TKey]>["subscribe"];
} & Unsubscribable;
export declare function dep<TKey>(options?: {
    subscribe: Dep<TKey>["subscribe"];
}): OptimisticDependencyFunction<TKey>;
