var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as monaco from "monaco-editor/esm/vs/editor/editor.api";
import * as PropTypes from "prop-types";
import * as React from "react";
import { noop, processSize } from "./utils";
var MonacoEditor = /** @class */ (function (_super) {
    __extends(MonacoEditor, _super);
    function MonacoEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.assignRef = function (component) {
            _this.containerElement = component;
        };
        _this.containerElement = undefined;
        return _this;
    }
    MonacoEditor.prototype.componentDidMount = function () {
        this.initMonaco();
    };
    MonacoEditor.prototype.componentDidUpdate = function (prevProps) {
        var _a = this.props, value = _a.value, language = _a.language, theme = _a.theme, height = _a.height, options = _a.options, width = _a.width, className = _a.className;
        var editor = this.editor;
        var model = editor.getModel();
        if (this.props.value != null && this.props.value !== model.getValue()) {
            this.__prevent_trigger_change_event = true;
            this.editor.pushUndoStop();
            // pushEditOperations says it expects a cursorComputer, but doesn't seem to need one.
            // @ts-expect-error
            model.pushEditOperations([], [
                {
                    range: model.getFullModelRange(),
                    text: value,
                },
            ]);
            this.editor.pushUndoStop();
            this.__prevent_trigger_change_event = false;
        }
        if (prevProps.language !== language) {
            monaco.editor.setModelLanguage(model, language);
        }
        if (prevProps.theme !== theme) {
            monaco.editor.setTheme(theme);
        }
        if (editor && (width !== prevProps.width || height !== prevProps.height)) {
            editor.layout();
        }
        if (prevProps.options !== options) {
            // Don't pass in the model on update because monaco crashes if we pass the model
            // a second time. See https://github.com/microsoft/monaco-editor/issues/2027
            var _model = options.model, optionsWithoutModel = __rest(options, ["model"]);
            editor.updateOptions(__assign(__assign({}, (className ? { extraEditorClassName: className } : {})), optionsWithoutModel));
        }
    };
    MonacoEditor.prototype.componentWillUnmount = function () {
        this.destroyMonaco();
    };
    MonacoEditor.prototype.destroyMonaco = function () {
        if (this.editor) {
            this.editor.dispose();
            var model = this.editor.getModel();
            if (model) {
                model.dispose();
            }
        }
        if (this._subscription) {
            this._subscription.dispose();
        }
    };
    MonacoEditor.prototype.initMonaco = function () {
        var value = this.props.value != null ? this.props.value : this.props.defaultValue;
        var _a = this.props, language = _a.language, theme = _a.theme, overrideServices = _a.overrideServices, className = _a.className;
        if (this.containerElement) {
            // Before initializing monaco editor
            var options = __assign(__assign({}, this.props.options), this.editorWillMount());
            this.editor = monaco.editor.create(this.containerElement, __assign(__assign(__assign({ value: value,
                language: language }, (className ? { extraEditorClassName: className } : {})), options), (theme ? { theme: theme } : {})), overrideServices);
            // After initializing monaco editor
            this.editorDidMount(this.editor);
        }
    };
    MonacoEditor.prototype.editorWillMount = function () {
        var editorWillMount = this.props.editorWillMount;
        var options = editorWillMount(monaco);
        return options || {};
    };
    MonacoEditor.prototype.editorDidMount = function (editor) {
        var _this = this;
        this.props.editorDidMount(editor, monaco);
        this._subscription = editor.onDidChangeModelContent(function (event) {
            if (!_this.__prevent_trigger_change_event) {
                _this.props.onChange(editor.getValue(), event);
            }
        });
    };
    MonacoEditor.prototype.render = function () {
        var _a = this.props, width = _a.width, height = _a.height;
        var fixedWidth = processSize(width);
        var fixedHeight = processSize(height);
        var style = {
            width: fixedWidth,
            height: fixedHeight,
        };
        return (React.createElement("div", { ref: this.assignRef, style: style, className: "react-monaco-editor-container" }));
    };
    MonacoEditor.propTypes = {
        width: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
        height: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
        value: PropTypes.string,
        defaultValue: PropTypes.string,
        language: PropTypes.string,
        theme: PropTypes.string,
        options: PropTypes.object,
        overrideServices: PropTypes.object,
        editorDidMount: PropTypes.func,
        editorWillMount: PropTypes.func,
        onChange: PropTypes.func,
        className: PropTypes.string,
    };
    MonacoEditor.defaultProps = {
        width: "100%",
        height: "100%",
        value: null,
        defaultValue: "",
        language: "javascript",
        theme: null,
        options: {},
        overrideServices: {},
        editorDidMount: noop,
        editorWillMount: noop,
        onChange: noop,
        className: null,
    };
    return MonacoEditor;
}(React.Component));
export default MonacoEditor;
//# sourceMappingURL=editor.js.map