"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmModal = void 0;
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var AcmAlert_1 = require("../AcmAlert/AcmAlert");
function AcmModal(props) {
    return (react_1.default.createElement(AcmAlert_1.AcmAlertProvider, null,
        react_1.default.createElement(AcmModalContent, __assign({}, props))));
}
exports.AcmModal = AcmModal;
function AcmModalContent(props) {
    var alertContext = react_1.useContext(AcmAlert_1.AcmAlertContext);
    react_1.useEffect(function () {
        if (!props.isOpen) {
            alertContext.clearAlerts();
        }
    }, [props.isOpen]);
    return react_1.default.createElement(react_core_1.Modal, __assign({}, props, { ref: null }));
}
//# sourceMappingURL=AcmModal.js.map