"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartCursorTooltip = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_core_1 = require("victory-core");
const victory_tooltip_1 = require("victory-tooltip");
const ChartLabel_1 = require("../ChartLabel");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
const ChartCursorFlyout_1 = require("./ChartCursorFlyout");
exports.ChartCursorTooltip = (_a) => {
    var { constrainToVisibleArea = true, flyoutComponent = React.createElement(ChartCursorFlyout_1.ChartCursorFlyout, null), labelComponent = React.createElement(ChartLabel_1.ChartLabel, null), labelTextAnchor = 'start', showPointer = true, style, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant), centerOffset = ChartUtils_1.getCursorTooltipCenterOffset({ offsetCursorDimensionX: true, theme }), pointerOrientation = ChartUtils_1.getCursorTooltipPoniterOrientation({ horizontal: true, theme }), pointerLength = showPointer && theme && theme.tooltip ? theme.tooltip.pointerLength : 0, pointerWidth = theme.tooltip.pointerWidth } = _a, rest = tslib_1.__rest(_a, ["constrainToVisibleArea", "flyoutComponent", "labelComponent", "labelTextAnchor", "showPointer", "style", "themeColor", "themeVariant", "theme", "centerOffset", "pointerOrientation", "pointerLength", "pointerWidth"]);
    // Apply text anchor style
    const applyDefaultStyle = (customStyle) => (Object.assign(Object.assign({}, customStyle), { textAnchor: labelTextAnchor // Workaround for VictoryTooltip.getLabelProps referencing the theme style only
     }));
    const newStyle = Array.isArray(style) ? style.map(applyDefaultStyle) : applyDefaultStyle(style);
    const getFlyoutComponent = () => {
        let _pointerLength = victory_core_1.Helpers.evaluateProp(pointerLength);
        if (showPointer && _pointerLength === 0) {
            _pointerLength = theme && theme.tooltip ? victory_core_1.Helpers.evaluateProp(theme.tooltip.pointerLength) : 10;
        }
        return React.cloneElement(flyoutComponent, Object.assign({ pointerLength: _pointerLength, pointerWidth }, flyoutComponent.props));
    };
    return (React.createElement(ChartTooltip_1.ChartTooltip, Object.assign({ centerOffset: centerOffset, constrainToVisibleArea: constrainToVisibleArea, flyoutComponent: getFlyoutComponent(), labelComponent: labelComponent, labelTextAnchor: labelTextAnchor, pointerOrientation: pointerOrientation, style: newStyle, theme: theme }, rest)));
};
exports.ChartCursorTooltip.displayName = 'ChartCursorTooltip';
// Note: VictoryTooltip.defaultEvents must be hoisted
hoist_non_react_statics_1.default(exports.ChartCursorTooltip, victory_tooltip_1.VictoryTooltip);
//# sourceMappingURL=ChartCursorTooltip.js.map