import * as monaco from "monaco-editor/esm/vs/editor/editor.api";
import * as PropTypes from "prop-types";
import * as React from "react";
import { MonacoEditorProps } from "./types";
import { noop } from "./utils";
declare class MonacoEditor extends React.Component<MonacoEditorProps> {
    static propTypes: {
        width: PropTypes.Requireable<string | number>;
        height: PropTypes.Requireable<string | number>;
        value: PropTypes.Requireable<string>;
        defaultValue: PropTypes.Requireable<string>;
        language: PropTypes.Requireable<string>;
        theme: PropTypes.Requireable<string>;
        options: PropTypes.Requireable<object>;
        overrideServices: PropTypes.Requireable<object>;
        editorDidMount: PropTypes.Requireable<(...args: any[]) => any>;
        editorWillMount: PropTypes.Requireable<(...args: any[]) => any>;
        onChange: PropTypes.Requireable<(...args: any[]) => any>;
        className: PropTypes.Requireable<string>;
    };
    static defaultProps: {
        width: string;
        height: string;
        value: any;
        defaultValue: string;
        language: string;
        theme: any;
        options: {};
        overrideServices: {};
        editorDidMount: typeof noop;
        editorWillMount: typeof noop;
        onChange: typeof noop;
        className: any;
    };
    editor?: monaco.editor.IStandaloneCodeEditor;
    private containerElement?;
    private _subscription;
    private __prevent_trigger_change_event?;
    constructor(props: MonacoEditorProps);
    componentDidMount(): void;
    componentDidUpdate(prevProps: MonacoEditorProps): void;
    componentWillUnmount(): void;
    assignRef: (component: HTMLDivElement) => void;
    destroyMonaco(): void;
    initMonaco(): void;
    editorWillMount(): monaco.editor.IStandaloneEditorConstructionOptions;
    editorDidMount(editor: monaco.editor.IStandaloneCodeEditor): void;
    render(): JSX.Element;
}
export default MonacoEditor;
