"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = void 0;
const fs_1 = __importDefault(require("fs"));
const log_1 = require("../log");
const install_1 = require("./install");
const set_add_1 = require("./set_add");
const regex = /^[ ]+|\t+/m;
function init(isYarn2) {
    var _a;
    const str = fs_1.default.readFileSync('package.json', 'utf-8');
    const pkg = JSON.parse(str);
    if (isYarn2) {
        pkg.scripts || (pkg.scripts = {});
        pkg.scripts.postinstall = 'husky install';
        if (pkg.private !== true) {
            pkg.scripts.prepublishOnly = 'pinst --disable';
            pkg.scripts.postpublish = 'pinst --enable';
            pkg.devDependencies || (pkg.devDependencies = {});
            pkg.devDependencies.pinst = '^2.0.0';
        }
    }
    else {
        pkg.scripts || (pkg.scripts = {});
        pkg.scripts.prepare = 'husky install';
    }
    const indent = (_a = regex.exec(str)) === null || _a === void 0 ? void 0 : _a[0];
    fs_1.default.writeFileSync('package.json', `${JSON.stringify(pkg, null, indent)}\n`);
    log_1.l('updated package.json');
    install_1.install();
    set_add_1.set('.husky/pre-commit', 'npm test');
}
exports.init = init;
