import React, { CSSProperties, ReactNode } from 'react';
export interface AcmAlertInfo {
    type?: 'success' | 'danger' | 'warning' | 'info' | 'default';
    title: ReactNode;
    message?: ReactNode;
    actions?: ReactNode;
    id?: string;
    group?: string;
    autoClose?: boolean;
}
export interface IAlertContext {
    readonly activeAlerts: AcmAlertInfo[];
    readonly alertInfos: AcmAlertInfo[];
    addAlert: (alertInfo: AcmAlertInfo) => void;
    removeAlert: (alertInfo: AcmAlertInfo) => void;
    removeVisibleAlert: (alertInfo: AcmAlertInfo) => void;
    clearAlerts: (matcher?: (alertInfo: AcmAlertInfo) => boolean) => void;
}
export declare const AcmAlertContext: React.Context<IAlertContext>;
export declare function AcmAlertProvider(props: {
    children: ReactNode;
    isToast?: boolean;
}): JSX.Element;
export declare function AcmAlert(props: {
    alertInfo?: AcmAlertInfo;
    isInline?: boolean;
    title?: ReactNode;
    subtitle?: ReactNode;
    message?: ReactNode;
    noClose?: boolean;
    variant?: 'success' | 'danger' | 'warning' | 'info' | 'default';
    style?: CSSProperties;
    className?: string;
}): JSX.Element;
export declare type AcmAlertGroupProps = {
    /** Show alerts in the group as inLine alerts */
    isInline?: boolean;
    /** Allow alerts in the group to be closed with a close button */
    canClose?: boolean;
};
export declare function AcmAlertGroup(props: AcmAlertGroupProps): JSX.Element;
