import { PopoverProps } from '@patternfly/react-core';
import React from 'react';
export declare type AcmProgressTrackerProps = {
    steps: ProgressTrackerStep[];
    isCentered?: boolean;
    Title: string;
    Subtitle: string;
    isStatusPopover?: boolean;
    isStacked?: boolean;
};
export declare type ProgressTrackerStep = {
    statusType: StatusType;
    statusText: string | React.ReactNode;
    popover?: PopoverProps;
    statusSubtitle?: string;
    link?: ProgressTrackerStepLink;
};
export declare type ProgressTrackerStepLink = {
    linkUrl?: string;
    linkName: string;
    isDisabled?: boolean;
    linkCallback?: () => void;
};
declare enum StatusType {
    'healthy' = "healthy",
    'danger' = "danger",
    'warning' = "warning",
    'progress' = "progress",
    'detached' = "detached",
    'pending' = "pending",
    'unknown' = "unknown",
    'sleep' = "sleep",
    'empty' = "empty"
}
export declare function AcmProgressTracker(props: AcmProgressTrackerProps): JSX.Element;
export {};
