// Copyright 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/bigtable/v1/bigtable_service_messages.proto

package bigtable

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for BigtableServer.ReadRows.
type ReadRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table from which to read.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// If neither row_key nor row_range is set, reads from all rows.
	//
	// Types that are assignable to Target:
	//	*ReadRowsRequest_RowKey
	//	*ReadRowsRequest_RowRange
	//	*ReadRowsRequest_RowSet
	Target isReadRowsRequest_Target `protobuf_oneof:"target"`
	// The filter to apply to the contents of the specified row(s). If unset,
	// reads the entire table.
	Filter *RowFilter `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// By default, rows are read sequentially, producing results which are
	// guaranteed to arrive in increasing row order. Setting
	// "allow_row_interleaving" to true allows multiple rows to be interleaved in
	// the response stream, which increases throughput but breaks this guarantee,
	// and may force the client to use more memory to buffer partially-received
	// rows. Cannot be set to true when specifying "num_rows_limit".
	AllowRowInterleaving bool `protobuf:"varint,6,opt,name=allow_row_interleaving,json=allowRowInterleaving,proto3" json:"allow_row_interleaving,omitempty"`
	// The read will terminate after committing to N rows' worth of results. The
	// default (zero) is to return all results.
	// Note that "allow_row_interleaving" cannot be set to true when this is set.
	NumRowsLimit int64 `protobuf:"varint,7,opt,name=num_rows_limit,json=numRowsLimit,proto3" json:"num_rows_limit,omitempty"`
}

func (x *ReadRowsRequest) Reset() {
	*x = ReadRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsRequest) ProtoMessage() {}

func (x *ReadRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsRequest.ProtoReflect.Descriptor instead.
func (*ReadRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{0}
}

func (x *ReadRowsRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (m *ReadRowsRequest) GetTarget() isReadRowsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *ReadRowsRequest) GetRowKey() []byte {
	if x, ok := x.GetTarget().(*ReadRowsRequest_RowKey); ok {
		return x.RowKey
	}
	return nil
}

func (x *ReadRowsRequest) GetRowRange() *RowRange {
	if x, ok := x.GetTarget().(*ReadRowsRequest_RowRange); ok {
		return x.RowRange
	}
	return nil
}

func (x *ReadRowsRequest) GetRowSet() *RowSet {
	if x, ok := x.GetTarget().(*ReadRowsRequest_RowSet); ok {
		return x.RowSet
	}
	return nil
}

func (x *ReadRowsRequest) GetFilter() *RowFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *ReadRowsRequest) GetAllowRowInterleaving() bool {
	if x != nil {
		return x.AllowRowInterleaving
	}
	return false
}

func (x *ReadRowsRequest) GetNumRowsLimit() int64 {
	if x != nil {
		return x.NumRowsLimit
	}
	return 0
}

type isReadRowsRequest_Target interface {
	isReadRowsRequest_Target()
}

type ReadRowsRequest_RowKey struct {
	// The key of a single row from which to read.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3,oneof"`
}

type ReadRowsRequest_RowRange struct {
	// A range of rows from which to read.
	RowRange *RowRange `protobuf:"bytes,3,opt,name=row_range,json=rowRange,proto3,oneof"`
}

type ReadRowsRequest_RowSet struct {
	// A set of rows from which to read. Entries need not be in order, and will
	// be deduplicated before reading.
	// The total serialized size of the set must not exceed 1MB.
	RowSet *RowSet `protobuf:"bytes,8,opt,name=row_set,json=rowSet,proto3,oneof"`
}

func (*ReadRowsRequest_RowKey) isReadRowsRequest_Target() {}

func (*ReadRowsRequest_RowRange) isReadRowsRequest_Target() {}

func (*ReadRowsRequest_RowSet) isReadRowsRequest_Target() {}

// Response message for BigtableService.ReadRows.
type ReadRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key of the row for which we're receiving data.
	// Results will be received in increasing row key order, unless
	// "allow_row_interleaving" was specified in the request.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// One or more chunks of the row specified by "row_key".
	Chunks []*ReadRowsResponse_Chunk `protobuf:"bytes,2,rep,name=chunks,proto3" json:"chunks,omitempty"`
}

func (x *ReadRowsResponse) Reset() {
	*x = ReadRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsResponse) ProtoMessage() {}

func (x *ReadRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsResponse.ProtoReflect.Descriptor instead.
func (*ReadRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{1}
}

func (x *ReadRowsResponse) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *ReadRowsResponse) GetChunks() []*ReadRowsResponse_Chunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

// Request message for BigtableService.SampleRowKeys.
type SampleRowKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table from which to sample row keys.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
}

func (x *SampleRowKeysRequest) Reset() {
	*x = SampleRowKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampleRowKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleRowKeysRequest) ProtoMessage() {}

func (x *SampleRowKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleRowKeysRequest.ProtoReflect.Descriptor instead.
func (*SampleRowKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{2}
}

func (x *SampleRowKeysRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

// Response message for BigtableService.SampleRowKeys.
type SampleRowKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sorted streamed sequence of sample row keys in the table. The table might
	// have contents before the first row key in the list and after the last one,
	// but a key containing the empty string indicates "end of table" and will be
	// the last response given, if present.
	// Note that row keys in this list may not have ever been written to or read
	// from, and users should therefore not make any assumptions about the row key
	// structure that are specific to their use case.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Approximate total storage space used by all rows in the table which precede
	// "row_key". Buffering the contents of all rows between two subsequent
	// samples would require space roughly equal to the difference in their
	// "offset_bytes" fields.
	OffsetBytes int64 `protobuf:"varint,2,opt,name=offset_bytes,json=offsetBytes,proto3" json:"offset_bytes,omitempty"`
}

func (x *SampleRowKeysResponse) Reset() {
	*x = SampleRowKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SampleRowKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleRowKeysResponse) ProtoMessage() {}

func (x *SampleRowKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleRowKeysResponse.ProtoReflect.Descriptor instead.
func (*SampleRowKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{3}
}

func (x *SampleRowKeysResponse) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *SampleRowKeysResponse) GetOffsetBytes() int64 {
	if x != nil {
		return x.OffsetBytes
	}
	return 0
}

// Request message for BigtableService.MutateRow.
type MutateRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table to which the mutation should be applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The key of the row to which the mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Changes to be atomically applied to the specified row. Entries are applied
	// in order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry and at most 100000.
	Mutations []*Mutation `protobuf:"bytes,3,rep,name=mutations,proto3" json:"mutations,omitempty"`
}

func (x *MutateRowRequest) Reset() {
	*x = MutateRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowRequest) ProtoMessage() {}

func (x *MutateRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowRequest.ProtoReflect.Descriptor instead.
func (*MutateRowRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{4}
}

func (x *MutateRowRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *MutateRowRequest) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *MutateRowRequest) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

// Request message for BigtableService.MutateRows.
type MutateRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table to which the mutations should be applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The row keys/mutations to be applied in bulk.
	// Each entry is applied as an atomic mutation, but the entries may be
	// applied in arbitrary order (even between entries for the same row).
	// At least one entry must be specified, and in total the entries may
	// contain at most 100000 mutations.
	Entries []*MutateRowsRequest_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *MutateRowsRequest) Reset() {
	*x = MutateRowsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsRequest) ProtoMessage() {}

func (x *MutateRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsRequest.ProtoReflect.Descriptor instead.
func (*MutateRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{5}
}

func (x *MutateRowsRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *MutateRowsRequest) GetEntries() []*MutateRowsRequest_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Response message for BigtableService.MutateRows.
type MutateRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results for each Entry from the request, presented in the order
	// in which the entries were originally given.
	// Depending on how requests are batched during execution, it is possible
	// for one Entry to fail due to an error with another Entry. In the event
	// that this occurs, the same error will be reported for both entries.
	Statuses []*status.Status `protobuf:"bytes,1,rep,name=statuses,proto3" json:"statuses,omitempty"`
}

func (x *MutateRowsResponse) Reset() {
	*x = MutateRowsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsResponse) ProtoMessage() {}

func (x *MutateRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsResponse.ProtoReflect.Descriptor instead.
func (*MutateRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{6}
}

func (x *MutateRowsResponse) GetStatuses() []*status.Status {
	if x != nil {
		return x.Statuses
	}
	return nil
}

// Request message for BigtableService.CheckAndMutateRowRequest
type CheckAndMutateRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table to which the conditional mutation should be
	// applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The key of the row to which the conditional mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// The filter to be applied to the contents of the specified row. Depending
	// on whether or not any results are yielded, either "true_mutations" or
	// "false_mutations" will be executed. If unset, checks that the row contains
	// any values at all.
	PredicateFilter *RowFilter `protobuf:"bytes,6,opt,name=predicate_filter,json=predicateFilter,proto3" json:"predicate_filter,omitempty"`
	// Changes to be atomically applied to the specified row if "predicate_filter"
	// yields at least one cell when applied to "row_key". Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if "false_mutations" is empty, and at most
	// 100000.
	TrueMutations []*Mutation `protobuf:"bytes,4,rep,name=true_mutations,json=trueMutations,proto3" json:"true_mutations,omitempty"`
	// Changes to be atomically applied to the specified row if "predicate_filter"
	// does not yield any cells when applied to "row_key". Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if "true_mutations" is empty, and at most
	// 100000.
	FalseMutations []*Mutation `protobuf:"bytes,5,rep,name=false_mutations,json=falseMutations,proto3" json:"false_mutations,omitempty"`
}

func (x *CheckAndMutateRowRequest) Reset() {
	*x = CheckAndMutateRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckAndMutateRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAndMutateRowRequest) ProtoMessage() {}

func (x *CheckAndMutateRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAndMutateRowRequest.ProtoReflect.Descriptor instead.
func (*CheckAndMutateRowRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{7}
}

func (x *CheckAndMutateRowRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *CheckAndMutateRowRequest) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *CheckAndMutateRowRequest) GetPredicateFilter() *RowFilter {
	if x != nil {
		return x.PredicateFilter
	}
	return nil
}

func (x *CheckAndMutateRowRequest) GetTrueMutations() []*Mutation {
	if x != nil {
		return x.TrueMutations
	}
	return nil
}

func (x *CheckAndMutateRowRequest) GetFalseMutations() []*Mutation {
	if x != nil {
		return x.FalseMutations
	}
	return nil
}

// Response message for BigtableService.CheckAndMutateRowRequest.
type CheckAndMutateRowResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not the request's "predicate_filter" yielded any results for
	// the specified row.
	PredicateMatched bool `protobuf:"varint,1,opt,name=predicate_matched,json=predicateMatched,proto3" json:"predicate_matched,omitempty"`
}

func (x *CheckAndMutateRowResponse) Reset() {
	*x = CheckAndMutateRowResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckAndMutateRowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAndMutateRowResponse) ProtoMessage() {}

func (x *CheckAndMutateRowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAndMutateRowResponse.ProtoReflect.Descriptor instead.
func (*CheckAndMutateRowResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{8}
}

func (x *CheckAndMutateRowResponse) GetPredicateMatched() bool {
	if x != nil {
		return x.PredicateMatched
	}
	return false
}

// Request message for BigtableService.ReadModifyWriteRowRequest.
type ReadModifyWriteRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the table to which the read/modify/write rules should be
	// applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The key of the row to which the read/modify/write rules should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Rules specifying how the specified row's contents are to be transformed
	// into writes. Entries are applied in order, meaning that earlier rules will
	// affect the results of later ones.
	Rules []*ReadModifyWriteRule `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ReadModifyWriteRowRequest) Reset() {
	*x = ReadModifyWriteRowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadModifyWriteRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadModifyWriteRowRequest) ProtoMessage() {}

func (x *ReadModifyWriteRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadModifyWriteRowRequest.ProtoReflect.Descriptor instead.
func (*ReadModifyWriteRowRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{9}
}

func (x *ReadModifyWriteRowRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *ReadModifyWriteRowRequest) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *ReadModifyWriteRowRequest) GetRules() []*ReadModifyWriteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Specifies a piece of a row's contents returned as part of the read
// response stream.
type ReadRowsResponse_Chunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Chunk:
	//	*ReadRowsResponse_Chunk_RowContents
	//	*ReadRowsResponse_Chunk_ResetRow
	//	*ReadRowsResponse_Chunk_CommitRow
	Chunk isReadRowsResponse_Chunk_Chunk `protobuf_oneof:"chunk"`
}

func (x *ReadRowsResponse_Chunk) Reset() {
	*x = ReadRowsResponse_Chunk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadRowsResponse_Chunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsResponse_Chunk) ProtoMessage() {}

func (x *ReadRowsResponse_Chunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsResponse_Chunk.ProtoReflect.Descriptor instead.
func (*ReadRowsResponse_Chunk) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{1, 0}
}

func (m *ReadRowsResponse_Chunk) GetChunk() isReadRowsResponse_Chunk_Chunk {
	if m != nil {
		return m.Chunk
	}
	return nil
}

func (x *ReadRowsResponse_Chunk) GetRowContents() *Family {
	if x, ok := x.GetChunk().(*ReadRowsResponse_Chunk_RowContents); ok {
		return x.RowContents
	}
	return nil
}

func (x *ReadRowsResponse_Chunk) GetResetRow() bool {
	if x, ok := x.GetChunk().(*ReadRowsResponse_Chunk_ResetRow); ok {
		return x.ResetRow
	}
	return false
}

func (x *ReadRowsResponse_Chunk) GetCommitRow() bool {
	if x, ok := x.GetChunk().(*ReadRowsResponse_Chunk_CommitRow); ok {
		return x.CommitRow
	}
	return false
}

type isReadRowsResponse_Chunk_Chunk interface {
	isReadRowsResponse_Chunk_Chunk()
}

type ReadRowsResponse_Chunk_RowContents struct {
	// A subset of the data from a particular row. As long as no "reset_row"
	// is received in between, multiple "row_contents" from the same row are
	// from the same atomic view of that row, and will be received in the
	// expected family/column/timestamp order.
	RowContents *Family `protobuf:"bytes,1,opt,name=row_contents,json=rowContents,proto3,oneof"`
}

type ReadRowsResponse_Chunk_ResetRow struct {
	// Indicates that the client should drop all previous chunks for
	// "row_key", as it will be re-read from the beginning.
	ResetRow bool `protobuf:"varint,2,opt,name=reset_row,json=resetRow,proto3,oneof"`
}

type ReadRowsResponse_Chunk_CommitRow struct {
	// Indicates that the client can safely process all previous chunks for
	// "row_key", as its data has been fully read.
	CommitRow bool `protobuf:"varint,3,opt,name=commit_row,json=commitRow,proto3,oneof"`
}

func (*ReadRowsResponse_Chunk_RowContents) isReadRowsResponse_Chunk_Chunk() {}

func (*ReadRowsResponse_Chunk_ResetRow) isReadRowsResponse_Chunk_Chunk() {}

func (*ReadRowsResponse_Chunk_CommitRow) isReadRowsResponse_Chunk_Chunk() {}

type MutateRowsRequest_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key of the row to which the `mutations` should be applied.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Changes to be atomically applied to the specified row. Mutations are
	// applied in order, meaning that earlier mutations can be masked by
	// later ones.
	// At least one mutation must be specified.
	Mutations []*Mutation `protobuf:"bytes,2,rep,name=mutations,proto3" json:"mutations,omitempty"`
}

func (x *MutateRowsRequest_Entry) Reset() {
	*x = MutateRowsRequest_Entry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateRowsRequest_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsRequest_Entry) ProtoMessage() {}

func (x *MutateRowsRequest_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsRequest_Entry.ProtoReflect.Descriptor instead.
func (*MutateRowsRequest_Entry) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP(), []int{5, 0}
}

func (x *MutateRowsRequest_Entry) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *MutateRowsRequest_Entry) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

var File_google_bigtable_v1_bigtable_service_messages_proto protoreflect.FileDescriptor

var file_google_bigtable_v1_bigtable_service_messages_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x02, 0x0a, 0x0f, 0x52, 0x65,
	0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a,
	0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x07,
	0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52,
	0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x0a, 0x09, 0x72, 0x6f, 0x77, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x08, 0x72, 0x6f, 0x77, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x35, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x53, 0x65,
	0x74, 0x48, 0x00, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x53, 0x65, 0x74, 0x12, 0x35, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x72, 0x6f, 0x77, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6c, 0x65, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x52, 0x6f, 0x77, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x6c, 0x65, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f,
	0x72, 0x6f, 0x77, 0x73, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x52, 0x6f, 0x77, 0x73, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x08,
	0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x83, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x61,
	0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x0a,
	0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64,
	0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x52, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x1a, 0x91, 0x01, 0x0a, 0x05, 0x43,
	0x68, 0x75, 0x6e, 0x6b, 0x12, 0x3f, 0x0a, 0x0c, 0x72, 0x6f, 0x77, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x6f, 0x77, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x72,
	0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x52, 0x6f, 0x77, 0x12, 0x1f, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x72,
	0x6f, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x52, 0x6f, 0x77, 0x42, 0x07, 0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x22, 0x35,
	0x0a, 0x14, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x15, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52,
	0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x10, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x3a, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xd7, 0x01, 0x0a, 0x11, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a,
	0x5c, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65,
	0x79, 0x12, 0x3a, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x44, 0x0a,
	0x12, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x2e, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x65, 0x73, 0x22, 0xa8, 0x02, 0x0a, 0x18, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x43, 0x0a, 0x0e, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x74, 0x72, 0x75, 0x65, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x0a, 0x0f, 0x66, 0x61, 0x6c, 0x73, 0x65,
	0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x66, 0x61, 0x6c, 0x73, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x48,
	0x0a, 0x19, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x6f, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x22, 0x92, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x61,
	0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x3d,
	0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x42, 0x74, 0x0a,
	0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x1c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_v1_bigtable_service_messages_proto_rawDescOnce sync.Once
	file_google_bigtable_v1_bigtable_service_messages_proto_rawDescData = file_google_bigtable_v1_bigtable_service_messages_proto_rawDesc
)

func file_google_bigtable_v1_bigtable_service_messages_proto_rawDescGZIP() []byte {
	file_google_bigtable_v1_bigtable_service_messages_proto_rawDescOnce.Do(func() {
		file_google_bigtable_v1_bigtable_service_messages_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_v1_bigtable_service_messages_proto_rawDescData)
	})
	return file_google_bigtable_v1_bigtable_service_messages_proto_rawDescData
}

var file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_bigtable_v1_bigtable_service_messages_proto_goTypes = []interface{}{
	(*ReadRowsRequest)(nil),           // 0: google.bigtable.v1.ReadRowsRequest
	(*ReadRowsResponse)(nil),          // 1: google.bigtable.v1.ReadRowsResponse
	(*SampleRowKeysRequest)(nil),      // 2: google.bigtable.v1.SampleRowKeysRequest
	(*SampleRowKeysResponse)(nil),     // 3: google.bigtable.v1.SampleRowKeysResponse
	(*MutateRowRequest)(nil),          // 4: google.bigtable.v1.MutateRowRequest
	(*MutateRowsRequest)(nil),         // 5: google.bigtable.v1.MutateRowsRequest
	(*MutateRowsResponse)(nil),        // 6: google.bigtable.v1.MutateRowsResponse
	(*CheckAndMutateRowRequest)(nil),  // 7: google.bigtable.v1.CheckAndMutateRowRequest
	(*CheckAndMutateRowResponse)(nil), // 8: google.bigtable.v1.CheckAndMutateRowResponse
	(*ReadModifyWriteRowRequest)(nil), // 9: google.bigtable.v1.ReadModifyWriteRowRequest
	(*ReadRowsResponse_Chunk)(nil),    // 10: google.bigtable.v1.ReadRowsResponse.Chunk
	(*MutateRowsRequest_Entry)(nil),   // 11: google.bigtable.v1.MutateRowsRequest.Entry
	(*RowRange)(nil),                  // 12: google.bigtable.v1.RowRange
	(*RowSet)(nil),                    // 13: google.bigtable.v1.RowSet
	(*RowFilter)(nil),                 // 14: google.bigtable.v1.RowFilter
	(*Mutation)(nil),                  // 15: google.bigtable.v1.Mutation
	(*status.Status)(nil),             // 16: google.rpc.Status
	(*ReadModifyWriteRule)(nil),       // 17: google.bigtable.v1.ReadModifyWriteRule
	(*Family)(nil),                    // 18: google.bigtable.v1.Family
}
var file_google_bigtable_v1_bigtable_service_messages_proto_depIdxs = []int32{
	12, // 0: google.bigtable.v1.ReadRowsRequest.row_range:type_name -> google.bigtable.v1.RowRange
	13, // 1: google.bigtable.v1.ReadRowsRequest.row_set:type_name -> google.bigtable.v1.RowSet
	14, // 2: google.bigtable.v1.ReadRowsRequest.filter:type_name -> google.bigtable.v1.RowFilter
	10, // 3: google.bigtable.v1.ReadRowsResponse.chunks:type_name -> google.bigtable.v1.ReadRowsResponse.Chunk
	15, // 4: google.bigtable.v1.MutateRowRequest.mutations:type_name -> google.bigtable.v1.Mutation
	11, // 5: google.bigtable.v1.MutateRowsRequest.entries:type_name -> google.bigtable.v1.MutateRowsRequest.Entry
	16, // 6: google.bigtable.v1.MutateRowsResponse.statuses:type_name -> google.rpc.Status
	14, // 7: google.bigtable.v1.CheckAndMutateRowRequest.predicate_filter:type_name -> google.bigtable.v1.RowFilter
	15, // 8: google.bigtable.v1.CheckAndMutateRowRequest.true_mutations:type_name -> google.bigtable.v1.Mutation
	15, // 9: google.bigtable.v1.CheckAndMutateRowRequest.false_mutations:type_name -> google.bigtable.v1.Mutation
	17, // 10: google.bigtable.v1.ReadModifyWriteRowRequest.rules:type_name -> google.bigtable.v1.ReadModifyWriteRule
	18, // 11: google.bigtable.v1.ReadRowsResponse.Chunk.row_contents:type_name -> google.bigtable.v1.Family
	15, // 12: google.bigtable.v1.MutateRowsRequest.Entry.mutations:type_name -> google.bigtable.v1.Mutation
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_bigtable_v1_bigtable_service_messages_proto_init() }
func file_google_bigtable_v1_bigtable_service_messages_proto_init() {
	if File_google_bigtable_v1_bigtable_service_messages_proto != nil {
		return
	}
	file_google_bigtable_v1_bigtable_data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampleRowKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SampleRowKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateRowsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateRowsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckAndMutateRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckAndMutateRowResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadModifyWriteRowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadRowsResponse_Chunk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateRowsRequest_Entry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ReadRowsRequest_RowKey)(nil),
		(*ReadRowsRequest_RowRange)(nil),
		(*ReadRowsRequest_RowSet)(nil),
	}
	file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ReadRowsResponse_Chunk_RowContents)(nil),
		(*ReadRowsResponse_Chunk_ResetRow)(nil),
		(*ReadRowsResponse_Chunk_CommitRow)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_v1_bigtable_service_messages_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_v1_bigtable_service_messages_proto_goTypes,
		DependencyIndexes: file_google_bigtable_v1_bigtable_service_messages_proto_depIdxs,
		MessageInfos:      file_google_bigtable_v1_bigtable_service_messages_proto_msgTypes,
	}.Build()
	File_google_bigtable_v1_bigtable_service_messages_proto = out.File
	file_google_bigtable_v1_bigtable_service_messages_proto_rawDesc = nil
	file_google_bigtable_v1_bigtable_service_messages_proto_goTypes = nil
	file_google_bigtable_v1_bigtable_service_messages_proto_depIdxs = nil
}
