/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/submariner-io/submariner-operator/apis/submariner/v1alpha1"
	scheme "github.com/submariner-io/submariner-operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceDiscoveriesGetter has a method to return a ServiceDiscoveryInterface.
// A group's client should implement this interface.
type ServiceDiscoveriesGetter interface {
	ServiceDiscoveries(namespace string) ServiceDiscoveryInterface
}

// ServiceDiscoveryInterface has methods to work with ServiceDiscovery resources.
type ServiceDiscoveryInterface interface {
	Create(*v1alpha1.ServiceDiscovery) (*v1alpha1.ServiceDiscovery, error)
	Update(*v1alpha1.ServiceDiscovery) (*v1alpha1.ServiceDiscovery, error)
	UpdateStatus(*v1alpha1.ServiceDiscovery) (*v1alpha1.ServiceDiscovery, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.ServiceDiscovery, error)
	List(opts v1.ListOptions) (*v1alpha1.ServiceDiscoveryList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ServiceDiscovery, err error)
	ServiceDiscoveryExpansion
}

// serviceDiscoveries implements ServiceDiscoveryInterface
type serviceDiscoveries struct {
	client rest.Interface
	ns     string
}

// newServiceDiscoveries returns a ServiceDiscoveries
func newServiceDiscoveries(c *SubmarinerV1alpha1Client, namespace string) *serviceDiscoveries {
	return &serviceDiscoveries{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the serviceDiscovery, and returns the corresponding serviceDiscovery object, and an error if there is any.
func (c *serviceDiscoveries) Get(name string, options v1.GetOptions) (result *v1alpha1.ServiceDiscovery, err error) {
	result = &v1alpha1.ServiceDiscovery{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("servicediscoveries").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceDiscoveries that match those selectors.
func (c *serviceDiscoveries) List(opts v1.ListOptions) (result *v1alpha1.ServiceDiscoveryList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ServiceDiscoveryList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("servicediscoveries").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceDiscoveries.
func (c *serviceDiscoveries) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("servicediscoveries").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a serviceDiscovery and creates it.  Returns the server's representation of the serviceDiscovery, and an error, if there is any.
func (c *serviceDiscoveries) Create(serviceDiscovery *v1alpha1.ServiceDiscovery) (result *v1alpha1.ServiceDiscovery, err error) {
	result = &v1alpha1.ServiceDiscovery{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("servicediscoveries").
		Body(serviceDiscovery).
		Do().
		Into(result)
	return
}

// Update takes the representation of a serviceDiscovery and updates it. Returns the server's representation of the serviceDiscovery, and an error, if there is any.
func (c *serviceDiscoveries) Update(serviceDiscovery *v1alpha1.ServiceDiscovery) (result *v1alpha1.ServiceDiscovery, err error) {
	result = &v1alpha1.ServiceDiscovery{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("servicediscoveries").
		Name(serviceDiscovery.Name).
		Body(serviceDiscovery).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *serviceDiscoveries) UpdateStatus(serviceDiscovery *v1alpha1.ServiceDiscovery) (result *v1alpha1.ServiceDiscovery, err error) {
	result = &v1alpha1.ServiceDiscovery{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("servicediscoveries").
		Name(serviceDiscovery.Name).
		SubResource("status").
		Body(serviceDiscovery).
		Do().
		Into(result)
	return
}

// Delete takes name of the serviceDiscovery and deletes it. Returns an error if one occurs.
func (c *serviceDiscoveries) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("servicediscoveries").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceDiscoveries) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("servicediscoveries").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched serviceDiscovery.
func (c *serviceDiscoveries) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ServiceDiscovery, err error) {
	result = &v1alpha1.ServiceDiscovery{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("servicediscoveries").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
