// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "open-cluster-management.io/api/client/cluster/clientset/versioned/scheme"
	v1 "open-cluster-management.io/api/cluster/v1"
)

// ManagedClustersGetter has a method to return a ManagedClusterInterface.
// A group's client should implement this interface.
type ManagedClustersGetter interface {
	ManagedClusters() ManagedClusterInterface
}

// ManagedClusterInterface has methods to work with ManagedCluster resources.
type ManagedClusterInterface interface {
	Create(ctx context.Context, managedCluster *v1.ManagedCluster, opts metav1.CreateOptions) (*v1.ManagedCluster, error)
	Update(ctx context.Context, managedCluster *v1.ManagedCluster, opts metav1.UpdateOptions) (*v1.ManagedCluster, error)
	UpdateStatus(ctx context.Context, managedCluster *v1.ManagedCluster, opts metav1.UpdateOptions) (*v1.ManagedCluster, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ManagedCluster, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ManagedClusterList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ManagedCluster, err error)
	ManagedClusterExpansion
}

// managedClusters implements ManagedClusterInterface
type managedClusters struct {
	client rest.Interface
}

// newManagedClusters returns a ManagedClusters
func newManagedClusters(c *ClusterV1Client) *managedClusters {
	return &managedClusters{
		client: c.RESTClient(),
	}
}

// Get takes name of the managedCluster, and returns the corresponding managedCluster object, and an error if there is any.
func (c *managedClusters) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ManagedCluster, err error) {
	result = &v1.ManagedCluster{}
	err = c.client.Get().
		Resource("managedclusters").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ManagedClusters that match those selectors.
func (c *managedClusters) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ManagedClusterList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ManagedClusterList{}
	err = c.client.Get().
		Resource("managedclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested managedClusters.
func (c *managedClusters) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("managedclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a managedCluster and creates it.  Returns the server's representation of the managedCluster, and an error, if there is any.
func (c *managedClusters) Create(ctx context.Context, managedCluster *v1.ManagedCluster, opts metav1.CreateOptions) (result *v1.ManagedCluster, err error) {
	result = &v1.ManagedCluster{}
	err = c.client.Post().
		Resource("managedclusters").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedCluster).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a managedCluster and updates it. Returns the server's representation of the managedCluster, and an error, if there is any.
func (c *managedClusters) Update(ctx context.Context, managedCluster *v1.ManagedCluster, opts metav1.UpdateOptions) (result *v1.ManagedCluster, err error) {
	result = &v1.ManagedCluster{}
	err = c.client.Put().
		Resource("managedclusters").
		Name(managedCluster.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedCluster).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *managedClusters) UpdateStatus(ctx context.Context, managedCluster *v1.ManagedCluster, opts metav1.UpdateOptions) (result *v1.ManagedCluster, err error) {
	result = &v1.ManagedCluster{}
	err = c.client.Put().
		Resource("managedclusters").
		Name(managedCluster.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedCluster).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the managedCluster and deletes it. Returns an error if one occurs.
func (c *managedClusters) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("managedclusters").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *managedClusters) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("managedclusters").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched managedCluster.
func (c *managedClusters) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ManagedCluster, err error) {
	result = &v1.ManagedCluster{}
	err = c.client.Patch(pt).
		Resource("managedclusters").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
