// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To add permissions to a layer version
//
// The following example grants permission for the account 223456789012 to use version
// 1 of a layer named my-layer.
func ExampleLambda_AddLayerVersionPermission_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.AddLayerVersionPermissionInput{
		Action:        aws.String("lambda:GetLayerVersion"),
		LayerName:     aws.String("my-layer"),
		Principal:     aws.String("223456789012"),
		StatementId:   aws.String("xaccount"),
		VersionNumber: aws.Int64(1),
	}

	result, err := svc.AddLayerVersionPermission(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodePolicyLengthExceededException:
				fmt.Println(lambda.ErrCodePolicyLengthExceededException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To grant Amazon S3 permission to invoke a function
//
// The following example adds permission for Amazon S3 to invoke a Lambda function named
// my-function for notifications from a bucket named my-bucket-1xpuxmplzrlbh in account
// 123456789012.
func ExampleLambda_AddPermission_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.AddPermissionInput{
		Action:        aws.String("lambda:InvokeFunction"),
		FunctionName:  aws.String("my-function"),
		Principal:     aws.String("s3.amazonaws.com"),
		SourceAccount: aws.String("123456789012"),
		SourceArn:     aws.String("arn:aws:s3:::my-bucket-1xpuxmplzrlbh/*"),
		StatementId:   aws.String("s3"),
	}

	result, err := svc.AddPermission(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodePolicyLengthExceededException:
				fmt.Println(lambda.ErrCodePolicyLengthExceededException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To grant another account permission to invoke a function
//
// The following example adds permission for account 223456789012 invoke a Lambda function
// named my-function.
func ExampleLambda_AddPermission_shared01() {
	svc := lambda.New(session.New())
	input := &lambda.AddPermissionInput{
		Action:       aws.String("lambda:InvokeFunction"),
		FunctionName: aws.String("my-function"),
		Principal:    aws.String("223456789012"),
		StatementId:  aws.String("xaccount"),
	}

	result, err := svc.AddPermission(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodePolicyLengthExceededException:
				fmt.Println(lambda.ErrCodePolicyLengthExceededException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an alias for a Lambda function
//
// The following example creates an alias named LIVE that points to version 1 of the
// my-function Lambda function.
func ExampleLambda_CreateAlias_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.CreateAliasInput{
		Description:     aws.String("alias for live version of function"),
		FunctionName:    aws.String("my-function"),
		FunctionVersion: aws.String("1"),
		Name:            aws.String("LIVE"),
	}

	result, err := svc.CreateAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a mapping between an event source and an AWS Lambda function
//
// The following example creates a mapping between an SQS queue and the my-function
// Lambda function.
func ExampleLambda_CreateEventSourceMapping_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.CreateEventSourceMappingInput{
		BatchSize:      aws.Int64(5),
		EventSourceArn: aws.String("arn:aws:sqs:us-west-2:123456789012:my-queue"),
		FunctionName:   aws.String("my-function"),
	}

	result, err := svc.CreateEventSourceMapping(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a function
//
// The following example creates a function with a deployment package in Amazon S3 and
// enables X-Ray tracing and environment variable encryption.
func ExampleLambda_CreateFunction_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.CreateFunctionInput{
		Code: &lambda.FunctionCode{
			S3Bucket: aws.String("my-bucket-1xpuxmplzrlbh"),
			S3Key:    aws.String("function.zip"),
		},
		Description: aws.String("Process image objects from Amazon S3."),
		Environment: &lambda.Environment{
			Variables: map[string]*string{
				"BUCKET": aws.String("my-bucket-1xpuxmplzrlbh"),
				"PREFIX": aws.String("inbound"),
			},
		},
		FunctionName: aws.String("my-function"),
		Handler:      aws.String("index.handler"),
		KMSKeyArn:    aws.String("arn:aws:kms:us-west-2:123456789012:key/b0844d6c-xmpl-4463-97a4-d49f50839966"),
		MemorySize:   aws.Int64(256),
		Publish:      aws.Bool(true),
		Role:         aws.String("arn:aws:iam::123456789012:role/lambda-role"),
		Runtime:      aws.String("nodejs12.x"),
		Tags: map[string]*string{
			"DEPARTMENT": aws.String("Assets"),
		},
		Timeout: aws.Int64(15),
		TracingConfig: &lambda.TracingConfig{
			Mode: aws.String("Active"),
		},
	}

	result, err := svc.CreateFunction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeCodeStorageExceededException:
				fmt.Println(lambda.ErrCodeCodeStorageExceededException, aerr.Error())
			case lambda.ErrCodeCodeVerificationFailedException:
				fmt.Println(lambda.ErrCodeCodeVerificationFailedException, aerr.Error())
			case lambda.ErrCodeInvalidCodeSignatureException:
				fmt.Println(lambda.ErrCodeInvalidCodeSignatureException, aerr.Error())
			case lambda.ErrCodeCodeSigningConfigNotFoundException:
				fmt.Println(lambda.ErrCodeCodeSigningConfigNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a Lambda function alias
//
// The following example deletes an alias named BLUE from a function named my-function
func ExampleLambda_DeleteAlias_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteAliasInput{
		FunctionName: aws.String("my-function"),
		Name:         aws.String("BLUE"),
	}

	result, err := svc.DeleteAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a Lambda function event source mapping
//
// The following example deletes an event source mapping. To get a mapping's UUID, use
// ListEventSourceMappings.
func ExampleLambda_DeleteEventSourceMapping_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteEventSourceMappingInput{
		UUID: aws.String("14e0db71-xmpl-4eb5-b481-8945cf9d10c2"),
	}

	result, err := svc.DeleteEventSourceMapping(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceInUseException:
				fmt.Println(lambda.ErrCodeResourceInUseException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a version of a Lambda function
//
// The following example deletes version 1 of a Lambda function named my-function.
func ExampleLambda_DeleteFunction_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteFunctionInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("1"),
	}

	result, err := svc.DeleteFunction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove the reserved concurrent execution limit from a function
//
// The following example deletes the reserved concurrent execution limit from a function
// named my-function.
func ExampleLambda_DeleteFunctionConcurrency_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteFunctionConcurrencyInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.DeleteFunctionConcurrency(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an asynchronous invocation configuration
//
// The following example deletes the asynchronous invocation configuration for the GREEN
// alias of a function named my-function.
func ExampleLambda_DeleteFunctionEventInvokeConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteFunctionEventInvokeConfigInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("GREEN"),
	}

	result, err := svc.DeleteFunctionEventInvokeConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a version of a Lambda layer
//
// The following example deletes version 2 of a layer named my-layer.
func ExampleLambda_DeleteLayerVersion_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteLayerVersionInput{
		LayerName:     aws.String("my-layer"),
		VersionNumber: aws.Int64(2),
	}

	result, err := svc.DeleteLayerVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a provisioned concurrency configuration
//
// The following example deletes the provisioned concurrency configuration for the GREEN
// alias of a function named my-function.
func ExampleLambda_DeleteProvisionedConcurrencyConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.DeleteProvisionedConcurrencyConfigInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("GREEN"),
	}

	result, err := svc.DeleteProvisionedConcurrencyConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get account settings
//
// This operation takes no parameters and returns details about storage and concurrency
// quotas in the current Region.
func ExampleLambda_GetAccountSettings_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetAccountSettingsInput{}

	result, err := svc.GetAccountSettings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a Lambda function alias
//
// The following example returns details about an alias named BLUE for a function named
// my-function
func ExampleLambda_GetAlias_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetAliasInput{
		FunctionName: aws.String("my-function"),
		Name:         aws.String("BLUE"),
	}

	result, err := svc.GetAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a Lambda function's event source mapping
//
// The following example returns details about an event source mapping. To get a mapping's
// UUID, use ListEventSourceMappings.
func ExampleLambda_GetEventSourceMapping_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetEventSourceMappingInput{
		UUID: aws.String("14e0db71-xmpl-4eb5-b481-8945cf9d10c2"),
	}

	result, err := svc.GetEventSourceMapping(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a Lambda function
//
// The following example returns code and configuration details for version 1 of a function
// named my-function.
func ExampleLambda_GetFunction_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetFunctionInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("1"),
	}

	result, err := svc.GetFunction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get the reserved concurrency setting for a function
//
// The following example returns the reserved concurrency setting for a function named
// my-function.
func ExampleLambda_GetFunctionConcurrency_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetFunctionConcurrencyInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.GetFunctionConcurrency(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a Lambda function's event source mapping
//
// The following example returns and configuration details for version 1 of a function
// named my-function.
func ExampleLambda_GetFunctionConfiguration_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetFunctionConfigurationInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("1"),
	}

	result, err := svc.GetFunctionConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get an asynchronous invocation configuration
//
// The following example returns the asynchronous invocation configuration for the BLUE
// alias of a function named my-function.
func ExampleLambda_GetFunctionEventInvokeConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetFunctionEventInvokeConfigInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("BLUE"),
	}

	result, err := svc.GetFunctionEventInvokeConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a Lambda layer version
//
// The following example returns information for version 1 of a layer named my-layer.
func ExampleLambda_GetLayerVersion_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetLayerVersionInput{
		LayerName:     aws.String("my-layer"),
		VersionNumber: aws.Int64(1),
	}

	result, err := svc.GetLayerVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get information about a Lambda layer version
//
// The following example returns information about the layer version with the specified
// Amazon Resource Name (ARN).
func ExampleLambda_GetLayerVersionByArn_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetLayerVersionByArnInput{
		Arn: aws.String("arn:aws:lambda:ca-central-1:123456789012:layer:blank-python-lib:3"),
	}

	result, err := svc.GetLayerVersionByArn(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve a Lambda function policy
//
// The following example returns the resource-based policy for version 1 of a Lambda
// function named my-function.
func ExampleLambda_GetPolicy_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetPolicyInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("1"),
	}

	result, err := svc.GetPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a provisioned concurrency configuration
//
// The following example returns details for the provisioned concurrency configuration
// for the BLUE alias of the specified function.
func ExampleLambda_GetProvisionedConcurrencyConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.GetProvisionedConcurrencyConfigInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("BLUE"),
	}

	result, err := svc.GetProvisionedConcurrencyConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeProvisionedConcurrencyConfigNotFoundException:
				fmt.Println(lambda.ErrCodeProvisionedConcurrencyConfigNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To view a provisioned concurrency configuration
//
// The following example displays details for the provisioned concurrency configuration
// for the BLUE alias of the specified function.
func ExampleLambda_GetProvisionedConcurrencyConfig_shared01() {
	svc := lambda.New(session.New())
	input := &lambda.GetProvisionedConcurrencyConfigInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("BLUE"),
	}

	result, err := svc.GetProvisionedConcurrencyConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeProvisionedConcurrencyConfigNotFoundException:
				fmt.Println(lambda.ErrCodeProvisionedConcurrencyConfigNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To invoke a Lambda function
//
// The following example invokes version 1 of a function named my-function with an empty
// event payload.
func ExampleLambda_Invoke_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.InvokeInput{
		FunctionName: aws.String("my-function"),
		Payload:      []byte("{}"),
		Qualifier:    aws.String("1"),
	}

	result, err := svc.Invoke(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidRequestContentException:
				fmt.Println(lambda.ErrCodeInvalidRequestContentException, aerr.Error())
			case lambda.ErrCodeRequestTooLargeException:
				fmt.Println(lambda.ErrCodeRequestTooLargeException, aerr.Error())
			case lambda.ErrCodeUnsupportedMediaTypeException:
				fmt.Println(lambda.ErrCodeUnsupportedMediaTypeException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeEC2UnexpectedException:
				fmt.Println(lambda.ErrCodeEC2UnexpectedException, aerr.Error())
			case lambda.ErrCodeSubnetIPAddressLimitReachedException:
				fmt.Println(lambda.ErrCodeSubnetIPAddressLimitReachedException, aerr.Error())
			case lambda.ErrCodeENILimitReachedException:
				fmt.Println(lambda.ErrCodeENILimitReachedException, aerr.Error())
			case lambda.ErrCodeEFSMountConnectivityException:
				fmt.Println(lambda.ErrCodeEFSMountConnectivityException, aerr.Error())
			case lambda.ErrCodeEFSMountFailureException:
				fmt.Println(lambda.ErrCodeEFSMountFailureException, aerr.Error())
			case lambda.ErrCodeEFSMountTimeoutException:
				fmt.Println(lambda.ErrCodeEFSMountTimeoutException, aerr.Error())
			case lambda.ErrCodeEFSIOException:
				fmt.Println(lambda.ErrCodeEFSIOException, aerr.Error())
			case lambda.ErrCodeEC2ThrottledException:
				fmt.Println(lambda.ErrCodeEC2ThrottledException, aerr.Error())
			case lambda.ErrCodeEC2AccessDeniedException:
				fmt.Println(lambda.ErrCodeEC2AccessDeniedException, aerr.Error())
			case lambda.ErrCodeInvalidSubnetIDException:
				fmt.Println(lambda.ErrCodeInvalidSubnetIDException, aerr.Error())
			case lambda.ErrCodeInvalidSecurityGroupIDException:
				fmt.Println(lambda.ErrCodeInvalidSecurityGroupIDException, aerr.Error())
			case lambda.ErrCodeInvalidZipFileException:
				fmt.Println(lambda.ErrCodeInvalidZipFileException, aerr.Error())
			case lambda.ErrCodeKMSDisabledException:
				fmt.Println(lambda.ErrCodeKMSDisabledException, aerr.Error())
			case lambda.ErrCodeKMSInvalidStateException:
				fmt.Println(lambda.ErrCodeKMSInvalidStateException, aerr.Error())
			case lambda.ErrCodeKMSAccessDeniedException:
				fmt.Println(lambda.ErrCodeKMSAccessDeniedException, aerr.Error())
			case lambda.ErrCodeKMSNotFoundException:
				fmt.Println(lambda.ErrCodeKMSNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidRuntimeException:
				fmt.Println(lambda.ErrCodeInvalidRuntimeException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeResourceNotReadyException:
				fmt.Println(lambda.ErrCodeResourceNotReadyException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To invoke a Lambda function asynchronously
//
// The following example invokes version 1 of a function named my-function asynchronously.
func ExampleLambda_Invoke_shared01() {
	svc := lambda.New(session.New())
	input := &lambda.InvokeInput{
		FunctionName:   aws.String("my-function"),
		InvocationType: aws.String("Event"),
		Payload:        []byte("{}"),
		Qualifier:      aws.String("1"),
	}

	result, err := svc.Invoke(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidRequestContentException:
				fmt.Println(lambda.ErrCodeInvalidRequestContentException, aerr.Error())
			case lambda.ErrCodeRequestTooLargeException:
				fmt.Println(lambda.ErrCodeRequestTooLargeException, aerr.Error())
			case lambda.ErrCodeUnsupportedMediaTypeException:
				fmt.Println(lambda.ErrCodeUnsupportedMediaTypeException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeEC2UnexpectedException:
				fmt.Println(lambda.ErrCodeEC2UnexpectedException, aerr.Error())
			case lambda.ErrCodeSubnetIPAddressLimitReachedException:
				fmt.Println(lambda.ErrCodeSubnetIPAddressLimitReachedException, aerr.Error())
			case lambda.ErrCodeENILimitReachedException:
				fmt.Println(lambda.ErrCodeENILimitReachedException, aerr.Error())
			case lambda.ErrCodeEFSMountConnectivityException:
				fmt.Println(lambda.ErrCodeEFSMountConnectivityException, aerr.Error())
			case lambda.ErrCodeEFSMountFailureException:
				fmt.Println(lambda.ErrCodeEFSMountFailureException, aerr.Error())
			case lambda.ErrCodeEFSMountTimeoutException:
				fmt.Println(lambda.ErrCodeEFSMountTimeoutException, aerr.Error())
			case lambda.ErrCodeEFSIOException:
				fmt.Println(lambda.ErrCodeEFSIOException, aerr.Error())
			case lambda.ErrCodeEC2ThrottledException:
				fmt.Println(lambda.ErrCodeEC2ThrottledException, aerr.Error())
			case lambda.ErrCodeEC2AccessDeniedException:
				fmt.Println(lambda.ErrCodeEC2AccessDeniedException, aerr.Error())
			case lambda.ErrCodeInvalidSubnetIDException:
				fmt.Println(lambda.ErrCodeInvalidSubnetIDException, aerr.Error())
			case lambda.ErrCodeInvalidSecurityGroupIDException:
				fmt.Println(lambda.ErrCodeInvalidSecurityGroupIDException, aerr.Error())
			case lambda.ErrCodeInvalidZipFileException:
				fmt.Println(lambda.ErrCodeInvalidZipFileException, aerr.Error())
			case lambda.ErrCodeKMSDisabledException:
				fmt.Println(lambda.ErrCodeKMSDisabledException, aerr.Error())
			case lambda.ErrCodeKMSInvalidStateException:
				fmt.Println(lambda.ErrCodeKMSInvalidStateException, aerr.Error())
			case lambda.ErrCodeKMSAccessDeniedException:
				fmt.Println(lambda.ErrCodeKMSAccessDeniedException, aerr.Error())
			case lambda.ErrCodeKMSNotFoundException:
				fmt.Println(lambda.ErrCodeKMSNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidRuntimeException:
				fmt.Println(lambda.ErrCodeInvalidRuntimeException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeResourceNotReadyException:
				fmt.Println(lambda.ErrCodeResourceNotReadyException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To invoke a Lambda function asynchronously
//
// The following example invokes a Lambda function asynchronously
func ExampleLambda_InvokeAsync_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.InvokeAsyncInput{
		FunctionName: aws.String("my-function"),
		InvokeArgs:   aws.ReadSeekCloser(strings.NewReader("{}")),
	}

	result, err := svc.InvokeAsync(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidRequestContentException:
				fmt.Println(lambda.ErrCodeInvalidRequestContentException, aerr.Error())
			case lambda.ErrCodeInvalidRuntimeException:
				fmt.Println(lambda.ErrCodeInvalidRuntimeException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list a function's aliases
//
// The following example returns a list of aliases for a function named my-function.
func ExampleLambda_ListAliases_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListAliasesInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.ListAliases(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the event source mappings for a function
//
// The following example returns a list of the event source mappings for a function
// named my-function.
func ExampleLambda_ListEventSourceMappings_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListEventSourceMappingsInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.ListEventSourceMappings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To view a list of asynchronous invocation configurations
//
// The following example returns a list of asynchronous invocation configurations for
// a function named my-function.
func ExampleLambda_ListFunctionEventInvokeConfigs_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListFunctionEventInvokeConfigsInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.ListFunctionEventInvokeConfigs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of Lambda functions
//
// This operation returns a list of Lambda functions.
func ExampleLambda_ListFunctions_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListFunctionsInput{}

	result, err := svc.ListFunctions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list versions of a layer
//
// The following example displays information about the versions for the layer named
// blank-java-lib
func ExampleLambda_ListLayerVersions_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListLayerVersionsInput{
		LayerName: aws.String("blank-java-lib"),
	}

	result, err := svc.ListLayerVersions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the layers that are compatible with your function's runtime
//
// The following example returns information about layers that are compatible with the
// Python 3.7 runtime.
func ExampleLambda_ListLayers_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListLayersInput{
		CompatibleRuntime: aws.String("python3.7"),
	}

	result, err := svc.ListLayers(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get a list of provisioned concurrency configurations
//
// The following example returns a list of provisioned concurrency configurations for
// a function named my-function.
func ExampleLambda_ListProvisionedConcurrencyConfigs_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListProvisionedConcurrencyConfigsInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.ListProvisionedConcurrencyConfigs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve the list of tags for a Lambda function
//
// The following example displays the tags attached to the my-function Lambda function.
func ExampleLambda_ListTags_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListTagsInput{
		Resource: aws.String("arn:aws:lambda:us-west-2:123456789012:function:my-function"),
	}

	result, err := svc.ListTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list versions of a function
//
// The following example returns a list of versions of a function named my-function
func ExampleLambda_ListVersionsByFunction_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.ListVersionsByFunctionInput{
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.ListVersionsByFunction(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a Lambda layer version
//
// The following example creates a new Python library layer version. The command retrieves
// the layer content a file named layer.zip in the specified S3 bucket.
func ExampleLambda_PublishLayerVersion_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.PublishLayerVersionInput{
		CompatibleRuntimes: []*string{
			aws.String("python3.6"),
			aws.String("python3.7"),
		},
		Content: &lambda.LayerVersionContentInput{
			S3Bucket: aws.String("lambda-layers-us-west-2-123456789012"),
			S3Key:    aws.String("layer.zip"),
		},
		Description: aws.String("My Python layer"),
		LayerName:   aws.String("my-layer"),
		LicenseInfo: aws.String("MIT"),
	}

	result, err := svc.PublishLayerVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeCodeStorageExceededException:
				fmt.Println(lambda.ErrCodeCodeStorageExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To publish a version of a Lambda function
//
// This operation publishes a version of a Lambda function
func ExampleLambda_PublishVersion_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.PublishVersionInput{
		CodeSha256:   aws.String(""),
		Description:  aws.String(""),
		FunctionName: aws.String("myFunction"),
	}

	result, err := svc.PublishVersion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeCodeStorageExceededException:
				fmt.Println(lambda.ErrCodeCodeStorageExceededException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To configure a reserved concurrency limit for a function
//
// The following example configures 100 reserved concurrent executions for the my-function
// function.
func ExampleLambda_PutFunctionConcurrency_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.PutFunctionConcurrencyInput{
		FunctionName:                 aws.String("my-function"),
		ReservedConcurrentExecutions: aws.Int64(100),
	}

	result, err := svc.PutFunctionConcurrency(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To configure error handling for asynchronous invocation
//
// The following example sets a maximum event age of one hour and disables retries for
// the specified function.
func ExampleLambda_PutFunctionEventInvokeConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.PutFunctionEventInvokeConfigInput{
		FunctionName:             aws.String("my-function"),
		MaximumEventAgeInSeconds: aws.Int64(3600),
		MaximumRetryAttempts:     aws.Int64(0),
	}

	result, err := svc.PutFunctionEventInvokeConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To allocate provisioned concurrency
//
// The following example allocates 100 provisioned concurrency for the BLUE alias of
// the specified function.
func ExampleLambda_PutProvisionedConcurrencyConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.PutProvisionedConcurrencyConfigInput{
		FunctionName:                    aws.String("my-function"),
		ProvisionedConcurrentExecutions: aws.Int64(100),
		Qualifier:                       aws.String("BLUE"),
	}

	result, err := svc.PutProvisionedConcurrencyConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete layer-version permissions
//
// The following example deletes permission for an account to configure a layer version.
func ExampleLambda_RemoveLayerVersionPermission_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.RemoveLayerVersionPermissionInput{
		LayerName:     aws.String("my-layer"),
		StatementId:   aws.String("xaccount"),
		VersionNumber: aws.Int64(1),
	}

	result, err := svc.RemoveLayerVersionPermission(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove a Lambda function's permissions
//
// The following example removes a permissions statement named xaccount from the PROD
// alias of a function named my-function.
func ExampleLambda_RemovePermission_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.RemovePermissionInput{
		FunctionName: aws.String("my-function"),
		Qualifier:    aws.String("PROD"),
		StatementId:  aws.String("xaccount"),
	}

	result, err := svc.RemovePermission(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add tags to an existing Lambda function
//
// The following example adds a tag with the key name DEPARTMENT and a value of 'Department
// A' to the specified Lambda function.
func ExampleLambda_TagResource_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.TagResourceInput{
		Resource: aws.String("arn:aws:lambda:us-west-2:123456789012:function:my-function"),
		Tags: map[string]*string{
			"DEPARTMENT": aws.String("Department A"),
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from an existing Lambda function
//
// The following example removes the tag with the key name DEPARTMENT tag from the my-function
// Lambda function.
func ExampleLambda_UntagResource_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.UntagResourceInput{
		Resource: aws.String("arn:aws:lambda:us-west-2:123456789012:function:my-function"),
		TagKeys: []*string{
			aws.String("DEPARTMENT"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a function alias
//
// The following example updates the alias named BLUE to send 30% of traffic to version
// 2 and 70% to version 1.
func ExampleLambda_UpdateAlias_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.UpdateAliasInput{
		FunctionName:    aws.String("my-function"),
		FunctionVersion: aws.String("2"),
		Name:            aws.String("BLUE"),
		RoutingConfig: &lambda.AliasRoutingConfiguration{
			AdditionalVersionWeights: map[string]*float64{
				"1": aws.Float64(0.700000),
			},
		},
	}

	result, err := svc.UpdateAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a Lambda function event source mapping
//
// This operation updates a Lambda function event source mapping
func ExampleLambda_UpdateEventSourceMapping_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.UpdateEventSourceMappingInput{
		BatchSize:    aws.Int64(123),
		Enabled:      aws.Bool(true),
		FunctionName: aws.String("myFunction"),
		UUID:         aws.String("1234xCy789012"),
	}

	result, err := svc.UpdateEventSourceMapping(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeResourceInUseException:
				fmt.Println(lambda.ErrCodeResourceInUseException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a Lambda function's code
//
// The following example replaces the code of the unpublished ($LATEST) version of a
// function named my-function with the contents of the specified zip file in Amazon
// S3.
func ExampleLambda_UpdateFunctionCode_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.UpdateFunctionCodeInput{
		FunctionName: aws.String("my-function"),
		S3Bucket:     aws.String("my-bucket-1xpuxmplzrlbh"),
		S3Key:        aws.String("function.zip"),
	}

	result, err := svc.UpdateFunctionCode(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeCodeStorageExceededException:
				fmt.Println(lambda.ErrCodeCodeStorageExceededException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodeCodeVerificationFailedException:
				fmt.Println(lambda.ErrCodeCodeVerificationFailedException, aerr.Error())
			case lambda.ErrCodeInvalidCodeSignatureException:
				fmt.Println(lambda.ErrCodeInvalidCodeSignatureException, aerr.Error())
			case lambda.ErrCodeCodeSigningConfigNotFoundException:
				fmt.Println(lambda.ErrCodeCodeSigningConfigNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a Lambda function's configuration
//
// The following example modifies the memory size to be 256 MB for the unpublished ($LATEST)
// version of a function named my-function.
func ExampleLambda_UpdateFunctionConfiguration_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.UpdateFunctionConfigurationInput{
		FunctionName: aws.String("my-function"),
		MemorySize:   aws.Int64(256),
	}

	result, err := svc.UpdateFunctionConfiguration(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			case lambda.ErrCodeResourceConflictException:
				fmt.Println(lambda.ErrCodeResourceConflictException, aerr.Error())
			case lambda.ErrCodePreconditionFailedException:
				fmt.Println(lambda.ErrCodePreconditionFailedException, aerr.Error())
			case lambda.ErrCodeCodeVerificationFailedException:
				fmt.Println(lambda.ErrCodeCodeVerificationFailedException, aerr.Error())
			case lambda.ErrCodeInvalidCodeSignatureException:
				fmt.Println(lambda.ErrCodeInvalidCodeSignatureException, aerr.Error())
			case lambda.ErrCodeCodeSigningConfigNotFoundException:
				fmt.Println(lambda.ErrCodeCodeSigningConfigNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an asynchronous invocation configuration
//
// The following example adds an on-failure destination to the existing asynchronous
// invocation configuration for a function named my-function.
func ExampleLambda_UpdateFunctionEventInvokeConfig_shared00() {
	svc := lambda.New(session.New())
	input := &lambda.UpdateFunctionEventInvokeConfigInput{
		DestinationConfig: &lambda.DestinationConfig{
			OnFailure: &lambda.OnFailure{
				Destination: aws.String("arn:aws:sqs:us-east-2:123456789012:destination"),
			},
		},
		FunctionName: aws.String("my-function"),
	}

	result, err := svc.UpdateFunctionEventInvokeConfig(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case lambda.ErrCodeServiceException:
				fmt.Println(lambda.ErrCodeServiceException, aerr.Error())
			case lambda.ErrCodeResourceNotFoundException:
				fmt.Println(lambda.ErrCodeResourceNotFoundException, aerr.Error())
			case lambda.ErrCodeInvalidParameterValueException:
				fmt.Println(lambda.ErrCodeInvalidParameterValueException, aerr.Error())
			case lambda.ErrCodeTooManyRequestsException:
				fmt.Println(lambda.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
