// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lookoutforvision

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetRequest method.
//    req, resp := client.CreateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateDataset
func (c *LookoutForVision) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/projects/{projectName}/datasets",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Lookout for Vision.
//
// Creates a new dataset in an Amazon Lookout for Vision project. CreateDataset
// can create a training or a test dataset from a valid dataset source (DatasetSource).
//
// If you want a single dataset project, specify train for the value of DatasetType.
//
// To have a project with separate training and test datasets, call CreateDataset
// twice. On the first call, specify train for the value of DatasetType. On
// the second call, specify test for the value of DatasetType.
//
// This operation requires permissions to perform the lookoutvision:CreateDataset
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
//   * ServiceQuotaExceededException
//   A service quota was exceeded the allowed limit. For more information, see
//   Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer
//   Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateDataset
func (c *LookoutForVision) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateModel
func (c *LookoutForVision) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *CreateModelOutput) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &CreateModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for Amazon Lookout for Vision.
//
// Creates a new version of a model within an an Amazon Lookout for Vision project.
// CreateModel is an asynchronous operation in which Amazon Lookout for Vision
// trains, tests, and evaluates a new version of a model.
//
// To get the current status, check the Status field returned in the response
// from DescribeModel.
//
// If the project has a single dataset, Amazon Lookout for Vision internally
// splits the dataset to create a training and a test dataset. If the project
// has a training and a test dataset, Lookout for Vision uses the respective
// datasets to train and test the model.
//
// After training completes, the evaluation metrics are stored at the location
// specified in OutputConfig.
//
// This operation requires permissions to perform the lookoutvision:CreateModel
// operation. If you want to tag your model, you also require permission to
// the lookoutvision:TagResource operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
//   * ServiceQuotaExceededException
//   A service quota was exceeded the allowed limit. For more information, see
//   Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer
//   Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateModel
func (c *LookoutForVision) CreateModel(input *CreateModelInput) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*CreateModelOutput, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateProject
func (c *LookoutForVision) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for Amazon Lookout for Vision.
//
// Creates an empty Amazon Lookout for Vision project. After you create the
// project, add a dataset by calling CreateDataset.
//
// This operation requires permissions to perform the lookoutvision:CreateProject
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
//   * ServiceQuotaExceededException
//   A service quota was exceeded the allowed limit. For more information, see
//   Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer
//   Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/CreateProject
func (c *LookoutForVision) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteDataset
func (c *LookoutForVision) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-11-20/projects/{projectName}/datasets/{datasetType}",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for Amazon Lookout for Vision.
//
// Deletes an existing Amazon Lookout for Vision dataset.
//
// If your the project has a single dataset, you must create a new dataset before
// you can create a model.
//
// If you project has a training dataset and a test dataset consider the following.
//
//    * If you delete the test dataset, your project reverts to a single dataset
//    project. If you then train the model, Amazon Lookout for Vision internally
//    splits the remaining dataset into a training and test dataset.
//
//    * If you delete the training dataset, you must create a training dataset
//    before you can create a model.
//
// This operation requires permissions to perform the lookoutvision:DeleteDataset
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteDataset
func (c *LookoutForVision) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelRequest method.
//    req, resp := client.DeleteModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteModel
func (c *LookoutForVision) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models/{modelVersion}",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteModel API operation for Amazon Lookout for Vision.
//
// Deletes an Amazon Lookout for Vision model. You can't delete a running model.
// To stop a running model, use the StopModel operation.
//
// It might take a few seconds to delete a model. To determine if a model has
// been deleted, call ListProjects and check if the version of the model (ModelVersion)
// is in the Models array.
//
// This operation requires permissions to perform the lookoutvision:DeleteModel
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DeleteModel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteModel
func (c *LookoutForVision) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteProject
func (c *LookoutForVision) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-11-20/projects/{projectName}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for Amazon Lookout for Vision.
//
// Deletes an Amazon Lookout for Vision project.
//
// To delete a project, you must first delete each version of the model associated
// with the project. To delete a model use the DeleteModel operation.
//
// You also have to delete the dataset(s) associated with the model. For more
// information, see DeleteDataset. The images referenced by the training and
// test datasets aren't deleted.
//
// This operation requires permissions to perform the lookoutvision:DeleteProject
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DeleteProject
func (c *LookoutForVision) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeDataset
func (c *LookoutForVision) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/projects/{projectName}/datasets/{datasetType}",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Lookout for Vision.
//
// Describe an Amazon Lookout for Vision dataset.
//
// This operation requires permissions to perform the lookoutvision:DescribeDataset
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeDataset
func (c *LookoutForVision) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModel = "DescribeModel"

// DescribeModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModel for more information on using the DescribeModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelRequest method.
//    req, resp := client.DescribeModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeModel
func (c *LookoutForVision) DescribeModelRequest(input *DescribeModelInput) (req *request.Request, output *DescribeModelOutput) {
	op := &request.Operation{
		Name:       opDescribeModel,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models/{modelVersion}",
	}

	if input == nil {
		input = &DescribeModelInput{}
	}

	output = &DescribeModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModel API operation for Amazon Lookout for Vision.
//
// Describes a version of an Amazon Lookout for Vision model.
//
// This operation requires permissions to perform the lookoutvision:DescribeModel
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DescribeModel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeModel
func (c *LookoutForVision) DescribeModel(input *DescribeModelInput) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	return out, req.Send()
}

// DescribeModelWithContext is the same as DescribeModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DescribeModelWithContext(ctx aws.Context, input *DescribeModelInput, opts ...request.Option) (*DescribeModelOutput, error) {
	req, out := c.DescribeModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeProject
func (c *LookoutForVision) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/projects/{projectName}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for Amazon Lookout for Vision.
//
// Describes an Amazon Lookout for Vision project.
//
// This operation requires permissions to perform the lookoutvision:DescribeProject
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DescribeProject
func (c *LookoutForVision) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectAnomalies = "DetectAnomalies"

// DetectAnomaliesRequest generates a "aws/request.Request" representing the
// client's request for the DetectAnomalies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectAnomalies for more information on using the DetectAnomalies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectAnomaliesRequest method.
//    req, resp := client.DetectAnomaliesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DetectAnomalies
func (c *LookoutForVision) DetectAnomaliesRequest(input *DetectAnomaliesInput) (req *request.Request, output *DetectAnomaliesOutput) {
	op := &request.Operation{
		Name:       opDetectAnomalies,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models/{modelVersion}/detect",
	}

	if input == nil {
		input = &DetectAnomaliesInput{}
	}

	output = &DetectAnomaliesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectAnomalies API operation for Amazon Lookout for Vision.
//
// Detects anomalies in an image that you supply.
//
// The response from DetectAnomalies includes a boolean prediction that the
// image contains one or more anomalies and a confidence value for the prediction.
//
// Before calling DetectAnomalies, you must first start your model with the
// StartModel operation. You are charged for the amount of time, in minutes,
// that a model runs and for the number of anomaly detection units that your
// model uses. If you are not using a model, use the StopModel operation to
// stop your model.
//
// This operation requires permissions to perform the lookoutvision:DetectAnomalies
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation DetectAnomalies for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/DetectAnomalies
func (c *LookoutForVision) DetectAnomalies(input *DetectAnomaliesInput) (*DetectAnomaliesOutput, error) {
	req, out := c.DetectAnomaliesRequest(input)
	return out, req.Send()
}

// DetectAnomaliesWithContext is the same as DetectAnomalies with the addition of
// the ability to pass a context and additional request options.
//
// See DetectAnomalies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) DetectAnomaliesWithContext(ctx aws.Context, input *DetectAnomaliesInput, opts ...request.Option) (*DetectAnomaliesOutput, error) {
	req, out := c.DetectAnomaliesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDatasetEntries = "ListDatasetEntries"

// ListDatasetEntriesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetEntries for more information on using the ListDatasetEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetEntriesRequest method.
//    req, resp := client.ListDatasetEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListDatasetEntries
func (c *LookoutForVision) ListDatasetEntriesRequest(input *ListDatasetEntriesInput) (req *request.Request, output *ListDatasetEntriesOutput) {
	op := &request.Operation{
		Name:       opListDatasetEntries,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/projects/{projectName}/datasets/{datasetType}/entries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetEntriesInput{}
	}

	output = &ListDatasetEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetEntries API operation for Amazon Lookout for Vision.
//
// Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON
// Line contains the anomaly information for a single image, including the image
// location and the assigned label.
//
// This operation requires permissions to perform the lookoutvision:ListDatasetEntries
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation ListDatasetEntries for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListDatasetEntries
func (c *LookoutForVision) ListDatasetEntries(input *ListDatasetEntriesInput) (*ListDatasetEntriesOutput, error) {
	req, out := c.ListDatasetEntriesRequest(input)
	return out, req.Send()
}

// ListDatasetEntriesWithContext is the same as ListDatasetEntries with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListDatasetEntriesWithContext(ctx aws.Context, input *ListDatasetEntriesInput, opts ...request.Option) (*ListDatasetEntriesOutput, error) {
	req, out := c.ListDatasetEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetEntriesPages iterates over the pages of a ListDatasetEntries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetEntries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetEntries operation.
//    pageNum := 0
//    err := client.ListDatasetEntriesPages(params,
//        func(page *lookoutforvision.ListDatasetEntriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutForVision) ListDatasetEntriesPages(input *ListDatasetEntriesInput, fn func(*ListDatasetEntriesOutput, bool) bool) error {
	return c.ListDatasetEntriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetEntriesPagesWithContext same as ListDatasetEntriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListDatasetEntriesPagesWithContext(ctx aws.Context, input *ListDatasetEntriesInput, fn func(*ListDatasetEntriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetEntriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetEntriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetEntriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListModels = "ListModels"

// ListModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListModels for more information on using the ListModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListModelsRequest method.
//    req, resp := client.ListModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModels
func (c *LookoutForVision) ListModelsRequest(input *ListModelsInput) (req *request.Request, output *ListModelsOutput) {
	op := &request.Operation{
		Name:       opListModels,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListModelsInput{}
	}

	output = &ListModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListModels API operation for Amazon Lookout for Vision.
//
// Lists the versions of a model in an Amazon Lookout for Vision project.
//
// This operation requires permissions to perform the lookoutvision:ListModels
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation ListModels for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListModels
func (c *LookoutForVision) ListModels(input *ListModelsInput) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	return out, req.Send()
}

// ListModelsWithContext is the same as ListModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListModelsWithContext(ctx aws.Context, input *ListModelsInput, opts ...request.Option) (*ListModelsOutput, error) {
	req, out := c.ListModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListModelsPages iterates over the pages of a ListModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListModels operation.
//    pageNum := 0
//    err := client.ListModelsPages(params,
//        func(page *lookoutforvision.ListModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutForVision) ListModelsPages(input *ListModelsInput, fn func(*ListModelsOutput, bool) bool) error {
	return c.ListModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListModelsPagesWithContext same as ListModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListModelsPagesWithContext(ctx aws.Context, input *ListModelsInput, fn func(*ListModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListProjects
func (c *LookoutForVision) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for Amazon Lookout for Vision.
//
// Lists the Amazon Lookout for Vision projects in your AWS account.
//
// This operation requires permissions to perform the lookoutvision:ListProjects
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListProjects
func (c *LookoutForVision) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *lookoutforvision.ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LookoutForVision) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListTagsForResource
func (c *LookoutForVision) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2020-11-20/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Lookout for Vision.
//
// Returns a list of tags attached to the specified Amazon Lookout for Vision
// model.
//
// This operation requires permissions to perform the lookoutvision:ListTagsForResource
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/ListTagsForResource
func (c *LookoutForVision) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartModel = "StartModel"

// StartModelRequest generates a "aws/request.Request" representing the
// client's request for the StartModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartModel for more information on using the StartModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartModelRequest method.
//    req, resp := client.StartModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StartModel
func (c *LookoutForVision) StartModelRequest(input *StartModelInput) (req *request.Request, output *StartModelOutput) {
	op := &request.Operation{
		Name:       opStartModel,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models/{modelVersion}/start",
	}

	if input == nil {
		input = &StartModelInput{}
	}

	output = &StartModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartModel API operation for Amazon Lookout for Vision.
//
// Starts the running of the version of an Amazon Lookout for Vision model.
// Starting a model takes a while to complete. To check the current state of
// the model, use DescribeModel.
//
// A model is ready to use when its status is HOSTED.
//
// Once the model is running, you can detect custom labels in new images by
// calling DetectAnomalies.
//
// You are charged for the amount of time that the model is running. To stop
// a running model, call StopModel.
//
// This operation requires permissions to perform the lookoutvision:StartModel
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation StartModel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
//   * ServiceQuotaExceededException
//   A service quota was exceeded the allowed limit. For more information, see
//   Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer
//   Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StartModel
func (c *LookoutForVision) StartModel(input *StartModelInput) (*StartModelOutput, error) {
	req, out := c.StartModelRequest(input)
	return out, req.Send()
}

// StartModelWithContext is the same as StartModel with the addition of
// the ability to pass a context and additional request options.
//
// See StartModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) StartModelWithContext(ctx aws.Context, input *StartModelInput, opts ...request.Option) (*StartModelOutput, error) {
	req, out := c.StartModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopModel = "StopModel"

// StopModelRequest generates a "aws/request.Request" representing the
// client's request for the StopModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopModel for more information on using the StopModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopModelRequest method.
//    req, resp := client.StopModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StopModel
func (c *LookoutForVision) StopModelRequest(input *StopModelInput) (req *request.Request, output *StopModelOutput) {
	op := &request.Operation{
		Name:       opStopModel,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/projects/{projectName}/models/{modelVersion}/stop",
	}

	if input == nil {
		input = &StopModelInput{}
	}

	output = &StopModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopModel API operation for Amazon Lookout for Vision.
//
// Stops the hosting of a running model. The operation might take a while to
// complete. To check the current status, call DescribeModel.
//
// After the model hosting stops, the Status of the model is TRAINED.
//
// This operation requires permissions to perform the lookoutvision:StopModel
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation StopModel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/StopModel
func (c *LookoutForVision) StopModel(input *StopModelInput) (*StopModelOutput, error) {
	req, out := c.StopModelRequest(input)
	return out, req.Send()
}

// StopModelWithContext is the same as StopModel with the addition of
// the ability to pass a context and additional request options.
//
// See StopModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) StopModelWithContext(ctx aws.Context, input *StopModelInput, opts ...request.Option) (*StopModelOutput, error) {
	req, out := c.StopModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/TagResource
func (c *LookoutForVision) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2020-11-20/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Lookout for Vision.
//
// Adds one or more key-value tags to an Amazon Lookout for Vision model. For
// more information, see Tagging a model in the Amazon Lookout for Vision Developer
// Guide.
//
// This operation requires permissions to perform the lookoutvision:TagResource
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
//   * ServiceQuotaExceededException
//   A service quota was exceeded the allowed limit. For more information, see
//   Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer
//   Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/TagResource
func (c *LookoutForVision) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UntagResource
func (c *LookoutForVision) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2020-11-20/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Lookout for Vision.
//
// Removes one or more tags from an Amazon Lookout for Vision model. For more
// information, see Tagging a model in the Amazon Lookout for Vision Developer
// Guide.
//
// This operation requires permissions to perform the lookoutvision:UntagResource
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UntagResource
func (c *LookoutForVision) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatasetEntries = "UpdateDatasetEntries"

// UpdateDatasetEntriesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatasetEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatasetEntries for more information on using the UpdateDatasetEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatasetEntriesRequest method.
//    req, resp := client.UpdateDatasetEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UpdateDatasetEntries
func (c *LookoutForVision) UpdateDatasetEntriesRequest(input *UpdateDatasetEntriesInput) (req *request.Request, output *UpdateDatasetEntriesOutput) {
	op := &request.Operation{
		Name:       opUpdateDatasetEntries,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2020-11-20/projects/{projectName}/datasets/{datasetType}/entries",
	}

	if input == nil {
		input = &UpdateDatasetEntriesInput{}
	}

	output = &UpdateDatasetEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDatasetEntries API operation for Amazon Lookout for Vision.
//
// Adds one or more JSON Line entries to a dataset. A JSON Line includes information
// about an image used for training or testing an Amazon Lookout for Vision
// model. The following is an example JSON Line.
//
// Updating a dataset might take a while to complete. To check the current status,
// call DescribeDataset and check the Status field in the response.
//
// This operation requires permissions to perform the lookoutvision:UpdateDatasetEntries
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lookout for Vision's
// API operation UpdateDatasetEntries for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerException
//   Amazon Lookout for Vision experienced a service issue. Try your call again.
//
//   * ValidationException
//   An input validation error occured. For example, invalid characters in a project
//   name, or if a pagination token is invalid.
//
//   * ConflictException
//   The update or deletion of a resource caused an inconsistent state.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ThrottlingException
//   Amazon Lookout for Vision is temporarily unable to process the request. Try
//   your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lookoutvision-2020-11-20/UpdateDatasetEntries
func (c *LookoutForVision) UpdateDatasetEntries(input *UpdateDatasetEntriesInput) (*UpdateDatasetEntriesOutput, error) {
	req, out := c.UpdateDatasetEntriesRequest(input)
	return out, req.Send()
}

// UpdateDatasetEntriesWithContext is the same as UpdateDatasetEntries with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatasetEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LookoutForVision) UpdateDatasetEntriesWithContext(ctx aws.Context, input *UpdateDatasetEntriesInput, opts ...request.Option) (*UpdateDatasetEntriesOutput, error) {
	req, out := c.UpdateDatasetEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to perform the action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The update or deletion of a resource caused an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to CreateDataset
	// completes only once. You choose the value to pass. For example, An issue,
	// such as an network outage, might prevent you from getting a response from
	// CreateDataset. In this case, safely retry your call to CreateDataset by using
	// the same ClientToken parameter value. An error occurs if the other input
	// parameters are not the same as in the first request. Using a different value
	// for ClientToken is considered a new call to CreateDataset. An idempotency
	// token is active for 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The location of the manifest file that Amazon Lookout for Vision uses to
	// create the dataset.
	//
	// If you don't specify DatasetSource, an empty dataset is created and the operation
	// synchronously returns. Later, you can add JSON Lines by calling UpdateDatasetEntries.
	//
	// If you specify a value for DataSource, the manifest at the S3 location is
	// validated and used to create the dataset. The call to CreateDataset is asynchronous
	// and might take a while to complete. To find out the current status, Check
	// the value of Status returned in a call to DescribeDataset.
	DatasetSource *DatasetSource `type:"structure"`

	// The type of the dataset. Specify train for a training dataset. Specify test
	// for a test dataset.
	//
	// DatasetType is a required field
	DatasetType *string `min:"1" type:"string" required:"true"`

	// The name of the project in which you want to create a dataset.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.DatasetType != nil && len(*s.DatasetType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetType", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.DatasetSource != nil {
		if err := s.DatasetSource.Validate(); err != nil {
			invalidParams.AddNested("DatasetSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDatasetInput) SetClientToken(v string) *CreateDatasetInput {
	s.ClientToken = &v
	return s
}

// SetDatasetSource sets the DatasetSource field's value.
func (s *CreateDatasetInput) SetDatasetSource(v *DatasetSource) *CreateDatasetInput {
	s.DatasetSource = v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *CreateDatasetInput) SetDatasetType(v string) *CreateDatasetInput {
	s.DatasetType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateDatasetInput) SetProjectName(v string) *CreateDatasetInput {
	s.ProjectName = &v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the dataset.
	DatasetMetadata *DatasetMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetMetadata sets the DatasetMetadata field's value.
func (s *CreateDatasetOutput) SetDatasetMetadata(v *DatasetMetadata) *CreateDatasetOutput {
	s.DatasetMetadata = v
	return s
}

type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to CreateModel completes
	// only once. You choose the value to pass. For example, An issue, such as an
	// network outage, might prevent you from getting a response from CreateModel.
	// In this case, safely retry your call to CreateModel by using the same ClientToken
	// parameter value. An error occurs if the other input parameters are not the
	// same as in the first request. Using a different value for ClientToken is
	// considered a new call to CreateModel. An idempotency token is active for
	// 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// A description for the version of the model.
	Description *string `min:"1" type:"string"`

	// The identifier for your AWS Key Management Service (AWS KMS) customer master
	// key (CMK). The key is used to encrypt training and test images copied into
	// the service for model training. Your source images are unaffected. If this
	// parameter is not specified, the copied images are encrypted by a key that
	// AWS owns and manages.
	KmsKeyId *string `min:"1" type:"string"`

	// The location where Amazon Lookout for Vision saves the training results.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfig `type:"structure" required:"true"`

	// The name of the project in which you want to create a model version.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`

	// A set of tags (key-value pairs) that you want to attach to the model.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateModelInput) SetClientToken(v string) *CreateModelInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateModelInput) SetDescription(v string) *CreateModelInput {
	s.Description = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateModelInput) SetKmsKeyId(v string) *CreateModelInput {
	s.KmsKeyId = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreateModelInput) SetOutputConfig(v *OutputConfig) *CreateModelInput {
	s.OutputConfig = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateModelInput) SetProjectName(v string) *CreateModelInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelInput) SetTags(v []*Tag) *CreateModelInput {
	s.Tags = v
	return s
}

type CreateModelOutput struct {
	_ struct{} `type:"structure"`

	// The response from a call to CreateModel.
	ModelMetadata *ModelMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelOutput) GoString() string {
	return s.String()
}

// SetModelMetadata sets the ModelMetadata field's value.
func (s *CreateModelOutput) SetModelMetadata(v *ModelMetadata) *CreateModelOutput {
	s.ModelMetadata = v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to CreateProject
	// completes only once. You choose the value to pass. For example, An issue,
	// such as an network outage, might prevent you from getting a response from
	// CreateProject. In this case, safely retry your call to CreateProject by using
	// the same ClientToken parameter value. An error occurs if the other input
	// parameters are not the same as in the first request. Using a different value
	// for ClientToken is considered a new call to CreateProject. An idempotency
	// token is active for 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The name for the project.
	//
	// ProjectName is a required field
	ProjectName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProjectInput) SetClientToken(v string) *CreateProjectInput {
	s.ClientToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateProjectInput) SetProjectName(v string) *CreateProjectInput {
	s.ProjectName = &v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Information about the project.
	ProjectMetadata *ProjectMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProjectMetadata sets the ProjectMetadata field's value.
func (s *CreateProjectOutput) SetProjectMetadata(v *ProjectMetadata) *CreateProjectOutput {
	s.ProjectMetadata = v
	return s
}

// The description for a dataset. For more information, see DescribeDataset.
type DatasetDescription struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the time and date that the dataset was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The type of the dataset. The value train represents a training dataset or
	// single dataset project. The value test represents a test dataset.
	DatasetType *string `min:"1" type:"string"`

	// Statistics about the images in a dataset.
	ImageStats *DatasetImageStats `type:"structure"`

	// The Unix timestamp for the date and time that the dataset was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The name of the project that contains the dataset.
	ProjectName *string `min:"1" type:"string"`

	// The status of the dataset.
	Status *string `type:"string" enum:"DatasetStatus"`

	// The status message for the dataset.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDescription) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DatasetDescription) SetCreationTimestamp(v time.Time) *DatasetDescription {
	s.CreationTimestamp = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetDescription) SetDatasetType(v string) *DatasetDescription {
	s.DatasetType = &v
	return s
}

// SetImageStats sets the ImageStats field's value.
func (s *DatasetDescription) SetImageStats(v *DatasetImageStats) *DatasetDescription {
	s.ImageStats = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *DatasetDescription) SetLastUpdatedTimestamp(v time.Time) *DatasetDescription {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DatasetDescription) SetProjectName(v string) *DatasetDescription {
	s.ProjectName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetDescription) SetStatus(v string) *DatasetDescription {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DatasetDescription) SetStatusMessage(v string) *DatasetDescription {
	s.StatusMessage = &v
	return s
}

// Location information about a manifest file. You can use a manifest file to
// create a dataset.
type DatasetGroundTruthManifest struct {
	_ struct{} `type:"structure"`

	// The S3 bucket location for the manifest file.
	S3Object *InputS3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetGroundTruthManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetGroundTruthManifest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetGroundTruthManifest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetGroundTruthManifest"}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Object sets the S3Object field's value.
func (s *DatasetGroundTruthManifest) SetS3Object(v *InputS3Object) *DatasetGroundTruthManifest {
	s.S3Object = v
	return s
}

// Statistics about the images in a dataset.
type DatasetImageStats struct {
	_ struct{} `type:"structure"`

	// the total number of images labeled as an anomaly.
	Anomaly *int64 `type:"integer"`

	// The total number of labeled images.
	Labeled *int64 `type:"integer"`

	// The total number of images labeled as normal.
	Normal *int64 `type:"integer"`

	// The total number of images in the dataset.
	Total *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetImageStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetImageStats) GoString() string {
	return s.String()
}

// SetAnomaly sets the Anomaly field's value.
func (s *DatasetImageStats) SetAnomaly(v int64) *DatasetImageStats {
	s.Anomaly = &v
	return s
}

// SetLabeled sets the Labeled field's value.
func (s *DatasetImageStats) SetLabeled(v int64) *DatasetImageStats {
	s.Labeled = &v
	return s
}

// SetNormal sets the Normal field's value.
func (s *DatasetImageStats) SetNormal(v int64) *DatasetImageStats {
	s.Normal = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *DatasetImageStats) SetTotal(v int64) *DatasetImageStats {
	s.Total = &v
	return s
}

// Sumary information for an Amazon Lookout for Vision dataset.
type DatasetMetadata struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the date and time that the dataset was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The type of the dataset.
	DatasetType *string `min:"1" type:"string"`

	// The status for the dataset.
	Status *string `type:"string" enum:"DatasetStatus"`

	// The status message for the dataset.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetMetadata) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DatasetMetadata) SetCreationTimestamp(v time.Time) *DatasetMetadata {
	s.CreationTimestamp = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetMetadata) SetDatasetType(v string) *DatasetMetadata {
	s.DatasetType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetMetadata) SetStatus(v string) *DatasetMetadata {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DatasetMetadata) SetStatusMessage(v string) *DatasetMetadata {
	s.StatusMessage = &v
	return s
}

// Information about the location of a manifest file that Amazon Lookout for
// Vision uses to to create a dataset.
type DatasetSource struct {
	_ struct{} `type:"structure"`

	// Location information for the manifest file.
	GroundTruthManifest *DatasetGroundTruthManifest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetSource"}
	if s.GroundTruthManifest != nil {
		if err := s.GroundTruthManifest.Validate(); err != nil {
			invalidParams.AddNested("GroundTruthManifest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroundTruthManifest sets the GroundTruthManifest field's value.
func (s *DatasetSource) SetGroundTruthManifest(v *DatasetGroundTruthManifest) *DatasetSource {
	s.GroundTruthManifest = v
	return s
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to DeleteDataset
	// completes only once. You choose the value to pass. For example, An issue,
	// such as an network outage, might prevent you from getting a response from
	// DeleteDataset. In this case, safely retry your call to DeleteDataset by using
	// the same ClientToken parameter value. An error occurs if the other input
	// parameters are not the same as in the first request. Using a different value
	// for ClientToken is considered a new call to DeleteDataset. An idempotency
	// token is active for 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The type of the dataset to delete. Specify train to delete the training dataset.
	// Specify test to delete the test dataset. To delete the dataset in a single
	// dataset project, specify train.
	//
	// DatasetType is a required field
	DatasetType *string `location:"uri" locationName:"datasetType" min:"1" type:"string" required:"true"`

	// The name of the project that contains the dataset that you want to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.DatasetType != nil && len(*s.DatasetType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetType", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteDatasetInput) SetClientToken(v string) *DeleteDatasetInput {
	s.ClientToken = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DeleteDatasetInput) SetDatasetType(v string) *DeleteDatasetInput {
	s.DatasetType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DeleteDatasetInput) SetProjectName(v string) *DeleteDatasetInput {
	s.ProjectName = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteModelInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to DeleteModel completes
	// only once. You choose the value to pass. For example, An issue, such as an
	// network outage, might prevent you from getting a response from DeleteModel.
	// In this case, safely retry your call to DeleteModel by using the same ClientToken
	// parameter value. An error occurs if the other input parameters are not the
	// same as in the first request. Using a different value for ClientToken is
	// considered a new call to DeleteModel. An idempotency token is active for
	// 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The version of the model that you want to delete.
	//
	// ModelVersion is a required field
	ModelVersion *string `location:"uri" locationName:"modelVersion" min:"1" type:"string" required:"true"`

	// The name of the project that contains the model that you want to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ModelVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersion"))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteModelInput) SetClientToken(v string) *DeleteModelInput {
	s.ClientToken = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DeleteModelInput) SetModelVersion(v string) *DeleteModelInput {
	s.ModelVersion = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DeleteModelInput) SetProjectName(v string) *DeleteModelInput {
	s.ProjectName = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model that was deleted.
	ModelArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

// SetModelArn sets the ModelArn field's value.
func (s *DeleteModelOutput) SetModelArn(v string) *DeleteModelOutput {
	s.ModelArn = &v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to DeleteProject
	// completes only once. You choose the value to pass. For example, An issue,
	// such as an network outage, might prevent you from getting a response from
	// DeleteProject. In this case, safely retry your call to DeleteProject by using
	// the same ClientToken parameter value. An error occurs if the other input
	// parameters are not the same as in the first request. Using a different value
	// for ClientToken is considered a new call to DeleteProject. An idempotency
	// token is active for 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the project to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteProjectInput) SetClientToken(v string) *DeleteProjectInput {
	s.ClientToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DeleteProjectInput) SetProjectName(v string) *DeleteProjectInput {
	s.ProjectName = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project that was deleted.
	ProjectArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DeleteProjectOutput) SetProjectArn(v string) *DeleteProjectOutput {
	s.ProjectArn = &v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The type of the dataset to describe. Specify train to describe the training
	// dataset. Specify test to describe the test dataset. If you have a single
	// dataset project, specify train
	//
	// DatasetType is a required field
	DatasetType *string `location:"uri" locationName:"datasetType" min:"1" type:"string" required:"true"`

	// The name of the project that contains the dataset that you want to describe.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.DatasetType != nil && len(*s.DatasetType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetType", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetType sets the DatasetType field's value.
func (s *DescribeDatasetInput) SetDatasetType(v string) *DescribeDatasetInput {
	s.DatasetType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeDatasetInput) SetProjectName(v string) *DescribeDatasetInput {
	s.ProjectName = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The description of the requested dataset.
	DatasetDescription *DatasetDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetDescription sets the DatasetDescription field's value.
func (s *DescribeDatasetOutput) SetDatasetDescription(v *DatasetDescription) *DescribeDatasetOutput {
	s.DatasetDescription = v
	return s
}

type DescribeModelInput struct {
	_ struct{} `type:"structure"`

	// The version of the model that you want to describe.
	//
	// ModelVersion is a required field
	ModelVersion *string `location:"uri" locationName:"modelVersion" min:"1" type:"string" required:"true"`

	// The project that contains the version of a model that you want to describe.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelInput"}
	if s.ModelVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersion"))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DescribeModelInput) SetModelVersion(v string) *DescribeModelInput {
	s.ModelVersion = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeModelInput) SetProjectName(v string) *DescribeModelInput {
	s.ProjectName = &v
	return s
}

type DescribeModelOutput struct {
	_ struct{} `type:"structure"`

	// Contains the description of the model.
	ModelDescription *ModelDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeModelOutput) GoString() string {
	return s.String()
}

// SetModelDescription sets the ModelDescription field's value.
func (s *DescribeModelOutput) SetModelDescription(v *ModelDescription) *DescribeModelOutput {
	s.ModelDescription = v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the project that you want to describe.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeProjectInput) SetProjectName(v string) *DescribeProjectInput {
	s.ProjectName = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The description of the project.
	ProjectDescription *ProjectDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetProjectDescription sets the ProjectDescription field's value.
func (s *DescribeProjectOutput) SetProjectDescription(v *ProjectDescription) *DescribeProjectOutput {
	s.ProjectDescription = v
	return s
}

type DetectAnomaliesInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The unencrypted image bytes that you want to analyze.
	//
	// Body is a required field
	Body io.ReadSeeker `type:"blob" required:"true"`

	// The type of the image passed in Body. Valid values are image/png (PNG format
	// images) and image/jpeg (JPG format images).
	//
	// ContentType is a required field
	ContentType *string `location:"header" locationName:"Content-Type" min:"1" type:"string" required:"true"`

	// The version of the model that you want to use.
	//
	// ModelVersion is a required field
	ModelVersion *string `location:"uri" locationName:"modelVersion" min:"1" type:"string" required:"true"`

	// The name of the project that contains the model version that you want to
	// use.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectAnomaliesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectAnomaliesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectAnomaliesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectAnomaliesInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}
	if s.ModelVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersion"))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *DetectAnomaliesInput) SetBody(v io.ReadSeeker) *DetectAnomaliesInput {
	s.Body = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *DetectAnomaliesInput) SetContentType(v string) *DetectAnomaliesInput {
	s.ContentType = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectAnomaliesInput) SetModelVersion(v string) *DetectAnomaliesInput {
	s.ModelVersion = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DetectAnomaliesInput) SetProjectName(v string) *DetectAnomaliesInput {
	s.ProjectName = &v
	return s
}

type DetectAnomaliesOutput struct {
	_ struct{} `type:"structure"`

	// The results of the DetectAnomalies operation.
	DetectAnomalyResult *DetectAnomalyResult `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectAnomaliesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectAnomaliesOutput) GoString() string {
	return s.String()
}

// SetDetectAnomalyResult sets the DetectAnomalyResult field's value.
func (s *DetectAnomaliesOutput) SetDetectAnomalyResult(v *DetectAnomalyResult) *DetectAnomaliesOutput {
	s.DetectAnomalyResult = v
	return s
}

// The prediction results from a call to DetectAnomalies.
type DetectAnomalyResult struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Lookout for Vision has in the accuracy of the
	// prediction.
	Confidence *float64 `type:"float"`

	// True if the image contains an anomaly, otherwise false.
	IsAnomalous *bool `type:"boolean"`

	// The source of the image that was analyzed. direct means that the images was
	// supplied from the local computer. No other values are supported.
	Source *ImageSource `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectAnomalyResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectAnomalyResult) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *DetectAnomalyResult) SetConfidence(v float64) *DetectAnomalyResult {
	s.Confidence = &v
	return s
}

// SetIsAnomalous sets the IsAnomalous field's value.
func (s *DetectAnomalyResult) SetIsAnomalous(v bool) *DetectAnomalyResult {
	s.IsAnomalous = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DetectAnomalyResult) SetSource(v *ImageSource) *DetectAnomalyResult {
	s.Source = v
	return s
}

// The source for an image.
type ImageSource struct {
	_ struct{} `type:"structure"`

	// The type of the image.
	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageSource) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *ImageSource) SetType(v string) *ImageSource {
	s.Type = &v
	return s
}

// Amazon S3 Location information for an input manifest file.
type InputS3Object struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the manifest.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The name and location of the manifest file withiin the bucket.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The version ID of the bucket.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputS3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputS3Object) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputS3Object) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputS3Object"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *InputS3Object) SetBucket(v string) *InputS3Object {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *InputS3Object) SetKey(v string) *InputS3Object {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *InputS3Object) SetVersionId(v string) *InputS3Object {
	s.VersionId = &v
	return s
}

// Amazon Lookout for Vision experienced a service issue. Try your call again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The period of time, in seconds, before the operation can be retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDatasetEntriesInput struct {
	_ struct{} `type:"structure"`

	// Only includes entries after the specified date in the response. For example,
	// 2020-06-23T00:00:00.
	AfterCreationDate *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp"`

	// Specify normal to include only normal images. Specify anomaly to only include
	// anomalous entries. If you don't specify a value, Amazon Lookout for Vision
	// returns normal and anomalous images.
	AnomalyClass *string `location:"querystring" locationName:"anomalyClass" min:"1" type:"string"`

	// Only includes entries before the specified date in the response. For example,
	// 2020-06-23T00:00:00.
	BeforeCreationDate *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp"`

	// The type of the dataset that you want to list. Specify train to list the
	// training dataset. Specify test to list the test dataset. If you have a single
	// dataset project, specify train.
	//
	// DatasetType is a required field
	DatasetType *string `location:"uri" locationName:"datasetType" min:"1" type:"string" required:"true"`

	// Specify true to include labeled entries, otherwise specify false. If you
	// don't specify a value, Lookout for Vision returns all entries.
	Labeled *bool `location:"querystring" locationName:"labeled" type:"boolean"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Lookout for Vision returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of dataset entries.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the project that contains the dataset that you want to list.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`

	// Perform a "contains" search on the values of the source-ref key within the
	// dataset. For example a value of "IMG_17" returns all JSON Lines where the
	// source-ref key value matches *IMG_17*.
	SourceRefContains *string `location:"querystring" locationName:"sourceRefContains" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetEntriesInput"}
	if s.AnomalyClass != nil && len(*s.AnomalyClass) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AnomalyClass", 1))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.DatasetType != nil && len(*s.DatasetType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetType", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.SourceRefContains != nil && len(*s.SourceRefContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRefContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCreationDate sets the AfterCreationDate field's value.
func (s *ListDatasetEntriesInput) SetAfterCreationDate(v time.Time) *ListDatasetEntriesInput {
	s.AfterCreationDate = &v
	return s
}

// SetAnomalyClass sets the AnomalyClass field's value.
func (s *ListDatasetEntriesInput) SetAnomalyClass(v string) *ListDatasetEntriesInput {
	s.AnomalyClass = &v
	return s
}

// SetBeforeCreationDate sets the BeforeCreationDate field's value.
func (s *ListDatasetEntriesInput) SetBeforeCreationDate(v time.Time) *ListDatasetEntriesInput {
	s.BeforeCreationDate = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *ListDatasetEntriesInput) SetDatasetType(v string) *ListDatasetEntriesInput {
	s.DatasetType = &v
	return s
}

// SetLabeled sets the Labeled field's value.
func (s *ListDatasetEntriesInput) SetLabeled(v bool) *ListDatasetEntriesInput {
	s.Labeled = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetEntriesInput) SetMaxResults(v int64) *ListDatasetEntriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetEntriesInput) SetNextToken(v string) *ListDatasetEntriesInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListDatasetEntriesInput) SetProjectName(v string) *ListDatasetEntriesInput {
	s.ProjectName = &v
	return s
}

// SetSourceRefContains sets the SourceRefContains field's value.
func (s *ListDatasetEntriesInput) SetSourceRefContains(v string) *ListDatasetEntriesInput {
	s.SourceRefContains = &v
	return s
}

type ListDatasetEntriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the entries (JSON Lines) within the dataset.
	DatasetEntries []*string `type:"list"`

	// If the response is truncated, Amazon Lookout for Vision returns this token
	// that you can use in the subsequent request to retrieve the next set ofdataset
	// entries.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesOutput) GoString() string {
	return s.String()
}

// SetDatasetEntries sets the DatasetEntries field's value.
func (s *ListDatasetEntriesOutput) SetDatasetEntries(v []*string) *ListDatasetEntriesOutput {
	s.DatasetEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetEntriesOutput) SetNextToken(v string) *ListDatasetEntriesOutput {
	s.NextToken = &v
	return s
}

type ListModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Lookout for Vision returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of models.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the project that contains the model versions that you want to
	// list.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListModelsInput) SetMaxResults(v int64) *ListModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelsInput) SetNextToken(v string) *ListModelsInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListModelsInput) SetProjectName(v string) *ListModelsInput {
	s.ProjectName = &v
	return s
}

type ListModelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of model versions in the specified project.
	Models []*ModelMetadata `type:"list"`

	// If the response is truncated, Amazon Lookout for Vision returns this token
	// that you can use in the subsequent request to retrieve the next set of models.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *ListModelsOutput) SetModels(v []*ModelMetadata) *ListModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListModelsOutput) SetNextToken(v string) *ListModelsOutput {
	s.NextToken = &v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Lookout for Vision returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of projects.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Lookout for Vision returns this token
	// that you can use in the subsequent request to retrieve the next set of projects.
	NextToken *string `type:"string"`

	// A list of projects in your AWS account.
	Projects []*ProjectMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectMetadata) *ListProjectsOutput {
	s.Projects = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model for which you want to list tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map of tag keys and values attached to the specified model.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Describes an Amazon Lookout for Vision model.
type ModelDescription struct {
	_ struct{} `type:"structure"`

	// The unix timestamp for the date and time that the model was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The description for the model.
	Description *string `min:"1" type:"string"`

	// The unix timestamp for the date and time that the evaluation ended.
	EvaluationEndTimestamp *time.Time `type:"timestamp"`

	// The S3 location where Amazon Lookout for Vision saves the manifest file that
	// was used to test the trained model and generate the performance scores.
	EvaluationManifest *OutputS3Object `type:"structure"`

	// The S3 location where Amazon Lookout for Vision saves the performance metrics.
	EvaluationResult *OutputS3Object `type:"structure"`

	// The identifer for the AWS Key Management Service (AWS KMS) key that was used
	// to encrypt the model during training.
	KmsKeyId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the model.
	ModelArn *string `type:"string"`

	// The version of the model
	ModelVersion *string `min:"1" type:"string"`

	// The S3 location where Amazon Lookout for Vision saves model training files.
	OutputConfig *OutputConfig `type:"structure"`

	// Performance metrics for the model. Created during training.
	Performance *ModelPerformance `type:"structure"`

	// The status of the model.
	Status *string `type:"string" enum:"ModelStatus"`

	// The status message for the model.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelDescription) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ModelDescription) SetCreationTimestamp(v time.Time) *ModelDescription {
	s.CreationTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModelDescription) SetDescription(v string) *ModelDescription {
	s.Description = &v
	return s
}

// SetEvaluationEndTimestamp sets the EvaluationEndTimestamp field's value.
func (s *ModelDescription) SetEvaluationEndTimestamp(v time.Time) *ModelDescription {
	s.EvaluationEndTimestamp = &v
	return s
}

// SetEvaluationManifest sets the EvaluationManifest field's value.
func (s *ModelDescription) SetEvaluationManifest(v *OutputS3Object) *ModelDescription {
	s.EvaluationManifest = v
	return s
}

// SetEvaluationResult sets the EvaluationResult field's value.
func (s *ModelDescription) SetEvaluationResult(v *OutputS3Object) *ModelDescription {
	s.EvaluationResult = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ModelDescription) SetKmsKeyId(v string) *ModelDescription {
	s.KmsKeyId = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ModelDescription) SetModelArn(v string) *ModelDescription {
	s.ModelArn = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ModelDescription) SetModelVersion(v string) *ModelDescription {
	s.ModelVersion = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ModelDescription) SetOutputConfig(v *OutputConfig) *ModelDescription {
	s.OutputConfig = v
	return s
}

// SetPerformance sets the Performance field's value.
func (s *ModelDescription) SetPerformance(v *ModelPerformance) *ModelDescription {
	s.Performance = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelDescription) SetStatus(v string) *ModelDescription {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ModelDescription) SetStatusMessage(v string) *ModelDescription {
	s.StatusMessage = &v
	return s
}

// Describes an Amazon Lookout for Vision model.
type ModelMetadata struct {
	_ struct{} `type:"structure"`

	// The unix timestamp for the date and time that the model was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The description for the model.
	Description *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the model.
	ModelArn *string `type:"string"`

	// The version of the model.
	ModelVersion *string `min:"1" type:"string"`

	// Performance metrics for the model. Not available until training has successfully
	// completed.
	Performance *ModelPerformance `type:"structure"`

	// The status of the model.
	Status *string `type:"string" enum:"ModelStatus"`

	// The status message for the model.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelMetadata) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ModelMetadata) SetCreationTimestamp(v time.Time) *ModelMetadata {
	s.CreationTimestamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModelMetadata) SetDescription(v string) *ModelMetadata {
	s.Description = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *ModelMetadata) SetModelArn(v string) *ModelMetadata {
	s.ModelArn = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ModelMetadata) SetModelVersion(v string) *ModelMetadata {
	s.ModelVersion = &v
	return s
}

// SetPerformance sets the Performance field's value.
func (s *ModelMetadata) SetPerformance(v *ModelPerformance) *ModelMetadata {
	s.Performance = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelMetadata) SetStatus(v string) *ModelMetadata {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ModelMetadata) SetStatusMessage(v string) *ModelMetadata {
	s.StatusMessage = &v
	return s
}

// Information about the evaluation performance of a trained model.
type ModelPerformance struct {
	_ struct{} `type:"structure"`

	// The overall F1 score metric for the trained model.
	F1Score *float64 `type:"float"`

	// The overall precision metric value for the trained model.
	Precision *float64 `type:"float"`

	// The overall recall metric value for the trained model.
	Recall *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelPerformance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelPerformance) GoString() string {
	return s.String()
}

// SetF1Score sets the F1Score field's value.
func (s *ModelPerformance) SetF1Score(v float64) *ModelPerformance {
	s.F1Score = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ModelPerformance) SetPrecision(v float64) *ModelPerformance {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *ModelPerformance) SetRecall(v float64) *ModelPerformance {
	s.Recall = &v
	return s
}

// The S3 location where Amazon Lookout for Vision saves model training files.
type OutputConfig struct {
	_ struct{} `type:"structure"`

	// The S3 location for the output.
	//
	// S3Location is a required field
	S3Location *S3Location `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputConfig"}
	if s.S3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Location"))
	}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *OutputConfig) SetS3Location(v *S3Location) *OutputConfig {
	s.S3Location = v
	return s
}

// The S3 location where Amazon Lookout for Vision saves training output.
type OutputS3Object struct {
	_ struct{} `type:"structure"`

	// The bucket that contains the training output.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The location of the training output in the bucket.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputS3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputS3Object) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *OutputS3Object) SetBucket(v string) *OutputS3Object {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *OutputS3Object) SetKey(v string) *OutputS3Object {
	s.Key = &v
	return s
}

// Describe an Amazon Lookout for Vision project. For more information, see
// DescribeProject.
type ProjectDescription struct {
	_ struct{} `type:"structure"`

	// The unix timestamp for the date and time that the project was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// A list of datasets in the project.
	Datasets []*DatasetMetadata `type:"list"`

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string `type:"string"`

	// The name of the project.
	ProjectName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDescription) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ProjectDescription) SetCreationTimestamp(v time.Time) *ProjectDescription {
	s.CreationTimestamp = &v
	return s
}

// SetDatasets sets the Datasets field's value.
func (s *ProjectDescription) SetDatasets(v []*DatasetMetadata) *ProjectDescription {
	s.Datasets = v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ProjectDescription) SetProjectArn(v string) *ProjectDescription {
	s.ProjectArn = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ProjectDescription) SetProjectName(v string) *ProjectDescription {
	s.ProjectName = &v
	return s
}

// Metadata about an Amazon Lookout for Vision project.
type ProjectMetadata struct {
	_ struct{} `type:"structure"`

	// The unix timestamp for the date and time that the project was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string `type:"string"`

	// The name of the project.
	ProjectName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectMetadata) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ProjectMetadata) SetCreationTimestamp(v time.Time) *ProjectMetadata {
	s.CreationTimestamp = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ProjectMetadata) SetProjectArn(v string) *ProjectMetadata {
	s.ProjectArn = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ProjectMetadata) SetProjectName(v string) *ProjectMetadata {
	s.ProjectName = &v
	return s
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the resource.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the resource.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the location training output.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that contains the training output.
	//
	// Bucket is a required field
	Bucket *string `min:"3" type:"string" required:"true"`

	// The path of the folder, within the S3 bucket, that contains the training
	// output.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Location) SetBucket(v string) *S3Location {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3Location) SetPrefix(v string) *S3Location {
	s.Prefix = &v
	return s
}

// A service quota was exceeded the allowed limit. For more information, see
// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer
// Guide.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The quota code.
	//
	// QuotaCode is a required field
	QuotaCode *string `type:"string" required:"true"`

	// The ID of the resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// The service code.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartModelInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to StartModel completes
	// only once. You choose the value to pass. For example, An issue, such as an
	// network outage, might prevent you from getting a response from StartModel.
	// In this case, safely retry your call to StartModel by using the same ClientToken
	// parameter value. An error occurs if the other input parameters are not the
	// same as in the first request. Using a different value for ClientToken is
	// considered a new call to StartModel. An idempotency token is active for 8
	// hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The minimum number of inference units to use. A single inference unit represents
	// 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
	// Use a higher number to increase the TPS throughput of your model. You are
	// charged for the number of inference units that you use.
	//
	// MinInferenceUnits is a required field
	MinInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// The version of the model that you want to start.
	//
	// ModelVersion is a required field
	ModelVersion *string `location:"uri" locationName:"modelVersion" min:"1" type:"string" required:"true"`

	// The name of the project that contains the model that you want to start.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartModelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.MinInferenceUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("MinInferenceUnits"))
	}
	if s.MinInferenceUnits != nil && *s.MinInferenceUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinInferenceUnits", 1))
	}
	if s.ModelVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersion"))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartModelInput) SetClientToken(v string) *StartModelInput {
	s.ClientToken = &v
	return s
}

// SetMinInferenceUnits sets the MinInferenceUnits field's value.
func (s *StartModelInput) SetMinInferenceUnits(v int64) *StartModelInput {
	s.MinInferenceUnits = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *StartModelInput) SetModelVersion(v string) *StartModelInput {
	s.ModelVersion = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *StartModelInput) SetProjectName(v string) *StartModelInput {
	s.ProjectName = &v
	return s
}

type StartModelOutput struct {
	_ struct{} `type:"structure"`

	// The current running status of the model.
	Status *string `type:"string" enum:"ModelHostingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartModelOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *StartModelOutput) SetStatus(v string) *StartModelOutput {
	s.Status = &v
	return s
}

type StopModelInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to StopModel completes
	// only once. You choose the value to pass. For example, An issue, such as an
	// network outage, might prevent you from getting a response from StopModel.
	// In this case, safely retry your call to StopModel by using the same ClientToken
	// parameter value. An error occurs if the other input parameters are not the
	// same as in the first request. Using a different value for ClientToken is
	// considered a new call to StopModel. An idempotency token is active for 8
	// hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The version of the model that you want to stop.
	//
	// ModelVersion is a required field
	ModelVersion *string `location:"uri" locationName:"modelVersion" min:"1" type:"string" required:"true"`

	// The name of the project that contains the model that you want to stop.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopModelInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ModelVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersion"))
	}
	if s.ModelVersion != nil && len(*s.ModelVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersion", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StopModelInput) SetClientToken(v string) *StopModelInput {
	s.ClientToken = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *StopModelInput) SetModelVersion(v string) *StopModelInput {
	s.ModelVersion = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *StopModelInput) SetProjectName(v string) *StopModelInput {
	s.ProjectName = &v
	return s
}

type StopModelOutput struct {
	_ struct{} `type:"structure"`

	// The status of the model.
	Status *string `type:"string" enum:"ModelHostingStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopModelOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *StopModelOutput) SetStatus(v string) *StopModelOutput {
	s.Status = &v
	return s
}

// A key and value pair that is attached to the specified Amazon Lookout for
// Vision model.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag that is attached to the specified model.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag that is attached to the specified model.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model to assign the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The key-value tags to assign to the model.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Amazon Lookout for Vision is temporarily unable to process the request. Try
// your call again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The quota code.
	QuotaCode *string `type:"string"`

	// The period of time, in seconds, before the operation can be retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The service code.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model from which you want to remove
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of the keys of the tags that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDatasetEntriesInput struct {
	_ struct{} `type:"structure"`

	// The entries to add to the dataset.
	// Changes is automatically base64 encoded/decoded by the SDK.
	//
	// Changes is a required field
	Changes []byte `min:"1" type:"blob" required:"true"`

	// ClientToken is an idempotency token that ensures a call to UpdateDatasetEntries
	// completes only once. You choose the value to pass. For example, An issue,
	// such as an network outage, might prevent you from getting a response from
	// UpdateDatasetEntries. In this case, safely retry your call to UpdateDatasetEntries
	// by using the same ClientToken parameter value. An error occurs if the other
	// input parameters are not the same as in the first request. Using a different
	// value for ClientToken is considered a new call to UpdateDatasetEntries. An
	// idempotency token is active for 8 hours.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The type of the dataset that you want to update. Specify train to update
	// the training dataset. Specify test to update the test dataset. If you have
	// a single dataset project, specify train.
	//
	// DatasetType is a required field
	DatasetType *string `location:"uri" locationName:"datasetType" min:"1" type:"string" required:"true"`

	// The name of the project that contains the dataset that you want to update.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasetEntriesInput"}
	if s.Changes == nil {
		invalidParams.Add(request.NewErrParamRequired("Changes"))
	}
	if s.Changes != nil && len(s.Changes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Changes", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.DatasetType != nil && len(*s.DatasetType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetType", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChanges sets the Changes field's value.
func (s *UpdateDatasetEntriesInput) SetChanges(v []byte) *UpdateDatasetEntriesInput {
	s.Changes = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateDatasetEntriesInput) SetClientToken(v string) *UpdateDatasetEntriesInput {
	s.ClientToken = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *UpdateDatasetEntriesInput) SetDatasetType(v string) *UpdateDatasetEntriesInput {
	s.DatasetType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateDatasetEntriesInput) SetProjectName(v string) *UpdateDatasetEntriesInput {
	s.ProjectName = &v
	return s
}

type UpdateDatasetEntriesOutput struct {
	_ struct{} `type:"structure"`

	// The status of the dataset update.
	Status *string `type:"string" enum:"DatasetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *UpdateDatasetEntriesOutput) SetStatus(v string) *UpdateDatasetEntriesOutput {
	s.Status = &v
	return s
}

// An input validation error occured. For example, invalid characters in a project
// name, or if a pagination token is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DatasetStatusCreateInProgress is a DatasetStatus enum value
	DatasetStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// DatasetStatusCreateComplete is a DatasetStatus enum value
	DatasetStatusCreateComplete = "CREATE_COMPLETE"

	// DatasetStatusCreateFailed is a DatasetStatus enum value
	DatasetStatusCreateFailed = "CREATE_FAILED"

	// DatasetStatusUpdateInProgress is a DatasetStatus enum value
	DatasetStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// DatasetStatusUpdateComplete is a DatasetStatus enum value
	DatasetStatusUpdateComplete = "UPDATE_COMPLETE"

	// DatasetStatusUpdateFailedRollbackInProgress is a DatasetStatus enum value
	DatasetStatusUpdateFailedRollbackInProgress = "UPDATE_FAILED_ROLLBACK_IN_PROGRESS"

	// DatasetStatusUpdateFailedRollbackComplete is a DatasetStatus enum value
	DatasetStatusUpdateFailedRollbackComplete = "UPDATE_FAILED_ROLLBACK_COMPLETE"

	// DatasetStatusDeleteInProgress is a DatasetStatus enum value
	DatasetStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// DatasetStatusDeleteComplete is a DatasetStatus enum value
	DatasetStatusDeleteComplete = "DELETE_COMPLETE"

	// DatasetStatusDeleteFailed is a DatasetStatus enum value
	DatasetStatusDeleteFailed = "DELETE_FAILED"
)

// DatasetStatus_Values returns all elements of the DatasetStatus enum
func DatasetStatus_Values() []string {
	return []string{
		DatasetStatusCreateInProgress,
		DatasetStatusCreateComplete,
		DatasetStatusCreateFailed,
		DatasetStatusUpdateInProgress,
		DatasetStatusUpdateComplete,
		DatasetStatusUpdateFailedRollbackInProgress,
		DatasetStatusUpdateFailedRollbackComplete,
		DatasetStatusDeleteInProgress,
		DatasetStatusDeleteComplete,
		DatasetStatusDeleteFailed,
	}
}

const (
	// ModelHostingStatusStartingHosting is a ModelHostingStatus enum value
	ModelHostingStatusStartingHosting = "STARTING_HOSTING"

	// ModelHostingStatusHosted is a ModelHostingStatus enum value
	ModelHostingStatusHosted = "HOSTED"

	// ModelHostingStatusHostingFailed is a ModelHostingStatus enum value
	ModelHostingStatusHostingFailed = "HOSTING_FAILED"

	// ModelHostingStatusStoppingHosting is a ModelHostingStatus enum value
	ModelHostingStatusStoppingHosting = "STOPPING_HOSTING"

	// ModelHostingStatusSystemUpdating is a ModelHostingStatus enum value
	ModelHostingStatusSystemUpdating = "SYSTEM_UPDATING"
)

// ModelHostingStatus_Values returns all elements of the ModelHostingStatus enum
func ModelHostingStatus_Values() []string {
	return []string{
		ModelHostingStatusStartingHosting,
		ModelHostingStatusHosted,
		ModelHostingStatusHostingFailed,
		ModelHostingStatusStoppingHosting,
		ModelHostingStatusSystemUpdating,
	}
}

const (
	// ModelStatusTraining is a ModelStatus enum value
	ModelStatusTraining = "TRAINING"

	// ModelStatusTrained is a ModelStatus enum value
	ModelStatusTrained = "TRAINED"

	// ModelStatusTrainingFailed is a ModelStatus enum value
	ModelStatusTrainingFailed = "TRAINING_FAILED"

	// ModelStatusStartingHosting is a ModelStatus enum value
	ModelStatusStartingHosting = "STARTING_HOSTING"

	// ModelStatusHosted is a ModelStatus enum value
	ModelStatusHosted = "HOSTED"

	// ModelStatusHostingFailed is a ModelStatus enum value
	ModelStatusHostingFailed = "HOSTING_FAILED"

	// ModelStatusStoppingHosting is a ModelStatus enum value
	ModelStatusStoppingHosting = "STOPPING_HOSTING"

	// ModelStatusSystemUpdating is a ModelStatus enum value
	ModelStatusSystemUpdating = "SYSTEM_UPDATING"

	// ModelStatusDeleting is a ModelStatus enum value
	ModelStatusDeleting = "DELETING"
)

// ModelStatus_Values returns all elements of the ModelStatus enum
func ModelStatus_Values() []string {
	return []string{
		ModelStatusTraining,
		ModelStatusTrained,
		ModelStatusTrainingFailed,
		ModelStatusStartingHosting,
		ModelStatusHosted,
		ModelStatusHostingFailed,
		ModelStatusStoppingHosting,
		ModelStatusSystemUpdating,
		ModelStatusDeleting,
	}
}

const (
	// ResourceTypeProject is a ResourceType enum value
	ResourceTypeProject = "PROJECT"

	// ResourceTypeDataset is a ResourceType enum value
	ResourceTypeDataset = "DATASET"

	// ResourceTypeModel is a ResourceType enum value
	ResourceTypeModel = "MODEL"

	// ResourceTypeTrial is a ResourceType enum value
	ResourceTypeTrial = "TRIAL"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeProject,
		ResourceTypeDataset,
		ResourceTypeModel,
		ResourceTypeTrial,
	}
}
