// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v6/resources/campaign.proto

package resources

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v6/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v6/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// A campaign.
type Campaign struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the campaign.
	// Campaign resource names have the form:
	//
	// `customers/{customer_id}/campaigns/{campaign_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the campaign.
	Id *int64 `protobuf:"varint,59,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// The name of the campaign.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// It must not contain any null (code point 0x0), NL line feed
	// (code point 0xA) or carriage return (code point 0xD) characters.
	Name *string `protobuf:"bytes,58,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// The status of the campaign.
	//
	// When a new campaign is added, the status defaults to ENABLED.
	Status enums.CampaignStatusEnum_CampaignStatus `protobuf:"varint,5,opt,name=status,proto3,enum=google.ads.googleads.v6.enums.CampaignStatusEnum_CampaignStatus" json:"status,omitempty"`
	// Output only. The ad serving status of the campaign.
	ServingStatus enums.CampaignServingStatusEnum_CampaignServingStatus `protobuf:"varint,21,opt,name=serving_status,json=servingStatus,proto3,enum=google.ads.googleads.v6.enums.CampaignServingStatusEnum_CampaignServingStatus" json:"serving_status,omitempty"`
	// The ad serving optimization status of the campaign.
	AdServingOptimizationStatus enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus `protobuf:"varint,8,opt,name=ad_serving_optimization_status,json=adServingOptimizationStatus,proto3,enum=google.ads.googleads.v6.enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus" json:"ad_serving_optimization_status,omitempty"`
	// Immutable. The primary serving target for ads within the campaign.
	// The targeting options can be refined in `network_settings`.
	//
	// This field is required and should not be empty when creating new
	// campaigns.
	//
	// Can be set only when creating campaigns.
	// After the campaign is created, the field can not be changed.
	AdvertisingChannelType enums.AdvertisingChannelTypeEnum_AdvertisingChannelType `protobuf:"varint,9,opt,name=advertising_channel_type,json=advertisingChannelType,proto3,enum=google.ads.googleads.v6.enums.AdvertisingChannelTypeEnum_AdvertisingChannelType" json:"advertising_channel_type,omitempty"`
	// Immutable. Optional refinement to `advertising_channel_type`.
	// Must be a valid sub-type of the parent channel type.
	//
	// Can be set only when creating campaigns.
	// After campaign is created, the field can not be changed.
	AdvertisingChannelSubType enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType `protobuf:"varint,10,opt,name=advertising_channel_sub_type,json=advertisingChannelSubType,proto3,enum=google.ads.googleads.v6.enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType" json:"advertising_channel_sub_type,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *string `protobuf:"bytes,60,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3,oneof" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,12,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Settings for Real-Time Bidding, a feature only available for campaigns
	// targeting the Ad Exchange network.
	RealTimeBiddingSetting *common.RealTimeBiddingSetting `protobuf:"bytes,39,opt,name=real_time_bidding_setting,json=realTimeBiddingSetting,proto3" json:"real_time_bidding_setting,omitempty"`
	// The network settings for the campaign.
	NetworkSettings *Campaign_NetworkSettings `protobuf:"bytes,14,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// Immutable. The hotel setting for the campaign.
	HotelSetting *Campaign_HotelSettingInfo `protobuf:"bytes,32,opt,name=hotel_setting,json=hotelSetting,proto3" json:"hotel_setting,omitempty"`
	// The setting for controlling Dynamic Search Ads (DSA).
	DynamicSearchAdsSetting *Campaign_DynamicSearchAdsSetting `protobuf:"bytes,33,opt,name=dynamic_search_ads_setting,json=dynamicSearchAdsSetting,proto3" json:"dynamic_search_ads_setting,omitempty"`
	// The setting for controlling Shopping campaigns.
	ShoppingSetting *Campaign_ShoppingSetting `protobuf:"bytes,36,opt,name=shopping_setting,json=shoppingSetting,proto3" json:"shopping_setting,omitempty"`
	// Setting for targeting related features.
	TargetingSetting *common.TargetingSetting `protobuf:"bytes,43,opt,name=targeting_setting,json=targetingSetting,proto3" json:"targeting_setting,omitempty"`
	// The setting for ads geotargeting.
	GeoTargetTypeSetting *Campaign_GeoTargetTypeSetting `protobuf:"bytes,47,opt,name=geo_target_type_setting,json=geoTargetTypeSetting,proto3" json:"geo_target_type_setting,omitempty"`
	// The setting for local campaign.
	LocalCampaignSetting *Campaign_LocalCampaignSetting `protobuf:"bytes,50,opt,name=local_campaign_setting,json=localCampaignSetting,proto3" json:"local_campaign_setting,omitempty"`
	// The setting related to App Campaign.
	AppCampaignSetting *Campaign_AppCampaignSetting `protobuf:"bytes,51,opt,name=app_campaign_setting,json=appCampaignSetting,proto3" json:"app_campaign_setting,omitempty"`
	// Output only. The resource names of labels attached to this campaign.
	Labels []string `protobuf:"bytes,61,rep,name=labels,proto3" json:"labels,omitempty"`
	// Output only. The type of campaign: normal, draft, or experiment.
	ExperimentType enums.CampaignExperimentTypeEnum_CampaignExperimentType `protobuf:"varint,17,opt,name=experiment_type,json=experimentType,proto3,enum=google.ads.googleads.v6.enums.CampaignExperimentTypeEnum_CampaignExperimentType" json:"experiment_type,omitempty"`
	// Output only. The resource name of the base campaign of a draft or experiment campaign.
	// For base campaigns, this is equal to `resource_name`.
	//
	// This field is read-only.
	BaseCampaign *string `protobuf:"bytes,56,opt,name=base_campaign,json=baseCampaign,proto3,oneof" json:"base_campaign,omitempty"`
	// The budget of the campaign.
	CampaignBudget *string `protobuf:"bytes,62,opt,name=campaign_budget,json=campaignBudget,proto3,oneof" json:"campaign_budget,omitempty"`
	// Output only. The type of bidding strategy.
	//
	// A bidding strategy can be created by setting either the bidding scheme to
	// create a standard bidding strategy or the `bidding_strategy` field to
	// create a portfolio bidding strategy.
	//
	// This field is read-only.
	BiddingStrategyType enums.BiddingStrategyTypeEnum_BiddingStrategyType `protobuf:"varint,22,opt,name=bidding_strategy_type,json=biddingStrategyType,proto3,enum=google.ads.googleads.v6.enums.BiddingStrategyTypeEnum_BiddingStrategyType" json:"bidding_strategy_type,omitempty"`
	// The date when campaign started.
	StartDate *string `protobuf:"bytes,63,opt,name=start_date,json=startDate,proto3,oneof" json:"start_date,omitempty"`
	// The date when campaign ended.
	EndDate *string `protobuf:"bytes,64,opt,name=end_date,json=endDate,proto3,oneof" json:"end_date,omitempty"`
	// Suffix used to append query parameters to landing pages that are served
	// with parallel tracking.
	FinalUrlSuffix *string `protobuf:"bytes,65,opt,name=final_url_suffix,json=finalUrlSuffix,proto3,oneof" json:"final_url_suffix,omitempty"`
	// A list that limits how often each user will see this campaign's ads.
	FrequencyCaps []*common.FrequencyCapEntry `protobuf:"bytes,40,rep,name=frequency_caps,json=frequencyCaps,proto3" json:"frequency_caps,omitempty"`
	// Output only. 3-Tier Brand Safety setting for the campaign.
	VideoBrandSafetySuitability enums.BrandSafetySuitabilityEnum_BrandSafetySuitability `protobuf:"varint,42,opt,name=video_brand_safety_suitability,json=videoBrandSafetySuitability,proto3,enum=google.ads.googleads.v6.enums.BrandSafetySuitabilityEnum_BrandSafetySuitability" json:"video_brand_safety_suitability,omitempty"`
	// Describes how unbranded pharma ads will be displayed.
	VanityPharma *Campaign_VanityPharma `protobuf:"bytes,44,opt,name=vanity_pharma,json=vanityPharma,proto3" json:"vanity_pharma,omitempty"`
	// Selective optimization setting for this campaign, which includes a set of
	// conversion actions to optimize this campaign towards.
	SelectiveOptimization *Campaign_SelectiveOptimization `protobuf:"bytes,45,opt,name=selective_optimization,json=selectiveOptimization,proto3" json:"selective_optimization,omitempty"`
	// Optimization goal setting for this campaign, which includes a set of
	// optimization goal types.
	OptimizationGoalSetting *Campaign_OptimizationGoalSetting `protobuf:"bytes,54,opt,name=optimization_goal_setting,json=optimizationGoalSetting,proto3" json:"optimization_goal_setting,omitempty"`
	// Output only. Campaign-level settings for tracking information.
	TrackingSetting *Campaign_TrackingSetting `protobuf:"bytes,46,opt,name=tracking_setting,json=trackingSetting,proto3" json:"tracking_setting,omitempty"`
	// Payment mode for the campaign.
	PaymentMode enums.PaymentModeEnum_PaymentMode `protobuf:"varint,52,opt,name=payment_mode,json=paymentMode,proto3,enum=google.ads.googleads.v6.enums.PaymentModeEnum_PaymentMode" json:"payment_mode,omitempty"`
	// Output only. Optimization score of the campaign.
	//
	// Optimization score is an estimate of how well a campaign is set to perform.
	// It ranges from 0% (0.0) to 100% (1.0), with 100% indicating that the
	// campaign is performing at full potential. This field is null for unscored
	// campaigns.
	//
	// See "About optimization score" at
	// https://support.google.com/google-ads/answer/9061546.
	//
	// This field is read-only.
	OptimizationScore *float64 `protobuf:"fixed64,66,opt,name=optimization_score,json=optimizationScore,proto3,oneof" json:"optimization_score,omitempty"`
	// The bidding strategy for the campaign.
	//
	// Must be either portfolio (created via BiddingStrategy service) or
	// standard, that is embedded into the campaign.
	//
	// Types that are assignable to CampaignBiddingStrategy:
	//	*Campaign_BiddingStrategy
	//	*Campaign_Commission
	//	*Campaign_ManualCpc
	//	*Campaign_ManualCpm
	//	*Campaign_ManualCpv
	//	*Campaign_MaximizeConversions
	//	*Campaign_MaximizeConversionValue
	//	*Campaign_TargetCpa
	//	*Campaign_TargetImpressionShare
	//	*Campaign_TargetRoas
	//	*Campaign_TargetSpend
	//	*Campaign_PercentCpc
	//	*Campaign_TargetCpm
	CampaignBiddingStrategy isCampaign_CampaignBiddingStrategy `protobuf_oneof:"campaign_bidding_strategy"`
}

func (x *Campaign) Reset() {
	*x = Campaign{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign) ProtoMessage() {}

func (x *Campaign) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign.ProtoReflect.Descriptor instead.
func (*Campaign) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0}
}

func (x *Campaign) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *Campaign) GetId() int64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Campaign) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Campaign) GetStatus() enums.CampaignStatusEnum_CampaignStatus {
	if x != nil {
		return x.Status
	}
	return enums.CampaignStatusEnum_UNSPECIFIED
}

func (x *Campaign) GetServingStatus() enums.CampaignServingStatusEnum_CampaignServingStatus {
	if x != nil {
		return x.ServingStatus
	}
	return enums.CampaignServingStatusEnum_UNSPECIFIED
}

func (x *Campaign) GetAdServingOptimizationStatus() enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus {
	if x != nil {
		return x.AdServingOptimizationStatus
	}
	return enums.AdServingOptimizationStatusEnum_UNSPECIFIED
}

func (x *Campaign) GetAdvertisingChannelType() enums.AdvertisingChannelTypeEnum_AdvertisingChannelType {
	if x != nil {
		return x.AdvertisingChannelType
	}
	return enums.AdvertisingChannelTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetAdvertisingChannelSubType() enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType {
	if x != nil {
		return x.AdvertisingChannelSubType
	}
	return enums.AdvertisingChannelSubTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetTrackingUrlTemplate() string {
	if x != nil && x.TrackingUrlTemplate != nil {
		return *x.TrackingUrlTemplate
	}
	return ""
}

func (x *Campaign) GetUrlCustomParameters() []*common.CustomParameter {
	if x != nil {
		return x.UrlCustomParameters
	}
	return nil
}

func (x *Campaign) GetRealTimeBiddingSetting() *common.RealTimeBiddingSetting {
	if x != nil {
		return x.RealTimeBiddingSetting
	}
	return nil
}

func (x *Campaign) GetNetworkSettings() *Campaign_NetworkSettings {
	if x != nil {
		return x.NetworkSettings
	}
	return nil
}

func (x *Campaign) GetHotelSetting() *Campaign_HotelSettingInfo {
	if x != nil {
		return x.HotelSetting
	}
	return nil
}

func (x *Campaign) GetDynamicSearchAdsSetting() *Campaign_DynamicSearchAdsSetting {
	if x != nil {
		return x.DynamicSearchAdsSetting
	}
	return nil
}

func (x *Campaign) GetShoppingSetting() *Campaign_ShoppingSetting {
	if x != nil {
		return x.ShoppingSetting
	}
	return nil
}

func (x *Campaign) GetTargetingSetting() *common.TargetingSetting {
	if x != nil {
		return x.TargetingSetting
	}
	return nil
}

func (x *Campaign) GetGeoTargetTypeSetting() *Campaign_GeoTargetTypeSetting {
	if x != nil {
		return x.GeoTargetTypeSetting
	}
	return nil
}

func (x *Campaign) GetLocalCampaignSetting() *Campaign_LocalCampaignSetting {
	if x != nil {
		return x.LocalCampaignSetting
	}
	return nil
}

func (x *Campaign) GetAppCampaignSetting() *Campaign_AppCampaignSetting {
	if x != nil {
		return x.AppCampaignSetting
	}
	return nil
}

func (x *Campaign) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Campaign) GetExperimentType() enums.CampaignExperimentTypeEnum_CampaignExperimentType {
	if x != nil {
		return x.ExperimentType
	}
	return enums.CampaignExperimentTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetBaseCampaign() string {
	if x != nil && x.BaseCampaign != nil {
		return *x.BaseCampaign
	}
	return ""
}

func (x *Campaign) GetCampaignBudget() string {
	if x != nil && x.CampaignBudget != nil {
		return *x.CampaignBudget
	}
	return ""
}

func (x *Campaign) GetBiddingStrategyType() enums.BiddingStrategyTypeEnum_BiddingStrategyType {
	if x != nil {
		return x.BiddingStrategyType
	}
	return enums.BiddingStrategyTypeEnum_UNSPECIFIED
}

func (x *Campaign) GetStartDate() string {
	if x != nil && x.StartDate != nil {
		return *x.StartDate
	}
	return ""
}

func (x *Campaign) GetEndDate() string {
	if x != nil && x.EndDate != nil {
		return *x.EndDate
	}
	return ""
}

func (x *Campaign) GetFinalUrlSuffix() string {
	if x != nil && x.FinalUrlSuffix != nil {
		return *x.FinalUrlSuffix
	}
	return ""
}

func (x *Campaign) GetFrequencyCaps() []*common.FrequencyCapEntry {
	if x != nil {
		return x.FrequencyCaps
	}
	return nil
}

func (x *Campaign) GetVideoBrandSafetySuitability() enums.BrandSafetySuitabilityEnum_BrandSafetySuitability {
	if x != nil {
		return x.VideoBrandSafetySuitability
	}
	return enums.BrandSafetySuitabilityEnum_UNSPECIFIED
}

func (x *Campaign) GetVanityPharma() *Campaign_VanityPharma {
	if x != nil {
		return x.VanityPharma
	}
	return nil
}

func (x *Campaign) GetSelectiveOptimization() *Campaign_SelectiveOptimization {
	if x != nil {
		return x.SelectiveOptimization
	}
	return nil
}

func (x *Campaign) GetOptimizationGoalSetting() *Campaign_OptimizationGoalSetting {
	if x != nil {
		return x.OptimizationGoalSetting
	}
	return nil
}

func (x *Campaign) GetTrackingSetting() *Campaign_TrackingSetting {
	if x != nil {
		return x.TrackingSetting
	}
	return nil
}

func (x *Campaign) GetPaymentMode() enums.PaymentModeEnum_PaymentMode {
	if x != nil {
		return x.PaymentMode
	}
	return enums.PaymentModeEnum_UNSPECIFIED
}

func (x *Campaign) GetOptimizationScore() float64 {
	if x != nil && x.OptimizationScore != nil {
		return *x.OptimizationScore
	}
	return 0
}

func (m *Campaign) GetCampaignBiddingStrategy() isCampaign_CampaignBiddingStrategy {
	if m != nil {
		return m.CampaignBiddingStrategy
	}
	return nil
}

func (x *Campaign) GetBiddingStrategy() string {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_BiddingStrategy); ok {
		return x.BiddingStrategy
	}
	return ""
}

func (x *Campaign) GetCommission() *common.Commission {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_Commission); ok {
		return x.Commission
	}
	return nil
}

func (x *Campaign) GetManualCpc() *common.ManualCpc {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_ManualCpc); ok {
		return x.ManualCpc
	}
	return nil
}

func (x *Campaign) GetManualCpm() *common.ManualCpm {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_ManualCpm); ok {
		return x.ManualCpm
	}
	return nil
}

func (x *Campaign) GetManualCpv() *common.ManualCpv {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_ManualCpv); ok {
		return x.ManualCpv
	}
	return nil
}

func (x *Campaign) GetMaximizeConversions() *common.MaximizeConversions {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversions); ok {
		return x.MaximizeConversions
	}
	return nil
}

func (x *Campaign) GetMaximizeConversionValue() *common.MaximizeConversionValue {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_MaximizeConversionValue); ok {
		return x.MaximizeConversionValue
	}
	return nil
}

func (x *Campaign) GetTargetCpa() *common.TargetCpa {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetCpa); ok {
		return x.TargetCpa
	}
	return nil
}

func (x *Campaign) GetTargetImpressionShare() *common.TargetImpressionShare {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetImpressionShare); ok {
		return x.TargetImpressionShare
	}
	return nil
}

func (x *Campaign) GetTargetRoas() *common.TargetRoas {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetRoas); ok {
		return x.TargetRoas
	}
	return nil
}

func (x *Campaign) GetTargetSpend() *common.TargetSpend {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetSpend); ok {
		return x.TargetSpend
	}
	return nil
}

func (x *Campaign) GetPercentCpc() *common.PercentCpc {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_PercentCpc); ok {
		return x.PercentCpc
	}
	return nil
}

func (x *Campaign) GetTargetCpm() *common.TargetCpm {
	if x, ok := x.GetCampaignBiddingStrategy().(*Campaign_TargetCpm); ok {
		return x.TargetCpm
	}
	return nil
}

type isCampaign_CampaignBiddingStrategy interface {
	isCampaign_CampaignBiddingStrategy()
}

type Campaign_BiddingStrategy struct {
	// Portfolio bidding strategy used by campaign.
	BiddingStrategy string `protobuf:"bytes,67,opt,name=bidding_strategy,json=biddingStrategy,proto3,oneof"`
}

type Campaign_Commission struct {
	// Commission is an automatic bidding strategy in which the advertiser pays
	// a certain portion of the conversion value.
	Commission *common.Commission `protobuf:"bytes,49,opt,name=commission,proto3,oneof"`
}

type Campaign_ManualCpc struct {
	// Standard Manual CPC bidding strategy.
	// Manual click-based bidding where user pays per click.
	ManualCpc *common.ManualCpc `protobuf:"bytes,24,opt,name=manual_cpc,json=manualCpc,proto3,oneof"`
}

type Campaign_ManualCpm struct {
	// Standard Manual CPM bidding strategy.
	// Manual impression-based bidding where user pays per thousand
	// impressions.
	ManualCpm *common.ManualCpm `protobuf:"bytes,25,opt,name=manual_cpm,json=manualCpm,proto3,oneof"`
}

type Campaign_ManualCpv struct {
	// Output only. A bidding strategy that pays a configurable amount per video view.
	ManualCpv *common.ManualCpv `protobuf:"bytes,37,opt,name=manual_cpv,json=manualCpv,proto3,oneof"`
}

type Campaign_MaximizeConversions struct {
	// Standard Maximize Conversions bidding strategy that automatically
	// maximizes number of conversions while spending your budget.
	MaximizeConversions *common.MaximizeConversions `protobuf:"bytes,30,opt,name=maximize_conversions,json=maximizeConversions,proto3,oneof"`
}

type Campaign_MaximizeConversionValue struct {
	// Standard Maximize Conversion Value bidding strategy that automatically
	// sets bids to maximize revenue while spending your budget.
	MaximizeConversionValue *common.MaximizeConversionValue `protobuf:"bytes,31,opt,name=maximize_conversion_value,json=maximizeConversionValue,proto3,oneof"`
}

type Campaign_TargetCpa struct {
	// Standard Target CPA bidding strategy that automatically sets bids to
	// help get as many conversions as possible at the target
	// cost-per-acquisition (CPA) you set.
	TargetCpa *common.TargetCpa `protobuf:"bytes,26,opt,name=target_cpa,json=targetCpa,proto3,oneof"`
}

type Campaign_TargetImpressionShare struct {
	// Target Impression Share bidding strategy. An automated bidding strategy
	// that sets bids to achieve a desired percentage of impressions.
	TargetImpressionShare *common.TargetImpressionShare `protobuf:"bytes,48,opt,name=target_impression_share,json=targetImpressionShare,proto3,oneof"`
}

type Campaign_TargetRoas struct {
	// Standard Target ROAS bidding strategy that automatically maximizes
	// revenue while averaging a specific target return on ad spend (ROAS).
	TargetRoas *common.TargetRoas `protobuf:"bytes,29,opt,name=target_roas,json=targetRoas,proto3,oneof"`
}

type Campaign_TargetSpend struct {
	// Standard Target Spend bidding strategy that automatically sets your bids
	// to help get as many clicks as possible within your budget.
	TargetSpend *common.TargetSpend `protobuf:"bytes,27,opt,name=target_spend,json=targetSpend,proto3,oneof"`
}

type Campaign_PercentCpc struct {
	// Standard Percent Cpc bidding strategy where bids are a fraction of the
	// advertised price for some good or service.
	PercentCpc *common.PercentCpc `protobuf:"bytes,34,opt,name=percent_cpc,json=percentCpc,proto3,oneof"`
}

type Campaign_TargetCpm struct {
	// A bidding strategy that automatically optimizes cost per thousand
	// impressions.
	TargetCpm *common.TargetCpm `protobuf:"bytes,41,opt,name=target_cpm,json=targetCpm,proto3,oneof"`
}

func (*Campaign_BiddingStrategy) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_Commission) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpm) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_ManualCpv) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversions) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_MaximizeConversionValue) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpa) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetImpressionShare) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetRoas) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetSpend) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_PercentCpc) isCampaign_CampaignBiddingStrategy() {}

func (*Campaign_TargetCpm) isCampaign_CampaignBiddingStrategy() {}

// The network settings for the campaign.
type Campaign_NetworkSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether ads will be served with google.com search results.
	TargetGoogleSearch *bool `protobuf:"varint,5,opt,name=target_google_search,json=targetGoogleSearch,proto3,oneof" json:"target_google_search,omitempty"`
	// Whether ads will be served on partner sites in the Google Search Network
	// (requires `target_google_search` to also be `true`).
	TargetSearchNetwork *bool `protobuf:"varint,6,opt,name=target_search_network,json=targetSearchNetwork,proto3,oneof" json:"target_search_network,omitempty"`
	// Whether ads will be served on specified placements in the Google Display
	// Network. Placements are specified using the Placement criterion.
	TargetContentNetwork *bool `protobuf:"varint,7,opt,name=target_content_network,json=targetContentNetwork,proto3,oneof" json:"target_content_network,omitempty"`
	// Whether ads will be served on the Google Partner Network.
	// This is available only to some select Google partner accounts.
	TargetPartnerSearchNetwork *bool `protobuf:"varint,8,opt,name=target_partner_search_network,json=targetPartnerSearchNetwork,proto3,oneof" json:"target_partner_search_network,omitempty"`
}

func (x *Campaign_NetworkSettings) Reset() {
	*x = Campaign_NetworkSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_NetworkSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_NetworkSettings) ProtoMessage() {}

func (x *Campaign_NetworkSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_NetworkSettings.ProtoReflect.Descriptor instead.
func (*Campaign_NetworkSettings) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Campaign_NetworkSettings) GetTargetGoogleSearch() bool {
	if x != nil && x.TargetGoogleSearch != nil {
		return *x.TargetGoogleSearch
	}
	return false
}

func (x *Campaign_NetworkSettings) GetTargetSearchNetwork() bool {
	if x != nil && x.TargetSearchNetwork != nil {
		return *x.TargetSearchNetwork
	}
	return false
}

func (x *Campaign_NetworkSettings) GetTargetContentNetwork() bool {
	if x != nil && x.TargetContentNetwork != nil {
		return *x.TargetContentNetwork
	}
	return false
}

func (x *Campaign_NetworkSettings) GetTargetPartnerSearchNetwork() bool {
	if x != nil && x.TargetPartnerSearchNetwork != nil {
		return *x.TargetPartnerSearchNetwork
	}
	return false
}

// Campaign-level settings for hotel ads.
type Campaign_HotelSettingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The linked Hotel Center account.
	HotelCenterId *int64 `protobuf:"varint,2,opt,name=hotel_center_id,json=hotelCenterId,proto3,oneof" json:"hotel_center_id,omitempty"`
}

func (x *Campaign_HotelSettingInfo) Reset() {
	*x = Campaign_HotelSettingInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_HotelSettingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_HotelSettingInfo) ProtoMessage() {}

func (x *Campaign_HotelSettingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_HotelSettingInfo.ProtoReflect.Descriptor instead.
func (*Campaign_HotelSettingInfo) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Campaign_HotelSettingInfo) GetHotelCenterId() int64 {
	if x != nil && x.HotelCenterId != nil {
		return *x.HotelCenterId
	}
	return 0
}

// Campaign setting for local campaigns.
type Campaign_LocalCampaignSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location source type for this local campaign.
	LocationSourceType enums.LocationSourceTypeEnum_LocationSourceType `protobuf:"varint,1,opt,name=location_source_type,json=locationSourceType,proto3,enum=google.ads.googleads.v6.enums.LocationSourceTypeEnum_LocationSourceType" json:"location_source_type,omitempty"`
}

func (x *Campaign_LocalCampaignSetting) Reset() {
	*x = Campaign_LocalCampaignSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_LocalCampaignSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_LocalCampaignSetting) ProtoMessage() {}

func (x *Campaign_LocalCampaignSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_LocalCampaignSetting.ProtoReflect.Descriptor instead.
func (*Campaign_LocalCampaignSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Campaign_LocalCampaignSetting) GetLocationSourceType() enums.LocationSourceTypeEnum_LocationSourceType {
	if x != nil {
		return x.LocationSourceType
	}
	return enums.LocationSourceTypeEnum_UNSPECIFIED
}

// The setting for controlling Dynamic Search Ads (DSA).
type Campaign_DynamicSearchAdsSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Internet domain name that this setting represents, e.g., "google.com"
	// or "www.google.com".
	DomainName string `protobuf:"bytes,6,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Required. The language code specifying the language of the domain, e.g., "en".
	LanguageCode string `protobuf:"bytes,7,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Whether the campaign uses advertiser supplied URLs exclusively.
	UseSuppliedUrlsOnly *bool `protobuf:"varint,8,opt,name=use_supplied_urls_only,json=useSuppliedUrlsOnly,proto3,oneof" json:"use_supplied_urls_only,omitempty"`
	// The list of page feeds associated with the campaign.
	Feeds []string `protobuf:"bytes,9,rep,name=feeds,proto3" json:"feeds,omitempty"`
}

func (x *Campaign_DynamicSearchAdsSetting) Reset() {
	*x = Campaign_DynamicSearchAdsSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_DynamicSearchAdsSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_DynamicSearchAdsSetting) ProtoMessage() {}

func (x *Campaign_DynamicSearchAdsSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_DynamicSearchAdsSetting.ProtoReflect.Descriptor instead.
func (*Campaign_DynamicSearchAdsSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Campaign_DynamicSearchAdsSetting) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *Campaign_DynamicSearchAdsSetting) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Campaign_DynamicSearchAdsSetting) GetUseSuppliedUrlsOnly() bool {
	if x != nil && x.UseSuppliedUrlsOnly != nil {
		return *x.UseSuppliedUrlsOnly
	}
	return false
}

func (x *Campaign_DynamicSearchAdsSetting) GetFeeds() []string {
	if x != nil {
		return x.Feeds
	}
	return nil
}

// Optimization goal setting for this campaign, which includes a set of
// optimization goal types.
type Campaign_OptimizationGoalSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of optimization goal types.
	OptimizationGoalTypes []enums.OptimizationGoalTypeEnum_OptimizationGoalType `protobuf:"varint,1,rep,packed,name=optimization_goal_types,json=optimizationGoalTypes,proto3,enum=google.ads.googleads.v6.enums.OptimizationGoalTypeEnum_OptimizationGoalType" json:"optimization_goal_types,omitempty"`
}

func (x *Campaign_OptimizationGoalSetting) Reset() {
	*x = Campaign_OptimizationGoalSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_OptimizationGoalSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_OptimizationGoalSetting) ProtoMessage() {}

func (x *Campaign_OptimizationGoalSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_OptimizationGoalSetting.ProtoReflect.Descriptor instead.
func (*Campaign_OptimizationGoalSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Campaign_OptimizationGoalSetting) GetOptimizationGoalTypes() []enums.OptimizationGoalTypeEnum_OptimizationGoalType {
	if x != nil {
		return x.OptimizationGoalTypes
	}
	return nil
}

// The setting for Shopping campaigns. Defines the universe of products that
// can be advertised by the campaign, and how this campaign interacts with
// other Shopping campaigns.
type Campaign_ShoppingSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. ID of the Merchant Center account.
	// This field is required for create operations. This field is immutable for
	// Shopping campaigns.
	MerchantId *int64 `protobuf:"varint,5,opt,name=merchant_id,json=merchantId,proto3,oneof" json:"merchant_id,omitempty"`
	// Immutable. Sales country of products to include in the campaign.
	// This field is required for Shopping campaigns. This field is immutable.
	// This field is optional for non-Shopping campaigns, but it must be equal
	// to 'ZZ' if set.
	SalesCountry *string `protobuf:"bytes,6,opt,name=sales_country,json=salesCountry,proto3,oneof" json:"sales_country,omitempty"`
	// Priority of the campaign. Campaigns with numerically higher priorities
	// take precedence over those with lower priorities.
	// This field is required for Shopping campaigns, with values between 0 and
	// 2, inclusive.
	// This field is optional for Smart Shopping campaigns, but must be equal to
	// 3 if set.
	CampaignPriority *int32 `protobuf:"varint,7,opt,name=campaign_priority,json=campaignPriority,proto3,oneof" json:"campaign_priority,omitempty"`
	// Whether to include local products.
	EnableLocal *bool `protobuf:"varint,8,opt,name=enable_local,json=enableLocal,proto3,oneof" json:"enable_local,omitempty"`
}

func (x *Campaign_ShoppingSetting) Reset() {
	*x = Campaign_ShoppingSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_ShoppingSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_ShoppingSetting) ProtoMessage() {}

func (x *Campaign_ShoppingSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_ShoppingSetting.ProtoReflect.Descriptor instead.
func (*Campaign_ShoppingSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Campaign_ShoppingSetting) GetMerchantId() int64 {
	if x != nil && x.MerchantId != nil {
		return *x.MerchantId
	}
	return 0
}

func (x *Campaign_ShoppingSetting) GetSalesCountry() string {
	if x != nil && x.SalesCountry != nil {
		return *x.SalesCountry
	}
	return ""
}

func (x *Campaign_ShoppingSetting) GetCampaignPriority() int32 {
	if x != nil && x.CampaignPriority != nil {
		return *x.CampaignPriority
	}
	return 0
}

func (x *Campaign_ShoppingSetting) GetEnableLocal() bool {
	if x != nil && x.EnableLocal != nil {
		return *x.EnableLocal
	}
	return false
}

// Campaign-level settings for tracking information.
type Campaign_TrackingSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The url used for dynamic tracking.
	TrackingUrl *string `protobuf:"bytes,2,opt,name=tracking_url,json=trackingUrl,proto3,oneof" json:"tracking_url,omitempty"`
}

func (x *Campaign_TrackingSetting) Reset() {
	*x = Campaign_TrackingSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_TrackingSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_TrackingSetting) ProtoMessage() {}

func (x *Campaign_TrackingSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_TrackingSetting.ProtoReflect.Descriptor instead.
func (*Campaign_TrackingSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Campaign_TrackingSetting) GetTrackingUrl() string {
	if x != nil && x.TrackingUrl != nil {
		return *x.TrackingUrl
	}
	return ""
}

// Selective optimization setting for this campaign, which includes a set of
// conversion actions to optimize this campaign towards.
type Campaign_SelectiveOptimization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The selected set of conversion actions for optimizing this campaign.
	ConversionActions []string `protobuf:"bytes,2,rep,name=conversion_actions,json=conversionActions,proto3" json:"conversion_actions,omitempty"`
}

func (x *Campaign_SelectiveOptimization) Reset() {
	*x = Campaign_SelectiveOptimization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_SelectiveOptimization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_SelectiveOptimization) ProtoMessage() {}

func (x *Campaign_SelectiveOptimization) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_SelectiveOptimization.ProtoReflect.Descriptor instead.
func (*Campaign_SelectiveOptimization) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Campaign_SelectiveOptimization) GetConversionActions() []string {
	if x != nil {
		return x.ConversionActions
	}
	return nil
}

// Represents a collection of settings related to ads geotargeting.
type Campaign_GeoTargetTypeSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The setting used for positive geotargeting in this particular campaign.
	PositiveGeoTargetType enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType `protobuf:"varint,1,opt,name=positive_geo_target_type,json=positiveGeoTargetType,proto3,enum=google.ads.googleads.v6.enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType" json:"positive_geo_target_type,omitempty"`
	// The setting used for negative geotargeting in this particular campaign.
	NegativeGeoTargetType enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType `protobuf:"varint,2,opt,name=negative_geo_target_type,json=negativeGeoTargetType,proto3,enum=google.ads.googleads.v6.enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType" json:"negative_geo_target_type,omitempty"`
}

func (x *Campaign_GeoTargetTypeSetting) Reset() {
	*x = Campaign_GeoTargetTypeSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_GeoTargetTypeSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_GeoTargetTypeSetting) ProtoMessage() {}

func (x *Campaign_GeoTargetTypeSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_GeoTargetTypeSetting.ProtoReflect.Descriptor instead.
func (*Campaign_GeoTargetTypeSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Campaign_GeoTargetTypeSetting) GetPositiveGeoTargetType() enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType {
	if x != nil {
		return x.PositiveGeoTargetType
	}
	return enums.PositiveGeoTargetTypeEnum_UNSPECIFIED
}

func (x *Campaign_GeoTargetTypeSetting) GetNegativeGeoTargetType() enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType {
	if x != nil {
		return x.NegativeGeoTargetType
	}
	return enums.NegativeGeoTargetTypeEnum_UNSPECIFIED
}

// Campaign-level settings for App Campaigns.
type Campaign_AppCampaignSetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the goal which the bidding strategy of this app campaign
	// should optimize towards.
	BiddingStrategyGoalType enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType `protobuf:"varint,1,opt,name=bidding_strategy_goal_type,json=biddingStrategyGoalType,proto3,enum=google.ads.googleads.v6.enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType" json:"bidding_strategy_goal_type,omitempty"`
	// Immutable. A string that uniquely identifies a mobile application.
	AppId *string `protobuf:"bytes,4,opt,name=app_id,json=appId,proto3,oneof" json:"app_id,omitempty"`
	// Immutable. The application store that distributes this specific app.
	AppStore enums.AppCampaignAppStoreEnum_AppCampaignAppStore `protobuf:"varint,3,opt,name=app_store,json=appStore,proto3,enum=google.ads.googleads.v6.enums.AppCampaignAppStoreEnum_AppCampaignAppStore" json:"app_store,omitempty"`
}

func (x *Campaign_AppCampaignSetting) Reset() {
	*x = Campaign_AppCampaignSetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_AppCampaignSetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_AppCampaignSetting) ProtoMessage() {}

func (x *Campaign_AppCampaignSetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_AppCampaignSetting.ProtoReflect.Descriptor instead.
func (*Campaign_AppCampaignSetting) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Campaign_AppCampaignSetting) GetBiddingStrategyGoalType() enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType {
	if x != nil {
		return x.BiddingStrategyGoalType
	}
	return enums.AppCampaignBiddingStrategyGoalTypeEnum_UNSPECIFIED
}

func (x *Campaign_AppCampaignSetting) GetAppId() string {
	if x != nil && x.AppId != nil {
		return *x.AppId
	}
	return ""
}

func (x *Campaign_AppCampaignSetting) GetAppStore() enums.AppCampaignAppStoreEnum_AppCampaignAppStore {
	if x != nil {
		return x.AppStore
	}
	return enums.AppCampaignAppStoreEnum_UNSPECIFIED
}

// Describes how unbranded pharma ads will be displayed.
type Campaign_VanityPharma struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display mode for vanity pharma URLs.
	VanityPharmaDisplayUrlMode enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode `protobuf:"varint,1,opt,name=vanity_pharma_display_url_mode,json=vanityPharmaDisplayUrlMode,proto3,enum=google.ads.googleads.v6.enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode" json:"vanity_pharma_display_url_mode,omitempty"`
	// The text that will be displayed in display URL of the text ad when
	// website description is the selected display mode for vanity pharma URLs.
	VanityPharmaText enums.VanityPharmaTextEnum_VanityPharmaText `protobuf:"varint,2,opt,name=vanity_pharma_text,json=vanityPharmaText,proto3,enum=google.ads.googleads.v6.enums.VanityPharmaTextEnum_VanityPharmaText" json:"vanity_pharma_text,omitempty"`
}

func (x *Campaign_VanityPharma) Reset() {
	*x = Campaign_VanityPharma{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Campaign_VanityPharma) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Campaign_VanityPharma) ProtoMessage() {}

func (x *Campaign_VanityPharma) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Campaign_VanityPharma.ProtoReflect.Descriptor instead.
func (*Campaign_VanityPharma) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP(), []int{0, 10}
}

func (x *Campaign_VanityPharma) GetVanityPharmaDisplayUrlMode() enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode {
	if x != nil {
		return x.VanityPharmaDisplayUrlMode
	}
	return enums.VanityPharmaDisplayUrlModeEnum_UNSPECIFIED
}

func (x *Campaign_VanityPharma) GetVanityPharmaText() enums.VanityPharmaTextEnum_VanityPharmaText {
	if x != nil {
		return x.VanityPharmaText
	}
	return enums.VanityPharmaTextEnum_UNSPECIFIED
}

var File_google_ads_googleads_v6_resources_campaign_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v6_resources_campaign_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x61, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x72,
	0x65, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x75,
	0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64, 0x76, 0x65,
	0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x62, 0x72,
	0x61, 0x6e, 0x64, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36,
	0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x67,
	0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2f, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d,
	0x61, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8f, 0x39, 0x0a, 0x08, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x12, 0x4e, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x05, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x02, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x3a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x7a, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x9f, 0x01, 0x0a,
	0x1e, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x1b, 0x61, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x8f,
	0x01, 0x0a, 0x18, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x76,
	0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x69, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x9c, 0x01, 0x0a, 0x1c, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73,
	0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x19, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x53, 0x75, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x37, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03,
	0x52, 0x13, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x15, 0x75, 0x72, 0x6c, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x13, 0x75, 0x72, 0x6c, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x71, 0x0a,
	0x19, 0x72, 0x65, 0x61, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x52, 0x65, 0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x16, 0x72, 0x65, 0x61, 0x6c, 0x54, 0x69,
	0x6d, 0x65, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x66, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x66, 0x0a, 0x0d, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x48, 0x6f, 0x74,
	0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0,
	0x41, 0x05, 0x52, 0x0c, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x80, 0x01, 0x0a, 0x1a, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18,
	0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x64, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x17, 0x64, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x66, 0x0a, 0x10, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x0f, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x5d, 0x0a, 0x11, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69, 0x6e,
	0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x77, 0x0a, 0x17, 0x67, 0x65,
	0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x14, 0x67,
	0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x12, 0x76, 0x0a, 0x16, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x32, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x70, 0x0a, 0x14, 0x61,
	0x70, 0x70, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x61, 0x70, 0x70, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x46, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x3d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x7e, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x0d, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x38, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x48, 0x04, 0x52, 0x0c, 0x62, 0x61, 0x73, 0x65, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x5a, 0x0a, 0x0f, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x3e, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x48, 0x05, 0x52, 0x0e, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x88, 0x01, 0x01, 0x12, 0x83, 0x01, 0x0a, 0x15, 0x62, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x42,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x06, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x1e, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x40, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x07, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x2d, 0x0a, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x18, 0x41, 0x20, 0x01, 0x28, 0x09, 0x48, 0x08, 0x52, 0x0e, 0x66, 0x69,
	0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x88, 0x01, 0x01, 0x12,
	0x58, 0x0a, 0x0e, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x61, 0x70,
	0x73, 0x18, 0x28, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x43, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x61, 0x70, 0x73, 0x12, 0x9a, 0x01, 0x0a, 0x1e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x5f, 0x73, 0x75, 0x69, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x2a, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x75,
	0x69, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x42, 0x72,
	0x61, 0x6e, 0x64, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x75, 0x69, 0x74, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1b, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x42, 0x72, 0x61, 0x6e, 0x64, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x75, 0x69, 0x74, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x5d, 0x0a, 0x0d, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79,
	0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74,
	0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x52, 0x0c, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50,
	0x68, 0x61, 0x72, 0x6d, 0x61, 0x12, 0x78, 0x0a, 0x16, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x7f, 0x0a, 0x19, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x36, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e,
	0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f, 0x61, 0x6c,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x17, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x6b, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x5d, 0x0a,
	0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x34, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x45,
	0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x52,
	0x0b, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x12,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x42, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x09, 0x52,
	0x11, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5a, 0x0a, 0x10, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x43, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00,
	0x52, 0x0f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x12, 0x4c, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x31, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x4a, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x70, 0x63, 0x18, 0x18, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x63, 0x48, 0x00,
	0x52, 0x09, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x63, 0x12, 0x4a, 0x0a, 0x0a, 0x6d,
	0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x63, 0x70, 0x6d, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x6d, 0x12, 0x4f, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x75, 0x61,
	0x6c, 0x5f, 0x63, 0x70, 0x76, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x6e,
	0x75, 0x61, 0x6c, 0x43, 0x70, 0x76, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x09, 0x6d,
	0x61, 0x6e, 0x75, 0x61, 0x6c, 0x43, 0x70, 0x76, 0x12, 0x68, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x13, 0x6d,
	0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x75, 0x0a, 0x19, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00,
	0x52, 0x17, 0x6d, 0x61, 0x78, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x63, 0x70, 0x61, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x70, 0x61, 0x48, 0x00, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x43, 0x70, 0x61, 0x12, 0x6f, 0x0a, 0x17, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x69, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x48, 0x00, 0x52,
	0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x72, 0x6f, 0x61, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x6f, 0x61, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x6f, 0x61, 0x73, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x73, 0x70, 0x65, 0x6e, 0x64, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x53, 0x70, 0x65, 0x6e, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x70, 0x63, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x43, 0x70, 0x63, 0x12, 0x4a, 0x0a, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x63, 0x70, 0x6d, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x43, 0x70, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x70, 0x6d, 0x1a, 0xf4, 0x02, 0x0a, 0x0f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a,
	0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x13,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x16, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x88, 0x01,
	0x01, 0x12, 0x46, 0x0a, 0x1d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x1a, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x88, 0x01, 0x01, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x19, 0x0a, 0x17,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x58, 0x0a, 0x10, 0x48, 0x6f, 0x74,
	0x65, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a,
	0x0f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0d, 0x68,
	0x6f, 0x74, 0x65, 0x6c, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x64, 0x88, 0x01, 0x01, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x1a, 0x92, 0x01, 0x0a, 0x14, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x7a, 0x0a, 0x14,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xf8, 0x01, 0x0a, 0x17, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x38, 0x0a, 0x16, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70,
	0x6c, 0x69, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x13, 0x75, 0x73, 0x65, 0x53, 0x75, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x88, 0x01, 0x01, 0x12, 0x38,
	0x0a, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x22, 0xfa,
	0x41, 0x1f, 0x0a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65,
	0x64, 0x52, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x75, 0x73, 0x65,
	0x5f, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x1a, 0xa0, 0x01, 0x0a, 0x17, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x84, 0x01, 0x0a, 0x17, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f,
	0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x15, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x6f, 0x61,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x8e, 0x02, 0x0a, 0x0f, 0x53, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x0b, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x48, 0x01, 0x52, 0x0c, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x88, 0x01, 0x01, 0x12, 0x30, 0x0a, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x02, 0x52, 0x10, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0b,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x88, 0x01, 0x01, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x14, 0x0a, 0x12, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x70, 0x72,
	0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x1a, 0x4f, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x0c, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x55, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x1a, 0x76, 0x0a, 0x15, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5d, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x1a, 0xaa, 0x02, 0x0a, 0x14, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x87, 0x01, 0x0a, 0x18, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x47,
	0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x18, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x47,
	0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x15, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x47, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xd6, 0x02,
	0x0a, 0x12, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x12, 0xa5, 0x01, 0x0a, 0x1a, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x67, 0x6f, 0x61, 0x6c, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x47, 0x6f, 0x61, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x17, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x06,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x48, 0x00, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x6c, 0x0a,
	0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x70, 0x70, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x41, 0x70, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x08, 0x61, 0x70, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x1a, 0xa1, 0x02, 0x0a, 0x0c, 0x56, 0x61, 0x6e, 0x69, 0x74,
	0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x12, 0x9c, 0x01, 0x0a, 0x1e, 0x76, 0x61, 0x6e, 0x69,
	0x74, 0x79, 0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73,
	0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x55, 0x72, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x55, 0x72, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x1a, 0x76, 0x61, 0x6e, 0x69,
	0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x55,
	0x72, 0x6c, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x72, 0x0a, 0x12, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79,
	0x5f, 0x70, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x54,
	0x65, 0x78, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x56, 0x61, 0x6e, 0x69, 0x74, 0x79, 0x50, 0x68,
	0x61, 0x72, 0x6d, 0x61, 0x54, 0x65, 0x78, 0x74, 0x52, 0x10, 0x76, 0x61, 0x6e, 0x69, 0x74, 0x79,
	0x50, 0x68, 0x61, 0x72, 0x6d, 0x61, 0x54, 0x65, 0x78, 0x74, 0x3a, 0x57, 0xea, 0x41, 0x54, 0x0a,
	0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x12, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x69, 0x64, 0x7d, 0x42, 0x1b, 0x0a, 0x19, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x42, 0x05, 0x0a, 0x03, 0x5f, 0x69, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72,
	0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x13, 0x0a, 0x11,
	0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0xfa, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x42, 0x0d, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x3b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xa2,
	0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41,
	0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x36, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x5c, 0x56, 0x36, 0x5c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0xea, 0x02, 0x25,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x36, 0x3a, 0x3a, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v6_resources_campaign_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v6_resources_campaign_proto_rawDescData = file_google_ads_googleads_v6_resources_campaign_proto_rawDesc
)

func file_google_ads_googleads_v6_resources_campaign_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v6_resources_campaign_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v6_resources_campaign_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v6_resources_campaign_proto_rawDescData)
	})
	return file_google_ads_googleads_v6_resources_campaign_proto_rawDescData
}

var file_google_ads_googleads_v6_resources_campaign_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_ads_googleads_v6_resources_campaign_proto_goTypes = []interface{}{
	(*Campaign)(nil),                                                                     // 0: google.ads.googleads.v6.resources.Campaign
	(*Campaign_NetworkSettings)(nil),                                                     // 1: google.ads.googleads.v6.resources.Campaign.NetworkSettings
	(*Campaign_HotelSettingInfo)(nil),                                                    // 2: google.ads.googleads.v6.resources.Campaign.HotelSettingInfo
	(*Campaign_LocalCampaignSetting)(nil),                                                // 3: google.ads.googleads.v6.resources.Campaign.LocalCampaignSetting
	(*Campaign_DynamicSearchAdsSetting)(nil),                                             // 4: google.ads.googleads.v6.resources.Campaign.DynamicSearchAdsSetting
	(*Campaign_OptimizationGoalSetting)(nil),                                             // 5: google.ads.googleads.v6.resources.Campaign.OptimizationGoalSetting
	(*Campaign_ShoppingSetting)(nil),                                                     // 6: google.ads.googleads.v6.resources.Campaign.ShoppingSetting
	(*Campaign_TrackingSetting)(nil),                                                     // 7: google.ads.googleads.v6.resources.Campaign.TrackingSetting
	(*Campaign_SelectiveOptimization)(nil),                                               // 8: google.ads.googleads.v6.resources.Campaign.SelectiveOptimization
	(*Campaign_GeoTargetTypeSetting)(nil),                                                // 9: google.ads.googleads.v6.resources.Campaign.GeoTargetTypeSetting
	(*Campaign_AppCampaignSetting)(nil),                                                  // 10: google.ads.googleads.v6.resources.Campaign.AppCampaignSetting
	(*Campaign_VanityPharma)(nil),                                                        // 11: google.ads.googleads.v6.resources.Campaign.VanityPharma
	(enums.CampaignStatusEnum_CampaignStatus)(0),                                         // 12: google.ads.googleads.v6.enums.CampaignStatusEnum.CampaignStatus
	(enums.CampaignServingStatusEnum_CampaignServingStatus)(0),                           // 13: google.ads.googleads.v6.enums.CampaignServingStatusEnum.CampaignServingStatus
	(enums.AdServingOptimizationStatusEnum_AdServingOptimizationStatus)(0),               // 14: google.ads.googleads.v6.enums.AdServingOptimizationStatusEnum.AdServingOptimizationStatus
	(enums.AdvertisingChannelTypeEnum_AdvertisingChannelType)(0),                         // 15: google.ads.googleads.v6.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType
	(enums.AdvertisingChannelSubTypeEnum_AdvertisingChannelSubType)(0),                   // 16: google.ads.googleads.v6.enums.AdvertisingChannelSubTypeEnum.AdvertisingChannelSubType
	(*common.CustomParameter)(nil),                                                       // 17: google.ads.googleads.v6.common.CustomParameter
	(*common.RealTimeBiddingSetting)(nil),                                                // 18: google.ads.googleads.v6.common.RealTimeBiddingSetting
	(*common.TargetingSetting)(nil),                                                      // 19: google.ads.googleads.v6.common.TargetingSetting
	(enums.CampaignExperimentTypeEnum_CampaignExperimentType)(0),                         // 20: google.ads.googleads.v6.enums.CampaignExperimentTypeEnum.CampaignExperimentType
	(enums.BiddingStrategyTypeEnum_BiddingStrategyType)(0),                               // 21: google.ads.googleads.v6.enums.BiddingStrategyTypeEnum.BiddingStrategyType
	(*common.FrequencyCapEntry)(nil),                                                     // 22: google.ads.googleads.v6.common.FrequencyCapEntry
	(enums.BrandSafetySuitabilityEnum_BrandSafetySuitability)(0),                         // 23: google.ads.googleads.v6.enums.BrandSafetySuitabilityEnum.BrandSafetySuitability
	(enums.PaymentModeEnum_PaymentMode)(0),                                               // 24: google.ads.googleads.v6.enums.PaymentModeEnum.PaymentMode
	(*common.Commission)(nil),                                                            // 25: google.ads.googleads.v6.common.Commission
	(*common.ManualCpc)(nil),                                                             // 26: google.ads.googleads.v6.common.ManualCpc
	(*common.ManualCpm)(nil),                                                             // 27: google.ads.googleads.v6.common.ManualCpm
	(*common.ManualCpv)(nil),                                                             // 28: google.ads.googleads.v6.common.ManualCpv
	(*common.MaximizeConversions)(nil),                                                   // 29: google.ads.googleads.v6.common.MaximizeConversions
	(*common.MaximizeConversionValue)(nil),                                               // 30: google.ads.googleads.v6.common.MaximizeConversionValue
	(*common.TargetCpa)(nil),                                                             // 31: google.ads.googleads.v6.common.TargetCpa
	(*common.TargetImpressionShare)(nil),                                                 // 32: google.ads.googleads.v6.common.TargetImpressionShare
	(*common.TargetRoas)(nil),                                                            // 33: google.ads.googleads.v6.common.TargetRoas
	(*common.TargetSpend)(nil),                                                           // 34: google.ads.googleads.v6.common.TargetSpend
	(*common.PercentCpc)(nil),                                                            // 35: google.ads.googleads.v6.common.PercentCpc
	(*common.TargetCpm)(nil),                                                             // 36: google.ads.googleads.v6.common.TargetCpm
	(enums.LocationSourceTypeEnum_LocationSourceType)(0),                                 // 37: google.ads.googleads.v6.enums.LocationSourceTypeEnum.LocationSourceType
	(enums.OptimizationGoalTypeEnum_OptimizationGoalType)(0),                             // 38: google.ads.googleads.v6.enums.OptimizationGoalTypeEnum.OptimizationGoalType
	(enums.PositiveGeoTargetTypeEnum_PositiveGeoTargetType)(0),                           // 39: google.ads.googleads.v6.enums.PositiveGeoTargetTypeEnum.PositiveGeoTargetType
	(enums.NegativeGeoTargetTypeEnum_NegativeGeoTargetType)(0),                           // 40: google.ads.googleads.v6.enums.NegativeGeoTargetTypeEnum.NegativeGeoTargetType
	(enums.AppCampaignBiddingStrategyGoalTypeEnum_AppCampaignBiddingStrategyGoalType)(0), // 41: google.ads.googleads.v6.enums.AppCampaignBiddingStrategyGoalTypeEnum.AppCampaignBiddingStrategyGoalType
	(enums.AppCampaignAppStoreEnum_AppCampaignAppStore)(0),                               // 42: google.ads.googleads.v6.enums.AppCampaignAppStoreEnum.AppCampaignAppStore
	(enums.VanityPharmaDisplayUrlModeEnum_VanityPharmaDisplayUrlMode)(0),                 // 43: google.ads.googleads.v6.enums.VanityPharmaDisplayUrlModeEnum.VanityPharmaDisplayUrlMode
	(enums.VanityPharmaTextEnum_VanityPharmaText)(0),                                     // 44: google.ads.googleads.v6.enums.VanityPharmaTextEnum.VanityPharmaText
}
var file_google_ads_googleads_v6_resources_campaign_proto_depIdxs = []int32{
	12, // 0: google.ads.googleads.v6.resources.Campaign.status:type_name -> google.ads.googleads.v6.enums.CampaignStatusEnum.CampaignStatus
	13, // 1: google.ads.googleads.v6.resources.Campaign.serving_status:type_name -> google.ads.googleads.v6.enums.CampaignServingStatusEnum.CampaignServingStatus
	14, // 2: google.ads.googleads.v6.resources.Campaign.ad_serving_optimization_status:type_name -> google.ads.googleads.v6.enums.AdServingOptimizationStatusEnum.AdServingOptimizationStatus
	15, // 3: google.ads.googleads.v6.resources.Campaign.advertising_channel_type:type_name -> google.ads.googleads.v6.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType
	16, // 4: google.ads.googleads.v6.resources.Campaign.advertising_channel_sub_type:type_name -> google.ads.googleads.v6.enums.AdvertisingChannelSubTypeEnum.AdvertisingChannelSubType
	17, // 5: google.ads.googleads.v6.resources.Campaign.url_custom_parameters:type_name -> google.ads.googleads.v6.common.CustomParameter
	18, // 6: google.ads.googleads.v6.resources.Campaign.real_time_bidding_setting:type_name -> google.ads.googleads.v6.common.RealTimeBiddingSetting
	1,  // 7: google.ads.googleads.v6.resources.Campaign.network_settings:type_name -> google.ads.googleads.v6.resources.Campaign.NetworkSettings
	2,  // 8: google.ads.googleads.v6.resources.Campaign.hotel_setting:type_name -> google.ads.googleads.v6.resources.Campaign.HotelSettingInfo
	4,  // 9: google.ads.googleads.v6.resources.Campaign.dynamic_search_ads_setting:type_name -> google.ads.googleads.v6.resources.Campaign.DynamicSearchAdsSetting
	6,  // 10: google.ads.googleads.v6.resources.Campaign.shopping_setting:type_name -> google.ads.googleads.v6.resources.Campaign.ShoppingSetting
	19, // 11: google.ads.googleads.v6.resources.Campaign.targeting_setting:type_name -> google.ads.googleads.v6.common.TargetingSetting
	9,  // 12: google.ads.googleads.v6.resources.Campaign.geo_target_type_setting:type_name -> google.ads.googleads.v6.resources.Campaign.GeoTargetTypeSetting
	3,  // 13: google.ads.googleads.v6.resources.Campaign.local_campaign_setting:type_name -> google.ads.googleads.v6.resources.Campaign.LocalCampaignSetting
	10, // 14: google.ads.googleads.v6.resources.Campaign.app_campaign_setting:type_name -> google.ads.googleads.v6.resources.Campaign.AppCampaignSetting
	20, // 15: google.ads.googleads.v6.resources.Campaign.experiment_type:type_name -> google.ads.googleads.v6.enums.CampaignExperimentTypeEnum.CampaignExperimentType
	21, // 16: google.ads.googleads.v6.resources.Campaign.bidding_strategy_type:type_name -> google.ads.googleads.v6.enums.BiddingStrategyTypeEnum.BiddingStrategyType
	22, // 17: google.ads.googleads.v6.resources.Campaign.frequency_caps:type_name -> google.ads.googleads.v6.common.FrequencyCapEntry
	23, // 18: google.ads.googleads.v6.resources.Campaign.video_brand_safety_suitability:type_name -> google.ads.googleads.v6.enums.BrandSafetySuitabilityEnum.BrandSafetySuitability
	11, // 19: google.ads.googleads.v6.resources.Campaign.vanity_pharma:type_name -> google.ads.googleads.v6.resources.Campaign.VanityPharma
	8,  // 20: google.ads.googleads.v6.resources.Campaign.selective_optimization:type_name -> google.ads.googleads.v6.resources.Campaign.SelectiveOptimization
	5,  // 21: google.ads.googleads.v6.resources.Campaign.optimization_goal_setting:type_name -> google.ads.googleads.v6.resources.Campaign.OptimizationGoalSetting
	7,  // 22: google.ads.googleads.v6.resources.Campaign.tracking_setting:type_name -> google.ads.googleads.v6.resources.Campaign.TrackingSetting
	24, // 23: google.ads.googleads.v6.resources.Campaign.payment_mode:type_name -> google.ads.googleads.v6.enums.PaymentModeEnum.PaymentMode
	25, // 24: google.ads.googleads.v6.resources.Campaign.commission:type_name -> google.ads.googleads.v6.common.Commission
	26, // 25: google.ads.googleads.v6.resources.Campaign.manual_cpc:type_name -> google.ads.googleads.v6.common.ManualCpc
	27, // 26: google.ads.googleads.v6.resources.Campaign.manual_cpm:type_name -> google.ads.googleads.v6.common.ManualCpm
	28, // 27: google.ads.googleads.v6.resources.Campaign.manual_cpv:type_name -> google.ads.googleads.v6.common.ManualCpv
	29, // 28: google.ads.googleads.v6.resources.Campaign.maximize_conversions:type_name -> google.ads.googleads.v6.common.MaximizeConversions
	30, // 29: google.ads.googleads.v6.resources.Campaign.maximize_conversion_value:type_name -> google.ads.googleads.v6.common.MaximizeConversionValue
	31, // 30: google.ads.googleads.v6.resources.Campaign.target_cpa:type_name -> google.ads.googleads.v6.common.TargetCpa
	32, // 31: google.ads.googleads.v6.resources.Campaign.target_impression_share:type_name -> google.ads.googleads.v6.common.TargetImpressionShare
	33, // 32: google.ads.googleads.v6.resources.Campaign.target_roas:type_name -> google.ads.googleads.v6.common.TargetRoas
	34, // 33: google.ads.googleads.v6.resources.Campaign.target_spend:type_name -> google.ads.googleads.v6.common.TargetSpend
	35, // 34: google.ads.googleads.v6.resources.Campaign.percent_cpc:type_name -> google.ads.googleads.v6.common.PercentCpc
	36, // 35: google.ads.googleads.v6.resources.Campaign.target_cpm:type_name -> google.ads.googleads.v6.common.TargetCpm
	37, // 36: google.ads.googleads.v6.resources.Campaign.LocalCampaignSetting.location_source_type:type_name -> google.ads.googleads.v6.enums.LocationSourceTypeEnum.LocationSourceType
	38, // 37: google.ads.googleads.v6.resources.Campaign.OptimizationGoalSetting.optimization_goal_types:type_name -> google.ads.googleads.v6.enums.OptimizationGoalTypeEnum.OptimizationGoalType
	39, // 38: google.ads.googleads.v6.resources.Campaign.GeoTargetTypeSetting.positive_geo_target_type:type_name -> google.ads.googleads.v6.enums.PositiveGeoTargetTypeEnum.PositiveGeoTargetType
	40, // 39: google.ads.googleads.v6.resources.Campaign.GeoTargetTypeSetting.negative_geo_target_type:type_name -> google.ads.googleads.v6.enums.NegativeGeoTargetTypeEnum.NegativeGeoTargetType
	41, // 40: google.ads.googleads.v6.resources.Campaign.AppCampaignSetting.bidding_strategy_goal_type:type_name -> google.ads.googleads.v6.enums.AppCampaignBiddingStrategyGoalTypeEnum.AppCampaignBiddingStrategyGoalType
	42, // 41: google.ads.googleads.v6.resources.Campaign.AppCampaignSetting.app_store:type_name -> google.ads.googleads.v6.enums.AppCampaignAppStoreEnum.AppCampaignAppStore
	43, // 42: google.ads.googleads.v6.resources.Campaign.VanityPharma.vanity_pharma_display_url_mode:type_name -> google.ads.googleads.v6.enums.VanityPharmaDisplayUrlModeEnum.VanityPharmaDisplayUrlMode
	44, // 43: google.ads.googleads.v6.resources.Campaign.VanityPharma.vanity_pharma_text:type_name -> google.ads.googleads.v6.enums.VanityPharmaTextEnum.VanityPharmaText
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v6_resources_campaign_proto_init() }
func file_google_ads_googleads_v6_resources_campaign_proto_init() {
	if File_google_ads_googleads_v6_resources_campaign_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_NetworkSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_HotelSettingInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_LocalCampaignSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_DynamicSearchAdsSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_OptimizationGoalSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_ShoppingSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_TrackingSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_SelectiveOptimization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_GeoTargetTypeSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_AppCampaignSetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Campaign_VanityPharma); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Campaign_BiddingStrategy)(nil),
		(*Campaign_Commission)(nil),
		(*Campaign_ManualCpc)(nil),
		(*Campaign_ManualCpm)(nil),
		(*Campaign_ManualCpv)(nil),
		(*Campaign_MaximizeConversions)(nil),
		(*Campaign_MaximizeConversionValue)(nil),
		(*Campaign_TargetCpa)(nil),
		(*Campaign_TargetImpressionShare)(nil),
		(*Campaign_TargetRoas)(nil),
		(*Campaign_TargetSpend)(nil),
		(*Campaign_PercentCpc)(nil),
		(*Campaign_TargetCpm)(nil),
	}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_resources_campaign_proto_msgTypes[10].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v6_resources_campaign_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v6_resources_campaign_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v6_resources_campaign_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v6_resources_campaign_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v6_resources_campaign_proto = out.File
	file_google_ads_googleads_v6_resources_campaign_proto_rawDesc = nil
	file_google_ads_googleads_v6_resources_campaign_proto_goTypes = nil
	file_google_ads_googleads_v6_resources_campaign_proto_depIdxs = nil
}
