// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/storagetransfer/v1/transfer_types.proto

package storagetransfer

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	date "google.golang.org/genproto/googleapis/type/date"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The status of the transfer job.
type TransferJob_Status int32

const (
	// Zero is an illegal value.
	TransferJob_STATUS_UNSPECIFIED TransferJob_Status = 0
	// New transfers will be performed based on the schedule.
	TransferJob_ENABLED TransferJob_Status = 1
	// New transfers will not be scheduled.
	TransferJob_DISABLED TransferJob_Status = 2
	// This is a soft delete state. After a transfer job is set to this
	// state, the job and all the transfer executions are subject to
	// garbage collection.
	TransferJob_DELETED TransferJob_Status = 3
)

// Enum value maps for TransferJob_Status.
var (
	TransferJob_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "DELETED",
	}
	TransferJob_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"ENABLED":            1,
		"DISABLED":           2,
		"DELETED":            3,
	}
)

func (x TransferJob_Status) Enum() *TransferJob_Status {
	p := new(TransferJob_Status)
	*p = x
	return p
}

func (x TransferJob_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferJob_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[0].Descriptor()
}

func (TransferJob_Status) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[0]
}

func (x TransferJob_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferJob_Status.Descriptor instead.
func (TransferJob_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{9, 0}
}

// The status of a TransferOperation.
type TransferOperation_Status int32

const (
	// Zero is an illegal value.
	TransferOperation_STATUS_UNSPECIFIED TransferOperation_Status = 0
	// In progress.
	TransferOperation_IN_PROGRESS TransferOperation_Status = 1
	// Paused.
	TransferOperation_PAUSED TransferOperation_Status = 2
	// Completed successfully.
	TransferOperation_SUCCESS TransferOperation_Status = 3
	// Terminated due to an unrecoverable failure.
	TransferOperation_FAILED TransferOperation_Status = 4
	// Aborted by the user.
	TransferOperation_ABORTED TransferOperation_Status = 5
)

// Enum value maps for TransferOperation_Status.
var (
	TransferOperation_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "PAUSED",
		3: "SUCCESS",
		4: "FAILED",
		5: "ABORTED",
	}
	TransferOperation_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"IN_PROGRESS":        1,
		"PAUSED":             2,
		"SUCCESS":            3,
		"FAILED":             4,
		"ABORTED":            5,
	}
)

func (x TransferOperation_Status) Enum() *TransferOperation_Status {
	p := new(TransferOperation_Status)
	*p = x
	return p
}

func (x TransferOperation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferOperation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_storagetransfer_v1_transfer_types_proto_enumTypes[1].Descriptor()
}

func (TransferOperation_Status) Type() protoreflect.EnumType {
	return &file_google_storagetransfer_v1_transfer_types_proto_enumTypes[1]
}

func (x TransferOperation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferOperation_Status.Descriptor instead.
func (TransferOperation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{13, 0}
}

// Google service account
type GoogleServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	AccountEmail string `protobuf:"bytes,1,opt,name=account_email,json=accountEmail,proto3" json:"account_email,omitempty"`
}

func (x *GoogleServiceAccount) Reset() {
	*x = GoogleServiceAccount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleServiceAccount) ProtoMessage() {}

func (x *GoogleServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleServiceAccount.ProtoReflect.Descriptor instead.
func (*GoogleServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{0}
}

func (x *GoogleServiceAccount) GetAccountEmail() string {
	if x != nil {
		return x.AccountEmail
	}
	return ""
}

// AWS access key (see
// [AWS Security
// Credentials](http://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)).
type AwsAccessKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AWS access key ID.
	// Required.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// AWS secret access key. This field is not returned in RPC responses.
	// Required.
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
}

func (x *AwsAccessKey) Reset() {
	*x = AwsAccessKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsAccessKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsAccessKey) ProtoMessage() {}

func (x *AwsAccessKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsAccessKey.ProtoReflect.Descriptor instead.
func (*AwsAccessKey) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{1}
}

func (x *AwsAccessKey) GetAccessKeyId() string {
	if x != nil {
		return x.AccessKeyId
	}
	return ""
}

func (x *AwsAccessKey) GetSecretAccessKey() string {
	if x != nil {
		return x.SecretAccessKey
	}
	return ""
}

// Conditions that determine which objects will be transferred.
type ObjectConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If unspecified, `minTimeElapsedSinceLastModification` takes a zero value
	// and `maxTimeElapsedSinceLastModification` takes the maximum possible
	// value of Duration. Objects that satisfy the object conditions
	// must either have a `lastModificationTime` greater or equal to
	// `NOW` - `maxTimeElapsedSinceLastModification` and less than
	// `NOW` - `minTimeElapsedSinceLastModification`, or not have a
	// `lastModificationTime`.
	MinTimeElapsedSinceLastModification *durationpb.Duration `protobuf:"bytes,1,opt,name=min_time_elapsed_since_last_modification,json=minTimeElapsedSinceLastModification,proto3" json:"min_time_elapsed_since_last_modification,omitempty"`
	// `maxTimeElapsedSinceLastModification` is the complement to
	// `minTimeElapsedSinceLastModification`.
	MaxTimeElapsedSinceLastModification *durationpb.Duration `protobuf:"bytes,2,opt,name=max_time_elapsed_since_last_modification,json=maxTimeElapsedSinceLastModification,proto3" json:"max_time_elapsed_since_last_modification,omitempty"`
	// If `includePrefixes` is specified, objects that satisfy the object
	// conditions must have names that start with one of the `includePrefixes`
	// and that do not start with any of the `excludePrefixes`. If
	// `includePrefixes` is not specified, all objects except those that have
	// names starting with one of the `excludePrefixes` must satisfy the object
	// conditions.
	//
	// Requirements:
	//
	//   * Each include-prefix and exclude-prefix can contain any sequence of
	//     Unicode characters, of max length 1024 bytes when UTF8-encoded, and
	//     must not contain Carriage Return or Line Feed characters.  Wildcard
	//     matching and regular expression matching are not supported.
	//
	//   * Each include-prefix and exclude-prefix must omit the leading slash.
	//     For example, to include the `requests.gz` object in a transfer from
	//     `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include
	//     prefix as `logs/y=2015/requests.gz`.
	//
	//   * None of the include-prefix or the exclude-prefix values can be empty,
	//     if specified.
	//
	//   * Each include-prefix must include a distinct portion of the object
	//     namespace, i.e., no include-prefix may be a prefix of another
	//     include-prefix.
	//
	//   * Each exclude-prefix must exclude a distinct portion of the object
	//     namespace, i.e., no exclude-prefix may be a prefix of another
	//     exclude-prefix.
	//
	//   * If `includePrefixes` is specified, then each exclude-prefix must start
	//     with the value of a path explicitly included by `includePrefixes`.
	//
	// The max size of `includePrefixes` is 1000.
	IncludePrefixes []string `protobuf:"bytes,3,rep,name=include_prefixes,json=includePrefixes,proto3" json:"include_prefixes,omitempty"`
	// `excludePrefixes` must follow the requirements described for
	// `includePrefixes`.
	//
	// The max size of `excludePrefixes` is 1000.
	ExcludePrefixes []string `protobuf:"bytes,4,rep,name=exclude_prefixes,json=excludePrefixes,proto3" json:"exclude_prefixes,omitempty"`
}

func (x *ObjectConditions) Reset() {
	*x = ObjectConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectConditions) ProtoMessage() {}

func (x *ObjectConditions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectConditions.ProtoReflect.Descriptor instead.
func (*ObjectConditions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{2}
}

func (x *ObjectConditions) GetMinTimeElapsedSinceLastModification() *durationpb.Duration {
	if x != nil {
		return x.MinTimeElapsedSinceLastModification
	}
	return nil
}

func (x *ObjectConditions) GetMaxTimeElapsedSinceLastModification() *durationpb.Duration {
	if x != nil {
		return x.MaxTimeElapsedSinceLastModification
	}
	return nil
}

func (x *ObjectConditions) GetIncludePrefixes() []string {
	if x != nil {
		return x.IncludePrefixes
	}
	return nil
}

func (x *ObjectConditions) GetExcludePrefixes() []string {
	if x != nil {
		return x.ExcludePrefixes
	}
	return nil
}

// In a GcsData, an object's name is the Google Cloud Storage object's name and
// its `lastModificationTime` refers to the object's updated time, which changes
// when the content or the metadata of the object is updated.
type GcsData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage bucket name (see
	// [Bucket Name
	// Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	// Required.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
}

func (x *GcsData) Reset() {
	*x = GcsData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsData) ProtoMessage() {}

func (x *GcsData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsData.ProtoReflect.Descriptor instead.
func (*GcsData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{3}
}

func (x *GcsData) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

// An AwsS3Data can be a data source, but not a data sink.
// In an AwsS3Data, an object's name is the S3 object's key name.
type AwsS3Data struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// S3 Bucket name (see
	// [Creating a
	// bucket](http://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
	// Required.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// AWS access key used to sign the API requests to the AWS S3 bucket.
	// Permissions on the bucket must be granted to the access ID of the
	// AWS access key.
	// Required.
	AwsAccessKey *AwsAccessKey `protobuf:"bytes,2,opt,name=aws_access_key,json=awsAccessKey,proto3" json:"aws_access_key,omitempty"`
}

func (x *AwsS3Data) Reset() {
	*x = AwsS3Data{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AwsS3Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsS3Data) ProtoMessage() {}

func (x *AwsS3Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsS3Data.ProtoReflect.Descriptor instead.
func (*AwsS3Data) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{4}
}

func (x *AwsS3Data) GetBucketName() string {
	if x != nil {
		return x.BucketName
	}
	return ""
}

func (x *AwsS3Data) GetAwsAccessKey() *AwsAccessKey {
	if x != nil {
		return x.AwsAccessKey
	}
	return nil
}

// An HttpData specifies a list of objects on the web to be transferred over
// HTTP.  The information of the objects to be transferred is contained in a
// file referenced by a URL. The first line in the file must be
// "TsvHttpData-1.0", which specifies the format of the file.  Subsequent lines
// specify the information of the list of objects, one object per list entry.
// Each entry has the following tab-delimited fields:
//
// * HTTP URL - The location of the object.
//
// * Length - The size of the object in bytes.
//
// * MD5 - The base64-encoded MD5 hash of the object.
//
// For an example of a valid TSV file, see
// [Transferring data from
// URLs](https://cloud.google.com/storage/transfer/create-url-list).
//
// When transferring data based on a URL list, keep the following in mind:
//
// * When an object located at `http(s)://hostname:port/<URL-path>` is
// transferred to a data sink, the name of the object at the data sink is
// `<hostname>/<URL-path>`.
//
// * If the specified size of an object does not match the actual size of the
// object fetched, the object will not be transferred.
//
// * If the specified MD5 does not match the MD5 computed from the transferred
// bytes, the object transfer will fail. For more information, see
// [Generating MD5 hashes](https://cloud.google.com/storage/transfer/#md5)
//
// * Ensure that each URL you specify is publicly accessible. For
// example, in Google Cloud Storage you can
// [share an object publicly]
// (https://cloud.google.com/storage/docs/cloud-console#_sharingdata) and get
// a link to it.
//
// * Storage Transfer Service obeys `robots.txt` rules and requires the source
// HTTP server to support `Range` requests and to return a `Content-Length`
// header in each response.
//
// * [ObjectConditions](#ObjectConditions) have no effect when filtering objects
// to transfer.
type HttpData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL that points to the file that stores the object list entries.
	// This file must allow public access.  Currently, only URLs with HTTP and
	// HTTPS schemes are supported.
	// Required.
	ListUrl string `protobuf:"bytes,1,opt,name=list_url,json=listUrl,proto3" json:"list_url,omitempty"`
}

func (x *HttpData) Reset() {
	*x = HttpData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpData) ProtoMessage() {}

func (x *HttpData) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpData.ProtoReflect.Descriptor instead.
func (*HttpData) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{5}
}

func (x *HttpData) GetListUrl() string {
	if x != nil {
		return x.ListUrl
	}
	return ""
}

// TransferOptions uses three boolean parameters to define the actions
// to be performed on objects in a transfer.
type TransferOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether overwriting objects that already exist in the sink is allowed.
	OverwriteObjectsAlreadyExistingInSink bool `protobuf:"varint,1,opt,name=overwrite_objects_already_existing_in_sink,json=overwriteObjectsAlreadyExistingInSink,proto3" json:"overwrite_objects_already_existing_in_sink,omitempty"`
	// Whether objects that exist only in the sink should be deleted.  Note that
	// this option and `deleteObjectsFromSourceAfterTransfer` are mutually
	// exclusive.
	DeleteObjectsUniqueInSink bool `protobuf:"varint,2,opt,name=delete_objects_unique_in_sink,json=deleteObjectsUniqueInSink,proto3" json:"delete_objects_unique_in_sink,omitempty"`
	// Whether objects should be deleted from the source after they are
	// transferred to the sink.  Note that this option and
	// `deleteObjectsUniqueInSink` are mutually exclusive.
	DeleteObjectsFromSourceAfterTransfer bool `protobuf:"varint,3,opt,name=delete_objects_from_source_after_transfer,json=deleteObjectsFromSourceAfterTransfer,proto3" json:"delete_objects_from_source_after_transfer,omitempty"`
}

func (x *TransferOptions) Reset() {
	*x = TransferOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferOptions) ProtoMessage() {}

func (x *TransferOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferOptions.ProtoReflect.Descriptor instead.
func (*TransferOptions) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{6}
}

func (x *TransferOptions) GetOverwriteObjectsAlreadyExistingInSink() bool {
	if x != nil {
		return x.OverwriteObjectsAlreadyExistingInSink
	}
	return false
}

func (x *TransferOptions) GetDeleteObjectsUniqueInSink() bool {
	if x != nil {
		return x.DeleteObjectsUniqueInSink
	}
	return false
}

func (x *TransferOptions) GetDeleteObjectsFromSourceAfterTransfer() bool {
	if x != nil {
		return x.DeleteObjectsFromSourceAfterTransfer
	}
	return false
}

// Configuration for running a transfer.
type TransferSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The read source of the data.
	//
	// Types that are assignable to DataSource:
	//	*TransferSpec_GcsDataSource
	//	*TransferSpec_AwsS3DataSource
	//	*TransferSpec_HttpDataSource
	DataSource isTransferSpec_DataSource `protobuf_oneof:"data_source"`
	// The write sink for the data.
	//
	// Types that are assignable to DataSink:
	//	*TransferSpec_GcsDataSink
	DataSink isTransferSpec_DataSink `protobuf_oneof:"data_sink"`
	// Only objects that satisfy these object conditions are included in the set
	// of data source and data sink objects.  Object conditions based on
	// objects' `lastModificationTime` do not exclude objects in a data sink.
	ObjectConditions *ObjectConditions `protobuf:"bytes,5,opt,name=object_conditions,json=objectConditions,proto3" json:"object_conditions,omitempty"`
	// If the option `deleteObjectsUniqueInSink` is `true`, object conditions
	// based on objects' `lastModificationTime` are ignored and do not exclude
	// objects in a data source or a data sink.
	TransferOptions *TransferOptions `protobuf:"bytes,6,opt,name=transfer_options,json=transferOptions,proto3" json:"transfer_options,omitempty"`
}

func (x *TransferSpec) Reset() {
	*x = TransferSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferSpec) ProtoMessage() {}

func (x *TransferSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferSpec.ProtoReflect.Descriptor instead.
func (*TransferSpec) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{7}
}

func (m *TransferSpec) GetDataSource() isTransferSpec_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *TransferSpec) GetGcsDataSource() *GcsData {
	if x, ok := x.GetDataSource().(*TransferSpec_GcsDataSource); ok {
		return x.GcsDataSource
	}
	return nil
}

func (x *TransferSpec) GetAwsS3DataSource() *AwsS3Data {
	if x, ok := x.GetDataSource().(*TransferSpec_AwsS3DataSource); ok {
		return x.AwsS3DataSource
	}
	return nil
}

func (x *TransferSpec) GetHttpDataSource() *HttpData {
	if x, ok := x.GetDataSource().(*TransferSpec_HttpDataSource); ok {
		return x.HttpDataSource
	}
	return nil
}

func (m *TransferSpec) GetDataSink() isTransferSpec_DataSink {
	if m != nil {
		return m.DataSink
	}
	return nil
}

func (x *TransferSpec) GetGcsDataSink() *GcsData {
	if x, ok := x.GetDataSink().(*TransferSpec_GcsDataSink); ok {
		return x.GcsDataSink
	}
	return nil
}

func (x *TransferSpec) GetObjectConditions() *ObjectConditions {
	if x != nil {
		return x.ObjectConditions
	}
	return nil
}

func (x *TransferSpec) GetTransferOptions() *TransferOptions {
	if x != nil {
		return x.TransferOptions
	}
	return nil
}

type isTransferSpec_DataSource interface {
	isTransferSpec_DataSource()
}

type TransferSpec_GcsDataSource struct {
	// A Google Cloud Storage data source.
	GcsDataSource *GcsData `protobuf:"bytes,1,opt,name=gcs_data_source,json=gcsDataSource,proto3,oneof"`
}

type TransferSpec_AwsS3DataSource struct {
	// An AWS S3 data source.
	AwsS3DataSource *AwsS3Data `protobuf:"bytes,2,opt,name=aws_s3_data_source,json=awsS3DataSource,proto3,oneof"`
}

type TransferSpec_HttpDataSource struct {
	// An HTTP URL data source.
	HttpDataSource *HttpData `protobuf:"bytes,3,opt,name=http_data_source,json=httpDataSource,proto3,oneof"`
}

func (*TransferSpec_GcsDataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_AwsS3DataSource) isTransferSpec_DataSource() {}

func (*TransferSpec_HttpDataSource) isTransferSpec_DataSource() {}

type isTransferSpec_DataSink interface {
	isTransferSpec_DataSink()
}

type TransferSpec_GcsDataSink struct {
	// A Google Cloud Storage data sink.
	GcsDataSink *GcsData `protobuf:"bytes,4,opt,name=gcs_data_sink,json=gcsDataSink,proto3,oneof"`
}

func (*TransferSpec_GcsDataSink) isTransferSpec_DataSink() {}

// Transfers can be scheduled to recur or to run just once.
type Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The first day the recurring transfer is scheduled to run. If
	// `scheduleStartDate` is in the past, the transfer will run for the first
	// time on the following day.
	// Required.
	ScheduleStartDate *date.Date `protobuf:"bytes,1,opt,name=schedule_start_date,json=scheduleStartDate,proto3" json:"schedule_start_date,omitempty"`
	// The last day the recurring transfer will be run. If `scheduleEndDate`
	// is the same as `scheduleStartDate`, the transfer will be executed only
	// once.
	ScheduleEndDate *date.Date `protobuf:"bytes,2,opt,name=schedule_end_date,json=scheduleEndDate,proto3" json:"schedule_end_date,omitempty"`
	// The time in UTC at which the transfer will be scheduled to start in a day.
	// Transfers may start later than this time. If not specified, recurring and
	// one-time transfers that are scheduled to run today will run immediately;
	// recurring transfers that are scheduled to run on a future date will start
	// at approximately midnight UTC on that date. Note that when configuring a
	// transfer with the Cloud Platform Console, the transfer's start time in a
	// day is specified in your local timezone.
	StartTimeOfDay *timeofday.TimeOfDay `protobuf:"bytes,3,opt,name=start_time_of_day,json=startTimeOfDay,proto3" json:"start_time_of_day,omitempty"`
}

func (x *Schedule) Reset() {
	*x = Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schedule) ProtoMessage() {}

func (x *Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schedule.ProtoReflect.Descriptor instead.
func (*Schedule) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{8}
}

func (x *Schedule) GetScheduleStartDate() *date.Date {
	if x != nil {
		return x.ScheduleStartDate
	}
	return nil
}

func (x *Schedule) GetScheduleEndDate() *date.Date {
	if x != nil {
		return x.ScheduleEndDate
	}
	return nil
}

func (x *Schedule) GetStartTimeOfDay() *timeofday.TimeOfDay {
	if x != nil {
		return x.StartTimeOfDay
	}
	return nil
}

// This resource represents the configuration of a transfer job that runs
// periodically.
type TransferJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A globally unique name assigned by Storage Transfer Service when the
	// job is created. This field should be left empty in requests to create a new
	// transfer job; otherwise, the requests result in an `INVALID_ARGUMENT`
	// error.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A description provided by the user for the job. Its max length is 1024
	// bytes when Unicode-encoded.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The ID of the Google Cloud Platform Console project that owns the job.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Transfer specification.
	TransferSpec *TransferSpec `protobuf:"bytes,4,opt,name=transfer_spec,json=transferSpec,proto3" json:"transfer_spec,omitempty"`
	// Schedule specification.
	Schedule *Schedule `protobuf:"bytes,5,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Status of the job. This value MUST be specified for
	// `CreateTransferJobRequests`.
	//
	// NOTE: The effect of the new job status takes place during a subsequent job
	// run. For example, if you change the job status from `ENABLED` to
	// `DISABLED`, and an operation spawned by the transfer is running, the status
	// change would not affect the current operation.
	Status TransferJob_Status `protobuf:"varint,6,opt,name=status,proto3,enum=google.storagetransfer.v1.TransferJob_Status" json:"status,omitempty"`
	// This field cannot be changed by user requests.
	CreationTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// This field cannot be changed by user requests.
	LastModificationTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=last_modification_time,json=lastModificationTime,proto3" json:"last_modification_time,omitempty"`
	// This field cannot be changed by user requests.
	DeletionTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=deletion_time,json=deletionTime,proto3" json:"deletion_time,omitempty"`
}

func (x *TransferJob) Reset() {
	*x = TransferJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferJob) ProtoMessage() {}

func (x *TransferJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferJob.ProtoReflect.Descriptor instead.
func (*TransferJob) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{9}
}

func (x *TransferJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransferJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TransferJob) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TransferJob) GetTransferSpec() *TransferSpec {
	if x != nil {
		return x.TransferSpec
	}
	return nil
}

func (x *TransferJob) GetSchedule() *Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *TransferJob) GetStatus() TransferJob_Status {
	if x != nil {
		return x.Status
	}
	return TransferJob_STATUS_UNSPECIFIED
}

func (x *TransferJob) GetCreationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreationTime
	}
	return nil
}

func (x *TransferJob) GetLastModificationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModificationTime
	}
	return nil
}

func (x *TransferJob) GetDeletionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeletionTime
	}
	return nil
}

// An entry describing an error that has occurred.
type ErrorLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A URL that refers to the target (a data source, a data sink,
	// or an object) with which the error is associated.
	// Required.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// A list of messages that carry the error details.
	ErrorDetails []string `protobuf:"bytes,3,rep,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
}

func (x *ErrorLogEntry) Reset() {
	*x = ErrorLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorLogEntry) ProtoMessage() {}

func (x *ErrorLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorLogEntry.ProtoReflect.Descriptor instead.
func (*ErrorLogEntry) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{10}
}

func (x *ErrorLogEntry) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ErrorLogEntry) GetErrorDetails() []string {
	if x != nil {
		return x.ErrorDetails
	}
	return nil
}

// A summary of errors by error code, plus a count and sample error log
// entries.
type ErrorSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	ErrorCode code.Code `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3,enum=google.rpc.Code" json:"error_code,omitempty"`
	// Count of this type of error.
	// Required.
	ErrorCount int64 `protobuf:"varint,2,opt,name=error_count,json=errorCount,proto3" json:"error_count,omitempty"`
	// Error samples.
	ErrorLogEntries []*ErrorLogEntry `protobuf:"bytes,3,rep,name=error_log_entries,json=errorLogEntries,proto3" json:"error_log_entries,omitempty"`
}

func (x *ErrorSummary) Reset() {
	*x = ErrorSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorSummary) ProtoMessage() {}

func (x *ErrorSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorSummary.ProtoReflect.Descriptor instead.
func (*ErrorSummary) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{11}
}

func (x *ErrorSummary) GetErrorCode() code.Code {
	if x != nil {
		return x.ErrorCode
	}
	return code.Code_OK
}

func (x *ErrorSummary) GetErrorCount() int64 {
	if x != nil {
		return x.ErrorCount
	}
	return 0
}

func (x *ErrorSummary) GetErrorLogEntries() []*ErrorLogEntry {
	if x != nil {
		return x.ErrorLogEntries
	}
	return nil
}

// A collection of counters that report the progress of a transfer operation.
type TransferCounters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Objects found in the data source that are scheduled to be transferred,
	// excluding any that are filtered based on object conditions or skipped due
	// to sync.
	ObjectsFoundFromSource int64 `protobuf:"varint,1,opt,name=objects_found_from_source,json=objectsFoundFromSource,proto3" json:"objects_found_from_source,omitempty"`
	// Bytes found in the data source that are scheduled to be transferred,
	// excluding any that are filtered based on object conditions or skipped due
	// to sync.
	BytesFoundFromSource int64 `protobuf:"varint,2,opt,name=bytes_found_from_source,json=bytesFoundFromSource,proto3" json:"bytes_found_from_source,omitempty"`
	// Objects found only in the data sink that are scheduled to be deleted.
	ObjectsFoundOnlyFromSink int64 `protobuf:"varint,3,opt,name=objects_found_only_from_sink,json=objectsFoundOnlyFromSink,proto3" json:"objects_found_only_from_sink,omitempty"`
	// Bytes found only in the data sink that are scheduled to be deleted.
	BytesFoundOnlyFromSink int64 `protobuf:"varint,4,opt,name=bytes_found_only_from_sink,json=bytesFoundOnlyFromSink,proto3" json:"bytes_found_only_from_sink,omitempty"`
	// Objects in the data source that are not transferred because they already
	// exist in the data sink.
	ObjectsFromSourceSkippedBySync int64 `protobuf:"varint,5,opt,name=objects_from_source_skipped_by_sync,json=objectsFromSourceSkippedBySync,proto3" json:"objects_from_source_skipped_by_sync,omitempty"`
	// Bytes in the data source that are not transferred because they already
	// exist in the data sink.
	BytesFromSourceSkippedBySync int64 `protobuf:"varint,6,opt,name=bytes_from_source_skipped_by_sync,json=bytesFromSourceSkippedBySync,proto3" json:"bytes_from_source_skipped_by_sync,omitempty"`
	// Objects that are copied to the data sink.
	ObjectsCopiedToSink int64 `protobuf:"varint,7,opt,name=objects_copied_to_sink,json=objectsCopiedToSink,proto3" json:"objects_copied_to_sink,omitempty"`
	// Bytes that are copied to the data sink.
	BytesCopiedToSink int64 `protobuf:"varint,8,opt,name=bytes_copied_to_sink,json=bytesCopiedToSink,proto3" json:"bytes_copied_to_sink,omitempty"`
	// Objects that are deleted from the data source.
	ObjectsDeletedFromSource int64 `protobuf:"varint,9,opt,name=objects_deleted_from_source,json=objectsDeletedFromSource,proto3" json:"objects_deleted_from_source,omitempty"`
	// Bytes that are deleted from the data source.
	BytesDeletedFromSource int64 `protobuf:"varint,10,opt,name=bytes_deleted_from_source,json=bytesDeletedFromSource,proto3" json:"bytes_deleted_from_source,omitempty"`
	// Objects that are deleted from the data sink.
	ObjectsDeletedFromSink int64 `protobuf:"varint,11,opt,name=objects_deleted_from_sink,json=objectsDeletedFromSink,proto3" json:"objects_deleted_from_sink,omitempty"`
	// Bytes that are deleted from the data sink.
	BytesDeletedFromSink int64 `protobuf:"varint,12,opt,name=bytes_deleted_from_sink,json=bytesDeletedFromSink,proto3" json:"bytes_deleted_from_sink,omitempty"`
	// Objects in the data source that failed during the transfer.
	ObjectsFromSourceFailed int64 `protobuf:"varint,13,opt,name=objects_from_source_failed,json=objectsFromSourceFailed,proto3" json:"objects_from_source_failed,omitempty"`
	// Bytes in the data source that failed during the transfer.
	BytesFromSourceFailed int64 `protobuf:"varint,14,opt,name=bytes_from_source_failed,json=bytesFromSourceFailed,proto3" json:"bytes_from_source_failed,omitempty"`
	// Objects that failed to be deleted from the data sink.
	ObjectsFailedToDeleteFromSink int64 `protobuf:"varint,15,opt,name=objects_failed_to_delete_from_sink,json=objectsFailedToDeleteFromSink,proto3" json:"objects_failed_to_delete_from_sink,omitempty"`
	// Bytes that failed to be deleted from the data sink.
	BytesFailedToDeleteFromSink int64 `protobuf:"varint,16,opt,name=bytes_failed_to_delete_from_sink,json=bytesFailedToDeleteFromSink,proto3" json:"bytes_failed_to_delete_from_sink,omitempty"`
}

func (x *TransferCounters) Reset() {
	*x = TransferCounters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferCounters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferCounters) ProtoMessage() {}

func (x *TransferCounters) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferCounters.ProtoReflect.Descriptor instead.
func (*TransferCounters) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{12}
}

func (x *TransferCounters) GetObjectsFoundFromSource() int64 {
	if x != nil {
		return x.ObjectsFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetBytesFoundFromSource() int64 {
	if x != nil {
		return x.BytesFoundFromSource
	}
	return 0
}

func (x *TransferCounters) GetObjectsFoundOnlyFromSink() int64 {
	if x != nil {
		return x.ObjectsFoundOnlyFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesFoundOnlyFromSink() int64 {
	if x != nil {
		return x.BytesFoundOnlyFromSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsFromSourceSkippedBySync() int64 {
	if x != nil {
		return x.ObjectsFromSourceSkippedBySync
	}
	return 0
}

func (x *TransferCounters) GetBytesFromSourceSkippedBySync() int64 {
	if x != nil {
		return x.BytesFromSourceSkippedBySync
	}
	return 0
}

func (x *TransferCounters) GetObjectsCopiedToSink() int64 {
	if x != nil {
		return x.ObjectsCopiedToSink
	}
	return 0
}

func (x *TransferCounters) GetBytesCopiedToSink() int64 {
	if x != nil {
		return x.BytesCopiedToSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsDeletedFromSource() int64 {
	if x != nil {
		return x.ObjectsDeletedFromSource
	}
	return 0
}

func (x *TransferCounters) GetBytesDeletedFromSource() int64 {
	if x != nil {
		return x.BytesDeletedFromSource
	}
	return 0
}

func (x *TransferCounters) GetObjectsDeletedFromSink() int64 {
	if x != nil {
		return x.ObjectsDeletedFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesDeletedFromSink() int64 {
	if x != nil {
		return x.BytesDeletedFromSink
	}
	return 0
}

func (x *TransferCounters) GetObjectsFromSourceFailed() int64 {
	if x != nil {
		return x.ObjectsFromSourceFailed
	}
	return 0
}

func (x *TransferCounters) GetBytesFromSourceFailed() int64 {
	if x != nil {
		return x.BytesFromSourceFailed
	}
	return 0
}

func (x *TransferCounters) GetObjectsFailedToDeleteFromSink() int64 {
	if x != nil {
		return x.ObjectsFailedToDeleteFromSink
	}
	return 0
}

func (x *TransferCounters) GetBytesFailedToDeleteFromSink() int64 {
	if x != nil {
		return x.BytesFailedToDeleteFromSink
	}
	return 0
}

// A description of the execution of a transfer.
type TransferOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A globally unique ID assigned by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The ID of the Google Cloud Platform Console project that owns the
	// operation. Required.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Transfer specification.
	// Required.
	TransferSpec *TransferSpec `protobuf:"bytes,3,opt,name=transfer_spec,json=transferSpec,proto3" json:"transfer_spec,omitempty"`
	// Start time of this transfer execution.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of this transfer execution.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Status of the transfer operation.
	Status TransferOperation_Status `protobuf:"varint,6,opt,name=status,proto3,enum=google.storagetransfer.v1.TransferOperation_Status" json:"status,omitempty"`
	// Information about the progress of the transfer operation.
	Counters *TransferCounters `protobuf:"bytes,7,opt,name=counters,proto3" json:"counters,omitempty"`
	// Summarizes errors encountered with sample error log entries.
	ErrorBreakdowns []*ErrorSummary `protobuf:"bytes,8,rep,name=error_breakdowns,json=errorBreakdowns,proto3" json:"error_breakdowns,omitempty"`
	// The name of the transfer job that triggers this transfer operation.
	TransferJobName string `protobuf:"bytes,9,opt,name=transfer_job_name,json=transferJobName,proto3" json:"transfer_job_name,omitempty"`
}

func (x *TransferOperation) Reset() {
	*x = TransferOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferOperation) ProtoMessage() {}

func (x *TransferOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferOperation.ProtoReflect.Descriptor instead.
func (*TransferOperation) Descriptor() ([]byte, []int) {
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP(), []int{13}
}

func (x *TransferOperation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TransferOperation) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TransferOperation) GetTransferSpec() *TransferSpec {
	if x != nil {
		return x.TransferSpec
	}
	return nil
}

func (x *TransferOperation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TransferOperation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TransferOperation) GetStatus() TransferOperation_Status {
	if x != nil {
		return x.Status
	}
	return TransferOperation_STATUS_UNSPECIFIED
}

func (x *TransferOperation) GetCounters() *TransferCounters {
	if x != nil {
		return x.Counters
	}
	return nil
}

func (x *TransferOperation) GetErrorBreakdowns() []*ErrorSummary {
	if x != nil {
		return x.ErrorBreakdowns
	}
	return nil
}

func (x *TransferOperation) GetTransferJobName() string {
	if x != nil {
		return x.TransferJobName
	}
	return ""
}

var File_google_storagetransfer_v1_transfer_types_proto protoreflect.FileDescriptor

var file_google_storagetransfer_v1_transfer_types_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x66, 0x64, 0x61, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3b, 0x0a, 0x14, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x22, 0x5e, 0x0a, 0x0c, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4b, 0x65, 0x79, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x4b, 0x65, 0x79, 0x22, 0xcc, 0x02, 0x0a, 0x10, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x70, 0x0a, 0x28, 0x6d, 0x69, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x69, 0x6e,
	0x63, 0x65, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x23, 0x6d, 0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x45, 0x6c,
	0x61, 0x70, 0x73, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x28, 0x6d, 0x61,
	0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x65, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x5f, 0x73,
	0x69, 0x6e, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x23, 0x6d, 0x61, 0x78, 0x54, 0x69, 0x6d, 0x65,
	0x45, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x4c, 0x61, 0x73, 0x74,
	0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75,
	0x64, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x65, 0x73, 0x22, 0x2a, 0x0a, 0x07, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a,
	0x0b, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7b,
	0x0a, 0x09, 0x41, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0e,
	0x61, 0x77, 0x73, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x61,
	0x77, 0x73, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x22, 0x25, 0x0a, 0x08, 0x48,
	0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x69, 0x73, 0x74, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6c, 0x69, 0x73, 0x74, 0x55,
	0x72, 0x6c, 0x22, 0x87, 0x02, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x59, 0x0a, 0x2a, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x61, 0x6c, 0x72, 0x65,
	0x61, 0x64, 0x79, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x5f,
	0x73, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x25, 0x6f, 0x76, 0x65, 0x72,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x41, 0x6c, 0x72, 0x65,
	0x61, 0x64, 0x79, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x53, 0x69, 0x6e,
	0x6b, 0x12, 0x40, 0x0a, 0x1d, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x73, 0x69,
	0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x6e, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x57, 0x0a, 0x29, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x24, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41,
	0x66, 0x74, 0x65, 0x72, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x22, 0x99, 0x04, 0x0a,
	0x0c, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a,
	0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x63,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x12, 0x61,
	0x77, 0x73, 0x5f, 0x73, 0x33, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x0f, 0x61, 0x77, 0x73, 0x53, 0x33, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x4f, 0x0a, 0x10, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x48,
	0x00, 0x52, 0x0e, 0x68, 0x74, 0x74, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x48, 0x0a, 0x0d, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x69,
	0x6e, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x0b,
	0x67, 0x63, 0x73, 0x44, 0x61, 0x74, 0x61, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x58, 0x0a, 0x11, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x10, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0d, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x22, 0xcf, 0x01, 0x0a, 0x08, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x41, 0x0a, 0x13, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x3d, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x45, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x41, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x22, 0xd6, 0x04, 0x0a, 0x0b, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x4c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3f, 0x0a,
	0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x45,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6d,
	0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x48, 0x0a, 0x06, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45,
	0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x44, 0x10, 0x03, 0x22, 0x46, 0x0a, 0x0d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x0c,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x2f, 0x0a, 0x0a,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f,
	0x64, 0x65, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x54,
	0x0a, 0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x22, 0xf0, 0x07, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x39, 0x0a, 0x19, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x6f,
	0x75, 0x6e, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x75, 0x6e,
	0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x1c, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x4f,
	0x6e, 0x6c, 0x79, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x3a, 0x0a, 0x1a, 0x62,
	0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x16, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x4b, 0x0a, 0x23, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73,
	0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f,
	0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x42, 0x79,
	0x53, 0x79, 0x6e, 0x63, 0x12, 0x47, 0x0a, 0x21, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x72,
	0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x1c, 0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x42, 0x79, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x33, 0x0a,
	0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x5f,
	0x74, 0x6f, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x43, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x54, 0x6f, 0x53, 0x69,
	0x6e, 0x6b, 0x12, 0x2f, 0x0a, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x70, 0x69,
	0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x62, 0x79, 0x74, 0x65, 0x73, 0x43, 0x6f, 0x70, 0x69, 0x65, 0x64, 0x54, 0x6f, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x3d, 0x0a, 0x1b, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x39, 0x0a, 0x19, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x62, 0x79, 0x74, 0x65, 0x73, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x39, 0x0a,
	0x19, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x35, 0x0a, 0x17, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73,
	0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x12,
	0x3b, 0x0a, 0x1a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x17, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x37, 0x0a, 0x18,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x49, 0x0a, 0x22, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x1d, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x54, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b,
	0x12, 0x45, 0x0a, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f,
	0x73, 0x69, 0x6e, 0x6b, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1b, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x54, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x72, 0x6f, 0x6d, 0x53, 0x69, 0x6e, 0x6b, 0x22, 0x81, 0x05, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64,
	0x12, 0x4c, 0x0a, 0x0d, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x0c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a,
	0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x52, 0x08, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x52, 0x0a, 0x10, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f,
	0x62, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x64, 0x6f, 0x77, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x63, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55,
	0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b,
	0x0a, 0x07, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x05, 0x42, 0xc5, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x42, 0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0xf8, 0x01, 0x01, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_storagetransfer_v1_transfer_types_proto_rawDescOnce sync.Once
	file_google_storagetransfer_v1_transfer_types_proto_rawDescData = file_google_storagetransfer_v1_transfer_types_proto_rawDesc
)

func file_google_storagetransfer_v1_transfer_types_proto_rawDescGZIP() []byte {
	file_google_storagetransfer_v1_transfer_types_proto_rawDescOnce.Do(func() {
		file_google_storagetransfer_v1_transfer_types_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_storagetransfer_v1_transfer_types_proto_rawDescData)
	})
	return file_google_storagetransfer_v1_transfer_types_proto_rawDescData
}

var file_google_storagetransfer_v1_transfer_types_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_storagetransfer_v1_transfer_types_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_storagetransfer_v1_transfer_types_proto_goTypes = []interface{}{
	(TransferJob_Status)(0),       // 0: google.storagetransfer.v1.TransferJob.Status
	(TransferOperation_Status)(0), // 1: google.storagetransfer.v1.TransferOperation.Status
	(*GoogleServiceAccount)(nil),  // 2: google.storagetransfer.v1.GoogleServiceAccount
	(*AwsAccessKey)(nil),          // 3: google.storagetransfer.v1.AwsAccessKey
	(*ObjectConditions)(nil),      // 4: google.storagetransfer.v1.ObjectConditions
	(*GcsData)(nil),               // 5: google.storagetransfer.v1.GcsData
	(*AwsS3Data)(nil),             // 6: google.storagetransfer.v1.AwsS3Data
	(*HttpData)(nil),              // 7: google.storagetransfer.v1.HttpData
	(*TransferOptions)(nil),       // 8: google.storagetransfer.v1.TransferOptions
	(*TransferSpec)(nil),          // 9: google.storagetransfer.v1.TransferSpec
	(*Schedule)(nil),              // 10: google.storagetransfer.v1.Schedule
	(*TransferJob)(nil),           // 11: google.storagetransfer.v1.TransferJob
	(*ErrorLogEntry)(nil),         // 12: google.storagetransfer.v1.ErrorLogEntry
	(*ErrorSummary)(nil),          // 13: google.storagetransfer.v1.ErrorSummary
	(*TransferCounters)(nil),      // 14: google.storagetransfer.v1.TransferCounters
	(*TransferOperation)(nil),     // 15: google.storagetransfer.v1.TransferOperation
	(*durationpb.Duration)(nil),   // 16: google.protobuf.Duration
	(*date.Date)(nil),             // 17: google.type.Date
	(*timeofday.TimeOfDay)(nil),   // 18: google.type.TimeOfDay
	(*timestamppb.Timestamp)(nil), // 19: google.protobuf.Timestamp
	(code.Code)(0),                // 20: google.rpc.Code
}
var file_google_storagetransfer_v1_transfer_types_proto_depIdxs = []int32{
	16, // 0: google.storagetransfer.v1.ObjectConditions.min_time_elapsed_since_last_modification:type_name -> google.protobuf.Duration
	16, // 1: google.storagetransfer.v1.ObjectConditions.max_time_elapsed_since_last_modification:type_name -> google.protobuf.Duration
	3,  // 2: google.storagetransfer.v1.AwsS3Data.aws_access_key:type_name -> google.storagetransfer.v1.AwsAccessKey
	5,  // 3: google.storagetransfer.v1.TransferSpec.gcs_data_source:type_name -> google.storagetransfer.v1.GcsData
	6,  // 4: google.storagetransfer.v1.TransferSpec.aws_s3_data_source:type_name -> google.storagetransfer.v1.AwsS3Data
	7,  // 5: google.storagetransfer.v1.TransferSpec.http_data_source:type_name -> google.storagetransfer.v1.HttpData
	5,  // 6: google.storagetransfer.v1.TransferSpec.gcs_data_sink:type_name -> google.storagetransfer.v1.GcsData
	4,  // 7: google.storagetransfer.v1.TransferSpec.object_conditions:type_name -> google.storagetransfer.v1.ObjectConditions
	8,  // 8: google.storagetransfer.v1.TransferSpec.transfer_options:type_name -> google.storagetransfer.v1.TransferOptions
	17, // 9: google.storagetransfer.v1.Schedule.schedule_start_date:type_name -> google.type.Date
	17, // 10: google.storagetransfer.v1.Schedule.schedule_end_date:type_name -> google.type.Date
	18, // 11: google.storagetransfer.v1.Schedule.start_time_of_day:type_name -> google.type.TimeOfDay
	9,  // 12: google.storagetransfer.v1.TransferJob.transfer_spec:type_name -> google.storagetransfer.v1.TransferSpec
	10, // 13: google.storagetransfer.v1.TransferJob.schedule:type_name -> google.storagetransfer.v1.Schedule
	0,  // 14: google.storagetransfer.v1.TransferJob.status:type_name -> google.storagetransfer.v1.TransferJob.Status
	19, // 15: google.storagetransfer.v1.TransferJob.creation_time:type_name -> google.protobuf.Timestamp
	19, // 16: google.storagetransfer.v1.TransferJob.last_modification_time:type_name -> google.protobuf.Timestamp
	19, // 17: google.storagetransfer.v1.TransferJob.deletion_time:type_name -> google.protobuf.Timestamp
	20, // 18: google.storagetransfer.v1.ErrorSummary.error_code:type_name -> google.rpc.Code
	12, // 19: google.storagetransfer.v1.ErrorSummary.error_log_entries:type_name -> google.storagetransfer.v1.ErrorLogEntry
	9,  // 20: google.storagetransfer.v1.TransferOperation.transfer_spec:type_name -> google.storagetransfer.v1.TransferSpec
	19, // 21: google.storagetransfer.v1.TransferOperation.start_time:type_name -> google.protobuf.Timestamp
	19, // 22: google.storagetransfer.v1.TransferOperation.end_time:type_name -> google.protobuf.Timestamp
	1,  // 23: google.storagetransfer.v1.TransferOperation.status:type_name -> google.storagetransfer.v1.TransferOperation.Status
	14, // 24: google.storagetransfer.v1.TransferOperation.counters:type_name -> google.storagetransfer.v1.TransferCounters
	13, // 25: google.storagetransfer.v1.TransferOperation.error_breakdowns:type_name -> google.storagetransfer.v1.ErrorSummary
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_google_storagetransfer_v1_transfer_types_proto_init() }
func file_google_storagetransfer_v1_transfer_types_proto_init() {
	if File_google_storagetransfer_v1_transfer_types_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleServiceAccount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsAccessKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectConditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AwsS3Data); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferCounters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_storagetransfer_v1_transfer_types_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_storagetransfer_v1_transfer_types_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*TransferSpec_GcsDataSource)(nil),
		(*TransferSpec_AwsS3DataSource)(nil),
		(*TransferSpec_HttpDataSource)(nil),
		(*TransferSpec_GcsDataSink)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_storagetransfer_v1_transfer_types_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_storagetransfer_v1_transfer_types_proto_goTypes,
		DependencyIndexes: file_google_storagetransfer_v1_transfer_types_proto_depIdxs,
		EnumInfos:         file_google_storagetransfer_v1_transfer_types_proto_enumTypes,
		MessageInfos:      file_google_storagetransfer_v1_transfer_types_proto_msgTypes,
	}.Build()
	File_google_storagetransfer_v1_transfer_types_proto = out.File
	file_google_storagetransfer_v1_transfer_types_proto_rawDesc = nil
	file_google_storagetransfer_v1_transfer_types_proto_goTypes = nil
	file_google_storagetransfer_v1_transfer_types_proto_depIdxs = nil
}
