// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	scheme "open-cluster-management.io/api/client/cluster/clientset/versioned/scheme"
	v1alpha1 "open-cluster-management.io/api/cluster/v1alpha1"
)

// PlacementsGetter has a method to return a PlacementInterface.
// A group's client should implement this interface.
type PlacementsGetter interface {
	Placements(namespace string) PlacementInterface
}

// PlacementInterface has methods to work with Placement resources.
type PlacementInterface interface {
	Create(ctx context.Context, placement *v1alpha1.Placement, opts v1.CreateOptions) (*v1alpha1.Placement, error)
	Update(ctx context.Context, placement *v1alpha1.Placement, opts v1.UpdateOptions) (*v1alpha1.Placement, error)
	UpdateStatus(ctx context.Context, placement *v1alpha1.Placement, opts v1.UpdateOptions) (*v1alpha1.Placement, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.Placement, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.PlacementList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Placement, err error)
	PlacementExpansion
}

// placements implements PlacementInterface
type placements struct {
	client rest.Interface
	ns     string
}

// newPlacements returns a Placements
func newPlacements(c *ClusterV1alpha1Client, namespace string) *placements {
	return &placements{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the placement, and returns the corresponding placement object, and an error if there is any.
func (c *placements) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Placement, err error) {
	result = &v1alpha1.Placement{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("placements").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Placements that match those selectors.
func (c *placements) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PlacementList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.PlacementList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("placements").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested placements.
func (c *placements) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("placements").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a placement and creates it.  Returns the server's representation of the placement, and an error, if there is any.
func (c *placements) Create(ctx context.Context, placement *v1alpha1.Placement, opts v1.CreateOptions) (result *v1alpha1.Placement, err error) {
	result = &v1alpha1.Placement{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("placements").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(placement).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a placement and updates it. Returns the server's representation of the placement, and an error, if there is any.
func (c *placements) Update(ctx context.Context, placement *v1alpha1.Placement, opts v1.UpdateOptions) (result *v1alpha1.Placement, err error) {
	result = &v1alpha1.Placement{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("placements").
		Name(placement.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(placement).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *placements) UpdateStatus(ctx context.Context, placement *v1alpha1.Placement, opts v1.UpdateOptions) (result *v1alpha1.Placement, err error) {
	result = &v1alpha1.Placement{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("placements").
		Name(placement.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(placement).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the placement and deletes it. Returns an error if one occurs.
func (c *placements) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("placements").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *placements) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("placements").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched placement.
func (c *placements) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Placement, err error) {
	result = &v1alpha1.Placement{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("placements").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
