// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateMLTransformInput struct {
	_ struct{} `type:"structure"`

	// A description of the transform. The default is an empty string.
	Description *string `type:"string"`

	// This value determines which version of AWS Glue this machine learning transform
	// is compatible with. Glue 1.0 is recommended for most customers. If the value
	// is not set, the Glue compatibility defaults to Glue 0.9. For more information,
	// see AWS Glue Versions (https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions)
	// in the developer guide.
	GlueVersion *string `min:"1" type:"string"`

	// The number of AWS Glue data processing units (DPUs) that are allocated to
	// task runs for this transform. You can allocate from 2 to 100 DPUs; the default
	// is 10. A DPU is a relative measure of processing power that consists of 4
	// vCPUs of compute capacity and 16 GB of memory. For more information, see
	// the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// When the WorkerType field is set to a value other than Standard, the MaxCapacity
	// field is set automatically and becomes read-only.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry a task for this transform after a task
	// run fails.
	MaxRetries *int64 `type:"integer"`

	// The unique name that you gave the transform when you created it.
	Name *string `min:"1" type:"string"`

	// The number of workers of a defined workerType that are allocated when this
	// task runs.
	NumberOfWorkers *int64 `type:"integer"`

	// The configuration parameters that are specific to the transform type (algorithm)
	// used. Conditionally dependent on the transform type.
	Parameters *TransformParameters `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the IAM role with the required
	// permissions.
	Role *string `type:"string"`

	// The timeout for a task run for this transform in minutes. This is the maximum
	// time that a task run for this transform can consume resources before it is
	// terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// A unique identifier that was generated when the transform was created.
	//
	// TransformId is a required field
	TransformId *string `min:"1" type:"string" required:"true"`

	// The type of predefined worker that is allocated when this task runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateMLTransformInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMLTransformInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMLTransformInput"}
	if s.GlueVersion != nil && len(*s.GlueVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GlueVersion", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}

	if s.TransformId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransformId"))
	}
	if s.TransformId != nil && len(*s.TransformId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TransformId", 1))
	}
	if s.Parameters != nil {
		if err := s.Parameters.Validate(); err != nil {
			invalidParams.AddNested("Parameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateMLTransformOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the transform that was updated.
	TransformId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateMLTransformOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateMLTransform = "UpdateMLTransform"

// UpdateMLTransformRequest returns a request value for making API operation for
// AWS Glue.
//
// Updates an existing machine learning transform. Call this operation to tune
// the algorithm parameters to achieve better results.
//
// After calling this operation, you can call the StartMLEvaluationTaskRun operation
// to assess how well your new parameters achieved your goals (such as improving
// the quality of your machine learning transform, or making it more cost-effective).
//
//    // Example sending a request using UpdateMLTransformRequest.
//    req := client.UpdateMLTransformRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateMLTransform
func (c *Client) UpdateMLTransformRequest(input *UpdateMLTransformInput) UpdateMLTransformRequest {
	op := &aws.Operation{
		Name:       opUpdateMLTransform,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMLTransformInput{}
	}

	req := c.newRequest(op, input, &UpdateMLTransformOutput{})
	return UpdateMLTransformRequest{Request: req, Input: input, Copy: c.UpdateMLTransformRequest}
}

// UpdateMLTransformRequest is the request type for the
// UpdateMLTransform API operation.
type UpdateMLTransformRequest struct {
	*aws.Request
	Input *UpdateMLTransformInput
	Copy  func(*UpdateMLTransformInput) UpdateMLTransformRequest
}

// Send marshals and sends the UpdateMLTransform API request.
func (r UpdateMLTransformRequest) Send(ctx context.Context) (*UpdateMLTransformResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMLTransformResponse{
		UpdateMLTransformOutput: r.Request.Data.(*UpdateMLTransformOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMLTransformResponse is the response type for the
// UpdateMLTransform API operation.
type UpdateMLTransformResponse struct {
	*UpdateMLTransformOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMLTransform request.
func (r *UpdateMLTransformResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
