// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the issued certificate. The ARN contains the certificate serial
	// number and must be in the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCertificateInput"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateArn", 5))
	}

	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate specified by the CertificateArn parameter.
	Certificate *string `type:"string"`

	// The base64 PEM-encoded certificate chain that chains up to the on-premises
	// root CA certificate that you used to sign your private CA certificate.
	CertificateChain *string `type:"string"`
}

// String returns the string representation
func (s GetCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCertificate = "GetCertificate"

// GetCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Retrieves a certificate from your private CA. The ARN of the certificate
// is returned when you call the IssueCertificate action. You must specify both
// the ARN of your private CA and the ARN of the issued certificate when calling
// the GetCertificate action. You can retrieve the certificate if it is in the
// ISSUED state. You can call the CreateCertificateAuthorityAuditReport action
// to create a report that contains information about all of the certificates
// issued and revoked by your private CA.
//
//    // Example sending a request using GetCertificateRequest.
//    req := client.GetCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate
func (c *Client) GetCertificateRequest(input *GetCertificateInput) GetCertificateRequest {
	op := &aws.Operation{
		Name:       opGetCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateInput{}
	}

	req := c.newRequest(op, input, &GetCertificateOutput{})
	return GetCertificateRequest{Request: req, Input: input, Copy: c.GetCertificateRequest}
}

// GetCertificateRequest is the request type for the
// GetCertificate API operation.
type GetCertificateRequest struct {
	*aws.Request
	Input *GetCertificateInput
	Copy  func(*GetCertificateInput) GetCertificateRequest
}

// Send marshals and sends the GetCertificate API request.
func (r GetCertificateRequest) Send(ctx context.Context) (*GetCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCertificateResponse{
		GetCertificateOutput: r.Request.Data.(*GetCertificateOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCertificateResponse is the response type for the
// GetCertificate API operation.
type GetCertificateResponse struct {
	*GetCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCertificate request.
func (r *GetCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
