// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
)

// WaitUntilAuditReportCreated uses the ACM-PCA API operation
// DescribeCertificateAuthorityAuditReport to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilAuditReportCreated(ctx context.Context, input *DescribeCertificateAuthorityAuditReportInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilAuditReportCreated",
		MaxAttempts: 60,
		Delay:       aws.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "AuditReportStatus",
				Expected: "SUCCESS",
			},
			{
				State:   aws.FailureWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "AuditReportStatus",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeCertificateAuthorityAuditReportInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeCertificateAuthorityAuditReportRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}

// WaitUntilCertificateAuthorityCSRCreated uses the ACM-PCA API operation
// GetCertificateAuthorityCsr to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilCertificateAuthorityCSRCreated(ctx context.Context, input *GetCertificateAuthorityCsrInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilCertificateAuthorityCSRCreated",
		MaxAttempts: 60,
		Delay:       aws.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:    aws.SuccessWaiterState,
				Matcher:  aws.StatusWaiterMatch,
				Expected: 200,
			},
			{
				State:    aws.RetryWaiterState,
				Matcher:  aws.ErrorWaiterMatch,
				Expected: "RequestInProgressException",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *GetCertificateAuthorityCsrInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.GetCertificateAuthorityCsrRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}

// WaitUntilCertificateIssued uses the ACM-PCA API operation
// GetCertificate to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilCertificateIssued(ctx context.Context, input *GetCertificateInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilCertificateIssued",
		MaxAttempts: 60,
		Delay:       aws.ConstantWaiterDelay(3 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:    aws.SuccessWaiterState,
				Matcher:  aws.StatusWaiterMatch,
				Expected: 200,
			},
			{
				State:    aws.RetryWaiterState,
				Matcher:  aws.ErrorWaiterMatch,
				Expected: "RequestInProgressException",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *GetCertificateInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.GetCertificateRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}
