// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request to generate a sample mapping template used to transform the payload.
type GetModelTemplateInput struct {
	_ struct{} `type:"structure"`

	// [Required] The name of the model for which to generate a template.
	//
	// ModelName is a required field
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetModelTemplateInput"}

	if s.ModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelName"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetModelTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ModelName != nil {
		v := *s.ModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "model_name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a mapping template used to transform a payload.
//
// Mapping Templates (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-mappings)
type GetModelTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Apache Velocity Template Language (VTL) (https://velocity.apache.org/engine/devel/vtl-reference-guide.html)
	// template content used for the template resource.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s GetModelTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetModelTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetModelTemplate = "GetModelTemplate"

// GetModelTemplateRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Generates a sample mapping template that can be used to transform a payload
// into the structure of a model.
//
//    // Example sending a request using GetModelTemplateRequest.
//    req := client.GetModelTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetModelTemplateRequest(input *GetModelTemplateInput) GetModelTemplateRequest {
	op := &aws.Operation{
		Name:       opGetModelTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}/default_template",
	}

	if input == nil {
		input = &GetModelTemplateInput{}
	}

	req := c.newRequest(op, input, &GetModelTemplateOutput{})
	return GetModelTemplateRequest{Request: req, Input: input, Copy: c.GetModelTemplateRequest}
}

// GetModelTemplateRequest is the request type for the
// GetModelTemplate API operation.
type GetModelTemplateRequest struct {
	*aws.Request
	Input *GetModelTemplateInput
	Copy  func(*GetModelTemplateInput) GetModelTemplateRequest
}

// Send marshals and sends the GetModelTemplate API request.
func (r GetModelTemplateRequest) Send(ctx context.Context) (*GetModelTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetModelTemplateResponse{
		GetModelTemplateOutput: r.Request.Data.(*GetModelTemplateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetModelTemplateResponse is the response type for the
// GetModelTemplate API operation.
type GetModelTemplateResponse struct {
	*GetModelTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetModelTemplate request.
func (r *GetModelTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
