// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The application ID that includes the environment you want to delete.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The ID of the environment you want to delete.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteEnvironmentInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.EnvironmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEnvironmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnvironmentId != nil {
		v := *s.EnvironmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "EnvironmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteEnvironmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Delete an environment. Deleting an environment does not delete a configuration
// from a host.
//
//    // Example sending a request using DeleteEnvironmentRequest.
//    req := client.DeleteEnvironmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteEnvironment
func (c *Client) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) DeleteEnvironmentRequest {
	op := &aws.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	req := c.newRequest(op, input, &DeleteEnvironmentOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteEnvironmentRequest{Request: req, Input: input, Copy: c.DeleteEnvironmentRequest}
}

// DeleteEnvironmentRequest is the request type for the
// DeleteEnvironment API operation.
type DeleteEnvironmentRequest struct {
	*aws.Request
	Input *DeleteEnvironmentInput
	Copy  func(*DeleteEnvironmentInput) DeleteEnvironmentRequest
}

// Send marshals and sends the DeleteEnvironment API request.
func (r DeleteEnvironmentRequest) Send(ctx context.Context) (*DeleteEnvironmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteEnvironmentResponse{
		DeleteEnvironmentOutput: r.Request.Data.(*DeleteEnvironmentOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteEnvironmentResponse is the response type for the
// DeleteEnvironment API operation.
type DeleteEnvironmentResponse struct {
	*DeleteEnvironmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteEnvironment request.
func (r *DeleteEnvironmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
