// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateImageBuilderInput struct {
	_ struct{} `type:"structure"`

	// The list of interface VPC endpoint (interface endpoint) objects. Administrators
	// can connect to the image builder only through the specified endpoints.
	AccessEndpoints []AccessEndpoint `min:"1" type:"list"`

	// The version of the AppStream 2.0 agent to use for this image builder. To
	// use the latest version of the AppStream 2.0 agent, specify [LATEST].
	AppstreamAgentVersion *string `min:"1" type:"string"`

	// The description to display.
	Description *string `type:"string"`

	// The image builder name to display.
	DisplayName *string `type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// image builder to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the image builder.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role to apply to the image builder.
	// To assume a role, the image builder calls the AWS Security Token Service
	// (STS) AssumeRole API operation and passes the ARN of the role to use. The
	// operation creates a new session with temporary credentials. AppStream 2.0
	// retrieves the temporary credentials and creates the AppStream_Machine_Role
	// credential profile on the instance.
	//
	// For more information, see Using an IAM Role to Grant Permissions to Applications
	// and Scripts Running on AppStream 2.0 Streaming Instances (https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	IamRoleArn *string `type:"string"`

	// The ARN of the public, private, or shared image to use.
	ImageArn *string `type:"string"`

	// The name of the image used to create the image builder.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching the image builder. The following
	// instance types are available:
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// A unique name for the image builder.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The tags to associate with the image builder. A tag is a key-value pair,
	// and the value is optional. For example, Environment=Test. If you do not specify
	// a value, Environment=.
	//
	// Generally allowed characters are: letters, numbers, and spaces representable
	// in UTF-8, and the following special characters:
	//
	// _ . : / = + \ - @
	//
	// If you do not specify a value, the value is set to an empty string.
	//
	// For more information about tags, see Tagging Your Resources (https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
	// in the Amazon AppStream 2.0 Administration Guide.
	Tags map[string]string `min:"1" type:"map"`

	// The VPC configuration for the image builder. You can specify only one subnet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateImageBuilderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateImageBuilderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateImageBuilderInput"}
	if s.AccessEndpoints != nil && len(s.AccessEndpoints) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccessEndpoints", 1))
	}
	if s.AppstreamAgentVersion != nil && len(*s.AppstreamAgentVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppstreamAgentVersion", 1))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ImageName", 1))
	}

	if s.InstanceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceType", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.AccessEndpoints != nil {
		for i, v := range s.AccessEndpoints {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessEndpoints", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateImageBuilderOutput struct {
	_ struct{} `type:"structure"`

	// Information about the image builder.
	ImageBuilder *ImageBuilder `type:"structure"`
}

// String returns the string representation
func (s CreateImageBuilderOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateImageBuilder = "CreateImageBuilder"

// CreateImageBuilderRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Creates an image builder. An image builder is a virtual machine that is used
// to create an image.
//
// The initial state of the builder is PENDING. When it is ready, the state
// is RUNNING.
//
//    // Example sending a request using CreateImageBuilderRequest.
//    req := client.CreateImageBuilderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder
func (c *Client) CreateImageBuilderRequest(input *CreateImageBuilderInput) CreateImageBuilderRequest {
	op := &aws.Operation{
		Name:       opCreateImageBuilder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateImageBuilderInput{}
	}

	req := c.newRequest(op, input, &CreateImageBuilderOutput{})
	return CreateImageBuilderRequest{Request: req, Input: input, Copy: c.CreateImageBuilderRequest}
}

// CreateImageBuilderRequest is the request type for the
// CreateImageBuilder API operation.
type CreateImageBuilderRequest struct {
	*aws.Request
	Input *CreateImageBuilderInput
	Copy  func(*CreateImageBuilderInput) CreateImageBuilderRequest
}

// Send marshals and sends the CreateImageBuilder API request.
func (r CreateImageBuilderRequest) Send(ctx context.Context) (*CreateImageBuilderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateImageBuilderResponse{
		CreateImageBuilderOutput: r.Request.Data.(*CreateImageBuilderOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateImageBuilderResponse is the response type for the
// CreateImageBuilder API operation.
type CreateImageBuilderResponse struct {
	*CreateImageBuilderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateImageBuilder request.
func (r *CreateImageBuilderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
