// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscalingplans

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteScalingPlanInput struct {
	_ struct{} `type:"structure"`

	// The name of the scaling plan.
	//
	// ScalingPlanName is a required field
	ScalingPlanName *string `min:"1" type:"string" required:"true"`

	// The version number of the scaling plan.
	//
	// ScalingPlanVersion is a required field
	ScalingPlanVersion *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s DeleteScalingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScalingPlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteScalingPlanInput"}

	if s.ScalingPlanName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingPlanName"))
	}
	if s.ScalingPlanName != nil && len(*s.ScalingPlanName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScalingPlanName", 1))
	}

	if s.ScalingPlanVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ScalingPlanVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteScalingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScalingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteScalingPlan = "DeleteScalingPlan"

// DeleteScalingPlanRequest returns a request value for making API operation for
// AWS Auto Scaling Plans.
//
// Deletes the specified scaling plan.
//
// Deleting a scaling plan deletes the underlying ScalingInstruction for all
// of the scalable resources that are covered by the plan.
//
// If the plan has launched resources or has scaling activities in progress,
// you must delete those resources separately.
//
//    // Example sending a request using DeleteScalingPlanRequest.
//    req := client.DeleteScalingPlanRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-plans-2018-01-06/DeleteScalingPlan
func (c *Client) DeleteScalingPlanRequest(input *DeleteScalingPlanInput) DeleteScalingPlanRequest {
	op := &aws.Operation{
		Name:       opDeleteScalingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScalingPlanInput{}
	}

	req := c.newRequest(op, input, &DeleteScalingPlanOutput{})
	return DeleteScalingPlanRequest{Request: req, Input: input, Copy: c.DeleteScalingPlanRequest}
}

// DeleteScalingPlanRequest is the request type for the
// DeleteScalingPlan API operation.
type DeleteScalingPlanRequest struct {
	*aws.Request
	Input *DeleteScalingPlanInput
	Copy  func(*DeleteScalingPlanInput) DeleteScalingPlanRequest
}

// Send marshals and sends the DeleteScalingPlan API request.
func (r DeleteScalingPlanRequest) Send(ctx context.Context) (*DeleteScalingPlanResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteScalingPlanResponse{
		DeleteScalingPlanOutput: r.Request.Data.(*DeleteScalingPlanOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteScalingPlanResponse is the response type for the
// DeleteScalingPlan API operation.
type DeleteScalingPlanResponse struct {
	*DeleteScalingPlanOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteScalingPlan request.
func (r *DeleteScalingPlanResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
