// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The Amazon Chime account details. An AWS account can have multiple Amazon
// Chime accounts.
type Account struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The Amazon Chime account type. For more information about different account
	// types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
	// in the Amazon Chime Administration Guide.
	AccountType AccountType `type:"string" enum:"true"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// The Amazon Chime account creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The default license for the Amazon Chime account.
	DefaultLicense License `type:"string" enum:"true"`

	// The Amazon Chime account name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Supported licenses for the Amazon Chime account.
	SupportedLicenses []License `type:"list"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Account) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AccountType) > 0 {
		v := s.AccountType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.DefaultLicense) > 0 {
		v := s.DefaultLicense

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultLicense", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SupportedLicenses != nil {
		v := s.SupportedLicenses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SupportedLicenses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Settings related to the Amazon Chime account. This includes settings that
// start or stop remote control of shared screens, or start or stop the dial-out
// option in the Amazon Chime web application. For more information about these
// settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// Setting that stops or starts remote control of shared screens during meetings.
	DisableRemoteControl *bool `type:"boolean"`

	// Setting that allows meeting participants to choose the Call me at a phone
	// number option. For more information, see Join a Meeting without the Amazon
	// Chime App (https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
	EnableDialOut *bool `type:"boolean"`
}

// String returns the string representation
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DisableRemoteControl != nil {
		v := *s.DisableRemoteControl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisableRemoteControl", protocol.BoolValue(v), metadata)
	}
	if s.EnableDialOut != nil {
		v := *s.EnableDialOut

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnableDialOut", protocol.BoolValue(v), metadata)
	}
	return nil
}

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and JoinToken.
// The JoinToken allows a client to authenticate and join as the specified attendee.
// The JoinToken expires when the meeting ends or when DeleteAttendee is called.
// After that, the attendee is unable to join the meeting.
//
// We recommend securely transferring each JoinToken from your server application
// to the client so that no other client has access to the token except for
// the one authorized to represent the attendee.
type Attendee struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string `type:"string"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`

	// The join token used by the Amazon Chime SDK attendee.
	JoinToken *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s Attendee) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Attendee) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttendeeId != nil {
		v := *s.AttendeeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AttendeeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalUserId != nil {
		v := *s.ExternalUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JoinToken != nil {
		v := *s.JoinToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "JoinToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A resource that allows Enterprise account administrators to configure an
// interface to receive events from Amazon Chime.
type Bot struct {
	_ struct{} `type:"structure"`

	// The bot email address.
	BotEmail *string `type:"string" sensitive:"true"`

	// The bot ID.
	BotId *string `type:"string"`

	// The bot type.
	BotType BotType `type:"string" enum:"true"`

	// The bot creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// When true, the bot is stopped from running in your account.
	Disabled *bool `type:"boolean"`

	// The bot display name.
	DisplayName *string `type:"string" sensitive:"true"`

	// The security token used to authenticate Amazon Chime with the outgoing event
	// endpoint.
	SecurityToken *string `type:"string" sensitive:"true"`

	// The updated bot timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique ID for the bot user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s Bot) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Bot) MarshalFields(e protocol.FieldEncoder) error {
	if s.BotEmail != nil {
		v := *s.BotEmail

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BotEmail", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BotId != nil {
		v := *s.BotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.BotType) > 0 {
		v := s.BotType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BotType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Disabled != nil {
		v := *s.Disabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Disabled", protocol.BoolValue(v), metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityToken != nil {
		v := *s.SecurityToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SecurityToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The Amazon Chime Business Calling settings for the administrator's AWS account.
// Includes any Amazon S3 buckets designated for storing call detail records.
type BusinessCallingSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string `type:"string"`
}

// String returns the string representation
func (s BusinessCallingSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BusinessCallingSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.CdrBucket != nil {
		v := *s.CdrBucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CdrBucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The list of errors returned when errors are encountered during the BatchCreateAttendee
// and CreateAttendee actions. This includes external user IDs, error codes,
// and error messages.
type CreateAttendeeError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s CreateAttendeeError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAttendeeError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExternalUserId != nil {
		v := *s.ExternalUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee
// action.
type CreateAttendeeRequestItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s CreateAttendeeRequestItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeRequestItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAttendeeRequestItem"}

	if s.ExternalUserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ExternalUserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateAttendeeRequestItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExternalUserId != nil {
		v := *s.ExternalUserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExternalUserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The SIP credentials used to authenticate requests to your Amazon Chime Voice
// Connector.
type Credential struct {
	_ struct{} `type:"structure"`

	// The RFC2617 compliant password associated with the SIP credentials, in US-ASCII
	// format.
	Password *string `type:"string" sensitive:"true"`

	// The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
	// format.
	Username *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s Credential) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Credential) MarshalFields(e protocol.FieldEncoder) error {
	if s.Password != nil {
		v := *s.Password

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Password", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Username != nil {
		v := *s.Username

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Username", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The configuration that allows a bot to receive outgoing events. Can be either
// an HTTPS endpoint or a Lambda function ARN.
type EventsConfiguration struct {
	_ struct{} `type:"structure"`

	// The bot ID.
	BotId *string `type:"string"`

	// Lambda function ARN that allows a bot to receive outgoing events.
	LambdaFunctionArn *string `type:"string" sensitive:"true"`

	// HTTPS endpoint that allows a bot to receive outgoing events.
	OutboundEventsHTTPSEndpoint *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s EventsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EventsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.BotId != nil {
		v := *s.BotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LambdaFunctionArn != nil {
		v := *s.LambdaFunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LambdaFunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutboundEventsHTTPSEndpoint != nil {
		v := *s.OutboundEventsHTTPSEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutboundEventsHTTPSEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Invitation object returned after emailing users to invite them to join the
// Amazon Chime Team account.
type Invite struct {
	_ struct{} `type:"structure"`

	// The email address to which the invite is sent.
	EmailAddress *string `type:"string" sensitive:"true"`

	// The status of the invite email.
	EmailStatus EmailStatus `type:"string" enum:"true"`

	// The invite ID.
	InviteId *string `type:"string"`

	// The status of the invite.
	Status InviteStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s Invite) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invite) MarshalFields(e protocol.FieldEncoder) error {
	if s.EmailAddress != nil {
		v := *s.EmailAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EmailStatus) > 0 {
		v := s.EmailStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EmailStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.InviteId != nil {
		v := *s.InviteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InviteId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The logging configuration associated with an Amazon Chime Voice Connector.
// Specifies whether SIP message logs are enabled for sending to Amazon CloudWatch
// Logs.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
	EnableSIPLogs *bool `type:"boolean"`
}

// String returns the string representation
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.EnableSIPLogs != nil {
		v := *s.EnableSIPLogs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnableSIPLogs", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A set of endpoints used by clients to connect to the media service group
// for a Amazon Chime SDK meeting.
type MediaPlacement struct {
	_ struct{} `type:"structure"`

	// The audio host URL.
	AudioHostUrl *string `type:"string"`

	// The screen data URL.
	ScreenDataUrl *string `type:"string"`

	// The screen sharing URL.
	ScreenSharingUrl *string `type:"string"`

	// The screen viewing URL.
	ScreenViewingUrl *string `type:"string"`

	// The signaling URL.
	SignalingUrl *string `type:"string"`

	// The turn control URL.
	TurnControlUrl *string `type:"string"`
}

// String returns the string representation
func (s MediaPlacement) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MediaPlacement) MarshalFields(e protocol.FieldEncoder) error {
	if s.AudioHostUrl != nil {
		v := *s.AudioHostUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AudioHostUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScreenDataUrl != nil {
		v := *s.ScreenDataUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScreenDataUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScreenSharingUrl != nil {
		v := *s.ScreenSharingUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScreenSharingUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ScreenViewingUrl != nil {
		v := *s.ScreenViewingUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ScreenViewingUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SignalingUrl != nil {
		v := *s.SignalingUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SignalingUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TurnControlUrl != nil {
		v := *s.TurnControlUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TurnControlUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A meeting created using the Amazon Chime SDK.
type Meeting struct {
	_ struct{} `type:"structure"`

	// The media placement for the meeting.
	MediaPlacement *MediaPlacement `type:"structure"`

	// The Region in which to create the meeting. Available values: us-east-1, us-west-2.
	MediaRegion *string `type:"string"`

	// The Amazon Chime SDK meeting ID.
	MeetingId *string `type:"string"`
}

// String returns the string representation
func (s Meeting) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Meeting) MarshalFields(e protocol.FieldEncoder) error {
	if s.MediaPlacement != nil {
		v := s.MediaPlacement

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "MediaPlacement", v, metadata)
	}
	if s.MediaRegion != nil {
		v := *s.MediaRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MediaRegion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeetingId != nil {
		v := *s.MeetingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MeetingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The configuration for resource targets to receive notifications when Amazon
// Chime SDK meeting and attendee events occur.
type MeetingNotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The SNS topic ARN.
	SnsTopicArn *string `min:"1" type:"string" sensitive:"true"`

	// The SQS queue ARN.
	SqsQueueArn *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s MeetingNotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeetingNotificationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MeetingNotificationConfiguration"}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnsTopicArn", 1))
	}
	if s.SqsQueueArn != nil && len(*s.SqsQueueArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SqsQueueArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MeetingNotificationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.SnsTopicArn != nil {
		v := *s.SnsTopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SnsTopicArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SqsQueueArn != nil {
		v := *s.SqsQueueArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SqsQueueArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The member details, such as email address, name, member ID, and member type.
type Member struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The member email address.
	Email *string `type:"string" sensitive:"true"`

	// The member name.
	FullName *string `type:"string" sensitive:"true"`

	// The member ID (user ID or bot ID).
	MemberId *string `type:"string"`

	// The member type.
	MemberType MemberType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FullName != nil {
		v := *s.FullName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FullName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.MemberType) > 0 {
		v := s.MemberType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The list of errors returned when a member action results in an error.
type MemberError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The member ID.
	MemberId *string `type:"string"`
}

// String returns the string representation
func (s MemberError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MemberError) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Membership details, such as member ID and member role.
type MembershipItem struct {
	_ struct{} `type:"structure"`

	// The member ID.
	MemberId *string `type:"string"`

	// The member role.
	Role RoomMembershipRole `type:"string" enum:"true"`
}

// String returns the string representation
func (s MembershipItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MembershipItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A phone number for which an order has been placed.
type OrderedPhoneNumber struct {
	_ struct{} `type:"structure"`

	// The phone number, in E.164 format.
	E164PhoneNumber *string `type:"string" sensitive:"true"`

	// The phone number status.
	Status OrderedPhoneNumberStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s OrderedPhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OrderedPhoneNumber) MarshalFields(e protocol.FieldEncoder) error {
	if s.E164PhoneNumber != nil {
		v := *s.E164PhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "E164PhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Origination settings enable your SIP hosts to receive inbound calls using
// your Amazon Chime Voice Connector.
type Origination struct {
	_ struct{} `type:"structure"`

	// When origination settings are disabled, inbound calls are not enabled for
	// your Amazon Chime Voice Connector.
	Disabled *bool `type:"boolean"`

	// The call distribution properties defined for your SIP hosts. Valid range:
	// Minimum value of 1. Maximum value of 20.
	Routes []OriginationRoute `type:"list"`
}

// String returns the string representation
func (s Origination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Origination"}
	if s.Routes != nil {
		for i, v := range s.Routes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Routes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Origination) MarshalFields(e protocol.FieldEncoder) error {
	if s.Disabled != nil {
		v := *s.Disabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Disabled", protocol.BoolValue(v), metadata)
	}
	if s.Routes != nil {
		v := s.Routes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Routes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Origination routes define call distribution properties for your SIP hosts
// to receive inbound calls using your Amazon Chime Voice Connector. Limit:
// Ten origination routes for each Amazon Chime Voice Connector.
type OriginationRoute struct {
	_ struct{} `type:"structure"`

	// The FQDN or IP address to contact for origination traffic.
	Host *string `type:"string"`

	// The designated origination route port. Defaults to 5060.
	Port *int64 `type:"integer"`

	// The priority associated with the host, with 1 being the highest priority.
	// Higher priority hosts are attempted first.
	Priority *int64 `min:"1" type:"integer"`

	// The protocol to use for the origination route. Encryption-enabled Amazon
	// Chime Voice Connectors use TCP protocol by default.
	Protocol OriginationRouteProtocol `type:"string" enum:"true"`

	// The weight associated with the host. If hosts are equal in priority, calls
	// are distributed among them based on their relative weight.
	Weight *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s OriginationRoute) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginationRoute) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OriginationRoute"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Priority", 1))
	}
	if s.Weight != nil && *s.Weight < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Weight", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OriginationRoute) MarshalFields(e protocol.FieldEncoder) error {
	if s.Host != nil {
		v := *s.Host

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Host", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if len(s.Protocol) > 0 {
		v := s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Weight != nil {
		v := *s.Weight

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Weight", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A phone number used for Amazon Chime Business Calling or an Amazon Chime
// Voice Connector.
type PhoneNumber struct {
	_ struct{} `type:"structure"`

	// The phone number associations.
	Associations []PhoneNumberAssociation `type:"list"`

	// The outbound calling name associated with the phone number.
	CallingName *string `type:"string" sensitive:"true"`

	// The outbound calling name status.
	CallingNameStatus CallingNameStatus `type:"string" enum:"true"`

	// The phone number capabilities.
	Capabilities *PhoneNumberCapabilities `type:"structure"`

	// The phone number creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The deleted phone number timestamp, in ISO 8601 format.
	DeletionTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The phone number, in E.164 format.
	E164PhoneNumber *string `type:"string" sensitive:"true"`

	// The phone number ID.
	PhoneNumberId *string `type:"string"`

	// The phone number product type.
	ProductType PhoneNumberProductType `type:"string" enum:"true"`

	// The phone number status.
	Status PhoneNumberStatus `type:"string" enum:"true"`

	// The phone number type.
	Type PhoneNumberType `type:"string" enum:"true"`

	// The updated phone number timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s PhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumber) MarshalFields(e protocol.FieldEncoder) error {
	if s.Associations != nil {
		v := s.Associations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Associations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CallingName != nil {
		v := *s.CallingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CallingNameStatus) > 0 {
		v := s.CallingNameStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallingNameStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Capabilities != nil {
		v := s.Capabilities

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Capabilities", v, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DeletionTimestamp != nil {
		v := *s.DeletionTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeletionTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.E164PhoneNumber != nil {
		v := *s.E164PhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "E164PhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumberId != nil {
		v := *s.PhoneNumberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductType) > 0 {
		v := s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The phone number associations, such as Amazon Chime account ID, Amazon Chime
// user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector
// group ID.
type PhoneNumberAssociation struct {
	_ struct{} `type:"structure"`

	// The timestamp of the phone number association, in ISO 8601 format.
	AssociatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Defines the association with an Amazon Chime account ID, user ID, Amazon
	// Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.
	Name PhoneNumberAssociationName `type:"string" enum:"true"`

	// Contains the ID for the entity specified in Name.
	Value *string `type:"string"`
}

// String returns the string representation
func (s PhoneNumberAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociatedTimestamp != nil {
		v := *s.AssociatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.Name) > 0 {
		v := s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The phone number capabilities for Amazon Chime Business Calling phone numbers,
// such as enabled inbound and outbound calling and text messaging.
type PhoneNumberCapabilities struct {
	_ struct{} `type:"structure"`

	// Allows or denies inbound calling for the specified phone number.
	InboundCall *bool `type:"boolean"`

	// Allows or denies inbound MMS messaging for the specified phone number.
	InboundMMS *bool `type:"boolean"`

	// Allows or denies inbound SMS messaging for the specified phone number.
	InboundSMS *bool `type:"boolean"`

	// Allows or denies outbound calling for the specified phone number.
	OutboundCall *bool `type:"boolean"`

	// Allows or denies outbound MMS messaging for the specified phone number.
	OutboundMMS *bool `type:"boolean"`

	// Allows or denies outbound SMS messaging for the specified phone number.
	OutboundSMS *bool `type:"boolean"`
}

// String returns the string representation
func (s PhoneNumberCapabilities) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberCapabilities) MarshalFields(e protocol.FieldEncoder) error {
	if s.InboundCall != nil {
		v := *s.InboundCall

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboundCall", protocol.BoolValue(v), metadata)
	}
	if s.InboundMMS != nil {
		v := *s.InboundMMS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboundMMS", protocol.BoolValue(v), metadata)
	}
	if s.InboundSMS != nil {
		v := *s.InboundSMS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboundSMS", protocol.BoolValue(v), metadata)
	}
	if s.OutboundCall != nil {
		v := *s.OutboundCall

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutboundCall", protocol.BoolValue(v), metadata)
	}
	if s.OutboundMMS != nil {
		v := *s.OutboundMMS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutboundMMS", protocol.BoolValue(v), metadata)
	}
	if s.OutboundSMS != nil {
		v := *s.OutboundSMS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutboundSMS", protocol.BoolValue(v), metadata)
	}
	return nil
}

// If the phone number action fails for one or more of the phone numbers in
// the request, a list of the phone numbers is returned, along with error codes
// and error messages.
type PhoneNumberError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The phone number ID for which the action failed.
	PhoneNumberId *string `type:"string"`
}

// String returns the string representation
func (s PhoneNumberError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberError) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumberId != nil {
		v := *s.PhoneNumberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details of a phone number order created for Amazon Chime.
type PhoneNumberOrder struct {
	_ struct{} `type:"structure"`

	// The phone number order creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ordered phone number details, such as the phone number in E.164 format
	// and the phone number status.
	OrderedPhoneNumbers []OrderedPhoneNumber `type:"list"`

	// The phone number order ID.
	PhoneNumberOrderId *string `type:"string"`

	// The phone number order product type.
	ProductType PhoneNumberProductType `type:"string" enum:"true"`

	// The status of the phone number order.
	Status PhoneNumberOrderStatus `type:"string" enum:"true"`

	// The updated phone number order timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s PhoneNumberOrder) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PhoneNumberOrder) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.OrderedPhoneNumbers != nil {
		v := s.OrderedPhoneNumbers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "OrderedPhoneNumbers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PhoneNumberOrderId != nil {
		v := *s.PhoneNumberOrderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumberOrderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductType) > 0 {
		v := s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The Amazon Chime chat room details.
type Room struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The identifier of the room creator.
	CreatedBy *string `type:"string"`

	// The room creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The room name.
	Name *string `type:"string" sensitive:"true"`

	// The room ID.
	RoomId *string `type:"string"`

	// The room update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Room) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Room) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedBy != nil {
		v := *s.CreatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The room membership details.
type RoomMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the user that invited the room member.
	InvitedBy *string `type:"string"`

	// The member details, such as email address, name, member ID, and member type.
	Member *Member `type:"structure"`

	// The membership role.
	Role RoomMembershipRole `type:"string" enum:"true"`

	// The room ID.
	RoomId *string `type:"string"`

	// The room membership update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s RoomMembership) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RoomMembership) MarshalFields(e protocol.FieldEncoder) error {
	if s.InvitedBy != nil {
		v := *s.InvitedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Member != nil {
		v := s.Member

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Member", v, metadata)
	}
	if len(s.Role) > 0 {
		v := s.Role

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Role", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoomId != nil {
		v := *s.RoomId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoomId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The streaming configuration associated with an Amazon Chime Voice Connector.
// Specifies whether media streaming is enabled for sending to Amazon Kinesis,
// and shows the retention period for the Amazon Kinesis data, in hours.
type StreamingConfiguration struct {
	_ struct{} `type:"structure"`

	// The retention period, in hours, for the Amazon Kinesis data.
	//
	// DataRetentionInHours is a required field
	DataRetentionInHours *int64 `type:"integer" required:"true"`

	// When true, media streaming to Amazon Kinesis is turned off.
	Disabled *bool `type:"boolean"`
}

// String returns the string representation
func (s StreamingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StreamingConfiguration"}

	if s.DataRetentionInHours == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataRetentionInHours"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StreamingConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataRetentionInHours != nil {
		v := *s.DataRetentionInHours

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DataRetentionInHours", protocol.Int64Value(v), metadata)
	}
	if s.Disabled != nil {
		v := *s.Disabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Disabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Settings that allow management of telephony permissions for an Amazon Chime
// user, such as inbound and outbound calling and text messaging.
type TelephonySettings struct {
	_ struct{} `type:"structure"`

	// Allows or denies inbound calling.
	//
	// InboundCalling is a required field
	InboundCalling *bool `type:"boolean" required:"true"`

	// Allows or denies outbound calling.
	//
	// OutboundCalling is a required field
	OutboundCalling *bool `type:"boolean" required:"true"`

	// Allows or denies SMS messaging.
	//
	// SMS is a required field
	SMS *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TelephonySettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TelephonySettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TelephonySettings"}

	if s.InboundCalling == nil {
		invalidParams.Add(aws.NewErrParamRequired("InboundCalling"))
	}

	if s.OutboundCalling == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutboundCalling"))
	}

	if s.SMS == nil {
		invalidParams.Add(aws.NewErrParamRequired("SMS"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TelephonySettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.InboundCalling != nil {
		v := *s.InboundCalling

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InboundCalling", protocol.BoolValue(v), metadata)
	}
	if s.OutboundCalling != nil {
		v := *s.OutboundCalling

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutboundCalling", protocol.BoolValue(v), metadata)
	}
	if s.SMS != nil {
		v := *s.SMS

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SMS", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Termination settings enable your SIP hosts to make outbound calls using your
// Amazon Chime Voice Connector.
type Termination struct {
	_ struct{} `type:"structure"`

	// The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
	CallingRegions []string `type:"list"`

	// The IP addresses allowed to make calls, in CIDR format. Required.
	CidrAllowedList []string `type:"list"`

	// The limit on calls per second. Max value based on account service limit.
	// Default value of 1.
	CpsLimit *int64 `min:"1" type:"integer"`

	// The default caller ID phone number.
	DefaultPhoneNumber *string `type:"string" sensitive:"true"`

	// When termination settings are disabled, outbound calls can not be made.
	Disabled *bool `type:"boolean"`
}

// String returns the string representation
func (s Termination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Termination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Termination"}
	if s.CpsLimit != nil && *s.CpsLimit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CpsLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Termination) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallingRegions != nil {
		v := s.CallingRegions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CallingRegions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CidrAllowedList != nil {
		v := s.CidrAllowedList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CidrAllowedList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.CpsLimit != nil {
		v := *s.CpsLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CpsLimit", protocol.Int64Value(v), metadata)
	}
	if s.DefaultPhoneNumber != nil {
		v := *s.DefaultPhoneNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DefaultPhoneNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Disabled != nil {
		v := *s.Disabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Disabled", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The termination health details, including the source IP address and timestamp
// of the last successful SIP OPTIONS message from your SIP infrastructure.
type TerminationHealth struct {
	_ struct{} `type:"structure"`

	// The source IP address.
	Source *string `type:"string"`

	// The timestamp, in ISO 8601 format.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s TerminationHealth) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TerminationHealth) MarshalFields(e protocol.FieldEncoder) error {
	if s.Source != nil {
		v := *s.Source

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Source", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The phone number ID, product type, or calling name fields to update, used
// with the BatchUpdatePhoneNumber and UpdatePhoneNumber actions.
type UpdatePhoneNumberRequestItem struct {
	_ struct{} `type:"structure"`

	// The outbound calling name to update.
	CallingName *string `type:"string" sensitive:"true"`

	// The phone number ID to update.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `type:"string" required:"true"`

	// The product type to update.
	ProductType PhoneNumberProductType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdatePhoneNumberRequestItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberRequestItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdatePhoneNumberRequestItem"}

	if s.PhoneNumberId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PhoneNumberId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdatePhoneNumberRequestItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallingName != nil {
		v := *s.CallingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PhoneNumberId != nil {
		v := *s.PhoneNumberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PhoneNumberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductType) > 0 {
		v := s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The user ID and user fields to update, used with the BatchUpdateUser action.
type UpdateUserRequestItem struct {
	_ struct{} `type:"structure"`

	// The user license type.
	LicenseType License `type:"string" enum:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserRequestItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserRequestItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateUserRequestItem"}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateUserRequestItem) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.LicenseType) > 0 {
		v := s.LicenseType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LicenseType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The user on the Amazon Chime account.
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The display name of the user.
	DisplayName *string `type:"string" sensitive:"true"`

	// Date and time when the user is invited to the Amazon Chime account, in ISO
	// 8601 format.
	InvitedOn *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The license type for the user.
	LicenseType License `type:"string" enum:"true"`

	// The user's personal meeting PIN.
	PersonalPIN *string `type:"string"`

	// The primary email address of the user.
	PrimaryEmail *string `type:"string" sensitive:"true"`

	// The primary phone number associated with the user.
	PrimaryProvisionedNumber *string `type:"string" sensitive:"true"`

	// Date and time when the user is registered, in ISO 8601 format.
	RegisteredOn *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`

	// The user invite status.
	UserInvitationStatus InviteStatus `type:"string" enum:"true"`

	// The user registration status.
	UserRegistrationStatus RegistrationStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s User) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedOn != nil {
		v := *s.InvitedOn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitedOn",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.LicenseType) > 0 {
		v := s.LicenseType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LicenseType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PersonalPIN != nil {
		v := *s.PersonalPIN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PersonalPIN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrimaryEmail != nil {
		v := *s.PrimaryEmail

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrimaryEmail", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrimaryProvisionedNumber != nil {
		v := *s.PrimaryProvisionedNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrimaryProvisionedNumber", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegisteredOn != nil {
		v := *s.RegisteredOn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RegisteredOn",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.UserInvitationStatus) > 0 {
		v := s.UserInvitationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserInvitationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.UserRegistrationStatus) > 0 {
		v := s.UserRegistrationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserRegistrationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The list of errors returned when errors are encountered during the BatchSuspendUser,
// BatchUnsuspendUser, or BatchUpdateUser actions. This includes user IDs, error
// codes, and error messages.
type UserError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The user ID for which the action failed.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s UserError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserError) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Settings associated with an Amazon Chime user, including inbound and outbound
// calling and text messaging.
type UserSettings struct {
	_ struct{} `type:"structure"`

	// The telephony settings associated with the user.
	//
	// Telephony is a required field
	Telephony *TelephonySettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UserSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserSettings"}

	if s.Telephony == nil {
		invalidParams.Add(aws.NewErrParamRequired("Telephony"))
	}
	if s.Telephony != nil {
		if err := s.Telephony.Validate(); err != nil {
			invalidParams.AddNested("Telephony", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UserSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.Telephony != nil {
		v := s.Telephony

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Telephony", v, metadata)
	}
	return nil
}

// The Amazon Chime Voice Connector configuration, including outbound host name
// and encryption settings.
type VoiceConnector struct {
	_ struct{} `type:"structure"`

	// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
	// us-east-1.
	AwsRegion VoiceConnectorAwsRegion `type:"string" enum:"true"`

	// The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the Amazon Chime Voice Connector.
	Name *string `min:"1" type:"string"`

	// The outbound host name for the Amazon Chime Voice Connector.
	OutboundHostName *string `type:"string"`

	// Designates whether encryption is required for the Amazon Chime Voice Connector.
	RequireEncryption *bool `type:"boolean"`

	// The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Chime Voice Connector ID.
	VoiceConnectorId *string `type:"string"`
}

// String returns the string representation
func (s VoiceConnector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceConnector) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AwsRegion) > 0 {
		v := s.AwsRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AwsRegion", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutboundHostName != nil {
		v := *s.OutboundHostName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutboundHostName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequireEncryption != nil {
		v := *s.RequireEncryption

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequireEncryption", protocol.BoolValue(v), metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The Amazon Chime Voice Connector group configuration, including associated
// Amazon Chime Voice Connectors. You can include Amazon Chime Voice Connectors
// from different AWS Regions in your group. This creates a fault tolerant mechanism
// for fallback in case of availability events.
type VoiceConnectorGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the Amazon Chime Voice Connector group.
	Name *string `min:"1" type:"string"`

	// The updated Amazon Chime Voice Connector group timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Chime Voice Connector group ID.
	VoiceConnectorGroupId *string `type:"string"`

	// The Amazon Chime Voice Connectors to which to route inbound calls.
	VoiceConnectorItems []VoiceConnectorItem `type:"list"`
}

// String returns the string representation
func (s VoiceConnectorGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceConnectorGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTimestamp != nil {
		v := *s.CreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedTimestamp != nil {
		v := *s.UpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedTimestamp",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.VoiceConnectorGroupId != nil {
		v := *s.VoiceConnectorGroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceConnectorGroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VoiceConnectorItems != nil {
		v := s.VoiceConnectorItems

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VoiceConnectorItems", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors
// to which to route inbound calls. Includes priority configuration settings.
// Limit: 3 VoiceConnectorItems per Amazon Chime Voice Connector group.
type VoiceConnectorItem struct {
	_ struct{} `type:"structure"`

	// The priority associated with the Amazon Chime Voice Connector, with 1 being
	// the highest priority. Higher priority Amazon Chime Voice Connectors are attempted
	// first.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VoiceConnectorItem) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VoiceConnectorItem) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VoiceConnectorItem"}

	if s.Priority == nil {
		invalidParams.Add(aws.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Priority", 1))
	}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceConnectorItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.Priority != nil {
		v := *s.Priority

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Priority", protocol.Int64Value(v), metadata)
	}
	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VoiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets
// designated for storing call detail records.
type VoiceConnectorSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string `type:"string"`
}

// String returns the string representation
func (s VoiceConnectorSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VoiceConnectorSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.CdrBucket != nil {
		v := *s.CdrBucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CdrBucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
