// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type MergeBranchesBySquashInput struct {
	_ struct{} `type:"structure"`

	// The name of the author who created the commit. This information is used as
	// both the author and committer for the commit.
	AuthorName *string `locationName:"authorName" type:"string"`

	// The commit message for the merge.
	CommitMessage *string `locationName:"commitMessage" type:"string"`

	// The level of conflict detail to use. If unspecified, the default FILE_LEVEL
	// is used, which returns a not-mergeable result if the same file has differences
	// in both branches. If LINE_LEVEL is specified, a conflict is considered not
	// mergeable if the same file in both branches has differences on the same line.
	ConflictDetailLevel ConflictDetailLevelTypeEnum `locationName:"conflictDetailLevel" type:"string" enum:"true"`

	// If AUTOMERGE is the conflict resolution strategy, a list of inputs to use
	// when resolving conflicts during a merge.
	ConflictResolution *ConflictResolution `locationName:"conflictResolution" type:"structure"`

	// Specifies which branch to use when resolving conflicts, or whether to attempt
	// automatically merging two versions of a file. The default is NONE, which
	// requires any conflicts to be resolved manually before the merge operation
	// is successful.
	ConflictResolutionStrategy ConflictResolutionStrategyTypeEnum `locationName:"conflictResolutionStrategy" type:"string" enum:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit (for example, a branch name or a full commit ID).
	//
	// DestinationCommitSpecifier is a required field
	DestinationCommitSpecifier *string `locationName:"destinationCommitSpecifier" type:"string" required:"true"`

	// The email address of the person merging the branches. This information is
	// used in the commit information for the merge.
	Email *string `locationName:"email" type:"string"`

	// If the commit contains deletions, whether to keep a folder or folder structure
	// if the changes leave the folders empty. If this is specified as true, a .gitkeep
	// file is created for empty folders. The default is false.
	KeepEmptyFolders *bool `locationName:"keepEmptyFolders" type:"boolean"`

	// The name of the repository where you want to merge two branches.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit (for example, a branch name or a full commit ID).
	//
	// SourceCommitSpecifier is a required field
	SourceCommitSpecifier *string `locationName:"sourceCommitSpecifier" type:"string" required:"true"`

	// The branch where the merge is applied.
	TargetBranch *string `locationName:"targetBranch" min:"1" type:"string"`
}

// String returns the string representation
func (s MergeBranchesBySquashInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeBranchesBySquashInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MergeBranchesBySquashInput"}

	if s.DestinationCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCommitSpecifier"))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if s.SourceCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceCommitSpecifier"))
	}
	if s.TargetBranch != nil && len(*s.TargetBranch) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetBranch", 1))
	}
	if s.ConflictResolution != nil {
		if err := s.ConflictResolution.Validate(); err != nil {
			invalidParams.AddNested("ConflictResolution", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type MergeBranchesBySquashOutput struct {
	_ struct{} `type:"structure"`

	// The commit ID of the merge in the destination or target branch.
	CommitId *string `locationName:"commitId" type:"string"`

	// The tree ID of the merge in the destination or target branch.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s MergeBranchesBySquashOutput) String() string {
	return awsutil.Prettify(s)
}

const opMergeBranchesBySquash = "MergeBranchesBySquash"

// MergeBranchesBySquashRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Merges two branches using the squash merge strategy.
//
//    // Example sending a request using MergeBranchesBySquashRequest.
//    req := client.MergeBranchesBySquashRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesBySquash
func (c *Client) MergeBranchesBySquashRequest(input *MergeBranchesBySquashInput) MergeBranchesBySquashRequest {
	op := &aws.Operation{
		Name:       opMergeBranchesBySquash,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergeBranchesBySquashInput{}
	}

	req := c.newRequest(op, input, &MergeBranchesBySquashOutput{})
	return MergeBranchesBySquashRequest{Request: req, Input: input, Copy: c.MergeBranchesBySquashRequest}
}

// MergeBranchesBySquashRequest is the request type for the
// MergeBranchesBySquash API operation.
type MergeBranchesBySquashRequest struct {
	*aws.Request
	Input *MergeBranchesBySquashInput
	Copy  func(*MergeBranchesBySquashInput) MergeBranchesBySquashRequest
}

// Send marshals and sends the MergeBranchesBySquash API request.
func (r MergeBranchesBySquashRequest) Send(ctx context.Context) (*MergeBranchesBySquashResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &MergeBranchesBySquashResponse{
		MergeBranchesBySquashOutput: r.Request.Data.(*MergeBranchesBySquashOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// MergeBranchesBySquashResponse is the response type for the
// MergeBranchesBySquash API operation.
type MergeBranchesBySquashResponse struct {
	*MergeBranchesBySquashOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// MergeBranchesBySquash request.
func (r *MergeBranchesBySquashResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
