// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to update the device status.
type UpdateDeviceStatusInput struct {
	_ struct{} `type:"structure"`

	// The access token.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true" sensitive:"true"`

	// The device key.
	//
	// DeviceKey is a required field
	DeviceKey *string `min:"1" type:"string" required:"true"`

	// The status of whether a device is remembered.
	DeviceRememberedStatus DeviceRememberedStatusType `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateDeviceStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeviceStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDeviceStatusInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if s.DeviceKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceKey"))
	}
	if s.DeviceKey != nil && len(*s.DeviceKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to the request to update the device status.
type UpdateDeviceStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDeviceStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDeviceStatus = "UpdateDeviceStatus"

// UpdateDeviceStatusRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Updates the device status.
//
//    // Example sending a request using UpdateDeviceStatusRequest.
//    req := client.UpdateDeviceStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/UpdateDeviceStatus
func (c *Client) UpdateDeviceStatusRequest(input *UpdateDeviceStatusInput) UpdateDeviceStatusRequest {
	op := &aws.Operation{
		Name:       opUpdateDeviceStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeviceStatusInput{}
	}

	req := c.newRequest(op, input, &UpdateDeviceStatusOutput{})
	return UpdateDeviceStatusRequest{Request: req, Input: input, Copy: c.UpdateDeviceStatusRequest}
}

// UpdateDeviceStatusRequest is the request type for the
// UpdateDeviceStatus API operation.
type UpdateDeviceStatusRequest struct {
	*aws.Request
	Input *UpdateDeviceStatusInput
	Copy  func(*UpdateDeviceStatusInput) UpdateDeviceStatusRequest
}

// Send marshals and sends the UpdateDeviceStatus API request.
func (r UpdateDeviceStatusRequest) Send(ctx context.Context) (*UpdateDeviceStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDeviceStatusResponse{
		UpdateDeviceStatusOutput: r.Request.Data.(*UpdateDeviceStatusOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDeviceStatusResponse is the response type for the
// UpdateDeviceStatus API operation.
type UpdateDeviceStatusResponse struct {
	*UpdateDeviceStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDeviceStatus request.
func (r *UpdateDeviceStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
