// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package costexplorer

import (
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

//
//  Cost Category is in preview release for AWS Billing and Cost Management
//  and is subject to change. Your use of Cost Categories is subject to the
//  Beta Service Participation terms of the AWS Service Terms (https://aws.amazon.com/service-terms/)
//  (Section 1.10).
//
// The structure of Cost Categories. This includes detailed metadata and the
// set of rules for the CostCategory object.
type CostCategory struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category.
	//
	// CostCategoryArn is a required field
	CostCategoryArn *string `min:"20" type:"string" required:"true"`

	// The Cost Category's effective end date.
	EffectiveEnd *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	//
	// EffectiveStart is a required field
	EffectiveStart *string `min:"20" type:"string" required:"true"`

	// The unique name of the Cost Category.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The rule schema version in this particular Cost Category.
	//
	// RuleVersion is a required field
	RuleVersion CostCategoryRuleVersion `type:"string" required:"true" enum:"true"`

	// Rules are processed in order. If there are multiple rules that match the
	// line item, then the first rule to match is used to determine that Cost Category
	// value.
	//
	// Rules is a required field
	Rules []CostCategoryRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CostCategory) String() string {
	return awsutil.Prettify(s)
}

//
//  Cost Category is in preview release for AWS Billing and Cost Management
//  and is subject to change. Your use of Cost Categories is subject to the
//  Beta Service Participation terms of the AWS Service Terms (https://aws.amazon.com/service-terms/)
//  (Section 1.10).
//
// A reference to a Cost Category containing only enough information to identify
// the Cost Category.
//
// You can use this information to retrieve the full Cost Category information
// using DescribeCostCategory.
type CostCategoryReference struct {
	_ struct{} `type:"structure"`

	// The unique identifier for your Cost Category Reference.
	CostCategoryArn *string `min:"20" type:"string"`

	// The Cost Category's effective end date.
	EffectiveEnd *string `min:"20" type:"string"`

	// The Cost Category's effective start date.
	EffectiveStart *string `min:"20" type:"string"`

	// The unique name of the Cost Category.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CostCategoryReference) String() string {
	return awsutil.Prettify(s)
}

//
//  Cost Category is in preview release for AWS Billing and Cost Management
//  and is subject to change. Your use of Cost Categories is subject to the
//  Beta Service Participation terms of the AWS Service Terms (https://aws.amazon.com/service-terms/)
//  (Section 1.10).
//
// Rules are processed in order. If there are multiple rules that match the
// line item, then the first rule to match is used to determine that Cost Category
// value.
type CostCategoryRule struct {
	_ struct{} `type:"structure"`

	// An Expression (http://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html)
	// object used to categorize costs. This supports dimensions, Tags, and nested
	// expressions. Currently the only dimensions supported is LINKED_ACCOUNT.
	//
	// Root level OR is not supported. We recommend you create a separate rule instead.
	//
	// Rule is a required field
	Rule *Expression `type:"structure" required:"true"`

	// The value a line item will be categorized as, if it matches the rule.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CostCategoryRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategoryRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CostCategoryRule"}

	if s.Rule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rule"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

//
//  Cost Category is in preview release for AWS Billing and Cost Management
//  and is subject to change. Your use of Cost Categories is subject to the
//  Beta Service Participation terms of the AWS Service Terms (https://aws.amazon.com/service-terms/)
//  (Section 1.10).
//
// The values that are available for Cost Categories.
type CostCategoryValues struct {
	_ struct{} `type:"structure"`

	// The unique name of the Cost Category.
	Key *string `min:"1" type:"string"`

	// The specific value of the Cost Category.
	Values []string `type:"list"`
}

// String returns the string representation
func (s CostCategoryValues) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CostCategoryValues) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CostCategoryValues"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The amount of instance usage that a reservation covered.
type Coverage struct {
	_ struct{} `type:"structure"`

	// The amount of cost that the reservation covered.
	CoverageCost *CoverageCost `type:"structure"`

	// The amount of instance usage that the reservation covered, in hours.
	CoverageHours *CoverageHours `type:"structure"`

	// The amount of instance usage that the reservation covered, in normalized
	// units.
	CoverageNormalizedUnits *CoverageNormalizedUnits `type:"structure"`
}

// String returns the string representation
func (s Coverage) String() string {
	return awsutil.Prettify(s)
}

// Reservation coverage for a specified period, in hours.
type CoverageByTime struct {
	_ struct{} `type:"structure"`

	// The groups of instances that the reservation covered.
	Groups []ReservationCoverageGroup `type:"list"`

	// The period that this coverage was used over.
	TimePeriod *DateInterval `type:"structure"`

	// The total reservation coverage, in hours.
	Total *Coverage `type:"structure"`
}

// String returns the string representation
func (s CoverageByTime) String() string {
	return awsutil.Prettify(s)
}

// How much it cost to run an instance.
type CoverageCost struct {
	_ struct{} `type:"structure"`

	// How much an On-Demand instance cost.
	OnDemandCost *string `type:"string"`
}

// String returns the string representation
func (s CoverageCost) String() string {
	return awsutil.Prettify(s)
}

// How long a running instance either used a reservation or was On-Demand.
type CoverageHours struct {
	_ struct{} `type:"structure"`

	// The percentage of instance hours that a reservation covered.
	CoverageHoursPercentage *string `type:"string"`

	// The number of instance running hours that On-Demand Instances covered.
	OnDemandHours *string `type:"string"`

	// The number of instance running hours that reservations covered.
	ReservedHours *string `type:"string"`

	// The total instance usage, in hours.
	TotalRunningHours *string `type:"string"`
}

// String returns the string representation
func (s CoverageHours) String() string {
	return awsutil.Prettify(s)
}

// The amount of instance usage, in normalized units. Normalized units enable
// you to see your EC2 usage for multiple sizes of instances in a uniform way.
// For example, suppose you run an xlarge instance and a 2xlarge instance. If
// you run both instances for the same amount of time, the 2xlarge instance
// uses twice as much of your reservation as the xlarge instance, even though
// both instances show only one instance-hour. Using normalized units instead
// of instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge
// instance used 16 normalized units.
//
// For more information, see Modifying Reserved Instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
type CoverageNormalizedUnits struct {
	_ struct{} `type:"structure"`

	// The percentage of your used instance normalized units that a reservation
	// covers.
	CoverageNormalizedUnitsPercentage *string `type:"string"`

	// The number of normalized units that are covered by On-Demand Instances instead
	// of a reservation.
	OnDemandNormalizedUnits *string `type:"string"`

	// The number of normalized units that a reservation covers.
	ReservedNormalizedUnits *string `type:"string"`

	// The total number of normalized units that you used.
	TotalRunningNormalizedUnits *string `type:"string"`
}

// String returns the string representation
func (s CoverageNormalizedUnits) String() string {
	return awsutil.Prettify(s)
}

// Context about the current instance.
type CurrentInstance struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// Current On Demand cost of operating this instance on a monthly basis.
	MonthlyCost *string `type:"string"`

	// Number of hours during the lookback period billed at On Demand rates.
	OnDemandHoursInLookbackPeriod *string `type:"string"`

	// Number of hours during the lookback period covered by reservations.
	ReservationCoveredHoursInLookbackPeriod *string `type:"string"`

	// Details about the resource and utilization.
	ResourceDetails *ResourceDetails `type:"structure"`

	// Resource ID of the current instance.
	ResourceId *string `type:"string"`

	// Utilization information of the current instance during the lookback period.
	ResourceUtilization *ResourceUtilization `type:"structure"`

	// Number of hours during the lookback period covered by Savings Plans.
	SavingsPlansCoveredHoursInLookbackPeriod *string `type:"string"`

	// Cost allocation resource tags applied to the instance.
	Tags []TagValues `type:"list"`

	// The total number of hours the instance ran during the lookback period.
	TotalRunningHoursInLookbackPeriod *string `type:"string"`
}

// String returns the string representation
func (s CurrentInstance) String() string {
	return awsutil.Prettify(s)
}

// The time period that you want the usage and costs for.
type DateInterval struct {
	_ struct{} `type:"structure"`

	// The end of the time period that you want the usage and costs for. The end
	// date is exclusive. For example, if end is 2017-05-01, AWS retrieves cost
	// and usage data from the start date up to, but not including, 2017-05-01.
	//
	// End is a required field
	End *string `type:"string" required:"true"`

	// The beginning of the time period that you want the usage and costs for. The
	// start date is inclusive. For example, if start is 2017-01-01, AWS retrieves
	// cost and usage data starting at 2017-01-01 up to the end date.
	//
	// Start is a required field
	Start *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DateInterval) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateInterval) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DateInterval"}

	if s.End == nil {
		invalidParams.Add(aws.NewErrParamRequired("End"))
	}

	if s.Start == nil {
		invalidParams.Add(aws.NewErrParamRequired("Start"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The metadata that you can use to filter and group your results. You can use
// GetDimensionValues to find specific values.
type DimensionValues struct {
	_ struct{} `type:"structure"`

	// The names of the metadata types that you can use to filter and group your
	// results. For example, AZ returns a list of Availability Zones.
	Key Dimension `type:"string" enum:"true"`

	// The metadata values that you can use to filter and group your results. You
	// can use GetDimensionValues to find specific values.
	//
	// Valid values for the SERVICE dimension are Amazon Elastic Compute Cloud -
	// Compute, Amazon Elasticsearch Service, Amazon ElastiCache, Amazon Redshift,
	// and Amazon Relational Database Service.
	Values []string `type:"list"`
}

// String returns the string representation
func (s DimensionValues) String() string {
	return awsutil.Prettify(s)
}

// The metadata of a specific type that you can use to filter and group your
// results. You can use GetDimensionValues to find specific values.
type DimensionValuesWithAttributes struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string `type:"map"`

	// The value of a dimension with a specific attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DimensionValuesWithAttributes) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon EC2 instances that AWS recommends that you purchase.
type EC2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the recommended reservation.
	AvailabilityZone *string `type:"string"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`

	// Whether the recommended reservation is dedicated or shared.
	Tenancy *string `type:"string"`
}

// String returns the string representation
func (s EC2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Details on the Amazon EC2 Resource.
type EC2ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Hourly public On Demand rate for the instance type.
	HourlyOnDemandRate *string `type:"string"`

	// The type of Amazon Web Services instance.
	InstanceType *string `type:"string"`

	// Memory capacity of Amazon Web Services instance.
	Memory *string `type:"string"`

	// Network performance capacity of the Amazon Web Services instance.
	NetworkPerformance *string `type:"string"`

	// The platform of the Amazon Web Services instance. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string `type:"string"`

	// The Amazon Web Services Region of the instance.
	Region *string `type:"string"`

	// The SKU of the product.
	Sku *string `type:"string"`

	// The disk storage of the Amazon Web Services instance (Not EBS storage).
	Storage *string `type:"string"`

	// Number of VCPU cores in the Amazon Web Services instance type.
	Vcpu *string `type:"string"`
}

// String returns the string representation
func (s EC2ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// Utilization metrics of the instance.
type EC2ResourceUtilization struct {
	_ struct{} `type:"structure"`

	// Maximum observed or expected CPU utilization of the instance.
	MaxCpuUtilizationPercentage *string `type:"string"`

	// Maximum observed or expected memory utilization of the instance.
	MaxMemoryUtilizationPercentage *string `type:"string"`

	// Maximum observed or expected storage utilization of the instance (does not
	// measure EBS storage).
	MaxStorageUtilizationPercentage *string `type:"string"`
}

// String returns the string representation
func (s EC2ResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// The Amazon EC2 hardware specifications that you want AWS to provide recommendations
// for.
type EC2Specification struct {
	_ struct{} `type:"structure"`

	// Whether you want a recommendation for standard or convertible reservations.
	OfferingClass OfferingClass `type:"string" enum:"true"`
}

// String returns the string representation
func (s EC2Specification) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon ES instances that AWS recommends that you purchase.
type ESInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The class of instance that AWS recommends.
	InstanceClass *string `type:"string"`

	// The size of instance that AWS recommends.
	InstanceSize *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s ESInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon ElastiCache instances that AWS recommends that you
// purchase.
type ElastiCacheInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that AWS recommends.
	NodeType *string `type:"string"`

	// The description of the recommended reservation.
	ProductDescription *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s ElastiCacheInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Use Expression to filter by cost or by usage. There are two patterns:
//
//    * Simple dimension values - You can set the dimension name and values
//    for the filters that you plan to use. For example, you can filter for
//    REGION==us-east-1 OR REGION==us-west-1. The Expression for that looks
//    like this: { "Dimensions": { "Key": "REGION", "Values": [ "us-east-1",
//    “us-west-1” ] } } The list of dimension values are OR'd together to
//    retrieve cost or usage data. You can create Expression and DimensionValues
//    objects using either with* methods or set* methods in multiple lines.
//
//    * Compound dimension values with logical operations - You can use multiple
//    Expression types and the logical operators AND/OR/NOT to create a list
//    of one or more Expression objects. This allows you to filter on more advanced
//    options. For example, you can filter on ((REGION == us-east-1 OR REGION
//    == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer).
//    The Expression for that looks like this: { "And": [ {"Or": [ {"Dimensions":
//    { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags":
//    { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions":
//    { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } Because each
//    Expression can have only one operator, the service returns an error if
//    more than one is specified. The following example shows an Expression
//    object that creates an error. { "And": [ ... ], "DimensionValues": { "Dimension":
//    "USAGE_TYPE", "Values": [ "DataTransfer" ] } }
//
// For GetRightsizingRecommendation action, a combination of OR and NOT is not
// supported. OR is not supported between different dimensions, or dimensions
// and tags. NOT operators aren't supported. Dimensions are also limited to
// LINKED_ACCOUNT, REGION, or RIGHTSIZING_TYPE.
type Expression struct {
	_ struct{} `type:"structure"`

	// Return results that match both Dimension objects.
	And []Expression `type:"list"`

	//  Cost Category is in preview release for AWS Billing and Cost Management
	//  and is subject to change. Your use of Cost Categories is subject to the
	//  Beta Service Participation terms of the AWS Service Terms (https://aws.amazon.com/service-terms/)
	//  (Section 1.10).
	//
	// The specific CostCategory used for Expression.
	CostCategories *CostCategoryValues `type:"structure"`

	// The specific Dimension to use for Expression.
	Dimensions *DimensionValues `type:"structure"`

	// Return results that don't match a Dimension object.
	Not *Expression `type:"structure"`

	// Return results that match either Dimension object.
	Or []Expression `type:"list"`

	// The specific Tag to use for Expression.
	Tags *TagValues `type:"structure"`
}

// String returns the string representation
func (s Expression) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Expression) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Expression"}
	if s.CostCategories != nil {
		if err := s.CostCategories.Validate(); err != nil {
			invalidParams.AddNested("CostCategories", err.(aws.ErrInvalidParams))
		}
	}
	if s.Not != nil {
		if err := s.Not.Validate(); err != nil {
			invalidParams.AddNested("Not", err.(aws.ErrInvalidParams))
		}
	}
	if s.Or != nil {
		for i, v := range s.Or {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Or", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The forecast created for your query.
type ForecastResult struct {
	_ struct{} `type:"structure"`

	// The mean value of the forecast.
	MeanValue *string `type:"string"`

	// The lower limit for the prediction interval.
	PredictionIntervalLowerBound *string `type:"string"`

	// The upper limit for the prediction interval.
	PredictionIntervalUpperBound *string `type:"string"`

	// The period of time that the forecast covers.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s ForecastResult) String() string {
	return awsutil.Prettify(s)
}

// One level of grouped data in the results.
type Group struct {
	_ struct{} `type:"structure"`

	// The keys that are included in this group.
	Keys []string `type:"list"`

	// The metrics that are included in this group.
	Metrics map[string]MetricValue `type:"map"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// Represents a group when you specify a group by criteria or in the response
// to a query with a specific grouping.
type GroupDefinition struct {
	_ struct{} `type:"structure"`

	// The string that represents a key for a specified group.
	Key *string `type:"string"`

	// The string that represents the type of group.
	Type GroupDefinitionType `type:"string" enum:"true"`
}

// String returns the string representation
func (s GroupDefinition) String() string {
	return awsutil.Prettify(s)
}

// Details about the instances that AWS recommends that you purchase.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 instances that AWS recommends that you purchase.
	EC2InstanceDetails *EC2InstanceDetails `type:"structure"`

	// The Amazon ES instances that AWS recommends that you purchase.
	ESInstanceDetails *ESInstanceDetails `type:"structure"`

	// The ElastiCache instances that AWS recommends that you purchase.
	ElastiCacheInstanceDetails *ElastiCacheInstanceDetails `type:"structure"`

	// The Amazon RDS instances that AWS recommends that you purchase.
	RDSInstanceDetails *RDSInstanceDetails `type:"structure"`

	// The Amazon Redshift instances that AWS recommends that you purchase.
	RedshiftInstanceDetails *RedshiftInstanceDetails `type:"structure"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// The aggregated value for a metric.
type MetricValue struct {
	_ struct{} `type:"structure"`

	// The actual number that represents the metric.
	Amount *string `type:"string"`

	// The unit that the metric is given in.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s MetricValue) String() string {
	return awsutil.Prettify(s)
}

// Details on the modification recommendation.
type ModifyRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// Identifies whether this instance type is the Amazon Web Services default
	// recommendation.
	TargetInstances []TargetInstance `type:"list"`
}

// String returns the string representation
func (s ModifyRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon RDS instances that AWS recommends that you purchase.
type RDSInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string `type:"string"`

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string `type:"string"`

	// Whether the recommendation is for a reservation in a single Availability
	// Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string `type:"string"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of instance that AWS recommends.
	InstanceType *string `type:"string"`

	// The license model that the recommended reservation supports.
	LicenseModel *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s RDSInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// Details about the Amazon Redshift instances that AWS recommends that you
// purchase.
type RedshiftInstanceDetails struct {
	_ struct{} `type:"structure"`

	// Whether the recommendation is for a current-generation instance.
	CurrentGeneration *bool `type:"boolean"`

	// The instance family of the recommended reservation.
	Family *string `type:"string"`

	// The type of node that AWS recommends.
	NodeType *string `type:"string"`

	// The AWS Region of the recommended reservation.
	Region *string `type:"string"`

	// Whether the recommended reservation is size flexible.
	SizeFlexEligible *bool `type:"boolean"`
}

// String returns the string representation
func (s RedshiftInstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// The aggregated numbers for your reservation usage.
type ReservationAggregates struct {
	_ struct{} `type:"structure"`

	// The monthly cost of your reservation, amortized over the reservation period.
	AmortizedRecurringFee *string `type:"string"`

	// The upfront cost of your reservation, amortized over the reservation period.
	AmortizedUpfrontFee *string `type:"string"`

	// How much you saved due to purchasing and utilizing reservation. AWS calculates
	// this by subtracting TotalAmortizedFee from OnDemandCostOfRIHoursUsed.
	NetRISavings *string `type:"string"`

	// How much your reservation would cost if charged On-Demand rates.
	OnDemandCostOfRIHoursUsed *string `type:"string"`

	// How many reservation hours that you purchased.
	PurchasedHours *string `type:"string"`

	// How many Amazon EC2 reservation hours that you purchased, converted to normalized
	// units. Normalized units are available only for Amazon EC2 usage after November
	// 11, 2017.
	PurchasedUnits *string `type:"string"`

	// The total number of reservation hours that you used.
	TotalActualHours *string `type:"string"`

	// The total number of Amazon EC2 reservation hours that you used, converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	TotalActualUnits *string `type:"string"`

	// The total cost of your reservation, amortized over the reservation period.
	TotalAmortizedFee *string `type:"string"`

	// How much you could save if you use your entire reservation.
	TotalPotentialRISavings *string `type:"string"`

	// The number of reservation hours that you didn't use.
	UnusedHours *string `type:"string"`

	// The number of Amazon EC2 reservation hours that you didn't use, converted
	// to normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UnusedUnits *string `type:"string"`

	// The percentage of reservation time that you used.
	UtilizationPercentage *string `type:"string"`

	// The percentage of Amazon EC2 reservation time that you used, converted to
	// normalized units. Normalized units are available only for Amazon EC2 usage
	// after November 11, 2017.
	UtilizationPercentageInUnits *string `type:"string"`
}

// String returns the string representation
func (s ReservationAggregates) String() string {
	return awsutil.Prettify(s)
}

// A group of reservations that share a set of attributes.
type ReservationCoverageGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]string `type:"map"`

	// How much instance usage this group of reservations covered.
	Coverage *Coverage `type:"structure"`
}

// String returns the string representation
func (s ReservationCoverageGroup) String() string {
	return awsutil.Prettify(s)
}

// A specific reservation that AWS recommends for purchase.
type ReservationPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The account scope that AWS recommends that you purchase this instance for.
	// For example, you can purchase this reservation for an entire organization
	// in AWS Organizations.
	AccountScope AccountScope `type:"string" enum:"true"`

	// How many days of previous usage that AWS considers when making this recommendation.
	LookbackPeriodInDays LookbackPeriodInDays `type:"string" enum:"true"`

	// The payment option for the reservation. For example, AllUpfront or NoUpfront.
	PaymentOption PaymentOption `type:"string" enum:"true"`

	// Details about the recommended purchases.
	RecommendationDetails []ReservationPurchaseRecommendationDetail `type:"list"`

	// A summary about the recommended purchase.
	RecommendationSummary *ReservationPurchaseRecommendationSummary `type:"structure"`

	// Hardware specifications for the service that you want recommendations for.
	ServiceSpecification *ServiceSpecification `type:"structure"`

	// The term of the reservation that you want recommendations for, in years.
	TermInYears TermInYears `type:"string" enum:"true"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// Details about your recommended reservation purchase.
type ReservationPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The account that this RI recommendation is for.
	AccountId *string `type:"string"`

	// The average number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	AverageNormalizedUnitsUsedPerHour *string `type:"string"`

	// The average number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	AverageNumberOfInstancesUsedPerHour *string `type:"string"`

	// The average utilization of your instances. AWS uses this to calculate your
	// recommended reservation purchases.
	AverageUtilization *string `type:"string"`

	// The currency code that AWS used to calculate the costs for this instance.
	CurrencyCode *string `type:"string"`

	// How long AWS estimates that it takes for this instance to start saving you
	// money, in months.
	EstimatedBreakEvenInMonths *string `type:"string"`

	// How much AWS estimates that you spend on On-Demand Instances in a month.
	EstimatedMonthlyOnDemandCost *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// How much AWS estimates that this specific recommendation could save you in
	// a month, as a percentage of your overall costs.
	EstimatedMonthlySavingsPercentage *string `type:"string"`

	// How much AWS estimates that you would have spent for all usage during the
	// specified historical period if you had a reservation.
	EstimatedReservationCostForLookbackPeriod *string `type:"string"`

	// Details about the instances that AWS recommends that you purchase.
	InstanceDetails *InstanceDetails `type:"structure"`

	// The maximum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MaximumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The maximum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MaximumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The minimum number of normalized units that you used in an hour during the
	// historical period. AWS uses this to calculate your recommended reservation
	// purchases.
	MinimumNormalizedUnitsUsedPerHour *string `type:"string"`

	// The minimum number of instances that you used in an hour during the historical
	// period. AWS uses this to calculate your recommended reservation purchases.
	MinimumNumberOfInstancesUsedPerHour *string `type:"string"`

	// The number of normalized units that AWS recommends that you purchase.
	RecommendedNormalizedUnitsToPurchase *string `type:"string"`

	// The number of instances that AWS recommends that you purchase.
	RecommendedNumberOfInstancesToPurchase *string `type:"string"`

	// How much purchasing this instance costs you on a monthly basis.
	RecurringStandardMonthlyCost *string `type:"string"`

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// Information about this specific recommendation, such as the time stamp for
// when AWS made a specific recommendation.
type ReservationPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The time stamp for when AWS made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// A summary about this recommendation, such as the currency code, the amount
// that AWS estimates that you could save, and the total amount of reservation
// to purchase.
type ReservationPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code used for this recommendation.
	CurrencyCode *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month.
	TotalEstimatedMonthlySavingsAmount *string `type:"string"`

	// The total amount that AWS estimates that this recommendation could save you
	// in a month, as a percentage of your costs.
	TotalEstimatedMonthlySavingsPercentage *string `type:"string"`
}

// String returns the string representation
func (s ReservationPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// A group of reservations that share a set of attributes.
type ReservationUtilizationGroup struct {
	_ struct{} `type:"structure"`

	// The attributes for this group of reservations.
	Attributes map[string]string `type:"map"`

	// The key for a specific reservation attribute.
	Key *string `type:"string"`

	// How much you used this group of reservations.
	Utilization *ReservationAggregates `type:"structure"`

	// The value of a specific reservation attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ReservationUtilizationGroup) String() string {
	return awsutil.Prettify(s)
}

// Details on the resource.
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// Details on the Amazon EC2 resource.
	EC2ResourceDetails *EC2ResourceDetails `type:"structure"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// Resource utilization of current resource.
type ResourceUtilization struct {
	_ struct{} `type:"structure"`

	// Utilization of current Amazon EC2 Instance
	EC2ResourceUtilization *EC2ResourceUtilization `type:"structure"`
}

// String returns the string representation
func (s ResourceUtilization) String() string {
	return awsutil.Prettify(s)
}

// The result that is associated with a time period.
type ResultByTime struct {
	_ struct{} `type:"structure"`

	// Whether the result is estimated.
	Estimated *bool `type:"boolean"`

	// The groups that this time period includes.
	Groups []Group `type:"list"`

	// The time period that the result covers.
	TimePeriod *DateInterval `type:"structure"`

	// The total amount of cost or usage accrued during the time period.
	Total map[string]MetricValue `type:"map"`
}

// String returns the string representation
func (s ResultByTime) String() string {
	return awsutil.Prettify(s)
}

// Recommendations to rightsize resources.
type RightsizingRecommendation struct {
	_ struct{} `type:"structure"`

	// The account that this recommendation is for.
	AccountId *string `type:"string"`

	// Context regarding the current instance.
	CurrentInstance *CurrentInstance `type:"structure"`

	// Details for modification recommendations.
	ModifyRecommendationDetail *ModifyRecommendationDetail `type:"structure"`

	// Recommendation to either terminate or modify the resource.
	RightsizingType RightsizingType `type:"string" enum:"true"`

	// Details for termination recommendations.
	TerminateRecommendationDetail *TerminateRecommendationDetail `type:"structure"`
}

// String returns the string representation
func (s RightsizingRecommendation) String() string {
	return awsutil.Prettify(s)
}

// Metadata for this recommendation set.
type RightsizingRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The time stamp for when Amazon Web Services made this recommendation.
	GenerationTimestamp *string `type:"string"`

	// How many days of previous usage that Amazon Web Services considers when making
	// this recommendation.
	LookbackPeriodInDays LookbackPeriodInDays `type:"string" enum:"true"`

	// The ID for this specific recommendation.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s RightsizingRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// Summary of rightsizing recommendations
type RightsizingRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// Estimated total savings resulting from modifications, on a monthly basis.
	EstimatedTotalMonthlySavingsAmount *string `type:"string"`

	// The currency code that Amazon Web Services used to calculate the savings.
	SavingsCurrencyCode *string `type:"string"`

	// Savings percentage based on the recommended modifications, relative to the
	// total On Demand costs associated with these instances.
	SavingsPercentage *string `type:"string"`

	// Total number of instance recommendations.
	TotalRecommendationCount *string `type:"string"`
}

// String returns the string representation
func (s RightsizingRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// The amortized amount of Savings Plans purchased in a specific account during
// a specific time interval.
type SavingsPlansAmortizedCommitment struct {
	_ struct{} `type:"structure"`

	// The amortized amount of your Savings Plans commitment that was purchased
	// with either a Partial or a NoUpfront.
	AmortizedRecurringCommitment *string `type:"string"`

	// The amortized amount of your Savings Plans commitment that was purchased
	// with an Upfront or PartialUpfront Savings Plans.
	AmortizedUpfrontCommitment *string `type:"string"`

	// The total amortized amount of your Savings Plans commitment, regardless of
	// your Savings Plans purchase method.
	TotalAmortizedCommitment *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansAmortizedCommitment) String() string {
	return awsutil.Prettify(s)
}

// The amount of Savings Plans eligible usage that is covered by Savings Plans.
// All calculations consider the On-Demand equivalent of your Savings Plans
// usage.
type SavingsPlansCoverage struct {
	_ struct{} `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string `type:"map"`

	// The amount of Savings Plans eligible usage that the Savings Plans covered.
	Coverage *SavingsPlansCoverageData `type:"structure"`

	// The time period that you want the usage and costs for.
	TimePeriod *DateInterval `type:"structure"`
}

// String returns the string representation
func (s SavingsPlansCoverage) String() string {
	return awsutil.Prettify(s)
}

// Specific coverage percentage, On-Demand costs, and spend covered by Savings
// Plans, and total Savings Plans costs for an account.
type SavingsPlansCoverageData struct {
	_ struct{} `type:"structure"`

	// The percentage of your existing Savings Planscovered usage, divided by all
	// of your eligible Savings Plans usage in an account(or set of accounts).
	CoveragePercentage *string `type:"string"`

	// The cost of your Amazon Web Services usage at the public On-Demand rate.
	OnDemandCost *string `type:"string"`

	// The amount of your Amazon Web Services usage that is covered by a Savings
	// Plans.
	SpendCoveredBySavingsPlans *string `type:"string"`

	// The total cost of your Amazon Web Services usage, regardless of your purchase
	// option.
	TotalCost *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansCoverageData) String() string {
	return awsutil.Prettify(s)
}

// Attribute details on a specific Savings Plan.
type SavingsPlansDetails struct {
	_ struct{} `type:"structure"`

	// A group of instance types that Savings Plans applies to.
	InstanceFamily *string `type:"string"`

	// The unique ID used to distinguish Savings Plans from one another.
	OfferingId *string `type:"string"`

	// A collection of AWS resources in a geographic area. Each AWS Region is isolated
	// and independent of the other Regions.
	Region *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansDetails) String() string {
	return awsutil.Prettify(s)
}

// Contains your request parameters, Savings Plan Recommendations Summary, and
// Details.
type SavingsPlansPurchaseRecommendation struct {
	_ struct{} `type:"structure"`

	// The lookback period in days, used to generate the recommendation.
	LookbackPeriodInDays LookbackPeriodInDays `type:"string" enum:"true"`

	// The payment option used to generate the recommendation.
	PaymentOption PaymentOption `type:"string" enum:"true"`

	// Details for the Savings Plans we recommend you to purchase to cover existing,
	// Savings Plans eligible workloads.
	SavingsPlansPurchaseRecommendationDetails []SavingsPlansPurchaseRecommendationDetail `type:"list"`

	// Summary metrics for your Savings Plans Recommendations.
	SavingsPlansPurchaseRecommendationSummary *SavingsPlansPurchaseRecommendationSummary `type:"structure"`

	// The requested Savings Plans recommendation type.
	SavingsPlansType SupportedSavingsPlansType `type:"string" enum:"true"`

	// The Savings Plans recommendation term in years, used to generate the recommendation.
	TermInYears TermInYears `type:"string" enum:"true"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendation) String() string {
	return awsutil.Prettify(s)
}

// Details for your recommended Savings Plans.
type SavingsPlansPurchaseRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The AccountID the recommendation is generated for.
	AccountId *string `type:"string"`

	// The currency code Amazon Web Services used to generate the recommendations
	// and present potential savings.
	CurrencyCode *string `type:"string"`

	// The average value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentAverageHourlyOnDemandSpend *string `type:"string"`

	// The highest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMaximumHourlyOnDemandSpend *string `type:"string"`

	// The lowest value of hourly On-Demand spend over the lookback period of the
	// applicable usage type.
	CurrentMinimumHourlyOnDemandSpend *string `type:"string"`

	// The estimated utilization of the recommended Savings Plans.
	EstimatedAverageUtilization *string `type:"string"`

	// The estimated monthly savings amount, based on the recommended Savings Plans.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// Savings Plans, over the length of the lookback period.
	EstimatedOnDemandCost *string `type:"string"`

	// The estimated On-Demand costs you would expect with no additional commitment,
	// based on your usage of the selected time period and the Savings Plans you
	// own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment based on the recommended Savings Plans
	// purchased. This is calculated as estimatedSavingsAmount/ estimatedSPCost*100.
	EstimatedROI *string `type:"string"`

	// The cost of the recommended Savings Plans over the length of the lookback
	// period.
	EstimatedSPCost *string `type:"string"`

	// The estimated savings amount based on the recommended Savings Plans over
	// the length of the lookback period.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings percentage relative to the total cost of applicable
	// On-Demand usage over the lookback period.
	EstimatedSavingsPercentage *string `type:"string"`

	// The recommended hourly commitment level for the Savings Plans type, and configuration
	// based on the usage during the lookback period.
	HourlyCommitmentToPurchase *string `type:"string"`

	// Details for your recommended Savings Plans.
	SavingsPlansDetails *SavingsPlansDetails `type:"structure"`

	// The upfront cost of the recommended Savings Plans, based on the selected
	// payment option.
	UpfrontCost *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// Metadata about your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationMetadata struct {
	_ struct{} `type:"structure"`

	// The timestamp showing when the recommendations were generated.
	GenerationTimestamp *string `type:"string"`

	// The unique identifier for the recommendation set.
	RecommendationId *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendationMetadata) String() string {
	return awsutil.Prettify(s)
}

// Summary metrics for your Savings Plans Purchase Recommendations.
type SavingsPlansPurchaseRecommendationSummary struct {
	_ struct{} `type:"structure"`

	// The currency code Amazon Web Services used to generate the recommendations
	// and present potential savings.
	CurrencyCode *string `type:"string"`

	// The current total on demand spend of the applicable usage types over the
	// lookback period.
	CurrentOnDemandSpend *string `type:"string"`

	// The recommended Savings Plans cost on a daily (24 hourly) basis.
	DailyCommitmentToPurchase *string `type:"string"`

	// The estimated monthly savings amount, based on the recommended Savings Plans
	// purchase.
	EstimatedMonthlySavingsAmount *string `type:"string"`

	// The estimated On-Demand costs you would expect with no additional commitment,
	// based on your usage of the selected time period and the Savings Plans you
	// own.
	EstimatedOnDemandCostWithCurrentCommitment *string `type:"string"`

	// The estimated return on investment based on the recommended Savings Plans
	// and estimated savings.
	EstimatedROI *string `type:"string"`

	// The estimated total savings over the lookback period, based on the purchase
	// of the recommended Savings Plans.
	EstimatedSavingsAmount *string `type:"string"`

	// The estimated savings relative to the total cost of On-Demand usage, over
	// the lookback period. This is calculated as estimatedSavingsAmount/ CurrentOnDemandSpend*100.
	EstimatedSavingsPercentage *string `type:"string"`

	// The estimated total cost of the usage after purchasing the recommended Savings
	// Plans. This is a sum of the cost of Savings Plans during this term, and the
	// remaining On-Demand usage.
	EstimatedTotalCost *string `type:"string"`

	// The recommended hourly commitment based on the recommendation parameters.
	HourlyCommitmentToPurchase *string `type:"string"`

	// The aggregate number of Savings Plans recommendations that exist for your
	// account.
	TotalRecommendationCount *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansPurchaseRecommendationSummary) String() string {
	return awsutil.Prettify(s)
}

// The amount of savings you're accumulating, against the public On-Demand rate
// of the usage accrued in an account.
type SavingsPlansSavings struct {
	_ struct{} `type:"structure"`

	// The savings amount that you are accumulating for the usage that is covered
	// by a Savings Plans, when compared to the On-Demand equivalent of the same
	// usage.
	NetSavings *string `type:"string"`

	// How much the amount that the usage would have cost if it was accrued at the
	// On-Demand rate.
	OnDemandCostEquivalent *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansSavings) String() string {
	return awsutil.Prettify(s)
}

// The measurement of how well you are using your existing Savings Plans.
type SavingsPlansUtilization struct {
	_ struct{} `type:"structure"`

	// The total amount of Savings Plans commitment that's been purchased in an
	// account (or set of accounts).
	TotalCommitment *string `type:"string"`

	// The amount of your Savings Plans commitment that was not consumed from Savings
	// Plans eligible usage in a specific period.
	UnusedCommitment *string `type:"string"`

	// The amount of your Savings Plans commitment that was consumed from Savings
	// Plans eligible usage in a specific period.
	UsedCommitment *string `type:"string"`

	// The amount of UsedCommitment divided by the TotalCommitment for your Savings
	// Plans.
	UtilizationPercentage *string `type:"string"`
}

// String returns the string representation
func (s SavingsPlansUtilization) String() string {
	return awsutil.Prettify(s)
}

// The aggregated utilization metrics for your Savings Plans usage.
type SavingsPlansUtilizationAggregates struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. This includes the sum
	// of the upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from Savings Plans, as well as the onDemandCostEquivalent of the
	// Savings Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// Utilization is a required field
	Utilization *SavingsPlansUtilization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SavingsPlansUtilizationAggregates) String() string {
	return awsutil.Prettify(s)
}

// The amount of Savings Plans utilization, in hours.
type SavingsPlansUtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. This includes the sum
	// of the upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from Savings Plans as well as the onDemandCostEquivalent of the Savings
	// Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// The time period that you want the usage and costs for.
	//
	// TimePeriod is a required field
	TimePeriod *DateInterval `type:"structure" required:"true"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	//
	// Utilization is a required field
	Utilization *SavingsPlansUtilization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SavingsPlansUtilizationByTime) String() string {
	return awsutil.Prettify(s)
}

// A single daily or monthly Savings Plans utilization rate, and details for
// your account. Master accounts in an organization have access to member accounts.
// You can use GetDimensionValues to determine the possible dimension values.
type SavingsPlansUtilizationDetail struct {
	_ struct{} `type:"structure"`

	// The total amortized commitment for a Savings Plans. Includes the sum of the
	// upfront and recurring Savings Plans fees.
	AmortizedCommitment *SavingsPlansAmortizedCommitment `type:"structure"`

	// The attribute that applies to a specific Dimension.
	Attributes map[string]string `type:"map"`

	// The amount saved by using existing Savings Plans. Savings returns both net
	// savings from savings plans as well as the onDemandCostEquivalent of the Savings
	// Plans when considering the utilization rate.
	Savings *SavingsPlansSavings `type:"structure"`

	// The unique Amazon Resource Name (ARN) for a particular Savings Plan.
	SavingsPlanArn *string `type:"string"`

	// A ratio of your effectiveness of using existing Savings Plans to apply to
	// workloads that are Savings Plans eligible.
	Utilization *SavingsPlansUtilization `type:"structure"`
}

// String returns the string representation
func (s SavingsPlansUtilizationDetail) String() string {
	return awsutil.Prettify(s)
}

// Hardware specifications for the service that you want recommendations for.
type ServiceSpecification struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 hardware specifications that you want AWS to provide recommendations
	// for.
	EC2Specification *EC2Specification `type:"structure"`
}

// String returns the string representation
func (s ServiceSpecification) String() string {
	return awsutil.Prettify(s)
}

// The values that are available for a tag.
type TagValues struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	Key *string `type:"string"`

	// The specific value of the tag.
	Values []string `type:"list"`
}

// String returns the string representation
func (s TagValues) String() string {
	return awsutil.Prettify(s)
}

// Details on recommended instance.
type TargetInstance struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// Indicates whether or not this recommendation is the defaulted Amazon Web
	// Services recommendation.
	DefaultTargetInstance *bool `type:"boolean"`

	// Expected cost to operate this instance type on a monthly basis.
	EstimatedMonthlyCost *string `type:"string"`

	// Estimated savings resulting from modification, on a monthly basis.
	EstimatedMonthlySavings *string `type:"string"`

	// Expected utilization metrics for target instance type.
	ExpectedResourceUtilization *ResourceUtilization `type:"structure"`

	// Details on the target instance type.
	ResourceDetails *ResourceDetails `type:"structure"`
}

// String returns the string representation
func (s TargetInstance) String() string {
	return awsutil.Prettify(s)
}

// Details on termination recommendation.
type TerminateRecommendationDetail struct {
	_ struct{} `type:"structure"`

	// The currency code that Amazon Web Services used to calculate the costs for
	// this instance.
	CurrencyCode *string `type:"string"`

	// Estimated savings resulting from modification, on a monthly basis.
	EstimatedMonthlySavings *string `type:"string"`
}

// String returns the string representation
func (s TerminateRecommendationDetail) String() string {
	return awsutil.Prettify(s)
}

// The amount of utilization, in hours.
type UtilizationByTime struct {
	_ struct{} `type:"structure"`

	// The groups that this utilization result uses.
	Groups []ReservationUtilizationGroup `type:"list"`

	// The period of time that this utilization was used for.
	TimePeriod *DateInterval `type:"structure"`

	// The total number of reservation hours that were used.
	Total *ReservationAggregates `type:"structure"`
}

// String returns the string representation
func (s UtilizationByTime) String() string {
	return awsutil.Prettify(s)
}
