// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, or set to false
	// to create the subscription but not activate it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// For more information, see Working with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
	// in the AWS Database Migration Service User Guide.
	EventCategories []string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of identifiers for which AWS DMS provides notification events.
	//
	// If you don't specify a value, notifications are provided for all sources.
	//
	// If you specify multiple values, they must be of the same type. For example,
	// if you specify a database instance ID, then all of the other values must
	// be database instance IDs.
	SourceIds []string `type:"list"`

	// The type of AWS DMS resource that generates the events. For example, if you
	// want to be notified of events generated by a replication instance, you set
	// this parameter to replication-instance. If this value is not specified, all
	// events are returned.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string"`

	// The name of the AWS DMS event notification subscription. This name must be
	// less than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// One or more tags to be assigned to the event subscription.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}

	if s.SnsTopicArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnsTopicArn"))
	}

	if s.SubscriptionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was created.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Creates an AWS DMS event notification subscription.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of AWS DMS source IDs (SourceIds) that triggers the events,
// and provide a list of event categories (EventCategories) for events you want
// to be notified of. If you specify both the SourceType and SourceIds, such
// as SourceType = replication-instance and SourceIdentifier = my-replinstance,
// you will be notified of all the replication instance events for the specified
// source. If you specify a SourceType but don't specify a SourceIdentifier,
// you receive notice of the events for that source type for all your AWS DMS
// sources. If you don't specify either SourceType nor SourceIdentifier, you
// will be notified of events generated from all AWS DMS sources belonging to
// your customer account.
//
// For more information about AWS DMS events, see Working with Events and Notifications
// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the
// AWS Database Migration Service User Guide.
//
//    // Example sending a request using CreateEventSubscriptionRequest.
//    req := client.CreateEventSubscriptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *Client) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) CreateEventSubscriptionRequest {
	op := &aws.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	req := c.newRequest(op, input, &CreateEventSubscriptionOutput{})
	return CreateEventSubscriptionRequest{Request: req, Input: input, Copy: c.CreateEventSubscriptionRequest}
}

// CreateEventSubscriptionRequest is the request type for the
// CreateEventSubscription API operation.
type CreateEventSubscriptionRequest struct {
	*aws.Request
	Input *CreateEventSubscriptionInput
	Copy  func(*CreateEventSubscriptionInput) CreateEventSubscriptionRequest
}

// Send marshals and sends the CreateEventSubscription API request.
func (r CreateEventSubscriptionRequest) Send(ctx context.Context) (*CreateEventSubscriptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEventSubscriptionResponse{
		CreateEventSubscriptionOutput: r.Request.Data.(*CreateEventSubscriptionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEventSubscriptionResponse is the response type for the
// CreateEventSubscription API operation.
type CreateEventSubscriptionResponse struct {
	*CreateEventSubscriptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEventSubscription request.
func (r *CreateEventSubscriptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
