// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListDeviceInstancesInput struct {
	_ struct{} `type:"structure"`

	// An integer specifying the maximum number of items you want to return in the
	// API response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDeviceInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeviceInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListDeviceInstancesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListDeviceInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about your device instances.
	DeviceInstances []DeviceInstance `locationName:"deviceInstances" type:"list"`

	// An identifier that can be used in the next call to this operation to return
	// the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDeviceInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListDeviceInstances = "ListDeviceInstances"

// ListDeviceInstancesRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Returns information about the private device instances associated with one
// or more AWS accounts.
//
//    // Example sending a request using ListDeviceInstancesRequest.
//    req := client.ListDeviceInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDeviceInstances
func (c *Client) ListDeviceInstancesRequest(input *ListDeviceInstancesInput) ListDeviceInstancesRequest {
	op := &aws.Operation{
		Name:       opListDeviceInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeviceInstancesInput{}
	}

	req := c.newRequest(op, input, &ListDeviceInstancesOutput{})
	return ListDeviceInstancesRequest{Request: req, Input: input, Copy: c.ListDeviceInstancesRequest}
}

// ListDeviceInstancesRequest is the request type for the
// ListDeviceInstances API operation.
type ListDeviceInstancesRequest struct {
	*aws.Request
	Input *ListDeviceInstancesInput
	Copy  func(*ListDeviceInstancesInput) ListDeviceInstancesRequest
}

// Send marshals and sends the ListDeviceInstances API request.
func (r ListDeviceInstancesRequest) Send(ctx context.Context) (*ListDeviceInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListDeviceInstancesResponse{
		ListDeviceInstancesOutput: r.Request.Data.(*ListDeviceInstancesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListDeviceInstancesResponse is the response type for the
// ListDeviceInstances API operation.
type ListDeviceInstancesResponse struct {
	*ListDeviceInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListDeviceInstances request.
func (r *ListDeviceInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
