// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeregisterCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `type:"string" required:"true"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterCertificateInput"}

	if s.CertificateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateId"))
	}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterCertificate = "DeregisterCertificate"

// DeregisterCertificateRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Deletes from the system the certificate that was registered for a secured
// LDAP connection.
//
//    // Example sending a request using DeregisterCertificateRequest.
//    req := client.DeregisterCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate
func (c *Client) DeregisterCertificateRequest(input *DeregisterCertificateInput) DeregisterCertificateRequest {
	op := &aws.Operation{
		Name:       opDeregisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterCertificateInput{}
	}

	req := c.newRequest(op, input, &DeregisterCertificateOutput{})
	return DeregisterCertificateRequest{Request: req, Input: input, Copy: c.DeregisterCertificateRequest}
}

// DeregisterCertificateRequest is the request type for the
// DeregisterCertificate API operation.
type DeregisterCertificateRequest struct {
	*aws.Request
	Input *DeregisterCertificateInput
	Copy  func(*DeregisterCertificateInput) DeregisterCertificateRequest
}

// Send marshals and sends the DeregisterCertificate API request.
func (r DeregisterCertificateRequest) Send(ctx context.Context) (*DeregisterCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterCertificateResponse{
		DeregisterCertificateOutput: r.Request.Data.(*DeregisterCertificateOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterCertificateResponse is the response type for the
// DeregisterCertificate API operation.
type DeregisterCertificateResponse struct {
	*DeregisterCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterCertificate request.
func (r *DeregisterCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
