// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteVpcPeeringConnectionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the VPC peering connection.
	//
	// VpcPeeringConnectionId is a required field
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcPeeringConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVpcPeeringConnectionInput"}

	if s.VpcPeeringConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcPeeringConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteVpcPeeringConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DeleteVpcPeeringConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteVpcPeeringConnection = "DeleteVpcPeeringConnection"

// DeleteVpcPeeringConnectionRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes a VPC peering connection. Either the owner of the requester VPC or
// the owner of the accepter VPC can delete the VPC peering connection if it's
// in the active state. The owner of the requester VPC can delete a VPC peering
// connection in the pending-acceptance state. You cannot delete a VPC peering
// connection that's in the failed state.
//
//    // Example sending a request using DeleteVpcPeeringConnectionRequest.
//    req := client.DeleteVpcPeeringConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnection
func (c *Client) DeleteVpcPeeringConnectionRequest(input *DeleteVpcPeeringConnectionInput) DeleteVpcPeeringConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteVpcPeeringConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcPeeringConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteVpcPeeringConnectionOutput{})
	return DeleteVpcPeeringConnectionRequest{Request: req, Input: input, Copy: c.DeleteVpcPeeringConnectionRequest}
}

// DeleteVpcPeeringConnectionRequest is the request type for the
// DeleteVpcPeeringConnection API operation.
type DeleteVpcPeeringConnectionRequest struct {
	*aws.Request
	Input *DeleteVpcPeeringConnectionInput
	Copy  func(*DeleteVpcPeeringConnectionInput) DeleteVpcPeeringConnectionRequest
}

// Send marshals and sends the DeleteVpcPeeringConnection API request.
func (r DeleteVpcPeeringConnectionRequest) Send(ctx context.Context) (*DeleteVpcPeeringConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVpcPeeringConnectionResponse{
		DeleteVpcPeeringConnectionOutput: r.Request.Data.(*DeleteVpcPeeringConnectionOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVpcPeeringConnectionResponse is the response type for the
// DeleteVpcPeeringConnection API operation.
type DeleteVpcPeeringConnectionResponse struct {
	*DeleteVpcPeeringConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVpcPeeringConnection request.
func (r *DeleteVpcPeeringConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
