// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancing"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To add tags to a load balancer
//
// This example adds two tags to the specified load balancer.
func ExampleClient_AddTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.AddTagsInput{
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
		Tags: []elasticloadbalancing.Tag{
			{
				Key:   aws.String("project"),
				Value: aws.String("lima"),
			},
			{
				Key:   aws.String("department"),
				Value: aws.String("digital-media"),
			},
		},
	}

	req := svc.AddTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateTagKeysException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a security group with a load balancer in a VPC
//
// This example associates a security group with the specified load balancer in a VPC.
func ExampleClient_ApplySecurityGroupsToLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.ApplySecurityGroupsToLoadBalancerInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		SecurityGroups: []string{
			"sg-fc448899",
		},
	}

	req := svc.ApplySecurityGroupsToLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSecurityGroupException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach subnets to a load balancer
//
// This example adds the specified subnet to the set of configured subnets for the specified
// load balancer.
func ExampleClient_AttachLoadBalancerToSubnetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.AttachLoadBalancerToSubnetsInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		Subnets: []string{
			"subnet-0ecac448",
		},
	}

	req := svc.AttachLoadBalancerToSubnetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSubnetException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To specify the health check settings for your backend EC2 instances
//
// This example specifies the health check settings used to evaluate the health of your
// backend EC2 instances.
func ExampleClient_ConfigureHealthCheckRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.ConfigureHealthCheckInput{
		HealthCheck: &elasticloadbalancing.HealthCheck{
			HealthyThreshold:   aws.Int64(2),
			Interval:           aws.Int64(30),
			Target:             aws.String("HTTP:80/png"),
			Timeout:            aws.Int64(3),
			UnhealthyThreshold: aws.Int64(2),
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.ConfigureHealthCheckRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a stickiness policy for your load balancer
//
// This example generates a stickiness policy that follows the sticky session lifetimes
// of the application-generated cookie.
func ExampleClient_CreateAppCookieStickinessPolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateAppCookieStickinessPolicyInput{
		CookieName:       aws.String("my-app-cookie"),
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyName:       aws.String("my-app-cookie-policy"),
	}

	req := svc.CreateAppCookieStickinessPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyPoliciesException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyPoliciesException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a duration-based stickiness policy for your load balancer
//
// This example generates a stickiness policy with sticky session lifetimes controlled
// by the specified expiration period.
func ExampleClient_CreateLBCookieStickinessPolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLBCookieStickinessPolicyInput{
		CookieExpirationPeriod: aws.Int64(60),
		LoadBalancerName:       aws.String("my-load-balancer"),
		PolicyName:             aws.String("my-duration-cookie-policy"),
	}

	req := svc.CreateLBCookieStickinessPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyPoliciesException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyPoliciesException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP load balancer in a VPC
//
// This example creates a load balancer with an HTTP listener in a VPC.
func ExampleClient_CreateLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerInput{
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
		SecurityGroups: []string{
			"sg-a61988c3",
		},
		Subnets: []string{
			"subnet-15aaab61",
		},
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyAccessPointsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancing.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancing.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP load balancer in EC2-Classic
//
// This example creates a load balancer with an HTTP listener in EC2-Classic.
func ExampleClient_CreateLoadBalancerRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerInput{
		AvailabilityZones: []string{
			"us-west-2a",
		},
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyAccessPointsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancing.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancing.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS load balancer in a VPC
//
// This example creates a load balancer with an HTTPS listener in a VPC.
func ExampleClient_CreateLoadBalancerRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerInput{
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(443),
				Protocol:         aws.String("HTTPS"),
				SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
		SecurityGroups: []string{
			"sg-a61988c3",
		},
		Subnets: []string{
			"subnet-15aaab61",
		},
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyAccessPointsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancing.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancing.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS load balancer in EC2-Classic
//
// This example creates a load balancer with an HTTPS listener in EC2-Classic.
func ExampleClient_CreateLoadBalancerRequest_shared03() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerInput{
		AvailabilityZones: []string{
			"us-west-2a",
		},
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(443),
				Protocol:         aws.String("HTTPS"),
				SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyAccessPointsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancing.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancing.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an internal load balancer
//
// This example creates an internal load balancer with an HTTP listener in a VPC.
func ExampleClient_CreateLoadBalancerRequest_shared04() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerInput{
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
		Scheme:           aws.String("internal"),
		SecurityGroups: []string{
			"sg-a61988c3",
		},
		Subnets: []string{
			"subnet-15aaab61",
		},
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeDuplicateAccessPointNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateAccessPointNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyAccessPointsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyAccessPointsException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancing.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancing.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP listener for a load balancer
//
// This example creates a listener for your load balancer at port 80 using the HTTP
// protocol.
func ExampleClient_CreateLoadBalancerListenersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerListenersInput{
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(80),
				Protocol:         aws.String("HTTP"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.CreateLoadBalancerListenersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateListenerException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateListenerException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS listener for a load balancer
//
// This example creates a listener for your load balancer at port 443 using the HTTPS
// protocol.
func ExampleClient_CreateLoadBalancerListenersRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerListenersInput{
		Listeners: []elasticloadbalancing.Listener{
			{
				InstancePort:     aws.Int64(80),
				InstanceProtocol: aws.String("HTTP"),
				LoadBalancerPort: aws.Int64(443),
				Protocol:         aws.String("HTTPS"),
				SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.CreateLoadBalancerListenersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicateListenerException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicateListenerException, aerr.Error())
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a policy that enables Proxy Protocol on a load balancer
//
// This example creates a policy that enables Proxy Protocol on the specified load balancer.
func ExampleClient_CreateLoadBalancerPolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyAttributes: []elasticloadbalancing.PolicyAttribute{
			{
				AttributeName:  aws.String("ProxyProtocol"),
				AttributeValue: aws.String("true"),
			},
		},
		PolicyName:     aws.String("my-ProxyProtocol-policy"),
		PolicyTypeName: aws.String("ProxyProtocolPolicyType"),
	}

	req := svc.CreateLoadBalancerPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyTypeNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyPoliciesException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyPoliciesException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a public key policy
//
// This example creates a public key policy.
func ExampleClient_CreateLoadBalancerPolicyRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyAttributes: []elasticloadbalancing.PolicyAttribute{
			{
				AttributeName:  aws.String("PublicKey"),
				AttributeValue: aws.String("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwAYUjnfyEyXr1pxjhFWBpMlggUcqoi3kl+dS74kj//c6x7ROtusUaeQCTgIUkayttRDWchuqo1pHC1u+n5xxXnBBe2ejbb2WRsKIQ5rXEeixsjFpFsojpSQKkzhVGI6mJVZBJDVKSHmswnwLBdofLhzvllpovBPTHe+o4haAWvDBALJU0pkSI1FecPHcs2hwxf14zHoXy1e2k36A64nXW43wtfx5qcVSIxtCEOjnYRg7RPvybaGfQ+v6Iaxb/+7J5kEvZhTFQId+bSiJImF1FSUT1W1xwzBZPUbcUkkXDj45vC2s3Z8E+Lk7a3uZhvsQHLZnrfuWjBWGWvZ/MhZYgEXAMPLE"),
			},
		},
		PolicyName:     aws.String("my-PublicKey-policy"),
		PolicyTypeName: aws.String("PublicKeyPolicyType"),
	}

	req := svc.CreateLoadBalancerPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyTypeNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyPoliciesException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyPoliciesException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a backend server authentication policy
//
// This example creates a backend server authentication policy that enables authentication
// on your backend instance using a public key policy.
func ExampleClient_CreateLoadBalancerPolicyRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.CreateLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyAttributes: []elasticloadbalancing.PolicyAttribute{
			{
				AttributeName:  aws.String("PublicKeyPolicyName"),
				AttributeValue: aws.String("my-PublicKey-policy"),
			},
		},
		PolicyName:     aws.String("my-authentication-policy"),
		PolicyTypeName: aws.String("BackendServerAuthenticationPolicyType"),
	}

	req := svc.CreateLoadBalancerPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyTypeNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDuplicatePolicyNameException:
				fmt.Println(elasticloadbalancing.ErrCodeDuplicatePolicyNameException, aerr.Error())
			case elasticloadbalancing.ErrCodeTooManyPoliciesException:
				fmt.Println(elasticloadbalancing.ErrCodeTooManyPoliciesException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a load balancer
//
// This example deletes the specified load balancer.
func ExampleClient_DeleteLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DeleteLoadBalancerInput{
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.DeleteLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a listener from your load balancer
//
// This example deletes the listener for the specified port from the specified load
// balancer.
func ExampleClient_DeleteLoadBalancerListenersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DeleteLoadBalancerListenersInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		LoadBalancerPorts: []int64{
			80,
		},
	}

	req := svc.DeleteLoadBalancerListenersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a policy from your load balancer
//
// This example deletes the specified policy from the specified load balancer. The policy
// must not be enabled on any listener.
func ExampleClient_DeleteLoadBalancerPolicyRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DeleteLoadBalancerPolicyInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyName:       aws.String("my-duration-cookie-policy"),
	}

	req := svc.DeleteLoadBalancerPolicyRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To deregister instances from a load balancer
//
// This example deregisters the specified instance from the specified load balancer.
func ExampleClient_DeregisterInstancesFromLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DeregisterInstancesFromLoadBalancerInput{
		Instances: []elasticloadbalancing.Instance{
			{
				InstanceId: aws.String("i-d6f6fae3"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.DeregisterInstancesFromLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidEndPointException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidEndPointException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the health of the instances for a load balancer
//
// This example describes the health of the instances for the specified load balancer.
func ExampleClient_DescribeInstanceHealthRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DescribeInstanceHealthInput{
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.DescribeInstanceHealthRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidEndPointException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidEndPointException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the attributes of a load balancer
//
// This example describes the attributes of the specified load balancer.
func ExampleClient_DescribeLoadBalancerAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DescribeLoadBalancerAttributesInput{
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.DescribeLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeLoadBalancerAttributeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeLoadBalancerAttributeNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a policy associated with a load balancer
//
// This example describes the specified policy associated with the specified load balancer.
func ExampleClient_DescribeLoadBalancerPoliciesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DescribeLoadBalancerPoliciesInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyNames: []string{
			"my-authentication-policy",
		},
	}

	req := svc.DescribeLoadBalancerPoliciesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodePolicyNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a load balancer policy type defined by Elastic Load Balancing
//
// This example describes the specified load balancer policy type.
func ExampleClient_DescribeLoadBalancerPolicyTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DescribeLoadBalancerPolicyTypesInput{
		PolicyTypeNames: []string{
			"ProxyProtocolPolicyType",
		},
	}

	req := svc.DescribeLoadBalancerPolicyTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodePolicyTypeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyTypeNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe one of your load balancers
//
// This example describes the specified load balancer.
func ExampleClient_DescribeLoadBalancersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DescribeLoadBalancersInput{
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
	}

	req := svc.DescribeLoadBalancersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeDependencyThrottleException:
				fmt.Println(elasticloadbalancing.ErrCodeDependencyThrottleException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags for a load balancer
//
// This example describes the tags for the specified load balancer.
func ExampleClient_DescribeTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DescribeTagsInput{
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
	}

	req := svc.DescribeTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a load balancer from a subnet
//
// This example detaches the specified load balancer from the specified subnet.
func ExampleClient_DetachLoadBalancerFromSubnetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DetachLoadBalancerFromSubnetsInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		Subnets: []string{
			"subnet-0ecac448",
		},
	}

	req := svc.DetachLoadBalancerFromSubnetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable an Availability Zone for a load balancer
//
// This example removes the specified Availability Zone from the set of Availability
// Zones for the specified load balancer.
func ExampleClient_DisableAvailabilityZonesForLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.DisableAvailabilityZonesForLoadBalancerInput{
		AvailabilityZones: []string{
			"us-west-2a",
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.DisableAvailabilityZonesForLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable an Availability Zone for a load balancer
//
// This example adds the specified Availability Zone to the specified load balancer.
func ExampleClient_EnableAvailabilityZonesForLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.EnableAvailabilityZonesForLoadBalancerInput{
		AvailabilityZones: []string{
			"us-west-2b",
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.EnableAvailabilityZonesForLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable cross-zone load balancing
//
// This example enables cross-zone load balancing for the specified load balancer.
func ExampleClient_ModifyLoadBalancerAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.ModifyLoadBalancerAttributesInput{
		LoadBalancerAttributes: &elasticloadbalancing.LoadBalancerAttributes{
			CrossZoneLoadBalancing: &elasticloadbalancing.CrossZoneLoadBalancing{
				Enabled: aws.Bool(true),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.ModifyLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeLoadBalancerAttributeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeLoadBalancerAttributeNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable connection draining
//
// This example enables connection draining for the specified load balancer.
func ExampleClient_ModifyLoadBalancerAttributesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.ModifyLoadBalancerAttributesInput{
		LoadBalancerAttributes: &elasticloadbalancing.LoadBalancerAttributes{
			ConnectionDraining: &elasticloadbalancing.ConnectionDraining{
				Enabled: aws.Bool(true),
				Timeout: aws.Int64(300),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.ModifyLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeLoadBalancerAttributeNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeLoadBalancerAttributeNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To register instances with a load balancer
//
// This example registers the specified instance with the specified load balancer.
func ExampleClient_RegisterInstancesWithLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.RegisterInstancesWithLoadBalancerInput{
		Instances: []elasticloadbalancing.Instance{
			{
				InstanceId: aws.String("i-d6f6fae3"),
			},
		},
		LoadBalancerName: aws.String("my-load-balancer"),
	}

	req := svc.RegisterInstancesWithLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidEndPointException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidEndPointException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a load balancer
//
// This example removes the specified tag from the specified load balancer.
func ExampleClient_RemoveTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.RemoveTagsInput{
		LoadBalancerNames: []string{
			"my-load-balancer",
		},
		Tags: []elasticloadbalancing.TagKeyOnly{
			{
				Key: aws.String("project"),
			},
		},
	}

	req := svc.RemoveTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the SSL certificate for an HTTPS listener
//
// This example replaces the existing SSL certificate for the specified HTTPS listener.
func ExampleClient_SetLoadBalancerListenerSSLCertificateRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.SetLoadBalancerListenerSSLCertificateInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		LoadBalancerPort: aws.Int64(443),
		SSLCertificateId: aws.String("arn:aws:iam::123456789012:server-certificate/new-server-cert"),
	}

	req := svc.SetLoadBalancerListenerSSLCertificateRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancing.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancing.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the policies associated with a port for a backend instance
//
// This example replaces the policies that are currently associated with the specified
// port.
func ExampleClient_SetLoadBalancerPoliciesForBackendServerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.SetLoadBalancerPoliciesForBackendServerInput{
		InstancePort:     aws.Int64(80),
		LoadBalancerName: aws.String("my-load-balancer"),
		PolicyNames: []string{
			"my-ProxyProtocol-policy",
		},
	}

	req := svc.SetLoadBalancerPoliciesForBackendServerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodePolicyNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the policies associated with a listener
//
// This example replaces the policies that are currently associated with the specified
// listener.
func ExampleClient_SetLoadBalancerPoliciesOfListenerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancing.New(cfg)
	input := &elasticloadbalancing.SetLoadBalancerPoliciesOfListenerInput{
		LoadBalancerName: aws.String("my-load-balancer"),
		LoadBalancerPort: aws.Int64(80),
		PolicyNames: []string{
			"my-SSLNegotiation-policy",
		},
	}

	req := svc.SetLoadBalancerPoliciesOfListenerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancing.ErrCodeAccessPointNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeAccessPointNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodePolicyNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodePolicyNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancing.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancing.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancing.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
